/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.HttpHeaderFW;

public final class HttpBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_HEADERS = 4;
    private final ArrayFW<HttpHeaderFW> headersRO = new ArrayFW<HttpHeaderFW>(new HttpHeaderFW());

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public ArrayFW<HttpHeaderFW> headers() {
        return this.headersRO;
    }

    @Override
    public HttpBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.headersRO.wrap(buffer, offset + 4, maxLimit);
        HttpBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public HttpBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.headersRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.headersRO.limit();
    }

    public String toString() {
        return String.format("HTTP_BEGIN_EX [typeId=%d, headers=%s]", this.typeId(), this.headers());
    }

    public static final class Builder
    extends Flyweight.Builder<HttpBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_HEADERS = 1;
        private static final int FIELD_COUNT = 2;
        private final ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> headersRW = new ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new HttpBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            HttpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder headers(Consumer<ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
            assert (this.lastFieldSet == 0);
            Flyweight.Builder headersRW = this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>)headersRW);
            this.limit(((ArrayFW)((ArrayFW.Builder)headersRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder headersItem(Consumer<HttpHeaderFW.Builder> mutator) {
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.headersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.headersRW.item(mutator);
            this.limit(((ArrayFW)this.headersRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public HttpBeginExFW build() {
            if (this.lastFieldSet < 1) {
                this.headers(b -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (HttpBeginExFW)super.build();
        }
    }
}

