/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.jose4j.jwk.JsonWebKey;
import org.reaktivity.nukleus.Nukleus;
import org.reaktivity.nukleus.function.CommandHandler;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.oauth.internal.OAuthConfiguration;
import org.reaktivity.nukleus.oauth.internal.OAuthElektron;
import org.reaktivity.nukleus.oauth.internal.OAuthRealms;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.StringFW;
import org.reaktivity.nukleus.oauth.internal.types.control.ErrorFW;
import org.reaktivity.nukleus.oauth.internal.types.control.OAuthResolveExFW;
import org.reaktivity.nukleus.oauth.internal.types.control.ResolveFW;
import org.reaktivity.nukleus.oauth.internal.types.control.ResolvedFW;
import org.reaktivity.nukleus.oauth.internal.types.control.UnresolveFW;
import org.reaktivity.nukleus.oauth.internal.types.control.UnresolvedFW;

final class OAuthNukleus
implements Nukleus {
    static final String NAME = "oauth";
    private final ResolveFW resolveRO = new ResolveFW();
    private final OAuthResolveExFW resolveExRO = new OAuthResolveExFW();
    private final ResolvedFW.Builder resolvedRW = new ResolvedFW.Builder();
    private final UnresolveFW unresolveRO = new UnresolveFW();
    private final UnresolvedFW.Builder unresolvedRW = new UnresolvedFW.Builder();
    private final ErrorFW.Builder errorRW = new ErrorFW.Builder();
    private final OAuthConfiguration config;
    private final OAuthRealms realms;
    private final Int2ObjectHashMap<CommandHandler> commandHandlers;

    OAuthNukleus(OAuthConfiguration config) {
        this.config = config;
        Path keyFile = config.directory().resolve(this.name()).resolve(config.keyFileName());
        Map<String, JsonWebKey> keysByKid = OAuthRealms.parseKeyMap(keyFile);
        OAuthRealms realms = new OAuthRealms(keysByKid);
        if (config.autoDiscoverRealms()) {
            keysByKid.keySet().forEach(realms::resolve);
        }
        Int2ObjectHashMap commandHandlers = new Int2ObjectHashMap();
        commandHandlers.put(17, this::onResolve);
        commandHandlers.put(18, this::onUnresolve);
        this.realms = realms;
        this.commandHandlers = commandHandlers;
    }

    public String name() {
        return NAME;
    }

    public OAuthConfiguration config() {
        return this.config;
    }

    public CommandHandler commandHandler(int msgTypeId) {
        return (CommandHandler)this.commandHandlers.get(msgTypeId);
    }

    public OAuthElektron supplyElektron() {
        return new OAuthElektron(this.config, this.realms::lookup, this.realms::lookupKey);
    }

    private void onResolve(DirectBuffer buffer, int index, int length, MessageConsumer reply, MutableDirectBuffer replyBuffer) {
        OAuthResolveExFW resolveEx;
        ResolveFW resolve = this.resolveRO.wrap(buffer, index, index + length);
        long correlationId = resolve.correlationId();
        String realm = resolve.realm().asString();
        String issuer = null;
        String audience = null;
        if (resolve.extension().sizeof() > 0 && (resolveEx = this.resolveExRO.tryWrap(buffer, resolve.extension().offset(), resolve.extension().limit())) != null) {
            issuer = resolveEx.issuer().asString();
            audience = resolveEx.audience().asString();
        }
        ArrayFW<StringFW> roles = resolve.roles();
        LinkedList<String> collectedRoles = new LinkedList<String>();
        roles.forEach(r -> collectedRoles.add(r.asString()));
        long authorization = this.realms.resolve(realm, issuer, audience, collectedRoles);
        if (authorization != 0L) {
            ResolvedFW resolved = this.resolvedRW.wrap(replyBuffer, 0, replyBuffer.capacity()).correlationId(correlationId).authorization(authorization).build();
            reply.accept(resolved.typeId(), resolved.buffer(), resolved.offset(), resolved.sizeof());
        } else {
            ErrorFW error = this.errorRW.wrap(replyBuffer, 0, replyBuffer.capacity()).correlationId(correlationId).build();
            reply.accept(error.typeId(), error.buffer(), error.offset(), error.sizeof());
        }
    }

    private void onUnresolve(DirectBuffer buffer, int index, int length, MessageConsumer reply, MutableDirectBuffer replyBuffer) {
        UnresolveFW unresolve = this.unresolveRO.wrap(buffer, index, index + length);
        long correlationId = unresolve.correlationId();
        long authorization = unresolve.authorization();
        if (this.realms.unresolve(authorization)) {
            UnresolvedFW unresolved = this.unresolvedRW.wrap(replyBuffer, 0, replyBuffer.capacity()).correlationId(correlationId).build();
            reply.accept(unresolved.typeId(), unresolved.buffer(), unresolved.offset(), unresolved.sizeof());
        } else {
            ErrorFW error = this.errorRW.wrap(replyBuffer, 0, replyBuffer.capacity()).correlationId(correlationId).build();
            reply.accept(error.typeId(), error.buffer(), error.offset(), error.sizeof());
        }
    }
}

