/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.nukleus.ControllerSpi;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;
import org.reaktivity.nukleus.oauth.internal.types.control.FreezeFW;
import org.reaktivity.nukleus.oauth.internal.types.control.OAuthResolveExFW;
import org.reaktivity.nukleus.oauth.internal.types.control.ResolveFW;
import org.reaktivity.nukleus.oauth.internal.types.control.Role;
import org.reaktivity.nukleus.oauth.internal.types.control.RouteFW;
import org.reaktivity.nukleus.oauth.internal.types.control.UnresolveFW;
import org.reaktivity.nukleus.oauth.internal.types.control.UnrouteFW;
import org.reaktivity.nukleus.route.RouteKind;

public class OAuthController
implements Controller {
    private static final int MAX_SEND_LENGTH = 1024;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final ResolveFW.Builder resolveRW = new ResolveFW.Builder();
    private final OAuthResolveExFW.Builder resolveExRW = new OAuthResolveExFW.Builder();
    private final UnresolveFW.Builder unresolveRW = new UnresolveFW.Builder();
    private final RouteFW.Builder routeRW = new RouteFW.Builder();
    private final UnrouteFW.Builder unrouteRW = new UnrouteFW.Builder();
    private final FreezeFW.Builder freezeRW = new FreezeFW.Builder();
    private final OctetsFW extensionRO = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(new byte[0]), 0, 0);
    private final ControllerSpi controllerSpi;
    private final AtomicBuffer commandBuffer;
    private final AtomicBuffer extensionBuffer;
    private final Gson gson;

    public OAuthController(ControllerSpi controllerSpi) {
        this.controllerSpi = controllerSpi;
        this.commandBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()));
        this.extensionBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()));
        this.gson = new Gson();
    }

    public int process() {
        return this.controllerSpi.doProcess();
    }

    public void close() throws Exception {
        this.controllerSpi.doClose();
    }

    public Class<OAuthController> kind() {
        return OAuthController.class;
    }

    public String name() {
        return "oauth";
    }

    public CompletableFuture<Long> resolve(String realmName) {
        return this.resolve(realmName, EMPTY_STRING_ARRAY, null);
    }

    public CompletableFuture<Long> resolve(String realmName, String[] roleNames) {
        return this.resolve(realmName, roleNames, null);
    }

    public CompletableFuture<Long> resolve(String realmName, String[] roleNames, String extension) {
        JsonParser parser;
        JsonElement element;
        String issuerName = null;
        String audienceName = null;
        if (extension != null && (element = (parser = new JsonParser()).parse(extension)).isJsonObject()) {
            JsonObject object = (JsonObject)element;
            issuerName = (String)this.gson.fromJson(object.get("issuer"), String.class);
            audienceName = (String)this.gson.fromJson(object.get("audience"), String.class);
        }
        long correlationId = this.controllerSpi.nextCorrelationId();
        ResolveFW.Builder resolveBuilder = this.resolveRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).realm(realmName).roles(b -> Arrays.asList(roleNames).forEach(s -> b.item(sb -> sb.set((String)s, StandardCharsets.UTF_8))));
        if (issuerName != null || audienceName != null) {
            OAuthResolveExFW resolveEx = this.resolveExRW.wrap((MutableDirectBuffer)this.extensionBuffer, 0, this.extensionBuffer.capacity()).issuer(issuerName).audience(audienceName).build();
            resolveBuilder.extension(resolveEx.buffer(), resolveEx.offset(), resolveEx.sizeof());
        }
        ResolveFW resolve = resolveBuilder.build();
        return this.controllerSpi.doResolve(resolve.typeId(), resolve.buffer(), resolve.offset(), resolve.sizeof());
    }

    public CompletableFuture<Void> unresolve(long authorization) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        UnresolveFW unresolveRO = this.unresolveRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).authorization(authorization).build();
        return this.controllerSpi.doUnresolve(unresolveRO.typeId(), unresolveRO.buffer(), unresolveRO.offset(), unresolveRO.sizeof());
    }

    @Deprecated
    public CompletableFuture<Long> routeProxy(String localAddress, String remoteAddress, long authorization) {
        return this.route(RouteKind.PROXY, localAddress, remoteAddress, authorization);
    }

    public CompletableFuture<Long> route(RouteKind kind, String localAddress, String remoteAddress, long authorization) {
        return this.doRoute(kind, localAddress, remoteAddress, authorization, this.extensionRO);
    }

    public CompletableFuture<Void> unroute(long routeId) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        UnrouteFW unrouteRO = this.unrouteRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).routeId(routeId).build();
        return this.controllerSpi.doUnroute(unrouteRO.typeId(), unrouteRO.buffer(), unrouteRO.offset(), unrouteRO.sizeof());
    }

    public CompletableFuture<Void> freeze() {
        long correlationId = this.controllerSpi.nextCorrelationId();
        FreezeFW freeze = this.freezeRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).build();
        return this.controllerSpi.doFreeze(freeze.typeId(), freeze.buffer(), freeze.offset(), freeze.sizeof());
    }

    private CompletableFuture<Long> doRoute(RouteKind kind, String localAddress, String remoteAddress, long authorization, Flyweight extension) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        Role role = Role.valueOf(kind.ordinal());
        RouteFW routeRO = this.routeRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).role(b -> b.set(role)).authorization(authorization).localAddress(localAddress).remoteAddress(remoteAddress).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        return this.controllerSpi.doRoute(routeRO.typeId(), routeRO.buffer(), routeRO.offset(), routeRO.sizeof());
    }
}

