/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import org.reaktivity.nukleus.Configuration;

public class OAuthConfiguration
extends Configuration {
    public static final String KEYS_NAME = "nukleus.oauth.keys";
    public static final String AUTO_DISCOVER_REALMS_NAME = "nukleus.oauth.auto.discover.realms";
    public static final String CLAIM_NAMESPACE_NAME = "nukleus.oauth.claim.namespace";
    public static final String CLAIM_NAME_CHALLENGE_TIMEOUT_NAME = "nukleus.oauth.claim.name.challenge.timeout";
    static final Configuration.ConfigurationDef OAUTH_CONFIG;
    static final Configuration.BooleanPropertyDef EXPIRE_IN_FLIGHT_REQUESTS;
    static final Configuration.PropertyDef<String> KEYS;
    static final Configuration.BooleanPropertyDef AUTO_DISCOVER_REALMS;
    static final Configuration.PropertyDef<String> CLAIM_NAMESPACE;
    static final Configuration.PropertyDef<String> CLAIM_NAME_CHALLENGE_TIMEOUT;

    public OAuthConfiguration(Configuration config) {
        super(OAUTH_CONFIG, config);
    }

    public String keyFileName() {
        return (String)KEYS.get((Configuration)this);
    }

    public boolean expireInFlightRequests() {
        return EXPIRE_IN_FLIGHT_REQUESTS.getAsBoolean((Configuration)this);
    }

    public boolean autoDiscoverRealms() {
        return AUTO_DISCOVER_REALMS.getAsBoolean((Configuration)this);
    }

    public String getClaimNamespace() {
        return (String)CLAIM_NAMESPACE.get((Configuration)this);
    }

    public String getClaimNameChallengeTimeout() {
        return (String)CLAIM_NAME_CHALLENGE_TIMEOUT.get((Configuration)this);
    }

    public String getCanonicalClaimNamespace() {
        String namespace = this.getClaimNamespace();
        return namespace.endsWith("/") ? namespace : String.format("%s/", namespace);
    }

    static {
        Configuration.ConfigurationDef config = new Configuration.ConfigurationDef("nukleus.oauth");
        KEYS = config.property("keys", "keys.jwk");
        EXPIRE_IN_FLIGHT_REQUESTS = config.property("expire.in.flight.requests", true);
        AUTO_DISCOVER_REALMS = config.property("auto.discover.realms", false);
        CLAIM_NAMESPACE = config.property("claim.namespace", "https://reaktivity.org");
        CLAIM_NAME_CHALLENGE_TIMEOUT = config.property("claim.name.challenge.timeout", "challenge_timeout");
        OAUTH_CONFIG = config;
    }
}

