// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;
import org.reaktivity.nukleus.oauth.internal.types.StringFW;

public final class ResolveFW extends Flyweight {
  public static final int FIELD_OFFSET_CORRELATION_ID = 0;

  private static final int FIELD_SIZE_CORRELATION_ID = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_NUKLEUS = FIELD_OFFSET_CORRELATION_ID + FIELD_SIZE_CORRELATION_ID;

  public static final int FIELD_OFFSET_REALM = 0;

  public static final int FIELD_OFFSET_ROLES = 0;

  public static final int FIELD_OFFSET_EXTENSION = 0;

  public static final int TYPE_ID = 0x00000011;

  private final StringFW nukleusRO = new StringFW();

  private final StringFW realmRO = new StringFW();

  private final ArrayFW<StringFW> rolesRO = new ArrayFW<StringFW>(new StringFW());

  private final OctetsFW extensionRO = new OctetsFW();

  public long correlationId() {
    return buffer().getLong(offset() + FIELD_OFFSET_CORRELATION_ID);
  }

  public StringFW nukleus() {
    return nukleusRO;
  }

  public StringFW realm() {
    return realmRO;
  }

  public ArrayFW<StringFW> roles() {
    return rolesRO;
  }

  public OctetsFW extension() {
    return extensionRO;
  }

  public int typeId() {
    return TYPE_ID;
  }

  @Override
  public ResolveFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    nukleusRO.wrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit);
    realmRO.wrap(buffer, nukleusRO.limit() + FIELD_OFFSET_REALM, maxLimit);
    rolesRO.wrap(buffer, realmRO.limit() + FIELD_OFFSET_ROLES, maxLimit);
    extensionRO.wrap(buffer, rolesRO.limit() + FIELD_OFFSET_EXTENSION, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public ResolveFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == nukleusRO.tryWrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit)) {
      return null;
    }
    if (null == realmRO.tryWrap(buffer, nukleusRO.limit() + FIELD_OFFSET_REALM, maxLimit)) {
      return null;
    }
    if (null == rolesRO.tryWrap(buffer, realmRO.limit() + FIELD_OFFSET_ROLES, maxLimit)) {
      return null;
    }
    if (null == extensionRO.tryWrap(buffer, rolesRO.limit() + FIELD_OFFSET_EXTENSION, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return extensionRO.limit();
  }

  @Override
  public String toString() {
    return String.format("RESOLVE [correlationId=%d, nukleus=%s, realm=%s, roles=%s, extension=%s]", correlationId(), nukleusRO.asString(), realmRO.asString(), roles(), extension());
  }

  public static final class Builder extends Flyweight.Builder<ResolveFW> {
    private static final int INDEX_CORRELATION_ID = 0;

    private static final int INDEX_NUKLEUS = 1;

    private static final int INDEX_REALM = 2;

    private static final int INDEX_ROLES = 3;

    private static final int INDEX_EXTENSION = 4;

    private static final int FIELD_COUNT = 5;

    private final StringFW.Builder nukleusRW = new StringFW.Builder();

    private final StringFW.Builder realmRW = new StringFW.Builder();

    private final ArrayFW.Builder<StringFW.Builder, StringFW> rolesRW = new ArrayFW.Builder<StringFW.Builder, StringFW>(new StringFW.Builder(), new StringFW());

    private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new ResolveFW());
    }

    public Builder correlationId(long value) {
      assert lastFieldSet == INDEX_CORRELATION_ID - 1;
      int newLimit = limit() + FIELD_SIZE_CORRELATION_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_CORRELATION_ID;
      limit(newLimit);
      return this;
    }

    private StringFW.Builder nukleus() {
      assert lastFieldSet == INDEX_NUKLEUS - 1;
      return nukleusRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder nukleus(String value) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(StringFW value) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(value);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(buffer, offset, length);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    private StringFW.Builder realm() {
      assert lastFieldSet == INDEX_REALM - 1;
      return realmRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder realm(String value) {
      StringFW.Builder realmRW = realm();
      realmRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_REALM;
      limit(realmRW.build().limit());
      return this;
    }

    public Builder realm(StringFW value) {
      StringFW.Builder realmRW = realm();
      realmRW.set(value);
      lastFieldSet = INDEX_REALM;
      limit(realmRW.build().limit());
      return this;
    }

    public Builder realm(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder realmRW = realm();
      realmRW.set(buffer, offset, length);
      lastFieldSet = INDEX_REALM;
      limit(realmRW.build().limit());
      return this;
    }

    public Builder roles(Consumer<ArrayFW.Builder<StringFW.Builder, StringFW>> mutator) {
      assert lastFieldSet == INDEX_ROLES - 1;
      ArrayFW.Builder<StringFW.Builder, StringFW> rolesRW = this.rolesRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(rolesRW);
      limit(rolesRW.build().limit());
      lastFieldSet = INDEX_ROLES;
      return this;
    }

    public Builder rolesItem(Consumer<StringFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_ROLES - 1;
      if (lastFieldSet < INDEX_ROLES) {
        rolesRW.wrap(buffer(), limit(), maxLimit());
      }
      rolesRW.item(mutator);
      limit(rolesRW.build().limit());
      lastFieldSet = INDEX_ROLES;
      return this;
    }

    private OctetsFW.Builder extension() {
      if (lastFieldSet < INDEX_ROLES) {
        roles(b -> { });
      }
      assert lastFieldSet == INDEX_EXTENSION - 1;
      return extensionRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder extension(OctetsFW value) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(value);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(Consumer<OctetsFW.Builder> mutator) {
      OctetsFW.Builder extensionRW = extension();
      mutator.accept(extensionRW);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(DirectBuffer buffer, int offset, int length) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(buffer, offset, length);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public ResolveFW build() {
      if (lastFieldSet < INDEX_EXTENSION) {
        extension(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
