// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.control;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.HttpHeaderFW;

public final class HttpRouteExFW extends Flyweight {
  public static final int FIELD_OFFSET_HEADERS = 0;

  public static final int FIELD_OFFSET_OVERRIDES = 0;

  private final ArrayFW<HttpHeaderFW> headersRO = new ArrayFW<HttpHeaderFW>(new HttpHeaderFW());

  private final ArrayFW<HttpHeaderFW> overridesRO = new ArrayFW<HttpHeaderFW>(new HttpHeaderFW());

  public ArrayFW<HttpHeaderFW> headers() {
    return headersRO;
  }

  public ArrayFW<HttpHeaderFW> overrides() {
    return overridesRO;
  }

  @Override
  public HttpRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    headersRO.wrap(buffer, offset + FIELD_OFFSET_HEADERS, maxLimit);
    overridesRO.wrap(buffer, headersRO.limit() + FIELD_OFFSET_OVERRIDES, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public HttpRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == headersRO.tryWrap(buffer, offset + FIELD_OFFSET_HEADERS, maxLimit)) {
      return null;
    }
    if (null == overridesRO.tryWrap(buffer, headersRO.limit() + FIELD_OFFSET_OVERRIDES, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return overridesRO.limit();
  }

  @Override
  public String toString() {
    return String.format("HTTP_ROUTE_EX [headers=%s, overrides=%s]", headers(), overrides());
  }

  public static final class Builder extends Flyweight.Builder<HttpRouteExFW> {
    private static final int INDEX_HEADERS = 0;

    private static final int INDEX_OVERRIDES = 1;

    private static final int FIELD_COUNT = 2;

    private final ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> headersRW = new ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());

    private final ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> overridesRW = new ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new HttpRouteExFW());
    }

    public Builder headers(Consumer<ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
      assert lastFieldSet == INDEX_HEADERS - 1;
      ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> headersRW = this.headersRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(headersRW);
      limit(headersRW.build().limit());
      lastFieldSet = INDEX_HEADERS;
      return this;
    }

    public Builder headersItem(Consumer<HttpHeaderFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_HEADERS - 1;
      if (lastFieldSet < INDEX_HEADERS) {
        headersRW.wrap(buffer(), limit(), maxLimit());
      }
      headersRW.item(mutator);
      limit(headersRW.build().limit());
      lastFieldSet = INDEX_HEADERS;
      return this;
    }

    public Builder overrides(Consumer<ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
      if (lastFieldSet < INDEX_HEADERS) {
        headers(b -> { });
      }
      assert lastFieldSet == INDEX_OVERRIDES - 1;
      ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> overridesRW = this.overridesRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(overridesRW);
      limit(overridesRW.build().limit());
      lastFieldSet = INDEX_OVERRIDES;
      return this;
    }

    public Builder overridesItem(Consumer<HttpHeaderFW.Builder> mutator) {
      if (lastFieldSet < INDEX_HEADERS) {
        headers(b -> { });
      }
      assert lastFieldSet >= INDEX_OVERRIDES - 1;
      if (lastFieldSet < INDEX_OVERRIDES) {
        overridesRW.wrap(buffer(), limit(), maxLimit());
      }
      overridesRW.item(mutator);
      limit(overridesRW.build().limit());
      lastFieldSet = INDEX_OVERRIDES;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public HttpRouteExFW build() {
      if (lastFieldSet < INDEX_OVERRIDES) {
        overrides(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
