/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.util;

import org.agrona.DirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.String16FW;
import org.reaktivity.nukleus.oauth.internal.types.StringFW;

public final class BufferUtil {
    public static boolean equals(StringFW flyweight, byte[] value) {
        return BufferUtil.equals(flyweight.buffer(), flyweight.offset() + 1, flyweight.limit(), value);
    }

    public static int limitOfBytes(String16FW flyweight, byte[] value) {
        DirectBuffer buffer = flyweight.buffer();
        int offset = flyweight.offset();
        int limit = flyweight.limit();
        return BufferUtil.limitOfBytes(buffer, offset + 2, limit, value);
    }

    public static int indexOfBytes(String16FW flyweight, byte[] value) {
        return Math.max(BufferUtil.limitOfBytes(flyweight, value) - flyweight.offset() - value.length - 2, -1);
    }

    public static boolean equals(DirectBuffer buffer, int offset, int limit, byte[] value) {
        return limit - offset == value.length && limit == BufferUtil.limitOfBytes(buffer, offset, limit, value);
    }

    public static int limitOfBytes(DirectBuffer buffer, int offset, int limit, byte[] value) {
        int matchedBytes = 0;
        for (int cursor = offset; cursor < limit; ++cursor) {
            if (buffer.getByte(cursor) != value[matchedBytes]) {
                matchedBytes = 0;
                continue;
            }
            if (value.length != ++matchedBytes) continue;
            return cursor + 1;
        }
        return -1;
    }

    private BufferUtil() {
    }
}

