/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.types.state;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.state.RouteEntryFW;

public final class RouteTableFW
extends Flyweight {
    public static final int FIELD_OFFSET_MODIFICATION_COUNT = 0;
    private static final int FIELD_SIZE_MODIFICATION_COUNT = 4;
    public static final int FIELD_OFFSET_ENTRIES = 4;
    private final ArrayFW<RouteEntryFW> entriesRO = new ArrayFW<RouteEntryFW>(new RouteEntryFW());

    public int modificationCount() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public ArrayFW<RouteEntryFW> entries() {
        return this.entriesRO;
    }

    @Override
    public RouteTableFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.entriesRO.wrap(buffer, offset + 4, maxLimit);
        RouteTableFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public RouteTableFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.entriesRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.entriesRO.limit();
    }

    public String toString() {
        return String.format("ROUTE_TABLE [modificationCount=%d, entries=%s]", this.modificationCount(), this.entries());
    }

    public static final class Builder
    extends Flyweight.Builder<RouteTableFW> {
        private static final int INDEX_MODIFICATION_COUNT = 0;
        private static final int INDEX_ENTRIES = 1;
        private static final int FIELD_COUNT = 2;
        private final ArrayFW.Builder<RouteEntryFW.Builder, RouteEntryFW> entriesRW = new ArrayFW.Builder<RouteEntryFW.Builder, RouteEntryFW>(new RouteEntryFW.Builder(), new RouteEntryFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new RouteTableFW());
        }

        public Builder modificationCount(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            RouteTableFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder entries(Consumer<ArrayFW.Builder<RouteEntryFW.Builder, RouteEntryFW>> mutator) {
            assert (this.lastFieldSet == 0);
            Flyweight.Builder entriesRW = this.entriesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((ArrayFW.Builder<RouteEntryFW.Builder, RouteEntryFW>)entriesRW);
            this.limit(((ArrayFW)((ArrayFW.Builder)entriesRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder entriesItem(Consumer<RouteEntryFW.Builder> mutator) {
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.entriesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.entriesRW.item(mutator);
            this.limit(((ArrayFW)this.entriesRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public RouteTableFW build() {
            if (this.lastFieldSet < 1) {
                this.entries(b -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (RouteTableFW)super.build();
        }
    }
}

