/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.StringFW;

public final class OAuthResolveExFW
extends Flyweight {
    public static final int FIELD_OFFSET_ISSUER = 0;
    public static final int FIELD_OFFSET_AUDIENCE = 0;
    private final StringFW issuerRO = new StringFW();
    private final StringFW audienceRO = new StringFW();

    public StringFW issuer() {
        return this.issuerRO;
    }

    public StringFW audience() {
        return this.audienceRO;
    }

    @Override
    public OAuthResolveExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.issuerRO.wrap(buffer, offset + 0, maxLimit);
        this.audienceRO.wrap(buffer, this.issuerRO.limit() + 0, maxLimit);
        OAuthResolveExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public OAuthResolveExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.issuerRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.audienceRO.tryWrap(buffer, this.issuerRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.audienceRO.limit();
    }

    public String toString() {
        return String.format("OAUTH_RESOLVE_EX [issuer=%s, audience=%s]", this.issuerRO.asString(), this.audienceRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<OAuthResolveExFW> {
        private static final int INDEX_ISSUER = 0;
        private static final int INDEX_AUDIENCE = 1;
        private static final int FIELD_COUNT = 2;
        private final StringFW.Builder issuerRW = new StringFW.Builder();
        private final StringFW.Builder audienceRW = new StringFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new OAuthResolveExFW());
        }

        private StringFW.Builder issuer() {
            assert (this.lastFieldSet == -1);
            return this.issuerRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder issuer(String value) {
            StringFW.Builder issuerRW = this.issuer();
            issuerRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(issuerRW.build().limit());
            return this;
        }

        public Builder issuer(StringFW value) {
            StringFW.Builder issuerRW = this.issuer();
            issuerRW.set(value);
            this.lastFieldSet = 0;
            this.limit(issuerRW.build().limit());
            return this;
        }

        public Builder issuer(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder issuerRW = this.issuer();
            issuerRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(issuerRW.build().limit());
            return this;
        }

        private StringFW.Builder audience() {
            assert (this.lastFieldSet == 0);
            return this.audienceRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder audience(String value) {
            StringFW.Builder audienceRW = this.audience();
            audienceRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(audienceRW.build().limit());
            return this;
        }

        public Builder audience(StringFW value) {
            StringFW.Builder audienceRW = this.audience();
            audienceRW.set(value);
            this.lastFieldSet = 1;
            this.limit(audienceRW.build().limit());
            return this;
        }

        public Builder audience(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder audienceRW = this.audience();
            audienceRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(audienceRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public OAuthResolveExFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (OAuthResolveExFW)super.build();
        }
    }
}

