/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.stream;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;
import org.reaktivity.nukleus.concurrent.SignalingExecutor;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.function.MessagePredicate;
import org.reaktivity.nukleus.oauth.internal.Capabilities;
import org.reaktivity.nukleus.oauth.internal.OAuthConfiguration;
import org.reaktivity.nukleus.oauth.internal.stream.Writer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.HttpHeaderFW;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;
import org.reaktivity.nukleus.oauth.internal.types.String16FW;
import org.reaktivity.nukleus.oauth.internal.types.StringFW;
import org.reaktivity.nukleus.oauth.internal.types.control.RouteFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.AbortFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.BeginFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.DataFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.EndFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.HttpBeginExFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.HttpChallengeExFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.ResetFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.SignalFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.WindowFW;
import org.reaktivity.nukleus.oauth.internal.util.BufferUtil;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.stream.StreamFactory;

public class OAuthProxyFactory
implements StreamFactory {
    private static final long EXPIRES_NEVER = Long.MAX_VALUE;
    private static final long EXPIRES_IMMEDIATELY = 0L;
    private static final int GRANT_VALIDATION_SIGNAL = 1;
    private static final long REALM_MASK = -281474976710656L;
    private static final int SCOPE_BITS = 48;
    private static final Consumer<String> NOOP_CLEANER = s -> {};
    private static final Pattern QUERY_PARAMS = Pattern.compile("(?:\\?|.*?&)access_token=([^&#]+)(?:&.*)?");
    private static final String END_CHALLENGE_TYPE = "application/x-challenge-response";
    private static final byte[] BEARER_PREFIX = "Bearer ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] QUERY_PREFIX = "?".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] AUTHORIZATION = "authorization".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] PATH = ":path".getBytes(StandardCharsets.US_ASCII);
    private static final StringFW HEADER_NAME_METHOD = new StringFW(":method");
    private static final StringFW HEADER_NAME_CONTENT_TYPE = new StringFW("content-type");
    private static final StringFW HEADER_NAME_STATUS = new StringFW(":status");
    private static final StringFW HEADER_NAME_ACCESS_CONTROL_ALLOW_METHODS = new StringFW("access-control-allow-methods");
    private static final StringFW HEADER_NAME_ACCESS_CONTROL_ALLOW_HEADERS = new StringFW("access-control-allow-headers");
    private static final StringFW HEADER_NAME_ACCESS_CONTROL_REQUEST_METHOD = new StringFW("access-control-request-method");
    private static final StringFW HEADER_NAME_ACCESS_CONTROL_REQUEST_HEADERS = new StringFW("access-control-request-headers");
    private static final String16FW HEADER_VALUE_STATUS_204 = new String16FW("204");
    private static final String16FW HEADER_VALUE_METHOD_OPTIONS = new String16FW("OPTIONS");
    private static final String16FW HEADER_VALUE_METHOD_POST;
    private static final String16FW CHALLENGE_RESPONSE_METHOD;
    private static final String16FW CHALLENGE_RESPONSE_CONTENT_TYPE;
    private static final String16FW CORS_PREFLIGHT_METHOD;
    private static final String16FW CORS_ALLOWED_METHODS;
    private static final String16FW CORS_ALLOWED_HEADERS;
    private final RouteFW routeRO = new RouteFW();
    private final BeginFW beginRO = new BeginFW();
    private final DataFW dataRO = new DataFW();
    private final EndFW endRO = new EndFW();
    private final OctetsFW octetsRO = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(new byte[0]), 0, 0);
    private final HttpBeginExFW httpBeginExRO = new HttpBeginExFW();
    private final HttpBeginExFW.Builder httpBeginExRW = new HttpBeginExFW.Builder();
    private final HttpChallengeExFW.Builder httpChallengeExRW = new HttpChallengeExFW.Builder();
    private final WindowFW windowRO = new WindowFW();
    private final ResetFW resetRO = new ResetFW();
    private final AbortFW abortRO = new AbortFW();
    private final SignalFW signalRO = new SignalFW();
    private final JsonWebSignature signature = new JsonWebSignature();
    private final Long2ObjectHashMap<Map<String, OAuthAccessGrant>>[] grantsBySubjectByAffinityPerRealm;
    private final OAuthConfiguration config;
    private final RouteManager router;
    private final LongUnaryOperator supplyInitialId;
    private final LongSupplier supplyTrace;
    private final LongUnaryOperator supplyReplyId;
    private final Function<String, JsonWebKey> lookupKey;
    private final ToLongFunction<JsonWebSignature> lookupAuthorization;
    private final SignalingExecutor executor;
    private final Long2ObjectHashMap<OAuthProxy> correlations;
    private final Writer writer;
    private final UnsafeBuffer extensionBuffer;
    private final int httpTypeId;
    private final String challengeTimeoutClaimName;

    public OAuthProxyFactory(OAuthConfiguration config, MutableDirectBuffer writeBuffer, LongUnaryOperator supplyInitialId, LongSupplier supplyTrace, ToIntFunction<String> supplyTypeId, LongUnaryOperator supplyReplyId, Function<String, JsonWebKey> lookupKey, ToLongFunction<JsonWebSignature> lookupAuthorization, SignalingExecutor executor, RouteManager router) {
        this.config = config;
        this.router = Objects.requireNonNull(router);
        this.writer = new Writer(writeBuffer);
        this.extensionBuffer = new UnsafeBuffer(new byte[writeBuffer.capacity()]);
        this.supplyInitialId = Objects.requireNonNull(supplyInitialId);
        this.supplyReplyId = Objects.requireNonNull(supplyReplyId);
        this.supplyTrace = Objects.requireNonNull(supplyTrace);
        this.correlations = new Long2ObjectHashMap();
        this.lookupKey = lookupKey;
        this.lookupAuthorization = lookupAuthorization;
        this.executor = executor;
        this.httpTypeId = supplyTypeId.applyAsInt("http");
        this.grantsBySubjectByAffinityPerRealm = OAuthProxyFactory.initGrantsBySubjectByAffinityPerRealm();
        this.challengeTimeoutClaimName = String.format("%s%s", config.getCanonicalClaimNamespace(), config.getClaimNameChallengeTimeout());
    }

    public MessageConsumer newStream(int msgTypeId, DirectBuffer buffer, int index, int length, MessageConsumer source) {
        BeginFW begin = this.beginRO.wrap(buffer, index, index + length);
        long streamId = begin.streamId();
        MessageConsumer newStream = (streamId & 1L) != 0L ? this.newInitialStream(begin, source) : this.newReplyStream(begin, source);
        return newStream;
    }

    private MessageConsumer newInitialStream(BeginFW begin, MessageConsumer acceptReply) {
        long acceptAuthorization = begin.authorization();
        long acceptRouteId = begin.routeId();
        long acceptInitialId = begin.streamId();
        long affinity = begin.affinity();
        OctetsFW extension = begin.extension();
        HttpBeginExFW httpBeginEx = extension.get(this.httpBeginExRO::tryWrap);
        JsonWebSignature verified = this.verifiedSignature(begin);
        long connectAuthorization = acceptAuthorization;
        if (verified != null) {
            connectAuthorization = this.lookupAuthorization.applyAsLong(verified);
        }
        String subject = OAuthProxyFactory.resolveSubject(verified);
        long expiresAtMillis = this.config.expireInFlightRequests() ? OAuthProxyFactory.expiresAtMillis(verified) : Long.MAX_VALUE;
        int realmId = (int)((connectAuthorization & 0xFFFF000000000000L) >> 48);
        MessagePredicate filter = (t, b, o, l) -> true;
        RouteFW route = (RouteFW)this.router.resolve(acceptRouteId, connectAuthorization, filter, this::wrapRoute);
        MessageConsumer newStream = null;
        if (OAuthProxyFactory.isChallengeResponseRequest(httpBeginEx)) {
            long newTraceId = this.supplyTrace.getAsLong();
            long acceptReplyId = this.supplyReplyId.applyAsLong(acceptInitialId);
            long challengeTimeout = this.resolveChallengeTimeout(verified);
            OAuthAccessGrant grant = this.lookupGrant(realmId, affinity, subject);
            if (grant != null) {
                grant.reauthorize(subject, connectAuthorization, expiresAtMillis, challengeTimeout);
            }
            this.writer.doWindow(acceptReply, acceptRouteId, acceptInitialId, newTraceId, 0L, 0, 0, 0L);
            HttpBeginExFW newHttpBeginEx = this.httpBeginExRW.wrap((MutableDirectBuffer)this.extensionBuffer, 0, this.extensionBuffer.capacity()).typeId(this.httpTypeId).headers(OAuthProxyFactory::setChallengeResponseHeaders).build();
            this.writer.doBegin(acceptReply, acceptRouteId, acceptReplyId, newTraceId, 0L, newHttpBeginEx);
            this.writer.doEnd(acceptReply, acceptRouteId, acceptReplyId, newTraceId, 0L, this.octetsRO);
            newStream = (t, b, i, l) -> {};
        } else if (route != null) {
            long traceId = begin.trace();
            long acceptReplyId = this.supplyReplyId.applyAsLong(acceptInitialId);
            long connectRouteId = route.correlationId();
            long connectInitialId = this.supplyInitialId.applyAsLong(connectRouteId);
            MessageConsumer connectInitial = this.router.supplyReceiver(connectInitialId);
            long connectReplyId = this.supplyReplyId.applyAsLong(connectInitialId);
            boolean isCorsPreflight = OAuthProxyFactory.isCorsPreflightRequest(extension.get(this.httpBeginExRO::tryWrap));
            long challengeTimeout = this.resolveChallengeTimeout(verified);
            OAuthAccessGrant grant = this.supplyGrant(realmId, affinity, subject);
            grant.reauthorize(subject, connectAuthorization, expiresAtMillis, challengeTimeout);
            MutableInteger acceptCapabilities = new MutableInteger();
            MutableInteger connectCapabilities = new MutableInteger();
            OAuthProxy initialStream = new OAuthProxy(acceptReply, acceptRouteId, acceptInitialId, acceptAuthorization, acceptCapabilities, connectRouteId, connectInitialId, connectAuthorization, connectCapabilities, connectReplyId, expiresAtMillis, 0L, grant, isCorsPreflight, connectInitial, acceptReplyId);
            OAuthProxy replyStream = new OAuthProxy(connectInitial, connectRouteId, connectReplyId, connectAuthorization, connectCapabilities, acceptRouteId, acceptReplyId, acceptAuthorization, acceptCapabilities, connectReplyId, expiresAtMillis, challengeTimeout, grant, isCorsPreflight, acceptReply, acceptReplyId);
            this.correlations.put(connectReplyId, (Object)replyStream);
            this.router.setThrottle(acceptReplyId, (x$0, x$1, x$2, x$3) -> replyStream.onThrottleMessage(x$0, x$1, x$2, x$3));
            this.writer.doBegin(connectInitial, connectRouteId, connectInitialId, traceId, connectAuthorization, extension);
            this.router.setThrottle(connectInitialId, (x$0, x$1, x$2, x$3) -> initialStream.onThrottleMessage(x$0, x$1, x$2, x$3));
            newStream = (x$0, x$1, x$2, x$3) -> initialStream.onStreamMessage(x$0, x$1, x$2, x$3);
        }
        return newStream;
    }

    private MessageConsumer newReplyStream(BeginFW begin, MessageConsumer sender) {
        long connectReplyId = begin.streamId();
        long traceId = begin.trace();
        long authorization = begin.authorization();
        OctetsFW extension = begin.extension();
        HttpBeginExFW httpBeginEx = extension.get(this.httpBeginExRO::tryWrap);
        OAuthProxy replyStream = (OAuthProxy)this.correlations.remove(connectReplyId);
        MessageConsumer newStream = null;
        if (replyStream != null) {
            MessageConsumer acceptReply = replyStream.target;
            long acceptRouteId = replyStream.targetRouteId;
            long acceptReplyId = replyStream.targetStreamId;
            Flyweight beginEx = extension;
            if (replyStream.isCorsPreflight) {
                HttpBeginExFW.Builder newHttpBeginEx = this.httpBeginExRW.wrap((MutableDirectBuffer)this.extensionBuffer, 0, this.extensionBuffer.capacity()).typeId(this.httpTypeId);
                if (httpBeginEx != null) {
                    httpBeginEx.headers().forEach(h -> newHttpBeginEx.headersItem(i -> i.name(h.name()).value(h.value())));
                }
                OAuthProxyFactory.setCorsPreflightResponseHeaders(newHttpBeginEx);
                beginEx = newHttpBeginEx.build();
            }
            this.writer.doBegin(acceptReply, acceptRouteId, acceptReplyId, traceId, authorization, beginEx);
            newStream = (x$0, x$1, x$2, x$3) -> replyStream.onStreamMessage(x$0, x$1, x$2, x$3);
        }
        return newStream;
    }

    private RouteFW wrapRoute(int msgTypeId, DirectBuffer buffer, int index, int length) {
        return this.routeRO.wrap(buffer, index, index + length);
    }

    private long resolveChallengeTimeout(JsonWebSignature verified) {
        long challengeTimeout = 0L;
        try {
            JwtClaims claims;
            Object claimValue;
            if (verified != null && (claimValue = (claims = JwtClaims.parse((String)verified.getPayload())).getClaimValue(this.challengeTimeoutClaimName)) != null) {
                challengeTimeout = TimeUnit.SECONDS.toMillis(Integer.parseInt(claimValue.toString()));
            }
        }
        catch (NumberFormatException | InvalidJwtException | JoseException throwable) {
            // empty catch block
        }
        return challengeTimeout;
    }

    private OAuthAccessGrant supplyGrant(int realmIndex, long affinityId, String subject) {
        OAuthAccessGrant grant;
        if (affinityId != 0L && subject != null) {
            Map<String, OAuthAccessGrant> grantsBySubject = this.supplyGrantsBySubject(realmIndex, affinityId);
            String subjectKey = subject.intern();
            grant = grantsBySubject.computeIfAbsent(subjectKey, s -> new OAuthAccessGrant(grantsBySubject::remove));
        } else {
            grant = new OAuthAccessGrant();
        }
        return grant;
    }

    private Map<String, OAuthAccessGrant> supplyGrantsBySubject(int realmIndex, long affinityId) {
        Long2ObjectHashMap<Map<String, OAuthAccessGrant>> grantsBySubjectByAffinity = this.grantsBySubjectByAffinityPerRealm[realmIndex];
        return (Map)grantsBySubjectByAffinity.computeIfAbsent(affinityId, a -> new IdentityHashMap());
    }

    private OAuthAccessGrant lookupGrant(int realmIndex, long affinityId, String subject) {
        Map<String, OAuthAccessGrant> grantsBySubject;
        OAuthAccessGrant grant = null;
        if (affinityId != 0L && subject != null && (grantsBySubject = this.lookupGrantsBySubject(realmIndex, affinityId)) != null) {
            String subjectKey = subject.intern();
            grant = grantsBySubject.get(subjectKey);
        }
        return grant;
    }

    private Map<String, OAuthAccessGrant> lookupGrantsBySubject(int realmIndex, long affinityId) {
        Long2ObjectHashMap<Map<String, OAuthAccessGrant>> grantsBySubjectByAffinity = this.grantsBySubjectByAffinityPerRealm[realmIndex];
        return (Map)grantsBySubjectByAffinity.get(affinityId);
    }

    private JsonWebSignature verifiedSignature(BeginFW begin) {
        HttpBeginExFW httpBeginEx = begin.extension().get(this.httpBeginExRO::tryWrap);
        JsonWebSignature verified = null;
        String token = OAuthProxyFactory.bearerToken(httpBeginEx);
        if (token != null) {
            try {
                this.signature.setCompactSerialization(token);
                String kid = this.signature.getKeyIdHeaderValue();
                String algorithm = this.signature.getAlgorithmHeaderValue();
                JsonWebKey key = this.lookupKey.apply(kid);
                if (algorithm != null && key != null && algorithm.equals(key.getAlgorithm())) {
                    this.signature.setKey(null);
                    this.signature.setKey(key.getKey());
                    JwtClaims claims = JwtClaims.parse((String)this.signature.getPayload());
                    NumericDate expirationTime = claims.getExpirationTime();
                    NumericDate notBefore = claims.getNotBefore();
                    long now = System.currentTimeMillis();
                    if (!(expirationTime != null && now > expirationTime.getValueInMillis() || notBefore != null && now < notBefore.getValueInMillis() || !this.signature.verifySignature())) {
                        verified = this.signature;
                    }
                }
            }
            catch (MalformedClaimException | InvalidJwtException | JoseException throwable) {
                // empty catch block
            }
        }
        return verified;
    }

    private static String bearerToken(HttpBeginExFW httpBeginEx) {
        String token = null;
        if (httpBeginEx != null) {
            String16FW value;
            int tokenAt;
            HttpHeaderFW authorization;
            String query;
            Matcher matcher;
            String16FW value2;
            int queryAt;
            ArrayFW<HttpHeaderFW> headers = httpBeginEx.headers();
            HttpHeaderFW path = headers.matchFirst(h -> BufferUtil.equals(h.name(), PATH));
            if (path != null && (queryAt = BufferUtil.indexOfBytes(value2 = path.value(), QUERY_PREFIX)) != -1 && (matcher = QUERY_PARAMS.matcher(query = path.value().asString().substring(queryAt))).matches()) {
                token = matcher.group(1);
            }
            if ((authorization = headers.matchFirst(h -> BufferUtil.equals(h.name(), AUTHORIZATION))) != null && (tokenAt = BufferUtil.limitOfBytes(value = authorization.value(), BEARER_PREFIX)) > 0) {
                DirectBuffer buffer = value.buffer();
                int limit = value.limit();
                token = buffer.getStringWithoutLengthUtf8(tokenAt, limit - tokenAt);
            }
        }
        return token;
    }

    private static String resolveSubject(JsonWebSignature verified) {
        String subject = null;
        try {
            if (verified != null) {
                JwtClaims claims = JwtClaims.parse((String)verified.getPayload());
                subject = claims.getSubject();
            }
        }
        catch (MalformedClaimException | InvalidJwtException | JoseException throwable) {
            // empty catch block
        }
        return subject;
    }

    private static long expiresAtMillis(JsonWebSignature verified) {
        long expiresAtMillis = Long.MAX_VALUE;
        if (verified != null) {
            try {
                JwtClaims claims = JwtClaims.parse((String)verified.getPayload());
                NumericDate expirationTime = claims.getExpirationTime();
                if (expirationTime != null) {
                    expiresAtMillis = expirationTime.getValueInMillis();
                }
            }
            catch (MalformedClaimException | InvalidJwtException | JoseException ex) {
                expiresAtMillis = 0L;
            }
        }
        return expiresAtMillis;
    }

    private static Long2ObjectHashMap<Map<String, OAuthAccessGrant>>[] initGrantsBySubjectByAffinityPerRealm() {
        Long2ObjectHashMap[] grantsBySubjectByAffinityPerRealm = new Long2ObjectHashMap[16];
        Arrays.setAll(grantsBySubjectByAffinityPerRealm, i -> new Long2ObjectHashMap());
        return grantsBySubjectByAffinityPerRealm;
    }

    private static boolean isCorsPreflightRequest(HttpBeginExFW httpBeginEx) {
        return httpBeginEx != null && httpBeginEx.headers().anyMatch(h -> HEADER_NAME_METHOD.equals(h.name()) && CORS_PREFLIGHT_METHOD.equals(h.value())) && httpBeginEx.headers().anyMatch(h -> HEADER_NAME_ACCESS_CONTROL_REQUEST_METHOD.equals(h.name()) || HEADER_NAME_ACCESS_CONTROL_REQUEST_HEADERS.equals(h.name()));
    }

    private static void setCorsPreflightResponse(HttpBeginExFW.Builder httpBeginEx) {
        httpBeginEx.headersItem(h -> h.name(HEADER_NAME_STATUS).value(HEADER_VALUE_STATUS_204));
        OAuthProxyFactory.setCorsPreflightResponseHeaders(httpBeginEx);
    }

    private static void setCorsPreflightResponseHeaders(HttpBeginExFW.Builder httpBeginEx) {
        httpBeginEx.headersItem(h -> h.name(HEADER_NAME_ACCESS_CONTROL_ALLOW_METHODS).value(CORS_ALLOWED_METHODS)).headersItem(h -> h.name(HEADER_NAME_ACCESS_CONTROL_ALLOW_HEADERS).value(CORS_ALLOWED_HEADERS));
    }

    private static boolean isChallengeResponseRequest(HttpBeginExFW httpBeginEx) {
        return httpBeginEx != null && httpBeginEx.headers().anyMatch(h -> HEADER_NAME_METHOD.equals(h.name()) && CHALLENGE_RESPONSE_METHOD.equals(h.value())) && httpBeginEx.headers().anyMatch(h -> HEADER_NAME_CONTENT_TYPE.equals(h.name()) && CHALLENGE_RESPONSE_CONTENT_TYPE.equals(h.value()));
    }

    private static void setChallengeResponseHeaders(ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> headers) {
        headers.item(h -> h.name(HEADER_NAME_STATUS).value(HEADER_VALUE_STATUS_204));
    }

    static {
        CHALLENGE_RESPONSE_METHOD = HEADER_VALUE_METHOD_POST = new String16FW("POST");
        CHALLENGE_RESPONSE_CONTENT_TYPE = new String16FW(END_CHALLENGE_TYPE);
        CORS_PREFLIGHT_METHOD = HEADER_VALUE_METHOD_OPTIONS;
        CORS_ALLOWED_METHODS = HEADER_VALUE_METHOD_POST;
        CORS_ALLOWED_HEADERS = new String16FW("authorization,content-type");
    }

    private final class OAuthProxy {
        private final MessageConsumer source;
        private final long sourceRouteId;
        private final long sourceStreamId;
        private final long sourceAuthorization;
        private final MutableInteger sourceCapabailities;
        private final MessageConsumer target;
        private final long targetRouteId;
        private final long targetStreamId;
        private final long targetAuthorization;
        private final MutableInteger targetCapabailities;
        private final long acceptReplyId;
        private final long connectReplyId;
        private final OAuthAccessGrant grant;
        private final boolean isCorsPreflight;
        private Future<?> signalFuture;

        private OAuthProxy(MessageConsumer source, long sourceRouteId, long sourceId, long sourceAuthorization, MutableInteger sourceCapabilities, long targetRouteId, long targetId, long targetAuthorization, MutableInteger targetCapabilities, long connectReplyId, long expiresAtMillis, long challengeTimeout, OAuthAccessGrant grant, boolean isCorsPreflight, MessageConsumer target, long acceptReplyId) {
            this.source = source;
            this.sourceRouteId = sourceRouteId;
            this.sourceStreamId = sourceId;
            this.sourceAuthorization = sourceAuthorization;
            this.sourceCapabailities = sourceCapabilities;
            this.target = target;
            this.targetRouteId = targetRouteId;
            this.targetStreamId = targetId;
            this.targetAuthorization = targetAuthorization;
            this.targetCapabailities = targetCapabilities;
            this.acceptReplyId = acceptReplyId;
            this.connectReplyId = connectReplyId;
            this.grant = Objects.requireNonNull(grant);
            this.isCorsPreflight = isCorsPreflight;
            this.grant.acquire();
            assert (challengeTimeout >= 0L);
            if (expiresAtMillis != Long.MAX_VALUE) {
                long challengeDelay = expiresAtMillis - challengeTimeout - System.currentTimeMillis();
                this.signalFuture = OAuthProxyFactory.this.executor.schedule(challengeDelay, TimeUnit.MILLISECONDS, targetRouteId, this.targetStreamId, 1L);
            }
        }

        private void onStreamMessage(int msgTypeId, DirectBuffer buffer, int index, int length) {
            switch (msgTypeId) {
                case 1: {
                    BeginFW begin = OAuthProxyFactory.this.beginRO.wrap(buffer, index, index + length);
                    this.onBegin(begin);
                    break;
                }
                case 2: {
                    DataFW data = OAuthProxyFactory.this.dataRO.wrap(buffer, index, index + length);
                    this.onData(data);
                    break;
                }
                case 3: {
                    EndFW end = OAuthProxyFactory.this.endRO.wrap(buffer, index, index + length);
                    this.onEnd(end);
                    break;
                }
                case 4: {
                    AbortFW abort = OAuthProxyFactory.this.abortRO.wrap(buffer, index, index + length);
                    this.onAbort(abort);
                    break;
                }
                default: {
                    OAuthProxyFactory.this.writer.doReset(this.source, this.sourceRouteId, this.sourceStreamId, OAuthProxyFactory.this.supplyTrace.getAsLong(), this.sourceAuthorization);
                }
            }
        }

        private void onThrottleMessage(int msgTypeId, DirectBuffer buffer, int index, int length) {
            switch (msgTypeId) {
                case 0x40000002: {
                    WindowFW window = OAuthProxyFactory.this.windowRO.wrap(buffer, index, index + length);
                    this.onWindow(window);
                    break;
                }
                case 0x40000001: {
                    ResetFW reset = OAuthProxyFactory.this.resetRO.wrap(buffer, index, index + length);
                    this.onReset(reset);
                    break;
                }
                case 0x40000003: {
                    SignalFW signal = OAuthProxyFactory.this.signalRO.wrap(buffer, index, index + length);
                    this.onSignal(signal);
                    break;
                }
            }
        }

        private void onBegin(BeginFW begin) {
        }

        private void onData(DataFW data) {
            long traceId = data.trace();
            int padding = data.padding();
            long authorization = data.authorization();
            long groupId = data.groupId();
            OctetsFW payload = data.payload();
            OctetsFW extension = data.extension();
            OAuthProxyFactory.this.writer.doData(this.target, this.targetRouteId, this.targetStreamId, traceId, authorization, groupId, padding, payload, extension);
        }

        private void onEnd(EndFW end) {
            long traceId = end.trace();
            OctetsFW extension = end.extension();
            OAuthProxyFactory.this.writer.doEnd(this.target, this.targetRouteId, this.targetStreamId, traceId, this.targetAuthorization, extension);
            this.cancelTimerIfNecessary();
        }

        private void onAbort(AbortFW abort) {
            long traceId = abort.trace();
            OAuthProxyFactory.this.writer.doAbort(this.target, this.targetRouteId, this.targetStreamId, traceId, this.targetAuthorization);
            this.cleanupCorrelationIfNecessary();
            this.cancelTimerIfNecessary();
        }

        private void onWindow(WindowFW window) {
            int credit = window.credit();
            long traceId = window.trace();
            int padding = window.padding();
            long groupId = window.groupId();
            this.targetCapabailities.value = window.capabilities();
            OAuthProxyFactory.this.writer.doWindow(this.source, this.sourceRouteId, this.sourceStreamId, traceId, this.sourceAuthorization, credit, padding, groupId, this.targetCapabailities.value);
        }

        private void onReset(ResetFW reset) {
            long traceId = reset.trace();
            boolean replyNotStarted = this.cleanupCorrelationIfNecessary();
            if (this.isCorsPreflight && this.sourceStreamId != this.connectReplyId && replyNotStarted) {
                OAuthProxyFactory.this.writer.doWindow(this.source, this.sourceRouteId, this.sourceStreamId, traceId, 0L, 0, 0, 0L);
                HttpBeginExFW.Builder httpBeginEx = OAuthProxyFactory.this.httpBeginExRW.wrap((MutableDirectBuffer)OAuthProxyFactory.this.extensionBuffer, 0, OAuthProxyFactory.this.extensionBuffer.capacity()).typeId(OAuthProxyFactory.this.httpTypeId);
                OAuthProxyFactory.setCorsPreflightResponse(httpBeginEx);
                long sourceReplyId = OAuthProxyFactory.this.supplyReplyId.applyAsLong(this.sourceStreamId);
                OAuthProxyFactory.this.writer.doBegin(this.source, this.sourceRouteId, sourceReplyId, traceId, 0L, httpBeginEx.build());
                OAuthProxyFactory.this.writer.doEnd(this.source, this.sourceRouteId, sourceReplyId, traceId, 0L, OAuthProxyFactory.this.octetsRO);
            } else {
                OAuthProxyFactory.this.writer.doReset(this.source, this.sourceRouteId, this.sourceStreamId, traceId, this.sourceAuthorization);
            }
            this.cancelTimerIfNecessary();
        }

        private void onSignal(SignalFW signal) {
            long signalId = signal.signalId();
            switch ((int)signalId) {
                case 1: {
                    this.onGrantValidationSignal(signal);
                    break;
                }
            }
        }

        private void onGrantValidationSignal(SignalFW signal) {
            long now = System.currentTimeMillis();
            long nextSignalDelay = this.grant.expiresAtMillis - now;
            if (nextSignalDelay > 0L) {
                if (Capabilities.canChallenge(this.sourceCapabailities.value)) {
                    nextSignalDelay = this.grant.challenge(now, signal.trace(), this::doChallenge);
                }
                this.signalFuture = OAuthProxyFactory.this.executor.schedule(nextSignalDelay, TimeUnit.MILLISECONDS, this.targetRouteId, this.targetStreamId, 1L);
            } else {
                long traceId = signal.trace();
                OAuthProxyFactory.this.writer.doReset(this.source, this.sourceRouteId, this.sourceStreamId, traceId, this.sourceAuthorization);
                boolean replyNotStarted = this.cleanupCorrelationIfNecessary();
                if (this.sourceStreamId == this.connectReplyId && replyNotStarted) {
                    HttpBeginExFW httpBeginEx = OAuthProxyFactory.this.httpBeginExRW.wrap((MutableDirectBuffer)OAuthProxyFactory.this.extensionBuffer, 0, OAuthProxyFactory.this.extensionBuffer.capacity()).typeId(OAuthProxyFactory.this.httpTypeId).headersItem(h -> h.name(HEADER_NAME_STATUS).value("401")).build();
                    OAuthProxyFactory.this.writer.doBegin(this.target, this.targetRouteId, this.targetStreamId, traceId, this.targetAuthorization, httpBeginEx);
                    OAuthProxyFactory.this.writer.doEnd(this.target, this.targetRouteId, this.targetStreamId, traceId, this.targetAuthorization, OAuthProxyFactory.this.octetsRO);
                } else {
                    OAuthProxyFactory.this.writer.doAbort(this.target, this.targetRouteId, this.targetStreamId, traceId, this.targetAuthorization);
                }
                this.grant.release();
            }
        }

        private void doChallenge(long traceId) {
            HttpChallengeExFW httpChallengeEx = OAuthProxyFactory.this.httpChallengeExRW.wrap((MutableDirectBuffer)OAuthProxyFactory.this.extensionBuffer, 0, OAuthProxyFactory.this.extensionBuffer.capacity()).typeId(OAuthProxyFactory.this.httpTypeId).headersItem(h -> h.name(HEADER_NAME_METHOD).value(HEADER_VALUE_METHOD_POST)).headersItem(h -> h.name(HEADER_NAME_CONTENT_TYPE).value(OAuthProxyFactory.END_CHALLENGE_TYPE)).build();
            OAuthProxyFactory.this.writer.doChallenge(this.source, this.sourceRouteId, this.sourceStreamId, traceId, this.sourceAuthorization, httpChallengeEx);
        }

        private boolean cleanupCorrelationIfNecessary() {
            OAuthProxy correlated = (OAuthProxy)OAuthProxyFactory.this.correlations.remove(this.connectReplyId);
            if (correlated != null) {
                OAuthProxyFactory.this.router.clearThrottle(this.acceptReplyId);
            }
            return correlated != null;
        }

        private void cancelTimerIfNecessary() {
            if (this.signalFuture != null) {
                this.signalFuture.cancel(true);
                this.signalFuture = null;
                this.grant.release();
            }
        }
    }

    private final class OAuthAccessGrant {
        private String subject;
        private long authorization;
        private long expiresAtMillis;
        private long challengeTimeoutMillis;
        private long lastChallengedAt;
        private int referenceCount;
        private Consumer<String> cleaner;

        private OAuthAccessGrant(Consumer<String> cleaner) {
            this.cleaner = cleaner;
        }

        private OAuthAccessGrant() {
            this.cleaner = NOOP_CLEANER;
        }

        private boolean reauthorize(String subject, long connectAuthorization, long expiresAtMillis, long challengeTimeoutMillis) {
            boolean reauthorized = false;
            if (this.referenceCount > 0) {
                long grantAuthorization = this.authorization;
                boolean bl = reauthorized = (grantAuthorization & connectAuthorization) == grantAuthorization && expiresAtMillis > this.expiresAtMillis;
                if (reauthorized) {
                    this.expiresAtMillis = expiresAtMillis;
                    this.challengeTimeoutMillis = challengeTimeoutMillis;
                }
            } else {
                this.subject = subject != null ? subject.intern() : null;
                this.authorization = connectAuthorization;
                this.expiresAtMillis = expiresAtMillis;
                this.challengeTimeoutMillis = challengeTimeoutMillis;
            }
            return reauthorized;
        }

        private void acquire() {
            assert (this.cleaner != null);
            ++this.referenceCount;
        }

        private void release() {
            assert (this.cleaner != null && this.referenceCount > 0);
            --this.referenceCount;
            if (this.referenceCount == 0) {
                if (this.subject != null) {
                    this.cleaner.accept(this.subject);
                }
                this.cleaner = null;
            }
        }

        private long challenge(long now, long traceId, LongConsumer doChallenge) {
            long delay = this.expiresAtMillis - now;
            long challengeAfter = this.expiresAtMillis - this.challengeTimeoutMillis;
            if (challengeAfter <= now && now < this.expiresAtMillis) {
                if (this.lastChallengedAt < challengeAfter) {
                    this.lastChallengedAt = now;
                    doChallenge.accept(traceId);
                }
                assert (this.lastChallengedAt >= challengeAfter);
            } else if (now < challengeAfter) {
                delay = challengeAfter - now;
            }
            return delay;
        }
    }
}

