/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.reaktivity.nukleus.Configuration;
import org.reaktivity.nukleus.oauth.internal.OAuthConfiguration;

public class OAuthConfigurationTest {
    @Test
    public void shouldMatchKeysConfigName() {
        Assert.assertEquals((Object)"nukleus.oauth.keys", (Object)OAuthConfiguration.KEYS.name());
    }

    @Test
    public void shouldMatchAutoDiscoverRealmsConfigName() {
        Assert.assertEquals((Object)"nukleus.oauth.auto.discover.realms", (Object)OAuthConfiguration.AUTO_DISCOVER_REALMS.name());
    }

    @Test
    public void shouldMatchClaimNamespaceConfigName() {
        Assert.assertEquals((Object)"nukleus.oauth.claim.namespace", (Object)OAuthConfiguration.CLAIM_NAMESPACE.name());
    }

    @Test
    public void shouldMatchClaimNameChallengeTimeoutConfigName() {
        Assert.assertEquals((Object)"nukleus.oauth.claim.name.challenge.timeout", (Object)OAuthConfiguration.CLAIM_NAME_CHALLENGE_TIMEOUT.name());
    }

    @Test
    public void shouldCanonicalizeNamespaceWithTrailingSlash() {
        Properties properties = new Properties();
        properties.setProperty("nukleus.oauth.claim.namespace", "http://example.com/");
        OAuthConfiguration config = new OAuthConfiguration(new Configuration(properties));
        Assert.assertEquals((Object)"http://example.com/", (Object)config.getCanonicalClaimNamespace());
    }

    @Test
    public void shouldCanonicalizeNamespaceWithoutTrailingSlash() {
        Properties properties = new Properties();
        properties.setProperty("nukleus.oauth.claim.namespace", "http://example.com");
        OAuthConfiguration config = new OAuthConfiguration(new Configuration(properties));
        Assert.assertEquals((Object)"http://example.com/", (Object)config.getCanonicalClaimNamespace());
    }

    @Test
    public void shouldCanonicalizeNamespaceWithPathWithTrailingSlash() {
        Properties properties = new Properties();
        properties.setProperty("nukleus.oauth.claim.namespace", "http://example.com/path/");
        OAuthConfiguration config = new OAuthConfiguration(new Configuration(properties));
        Assert.assertEquals((Object)"http://example.com/path/", (Object)config.getCanonicalClaimNamespace());
    }

    @Test
    public void shouldCanonicalizeNamespaceWithPathWithoutTrailingSlash() {
        Properties properties = new Properties();
        properties.setProperty("nukleus.oauth.claim.namespace", "http://example.com/path");
        OAuthConfiguration config = new OAuthConfiguration(new Configuration(properties));
        Assert.assertEquals((Object)"http://example.com/path/", (Object)config.getCanonicalClaimNamespace());
    }
}

