/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;

public final class SignalFW
extends Flyweight {
    public static final int FIELD_OFFSET_ROUTE_ID = 0;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int FIELD_OFFSET_STREAM_ID = 8;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 16;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE = 24;
    private static final int FIELD_SIZE_TRACE = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 32;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_SIGNAL_ID = 40;
    private static final int FIELD_SIZE_SIGNAL_ID = 8;
    public static final int FIELD_OFFSET_EXTENSION = 48;
    public static final int TYPE_ID = 0x40000003;
    private final OctetsFW extensionRO = new OctetsFW();

    public long routeId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long streamId() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long trace() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 32);
    }

    public long signalId() {
        return this.buffer().getLong(this.offset() + 40);
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 0x40000003;
    }

    @Override
    public SignalFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.extensionRO.wrap(buffer, offset + 48, maxLimit);
        SignalFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public SignalFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.extensionRO.tryWrap(buffer, offset + 48, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("SIGNAL [routeId=%d, streamId=%d, timestamp=%d, trace=%d, authorization=%d, signalId=%d, extension=%s]", this.routeId(), this.streamId(), this.timestamp(), this.trace(), this.authorization(), this.signalId(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<SignalFW> {
        private static final int INDEX_ROUTE_ID = 0;
        private static final int INDEX_STREAM_ID = 1;
        private static final int INDEX_TIMESTAMP = 2;
        private static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE = 3;
        private static final long DEFAULT_TRACE = 0L;
        private static final int INDEX_AUTHORIZATION = 4;
        private static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_SIGNAL_ID = 5;
        private static final int INDEX_EXTENSION = 6;
        private static final int FIELD_COUNT = 7;
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new SignalFW());
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder streamId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder trace(long value) {
            if (this.lastFieldSet < 2) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            if (this.lastFieldSet < 3) {
                this.trace(0L);
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        public Builder signalId(long value) {
            if (this.lastFieldSet < 4) {
                this.authorization(0L);
            }
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 5;
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder extension() {
            assert (this.lastFieldSet == 5);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 6;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public SignalFW build() {
            if (this.lastFieldSet < 6) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 6);
            this.lastFieldSet = -1;
            return (SignalFW)super.build();
        }
    }
}

