/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.stream;

import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.AbortFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.BeginFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.ChallengeFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.DataFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.EndFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.ResetFW;
import org.reaktivity.nukleus.oauth.internal.types.stream.WindowFW;

public class Writer {
    private final BeginFW.Builder beginRW = new BeginFW.Builder();
    private final DataFW.Builder dataRW = new DataFW.Builder();
    private final EndFW.Builder endRW = new EndFW.Builder();
    private final WindowFW.Builder windowRW = new WindowFW.Builder();
    private final ResetFW.Builder resetRW = new ResetFW.Builder();
    private final AbortFW.Builder abortRW = new AbortFW.Builder();
    private final ChallengeFW.Builder challengeRW = new ChallengeFW.Builder();
    private final MutableDirectBuffer writeBuffer;

    public Writer(MutableDirectBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
    }

    public void doBegin(MessageConsumer receiver, long routeId, long streamId, long traceId, long authorization, Flyweight extension) {
        BeginFW begin = this.beginRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        receiver.accept(begin.typeId(), begin.buffer(), begin.offset(), begin.sizeof());
    }

    public void doData(MessageConsumer receiver, long routeId, long streamId, long traceId, long authorization, long groupId, int padding, OctetsFW payload, Flyweight extension) {
        DataFW data = this.dataRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).groupId(groupId).padding(padding).payload(payload).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        receiver.accept(data.typeId(), data.buffer(), data.offset(), data.sizeof());
    }

    public void doEnd(MessageConsumer receiver, long routeId, long streamId, long traceId, long authorization, Flyweight extension) {
        EndFW end = this.endRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        receiver.accept(end.typeId(), end.buffer(), end.offset(), end.sizeof());
    }

    public void doAbort(MessageConsumer receiver, long routeId, long streamId, long traceId, long authorization) {
        AbortFW abort = this.abortRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).build();
        receiver.accept(abort.typeId(), abort.buffer(), abort.offset(), abort.sizeof());
    }

    public void doWindow(MessageConsumer sender, long routeId, long streamId, long traceId, long authorization, int credit, int padding, long groupId) {
        WindowFW window = this.windowRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).credit(credit).padding(padding).groupId(groupId).build();
        sender.accept(window.typeId(), window.buffer(), window.offset(), window.sizeof());
    }

    public void doWindow(MessageConsumer sender, long routeId, long streamId, long traceId, long authorization, int credit, int padding, long groupId, int capabilities) {
        WindowFW window = this.windowRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).credit(credit).padding(padding).groupId(groupId).capabilities(capabilities).build();
        sender.accept(window.typeId(), window.buffer(), window.offset(), window.sizeof());
    }

    public void doReset(MessageConsumer sender, long routeId, long streamId, long traceId, long authorization) {
        ResetFW reset = this.resetRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).build();
        sender.accept(reset.typeId(), reset.buffer(), reset.offset(), reset.sizeof());
    }

    public void doChallenge(MessageConsumer receiver, long routeId, long streamId, long traceId, long authorization, Flyweight extension) {
        ChallengeFW challenge = this.challengeRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).trace(traceId).authorization(authorization).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        receiver.accept(challenge.typeId(), challenge.buffer(), challenge.offset(), challenge.sizeof());
    }
}

