/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.control;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.nukleus.oauth.internal.OAuthController;
import org.reaktivity.nukleus.route.RouteKind;
import org.reaktivity.reaktor.test.ReaktorRule;

public class ControllerIT {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Gson gson = new Gson();
    private final K3poRule k3po = new K3poRule().addScriptRoot("resolve", "org/reaktivity/specification/nukleus/oauth/control/resolve").addScriptRoot("unresolve", "org/reaktivity/specification/nukleus/oauth/control/unresolve").addScriptRoot("route", "org/reaktivity/specification/nukleus/oauth/control/route").addScriptRoot("unroute", "org/reaktivity/specification/nukleus/oauth/control/unroute").addScriptRoot("freeze", "org/reaktivity/specification/nukleus/control/freeze");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(5L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").commandBufferCapacity(4096).responseBufferCapacity(4096).counterValuesBufferCapacity(4096).controller("oauth"::equals);
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.k3po).around(this.timeout).around((TestRule)this.reaktor);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    @Specification(value={"${resolve}/fails.too.many.roles/nukleus"})
    public void shouldFailToResolveWithTooManyRoles() throws Exception {
        this.thrown.expect((Matcher)Matchers.either((Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))).or(Matchers.is((Matcher)Matchers.instanceOf(ExecutionException.class))));
        this.thrown.expectCause((Matcher)Matchers.either((Matcher)Matchers.nullValue(Exception.class)).or(Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))));
        this.k3po.start();
        ((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256", new String[]{"role1", "role2", "role3", "role4", "role5", "role6", "role7", "role8", "role9", "role10", "role11", "role12", "role13", "role14", "role15", "role16", "role17", "role18", "role19", "role20", "role21", "role22", "role23", "role24", "role25", "role26", "role27", "role28", "role29", "role30", "role31", "role32", "role33", "role34", "role35", "role36", "role37", "role38", "role39", "role40", "role41", "role42", "role43", "role44", "role45", "role46", "role47", "role48", "role49TooMany"}).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/fails.too.many.realms/nukleus"})
    public void shouldFailToResolveWithTooManyRealms() throws Exception {
        this.thrown.expect(Matchers.is((Matcher)Matchers.instanceOf(ExecutionException.class)));
        this.thrown.expectCause(Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
        this.k3po.start();
        long authorization1 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm1").get();
        Assert.assertEquals((long)0x1000000000000L, (long)authorization1);
        long authorization2 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm2").get();
        Assert.assertEquals((long)0x2000000000000L, (long)authorization2);
        long authorization3 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm3").get();
        Assert.assertEquals((long)0x4000000000000L, (long)authorization3);
        long authorization4 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm4").get();
        Assert.assertEquals((long)0x8000000000000L, (long)authorization4);
        long authorization5 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm5").get();
        Assert.assertEquals((long)0x10000000000000L, (long)authorization5);
        long authorization6 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm6").get();
        Assert.assertEquals((long)0x20000000000000L, (long)authorization6);
        long authorization7 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm7").get();
        Assert.assertEquals((long)0x40000000000000L, (long)authorization7);
        long authorization8 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm8").get();
        Assert.assertEquals((long)0x80000000000000L, (long)authorization8);
        long authorization9 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm9").get();
        Assert.assertEquals((long)0x100000000000000L, (long)authorization9);
        long authorization10 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm10").get();
        Assert.assertEquals((long)0x200000000000000L, (long)authorization10);
        long authorization11 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm11").get();
        Assert.assertEquals((long)0x400000000000000L, (long)authorization11);
        long authorization12 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm12").get();
        Assert.assertEquals((long)0x800000000000000L, (long)authorization12);
        long authorization13 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm13").get();
        Assert.assertEquals((long)0x1000000000000000L, (long)authorization13);
        long authorization14 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm14").get();
        Assert.assertEquals((long)0x2000000000000000L, (long)authorization14);
        long authorization15 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm15").get();
        Assert.assertEquals((long)0x4000000000000000L, (long)authorization15);
        long authorization16 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm16").get();
        Assert.assertEquals((long)Long.MIN_VALUE, (long)authorization16);
        long authorization17TooMany = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("realm17TooMany").get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/multiple.realms/nukleus"})
    public void shouldResolveMultipleRealms() throws Exception {
        this.k3po.start();
        long authorization1 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256").get();
        Assert.assertEquals((long)0x1000000000000L, (long)authorization1);
        long authorization2 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("ES256").get();
        Assert.assertEquals((long)0x2000000000000L, (long)authorization2);
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/one.realm/nukleus"})
    public void shouldResolveOneRealm() throws Exception {
        this.k3po.start();
        long authorization1 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256").get();
        Assert.assertEquals((long)0x1000000000000L, (long)authorization1);
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/with.roles/nukleus"})
    public void shouldResolveWithRoles() throws Exception {
        this.k3po.start();
        long authorization = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256", new String[]{"scope1", "scope2", "scope3"}).get();
        Assert.assertEquals((long)0x1000000000007L, (long)authorization);
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/one.realm.with.issuer.and.audience/nukleus"})
    public void shouldResolveWithIssuerAndAudience() throws Exception {
        this.k3po.start();
        JsonObject extension = new JsonObject();
        extension.addProperty("issuer", "test issuer");
        extension.addProperty("audience", "testAudience");
        long authorization = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256", EMPTY_STRING_ARRAY, this.gson.toJson((JsonElement)extension)).get();
        Assert.assertEquals((long)0x1000000000000L, (long)authorization);
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/with.roles.issuer.and.audience/nukleus"})
    public void shouldResolveWithRolesIssuerAndAudience() throws Exception {
        this.k3po.start();
        JsonObject extension = new JsonObject();
        extension.addProperty("issuer", "test issuer");
        extension.addProperty("audience", "testAudience");
        long authorization = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256", new String[]{"scope1", "scope2", "scope3"}, this.gson.toJson((JsonElement)extension)).get();
        Assert.assertEquals((long)0x1000000000007L, (long)authorization);
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/proxy/nukleus"})
    public void shouldRouteProxy() throws Exception {
        this.k3po.start();
        ((OAuthController)this.reaktor.controller(OAuthController.class)).route(RouteKind.PROXY, "oauth#0", "target#0", 0L).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${unresolve}/fails.unknown.realm/nukleus"})
    public void shouldFailToUnresolveUnkownRealm() throws Exception {
        this.thrown.expect((Matcher)Matchers.either((Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))).or(Matchers.is((Matcher)Matchers.instanceOf(ExecutionException.class))));
        this.thrown.expectCause((Matcher)Matchers.either((Matcher)Matchers.nullValue(Exception.class)).or(Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))));
        this.k3po.start();
        long authorizationWithUnknownRealm = 0x1000000000000000L;
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unresolve(authorizationWithUnknownRealm).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${unresolve}/fails.unknown.role/nukleus"})
    public void shouldFailToUnresolveUnkownRole() throws Exception {
        this.thrown.expect((Matcher)Matchers.either((Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))).or(Matchers.is((Matcher)Matchers.instanceOf(ExecutionException.class))));
        this.thrown.expectCause((Matcher)Matchers.either((Matcher)Matchers.nullValue(Exception.class)).or(Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))));
        this.k3po.start();
        long authorizationWithUnknownRoleBits = 0x1FFFF0000FFFFL;
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unresolve(authorizationWithUnknownRoleBits).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/multiple.realms/nukleus", "${unresolve}/multiple.realms/nukleus"})
    public void shouldUnresolveMultipleRealms() throws Exception {
        this.k3po.start();
        long authorization1 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256").get();
        Assert.assertEquals((long)0x1000000000000L, (long)authorization1);
        long authorization2 = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("ES256").get();
        Assert.assertEquals((long)0x2000000000000L, (long)authorization2);
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unresolve(authorization1).get();
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unresolve(authorization2).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/one.realm/nukleus", "${unresolve}/one.realm/nukleus"})
    public void shouldUnresolveOneRealm() throws Exception {
        this.k3po.start();
        long authorization = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256").get();
        Assert.assertEquals((long)0x1000000000000L, (long)authorization);
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unresolve(authorization).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/with.roles/nukleus", "${unresolve}/with.roles/nukleus"})
    public void shouldUnresolveWithRoles() throws Exception {
        this.k3po.start();
        long authorization = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).resolve("RS256", new String[]{"scope1", "scope2", "scope3"}).get();
        Assert.assertEquals((long)0x1000000000007L, (long)authorization);
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unresolve(authorization).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${unroute}/proxy/fails.unknown.route/nukleus"})
    public void shouldFailToUnrouteProxyWithUnknownRoute() throws Exception {
        this.thrown.expect((Matcher)Matchers.either((Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))).or(Matchers.is((Matcher)Matchers.instanceOf(ExecutionException.class))));
        this.thrown.expectCause((Matcher)Matchers.either((Matcher)Matchers.nullValue(Exception.class)).or(Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class))));
        this.k3po.start();
        long routeId = new Random().nextLong();
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unroute(routeId).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/proxy/nukleus", "${unroute}/proxy/nukleus"})
    public void shouldUnrouteProxy() throws Exception {
        this.k3po.start();
        long routeId = (Long)((OAuthController)this.reaktor.controller(OAuthController.class)).route(RouteKind.PROXY, "oauth#0", "target#0", 0L).get();
        this.k3po.notifyBarrier("ROUTED_PROXY");
        ((OAuthController)this.reaktor.controller(OAuthController.class)).unroute(routeId).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${freeze}/nukleus"})
    @ScriptProperty(value={"nameF00N \"oauth\"", "commandCapacityF00N 4096", "responseCapacityF00N 4096"})
    public void shouldFreeze() throws Exception {
        this.k3po.start();
        ((OAuthController)this.reaktor.controller(OAuthController.class)).freeze().get();
        this.k3po.finish();
    }
}

