/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.stream;

import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.reaktivity.nukleus.buffer.BufferPool;
import org.reaktivity.nukleus.concurrent.SignalingExecutor;
import org.reaktivity.nukleus.oauth.internal.OAuthConfiguration;
import org.reaktivity.nukleus.oauth.internal.stream.OAuthProxyFactory;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.stream.StreamFactory;
import org.reaktivity.nukleus.stream.StreamFactoryBuilder;

public class OAuthProxyFactoryBuilder
implements StreamFactoryBuilder {
    private final OAuthConfiguration config;
    private final Function<String, JsonWebKey> lookupKey;
    private final ToLongFunction<JsonWebSignature> lookupAuthorization;
    private final Long2ObjectHashMap<OAuthProxyFactory.OAuthProxy> correlations;
    private RouteManager router;
    private MutableDirectBuffer writeBuffer;
    private LongUnaryOperator supplyInitialId;
    private LongUnaryOperator supplyReplyId;
    private LongSupplier supplyTrace;
    private SignalingExecutor executor;

    public OAuthProxyFactoryBuilder(OAuthConfiguration config, ToLongFunction<JsonWebSignature> lookupAuthorization, Function<String, JsonWebKey> lookupKey) {
        this.config = config;
        this.lookupKey = lookupKey;
        this.lookupAuthorization = lookupAuthorization;
        this.correlations = new Long2ObjectHashMap();
    }

    public OAuthProxyFactoryBuilder setRouteManager(RouteManager router) {
        this.router = router;
        return this;
    }

    public StreamFactoryBuilder setTraceSupplier(LongSupplier supplyTrace) {
        this.supplyTrace = supplyTrace;
        return this;
    }

    public OAuthProxyFactoryBuilder setWriteBuffer(MutableDirectBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
        return this;
    }

    public OAuthProxyFactoryBuilder setInitialIdSupplier(LongUnaryOperator supplyInitialId) {
        this.supplyInitialId = supplyInitialId;
        return this;
    }

    public StreamFactoryBuilder setReplyIdSupplier(LongUnaryOperator supplyReplyId) {
        this.supplyReplyId = supplyReplyId;
        return this;
    }

    public OAuthProxyFactoryBuilder setGroupBudgetClaimer(LongFunction<IntUnaryOperator> groupBudgetClaimer) {
        return this;
    }

    public OAuthProxyFactoryBuilder setGroupBudgetReleaser(LongFunction<IntUnaryOperator> groupBudgetReleaser) {
        return this;
    }

    public StreamFactoryBuilder setBufferPoolSupplier(Supplier<BufferPool> supplyBufferPool) {
        return this;
    }

    public StreamFactoryBuilder setExecutor(SignalingExecutor executor) {
        this.executor = executor;
        return this;
    }

    public StreamFactory build() {
        return new OAuthProxyFactory(this.config, this.writeBuffer, this.supplyInitialId, this.supplyTrace, this.supplyReplyId, this.correlations, this.lookupKey, this.lookupAuthorization, this.executor, this.router);
    }
}

