/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.util;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.reaktivity.nukleus.oauth.internal.types.StringFW;
import org.reaktivity.nukleus.oauth.internal.util.BufferUtil;

public class BufferUtilTest {
    @Test
    public void shouldEqualStringWhenValueAtStart() {
        UnsafeBuffer buffer = new UnsafeBuffer("cookie".getBytes(StandardCharsets.US_ASCII));
        Assert.assertTrue((boolean)BufferUtil.equals((DirectBuffer)buffer, (int)0, (int)buffer.capacity(), (byte[])"cookie".getBytes()));
    }

    @Test
    public void shouldEqualStringValueInMiddle() {
        UnsafeBuffer buffer = new UnsafeBuffer("a nice warm cookie cutter".getBytes(StandardCharsets.US_ASCII));
        Assert.assertTrue((boolean)BufferUtil.equals((DirectBuffer)buffer, (int)2, (int)6, (byte[])"nice".getBytes()));
    }

    @Test
    public void shouldEqualStringFW() {
        UnsafeBuffer buffer = new UnsafeBuffer("1234567890123456789012345678901234567890".getBytes());
        StringFW value = new StringFW.Builder().wrap((MutableDirectBuffer)buffer, 5, 40).set("cookie", StandardCharsets.US_ASCII).build();
        Assert.assertTrue((boolean)BufferUtil.equals((StringFW)value, (byte[])"cookie".getBytes()));
    }

    @Test
    public void shouldReportUnequalString() {
        UnsafeBuffer buffer = new UnsafeBuffer("cookie".getBytes(StandardCharsets.US_ASCII));
        Assert.assertFalse((boolean)BufferUtil.equals((DirectBuffer)buffer, (int)0, (int)buffer.capacity(), (byte[])"cook".getBytes()));
    }

    @Test
    public void shouldReportUnequalStringFW() {
        UnsafeBuffer buffer = new UnsafeBuffer("1234567890".getBytes());
        StringFW value = new StringFW.Builder().wrap((MutableDirectBuffer)buffer, 0, 10).set("cookie", StandardCharsets.US_ASCII).build();
        Assert.assertFalse((boolean)BufferUtil.equals((StringFW)value, (byte[])"cookie890".getBytes()));
    }

    @Test
    public void shouldReportUnequalStringValueLongerThanBuffer() {
        UnsafeBuffer buffer = new UnsafeBuffer("a nice".getBytes(StandardCharsets.US_ASCII));
        Assert.assertFalse((boolean)BufferUtil.equals((DirectBuffer)buffer, (int)2, (int)6, (byte[])"nicer".getBytes()));
    }

    @Test
    public void shouldReportUnequalStringFWValueLongerThanBuffer() {
        UnsafeBuffer buffer = new UnsafeBuffer("1234567890".getBytes());
        StringFW value = new StringFW.Builder().wrap((MutableDirectBuffer)buffer, 0, 10).set("cookie", StandardCharsets.US_ASCII).build();
        Assert.assertFalse((boolean)BufferUtil.equals((StringFW)value, (byte[])"cookies and cream".getBytes()));
    }

    @Test
    public void shouldReportUnequalWhenBothOfEqualLength() {
        UnsafeBuffer buffer = new UnsafeBuffer("a nice".getBytes(StandardCharsets.US_ASCII));
        Assert.assertFalse((boolean)BufferUtil.equals((DirectBuffer)buffer, (int)0, (int)6, (byte[])"a nick".getBytes()));
    }

    @Test
    public void shouldLocateLimitWhenValueAtEndBuffer() {
        UnsafeBuffer buffer = new UnsafeBuffer("a nice warm cookie cutter".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((long)buffer.capacity(), (long)BufferUtil.limitOfBytes((DirectBuffer)buffer, (int)0, (int)buffer.capacity(), (byte[])"cutter".getBytes()));
    }

    @Test
    public void shouldLocateLimitWhenValueInsideBuffer() {
        UnsafeBuffer buffer = new UnsafeBuffer("a nice warm cookie cutter".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((long)"a nice".length(), (long)BufferUtil.limitOfBytes((DirectBuffer)buffer, (int)0, (int)buffer.capacity(), (byte[])"nice".getBytes()));
    }

    @Test
    public void shouldReportLimitMinusOneWhenValueNotFound() {
        UnsafeBuffer buffer = new UnsafeBuffer("a nice warm cookie cutter".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((long)-1L, (long)BufferUtil.limitOfBytes((DirectBuffer)buffer, (int)0, (int)buffer.capacity(), (byte[])"cutlass".getBytes()));
    }

    @Test
    public void shouldReportLimitMinusOneWhenValueLongerThanBuffer() {
        UnsafeBuffer buffer = new UnsafeBuffer("a nice warm cookie cutter".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((long)-1L, (long)BufferUtil.limitOfBytes((DirectBuffer)buffer, (int)0, (int)buffer.capacity(), (byte[])"a nice warm cookie cutter indeed".getBytes()));
    }
}

