/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.streams;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.nukleus.oauth.internal.OAuthConfiguration;
import org.reaktivity.reaktor.test.ReaktorRule;

public class StreamsIT {
    private final K3poRule k3po = new K3poRule().addScriptRoot("route", "org/reaktivity/specification/nukleus/oauth/control/route/proxy").addScriptRoot("streams", "org/reaktivity/specification/nukleus/oauth/streams/proxy");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(15L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").commandBufferCapacity(4096).responseBufferCapacity(4096).counterValuesBufferCapacity(4096).nukleus("oauth"::equals).configure(OAuthConfiguration.KEYS.name(), "keys/keys.jwk").affinityMask("target#0", Long.MIN_VALUE).clean();
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.reaktor).around((TestRule)this.k3po).around(this.timeout);

    @Test
    @Specification(value={"${route}/resolve.one.realm.with.no.roles.then.route.proxy/controller", "${streams}/authorize.then.abort.expiring.request/accept/client", "${streams}/authorize.then.abort.expiring.request/connect/server"})
    public void shouldAuthorizeThenAbortExpiringRequest() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/resolve.one.realm.with.no.roles.then.route.proxy/controller", "${streams}/authorize.then.abort.expiring.response/accept/client", "${streams}/authorize.then.abort.expiring.response/connect/server"})
    public void shouldAuthorizeThenAbortExpiringResponse() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/resolve.multiple.realms.with.no.roles.then.route.proxy/controller", "${streams}/authorize.query.with.signed.jwt.es256/accept/client", "${streams}/authorize.query.with.signed.jwt.es256/connect/server"})
    public void shouldAuthorizeQueryWithValidJwtEC256OnSecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/proxy.accept.aborts/accept/client", "${streams}/proxy.accept.aborts/connect/server"})
    public void shouldAbortClientConnectWhenAcceptAborts() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/proxy.accept.reply.is.reset/accept/client", "${streams}/proxy.accept.reply.is.reset/connect/server"})
    public void shouldResetClientReplyWhenAcceptReplyIsReset() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/proxy.connect.is.reset/accept/client", "${streams}/proxy.connect.is.reset/connect/server"})
    public void shouldResetAcceptWhenConnectIsReset() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/proxy.connect.reply.aborts/accept/client", "${streams}/proxy.connect.reply.aborts/connect/server"})
    public void shouldAbortAcceptReplyWhenConnectReplyAborts() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.and.response.with.fragmented.data/accept/client", "${streams}/request.and.response.with.fragmented.data/connect/server"})
    public void shouldPropagateWindows() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.expired.jwt.forwarded/accept/client", "${streams}/request.with.expired.jwt.forwarded/connect/server"})
    public void shouldForwardRequestWithExpiredJwtOnUnsecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.expired.jwt.no.route/accept/client"})
    public void shouldRejectRequestWithExpiredJwt() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.invalid.jwt.forwarded/accept/client", "${streams}/request.with.invalid.jwt.forwarded/connect/server"})
    public void shouldForwardRequestWithInvalidJwtOnUnsecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.invalid.jwt.no.route/accept/client"})
    public void shouldRejectRequestWithInvalidJwt() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/resolve.multiple.realms.with.no.roles.then.route.proxy/controller", "${streams}/request.with.signed.jwt.es256.forwarded/accept/client", "${streams}/request.with.signed.jwt.es256.forwarded/connect/server"})
    public void shouldForwardRequestWithValidJwtEC256OnSecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/resolve.one.realm.with.set.roles.then.route.proxy/controller", "${streams}/request.with.scopes.with.signed.jwt.rs256.forwarded/accept/client", "${streams}/request.with.scopes.with.signed.jwt.rs256.forwarded/connect/server"})
    public void shouldForwardRequestWithSetScopesWithValidJwtRS256OnSecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/resolve.one.realm.with.extra.roles.then.route.proxy/controller", "${streams}/request.with.extra.scope.with.signed.jwt.rs256.forwarded/accept/client", "${streams}/request.with.extra.scope.with.signed.jwt.rs256.forwarded/connect/server"})
    public void shouldForwardRequestWithExtraScopeWithValidJwtRS256OnSecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/resolve.one.realm.with.no.roles.then.route.proxy/controller", "${streams}/request.with.signed.jwt.rs256.forwarded/accept/client", "${streams}/request.with.signed.jwt.rs256.forwarded/connect/server"})
    public void shouldForwardRequestWithValidJwtRS256OnSecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.unready.jwt.forwarded/accept/client", "${streams}/request.with.unready.jwt.forwarded/connect/server"})
    public void shouldForwardRequestWithUnreadyJwtOnUnsecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.unready.jwt.no.route/accept/client"})
    public void shouldRejectRequestWithUnreadyJwt() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.unsigned.jwt.forwarded/accept/client", "${streams}/request.with.unsigned.jwt.forwarded/connect/server"})
    public void shouldForwardRequestWithUnsignedJwtOnUnsecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.with.unsigned.jwt.no.route/accept/client"})
    public void shouldRejectRequestWithUnsignedJwt() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.without.authorization.forwarded/accept/client", "${streams}/request.without.authorization.forwarded/connect/server"})
    public void shouldForwardRequestWithoutAuthorizationOnUnsecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.without.authorization.no.route/accept/client"})
    public void shouldRejectRequestWithoutAuthorization() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.without.bearer.forwarded/accept/client", "${streams}/request.without.bearer.forwarded/connect/server"})
    public void shouldForwardRequestWithoutBearerOnUnsecuredRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/controller", "${streams}/request.without.bearer.no.route/accept/client"})
    public void shouldRejectRequestWithoutBearer() throws Exception {
        this.k3po.finish();
    }
}

