/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.control;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.reaktor.test.ReaktorRule;

public class ControlIT {
    private final K3poRule k3po = new K3poRule().addScriptRoot("resolve", "org/reaktivity/specification/nukleus/oauth/control/resolve").addScriptRoot("unresolve", "org/reaktivity/specification/nukleus/oauth/control/unresolve").addScriptRoot("route", "org/reaktivity/specification/nukleus/oauth/control/route").addScriptRoot("unroute", "org/reaktivity/specification/nukleus/oauth/control/unroute").addScriptRoot("freeze", "org/reaktivity/specification/nukleus/control/freeze");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(5L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").commandBufferCapacity(4096).responseBufferCapacity(4096).counterValuesBufferCapacity(4096).nukleus("oauth"::equals).configure("oauth.keys", "keys/keys.jwk");
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.k3po).around(this.timeout).around((TestRule)this.reaktor);

    @Test
    @Specification(value={"${resolve}/fails.too.many.roles/controller"})
    public void shouldFailToResolveWithTooManyRoles() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/fails.too.many.realms/controller"})
    public void shouldFailToResolveWithTooManyRealms() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/multiple.realms/controller"})
    public void shouldResolveMultipleRealms() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/one.realm/controller"})
    public void shouldResolveOneRealm() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/with.roles/controller"})
    public void shouldResolveWithRoles() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/proxy/controller"})
    public void shouldRouteProxy() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${unresolve}/fails.unknown.realm/controller"})
    public void shouldFailToUnresolveUnkownRealm() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${unresolve}/fails.unknown.role/controller"})
    public void shouldFailToUnresolveUnkownRole() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/multiple.realms/controller", "${unresolve}/multiple.realms/controller"})
    public void shouldUnresolveMultipleRealms() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/one.realm/controller", "${unresolve}/one.realm/controller"})
    public void shouldUnresolveOneRealm() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/with.roles/controller", "${unresolve}/with.roles/controller"})
    public void shouldUnresolveWithRoles() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${unroute}/proxy/fails.unknown.route/controller"})
    public void shouldFailToUnrouteProxyWithUnknownRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/proxy/controller", "${unroute}/proxy/controller"})
    public void shouldUnrouteProxy() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${freeze}/controller"})
    @ScriptProperty(value={"nameF00C \"oauth\"", "commandCapacityF00C 4096", "responseCapacityF00C 4096"})
    public void shouldFreeze() throws Exception {
        this.k3po.finish();
    }
}

