/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import java.security.Key;
import java.security.KeyPair;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.junit.Assert;
import org.junit.Test;
import org.reaktivity.nukleus.oauth.internal.OAuthRealms;
import org.reaktivity.specification.nukleus.oauth.internal.OAuthJwtKeys;

public class OAuthRealmsTest {
    @Test
    public void shouldAddUpToMaximumRealms() throws Exception {
        OAuthRealms realms = new OAuthRealms();
        for (int i = 0; i < 16; ++i) {
            realms.resolve("realm" + i);
        }
    }

    @Test
    public void shouldNotAddTooManyRealms() throws Exception {
        OAuthRealms realms = new OAuthRealms();
        for (int i = 0; i < 16; ++i) {
            realms.resolve("realm" + i);
        }
        Assert.assertEquals((long)0L, (long)realms.resolve("one realm too many"));
    }

    @Test
    public void shouldResolveKnownRealms() throws Exception {
        OAuthRealms realms = new OAuthRealms();
        realms.resolve("realm one");
        realms.resolve("realm two");
        JwtClaims claims = new JwtClaims();
        claims.setClaim("iss", (Object)"test issuer");
        String payload = claims.toJson();
        JsonWebSignature signatureOne = this.newSignedSignature("realm one", "RS256", payload, OAuthJwtKeys.RFC7515_RS256);
        JsonWebSignature signatureTwo = this.newSignedSignature("realm two", "ES256", payload, OAuthJwtKeys.RFC7515_ES256);
        Assert.assertEquals((long)0x1000000000000L, (long)realms.lookup(signatureOne));
        Assert.assertEquals((long)0x2000000000000L, (long)realms.lookup(signatureTwo));
    }

    @Test
    public void shouldNotResolveUnknownRealm() throws Exception {
        OAuthRealms realms = new OAuthRealms();
        JsonWebSignature signature = new JsonWebSignature();
        Assert.assertEquals((long)0L, (long)realms.lookup(signature));
    }

    @Test
    public void shouldUnresolveAllKnownRealms() throws Exception {
        int i;
        OAuthRealms realms = new OAuthRealms();
        JwtClaims claims = new JwtClaims();
        claims.setClaim("iss", (Object)"test issuer");
        String payload = claims.toJson();
        for (i = 0; i < 16; ++i) {
            realms.resolve("realm" + i);
        }
        for (i = 0; i < 16; ++i) {
            JsonWebSignature signature = this.newSignedSignature("realm" + i, "RS256", payload, OAuthJwtKeys.RFC7515_RS256);
            Assert.assertTrue((boolean)realms.unresolve(realms.lookup(signature)));
        }
    }

    @Test
    public void shouldNotUnresolveUnknownRealm() throws Exception {
        OAuthRealms realms = new OAuthRealms();
        realms.resolve("realm one");
        Assert.assertFalse((boolean)realms.unresolve(0x2000000000000L));
    }

    @Test
    public void shouldNotUnresolveInvalidRealm() throws Exception {
        OAuthRealms realms = new OAuthRealms();
        realms.resolve("realm one");
        realms.resolve("realm two");
        Assert.assertFalse((boolean)realms.unresolve(0x3000000000000L));
    }

    private JsonWebSignature newSignedSignature(String kid, String alg, String payload, KeyPair pair) throws Exception {
        JsonWebSignature signature = new JsonWebSignature();
        signature.setPayload(payload);
        signature.setKey((Key)pair.getPrivate());
        signature.setKeyIdHeaderValue(kid);
        signature.setAlgorithmHeaderValue(alg);
        signature.sign();
        signature.setKey((Key)pair.getPublic());
        return signature;
    }
}

