// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import java.nio.charset.StandardCharsets;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class HttpHeaderFW extends Flyweight {
  public static final int FIELD_OFFSET_REPRESENTATION = 0;

  private static final int FIELD_SIZE_REPRESENTATION = BitUtil.SIZE_OF_BYTE;

  public static final int FIELD_OFFSET_NAME = FIELD_OFFSET_REPRESENTATION + FIELD_SIZE_REPRESENTATION;

  public static final int FIELD_OFFSET_VALUE = 0;

  private final StringFW nameRO = new StringFW();

  private final String16FW valueRO = new String16FW();

  public byte representation() {
    return buffer().getByte(offset() + FIELD_OFFSET_REPRESENTATION);
  }

  public StringFW name() {
    return nameRO;
  }

  public String16FW value() {
    return valueRO;
  }

  @Override
  public HttpHeaderFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    nameRO.wrap(buffer, offset + FIELD_OFFSET_NAME, maxLimit);
    valueRO.wrap(buffer, nameRO.limit() + FIELD_OFFSET_VALUE, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public HttpHeaderFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == nameRO.tryWrap(buffer, offset + FIELD_OFFSET_NAME, maxLimit)) {
      return null;
    }
    if (null == valueRO.tryWrap(buffer, nameRO.limit() + FIELD_OFFSET_VALUE, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return valueRO.limit();
  }

  @Override
  public String toString() {
    return String.format("HTTP_HEADER [representation=%d, name=%s, value=%s]", representation(), nameRO.asString(), valueRO.asString());
  }

  public static final class Builder extends Flyweight.Builder<HttpHeaderFW> {
    private static final int INDEX_REPRESENTATION = 0;

    private static final byte DEFAULT_REPRESENTATION = 0;

    private static final int INDEX_NAME = 1;

    private static final int INDEX_VALUE = 2;

    private static final int FIELD_COUNT = 3;

    private final StringFW.Builder nameRW = new StringFW.Builder();

    private final String16FW.Builder valueRW = new String16FW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new HttpHeaderFW());
    }

    public Builder representation(byte value) {
      assert lastFieldSet == INDEX_REPRESENTATION - 1;
      int newLimit = limit() + FIELD_SIZE_REPRESENTATION;
      checkLimit(newLimit, maxLimit());
      buffer().putByte(limit(), value);
      lastFieldSet = INDEX_REPRESENTATION;
      limit(newLimit);
      return this;
    }

    private StringFW.Builder name() {
      if (lastFieldSet < INDEX_REPRESENTATION) {
        representation(DEFAULT_REPRESENTATION);
      }
      assert lastFieldSet == INDEX_NAME - 1;
      return nameRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder name(String value) {
      StringFW.Builder nameRW = name();
      nameRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_NAME;
      limit(nameRW.build().limit());
      return this;
    }

    public Builder name(StringFW value) {
      StringFW.Builder nameRW = name();
      nameRW.set(value);
      lastFieldSet = INDEX_NAME;
      limit(nameRW.build().limit());
      return this;
    }

    public Builder name(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder nameRW = name();
      nameRW.set(buffer, offset, length);
      lastFieldSet = INDEX_NAME;
      limit(nameRW.build().limit());
      return this;
    }

    private String16FW.Builder value() {
      assert lastFieldSet == INDEX_VALUE - 1;
      return valueRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder value(String value) {
      String16FW.Builder valueRW = value();
      valueRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_VALUE;
      limit(valueRW.build().limit());
      return this;
    }

    public Builder value(String16FW value) {
      String16FW.Builder valueRW = value();
      valueRW.set(value);
      lastFieldSet = INDEX_VALUE;
      limit(valueRW.build().limit());
      return this;
    }

    public Builder value(DirectBuffer buffer, int offset, int length) {
      String16FW.Builder valueRW = value();
      valueRW.set(buffer, offset, length);
      lastFieldSet = INDEX_VALUE;
      limit(valueRW.build().limit());
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public HttpHeaderFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
