/*
 * Copyright 2020 Readium Foundation. All rights reserved.
 * Use of this source code is governed by the BSD-style license
 * available in the top-level LICENSE file of the project.
 */

package org.readium.r2.shared.util

import kotlin.reflect.KProperty0
import kotlin.reflect.jvm.isAccessible
import org.readium.r2.shared.InternalReadiumApi

/**
 * Returns true if a lazy property reference has been initialized, or if the property is not lazy.
 *
 * Source: https://stackoverflow.com/a/42536189/1474476
 */
@InternalReadiumApi
public val KProperty0<*>.isLazyInitialized: Boolean
    get() {
        if (this !is Lazy<*>) return true

        // Prevent IllegalAccessException from JVM access check on private properties.
        val originalAccessLevel = isAccessible
        isAccessible = true
        val isLazyInitialized = (getDelegate() as Lazy<*>).isInitialized()
        // Reset access level.
        isAccessible = originalAccessLevel
        return isLazyInitialized
    }
