package org.readium.r2.lcp.persistence;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class LcpDatabase_Impl extends LcpDatabase {
  private volatile LcpDao _lcpDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(2) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `passphrases` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `license_id` TEXT, `provider` TEXT, `user_id` TEXT, `passphrase` TEXT NOT NULL)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `licenses` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `license_id` TEXT NOT NULL, `right_print` INTEGER, `right_copy` INTEGER, `registered` INTEGER NOT NULL DEFAULT 0)");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '89728981fa80b09a9dfcadc5da1fac1d')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `passphrases`");
        db.execSQL("DROP TABLE IF EXISTS `licenses`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsPassphrases = new HashMap<String, TableInfo.Column>(5);
        _columnsPassphrases.put("id", new TableInfo.Column("id", "INTEGER", false, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPassphrases.put("license_id", new TableInfo.Column("license_id", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPassphrases.put("provider", new TableInfo.Column("provider", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPassphrases.put("user_id", new TableInfo.Column("user_id", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPassphrases.put("passphrase", new TableInfo.Column("passphrase", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPassphrases = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPassphrases = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPassphrases = new TableInfo("passphrases", _columnsPassphrases, _foreignKeysPassphrases, _indicesPassphrases);
        final TableInfo _existingPassphrases = TableInfo.read(db, "passphrases");
        if (!_infoPassphrases.equals(_existingPassphrases)) {
          return new RoomOpenHelper.ValidationResult(false, "passphrases(org.readium.r2.lcp.persistence.Passphrase).\n"
                  + " Expected:\n" + _infoPassphrases + "\n"
                  + " Found:\n" + _existingPassphrases);
        }
        final HashMap<String, TableInfo.Column> _columnsLicenses = new HashMap<String, TableInfo.Column>(5);
        _columnsLicenses.put("id", new TableInfo.Column("id", "INTEGER", false, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLicenses.put("license_id", new TableInfo.Column("license_id", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLicenses.put("right_print", new TableInfo.Column("right_print", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLicenses.put("right_copy", new TableInfo.Column("right_copy", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLicenses.put("registered", new TableInfo.Column("registered", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLicenses = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLicenses = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoLicenses = new TableInfo("licenses", _columnsLicenses, _foreignKeysLicenses, _indicesLicenses);
        final TableInfo _existingLicenses = TableInfo.read(db, "licenses");
        if (!_infoLicenses.equals(_existingLicenses)) {
          return new RoomOpenHelper.ValidationResult(false, "licenses(org.readium.r2.lcp.persistence.License).\n"
                  + " Expected:\n" + _infoLicenses + "\n"
                  + " Found:\n" + _existingLicenses);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "89728981fa80b09a9dfcadc5da1fac1d", "5d787efcad966e75e6d9483c362ba5cc");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "passphrases","licenses");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `passphrases`");
      _db.execSQL("DELETE FROM `licenses`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(LcpDao.class, LcpDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public LcpDao lcpDao() {
    if (_lcpDao != null) {
      return _lcpDao;
    } else {
      synchronized(this) {
        if(_lcpDao == null) {
          _lcpDao = new LcpDao_Impl(this);
        }
        return _lcpDao;
      }
    }
  }
}
