/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.example.unicast;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.reactivestreams.example.unicast.AsyncIterablePublisher;

public class NumberIterablePublisher
extends AsyncIterablePublisher<Integer> {
    public NumberIterablePublisher(final int from, final int to, Executor executor) {
        super(new Iterable<Integer>(){
            {
                if (from > to) {
                    throw new IllegalArgumentException("from must be equal or greater than to!");
                }
            }

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int at;
                    {
                        this.at = from;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.at < to;
                    }

                    @Override
                    public Integer next() {
                        if (!this.hasNext()) {
                            return (Integer)Collections.emptyList().iterator().next();
                        }
                        return this.at++;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, executor);
    }
}

