/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.senders;

import io.cloudevents.CloudEvent;
import java.beans.ConstructorProperties;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.reactivecommons.api.domain.Command;
import org.reactivecommons.async.api.AsyncQuery;
import org.reactivecommons.async.api.DirectAsyncGateway;
import org.reactivecommons.async.api.From;
import reactor.core.publisher.Mono;

public class GenericDirectAsyncGateway
implements DirectAsyncGateway {
    private final ConcurrentMap<String, DirectAsyncGateway> directAsyncGateways;

    public <T> Mono<Void> sendCommand(Command<T> command, String targetName) {
        return this.sendCommand(command, targetName, "app");
    }

    public <T> Mono<Void> sendCommand(Command<T> command, String targetName, long delayMillis) {
        return this.sendCommand(command, targetName, delayMillis, "app");
    }

    public <T> Mono<Void> sendCommand(Command<T> command, String targetName, String domain) {
        return ((DirectAsyncGateway)this.directAsyncGateways.get(domain)).sendCommand(command, targetName);
    }

    public <T> Mono<Void> sendCommand(Command<T> command, String targetName, long delayMillis, String domain) {
        return ((DirectAsyncGateway)this.directAsyncGateways.get(domain)).sendCommand(command, targetName, delayMillis);
    }

    public Mono<Void> sendCommand(CloudEvent command, String targetName) {
        return this.sendCommand(command, targetName, "app");
    }

    public Mono<Void> sendCommand(CloudEvent command, String targetName, long delayMillis) {
        return this.sendCommand(command, targetName, delayMillis, "app");
    }

    public Mono<Void> sendCommand(CloudEvent command, String targetName, String domain) {
        return ((DirectAsyncGateway)this.directAsyncGateways.get(domain)).sendCommand(command, targetName);
    }

    public Mono<Void> sendCommand(CloudEvent command, String targetName, long delayMillis, String domain) {
        return ((DirectAsyncGateway)this.directAsyncGateways.get(domain)).sendCommand(command, targetName, delayMillis);
    }

    public <T, R> Mono<R> requestReply(AsyncQuery<T> query, String targetName, Class<R> type) {
        return this.requestReply(query, targetName, type, "app");
    }

    public <T, R> Mono<R> requestReply(AsyncQuery<T> query, String targetName, Class<R> type, String domain) {
        return ((DirectAsyncGateway)this.directAsyncGateways.get(domain)).requestReply(query, targetName, type);
    }

    public <R extends CloudEvent> Mono<R> requestReply(CloudEvent query, String targetName, Class<R> type) {
        return this.requestReply(query, targetName, type, "app");
    }

    public <R extends CloudEvent> Mono<R> requestReply(CloudEvent query, String targetName, Class<R> type, String domain) {
        return ((DirectAsyncGateway)this.directAsyncGateways.get(domain)).requestReply(query, targetName, type);
    }

    public <T> Mono<Void> reply(T response, From from) {
        return ((DirectAsyncGateway)this.directAsyncGateways.get("app")).reply(response, from);
    }

    @ConstructorProperties(value={"directAsyncGateways"})
    @Generated
    public GenericDirectAsyncGateway(ConcurrentMap<String, DirectAsyncGateway> directAsyncGateways) {
        this.directAsyncGateways = directAsyncGateways;
    }
}

