/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.props;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.reactivecommons.async.starter.exceptions.InvalidConfigurationException;
import org.reactivecommons.async.starter.props.GenericAsyncProps;
import org.reactivecommons.async.starter.props.GenericAsyncPropsDomainProperties;

public class GenericAsyncPropsDomain<T extends GenericAsyncProps<P>, P>
extends HashMap<String, T> {
    private Class<T> asyncPropsClass;
    private Class<P> propsClass;

    public GenericAsyncPropsDomain(String defaultAppName, P defaultProperties, GenericAsyncPropsDomainProperties<T, P> configured, SecretFiller<P> secretFiller, Class<T> asyncPropsClass, Class<P> propsClass) {
        super(configured);
        this.propsClass = propsClass;
        this.asyncPropsClass = asyncPropsClass;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        if (!this.containsKey("app")) {
            throw new InvalidConfigurationException("Required domain 'app' is not configured.");
        }
        super.forEach((key, value) -> {
            if (value.getAppName() == null) {
                if (defaultAppName == null || defaultAppName.isEmpty()) {
                    throw new InvalidConfigurationException("defaultAppName does not has value and domain " + key + " has not set the property appName. please use respective property or  spring.application.name property or withDefaultAppName in builder");
                }
                value.setAppName(defaultAppName);
            }
            if (value.getConnectionProperties() == null) {
                if (defaultProperties == null) {
                    throw new InvalidConfigurationException("Domain " + key + " could not be instantiated because no properties found, please use withDefaultProperties or define thedefault " + key + " domain with properties explicitly");
                }
                value.setConnectionProperties(mapper.convertValue(defaultProperties, propsClass));
            }
            if (secretFiller != null) {
                secretFiller.fillWithSecret((String)key, (GenericAsyncProps<P>)value);
            }
            this.fillCustoms(value);
        });
    }

    protected void fillCustoms(T asyncProps) {
    }

    public T getProps(String domain) {
        GenericAsyncProps props = (GenericAsyncProps)this.get(domain);
        if (props == null) {
            throw new InvalidConfigurationException("Domain " + domain + " id not defined");
        }
        return (T)props;
    }

    public static <T extends GenericAsyncProps<P>, P, X extends GenericAsyncPropsDomainProperties<T, P>, R extends GenericAsyncPropsDomain<T, P>> AsyncPropsDomainBuilder<T, P, X, R> builder(Class<P> propsClass, Class<X> asyncPropsDomainClass, Constructor<R> returnType) {
        return new AsyncPropsDomainBuilder(propsClass, asyncPropsDomainClass, returnType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericAsyncPropsDomain that = (GenericAsyncPropsDomain)o;
        return Objects.equals(this.asyncPropsClass, that.asyncPropsClass) && Objects.equals(this.propsClass, that.propsClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.asyncPropsClass, this.propsClass);
    }

    @Generated
    public Class<T> getAsyncPropsClass() {
        return this.asyncPropsClass;
    }

    @Generated
    public Class<P> getPropsClass() {
        return this.propsClass;
    }

    @Generated
    public void setAsyncPropsClass(Class<T> asyncPropsClass) {
        this.asyncPropsClass = asyncPropsClass;
    }

    @Generated
    public void setPropsClass(Class<P> propsClass) {
        this.propsClass = propsClass;
    }

    public static interface SecretFiller<P> {
        public void fillWithSecret(String var1, GenericAsyncProps<P> var2);
    }

    public static class AsyncPropsDomainBuilder<T extends GenericAsyncProps<P>, P, X extends GenericAsyncPropsDomainProperties<T, P>, R extends GenericAsyncPropsDomain<T, P>> {
        private final Class<P> propsClass;
        private final Class<X> asyncPropsDomainClass;
        private final Constructor<R> returnType;
        private String defaultAppName;
        private final HashMap<String, T> domains = new HashMap();
        private P defaultProperties;
        private SecretFiller<P> secretFiller;

        public AsyncPropsDomainBuilder(Class<P> propsClass, Class<X> asyncPropsDomainClass, Constructor<R> returnType) {
            this.propsClass = propsClass;
            this.asyncPropsDomainClass = asyncPropsDomainClass;
            this.returnType = returnType;
        }

        public AsyncPropsDomainBuilder<T, P, X, R> withDefaultProperties(P defaultProperties) {
            this.defaultProperties = defaultProperties;
            return this;
        }

        public AsyncPropsDomainBuilder<T, P, X, R> withDefaultAppName(String defaultAppName) {
            this.defaultAppName = defaultAppName;
            return this;
        }

        public AsyncPropsDomainBuilder<T, P, X, R> withSecretFiller(SecretFiller<P> secretFiller) {
            this.secretFiller = secretFiller;
            return this;
        }

        public AsyncPropsDomainBuilder<T, P, X, R> withDomain(String domain, T props) {
            this.domains.put(domain, props);
            return this;
        }

        public R build() {
            GenericAsyncPropsDomainProperties domainProperties = (GenericAsyncPropsDomainProperties)AsyncPropsDomainBuilder.instantiate(this.asyncPropsDomainClass, this.domains);
            if (this.defaultProperties == null) {
                this.defaultProperties = AsyncPropsDomainBuilder.instantiate(this.propsClass);
            }
            return (R)((GenericAsyncPropsDomain)this.returnType.newInstance(this.defaultAppName, this.defaultProperties, domainProperties, this.secretFiller));
        }

        private static <X> X instantiate(Class<X> xClass) {
            return xClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }

        private static <X> X instantiate(Class<X> xClass, Map<?, ?> arg) {
            return xClass.getDeclaredConstructor(Map.class).newInstance(arg);
        }
    }
}

