/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.luava.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rdlinux.luava.json.JacksonUtils;

public class HttpServletUtils {
    public static boolean isAjax(HttpServletRequest request) {
        if (request.getMethod().equalsIgnoreCase("GET")) {
            String userAgent = request.getHeader("user-agent").toLowerCase();
            if (userAgent.contains("postman")) {
                return true;
            }
            if (userAgent.contains("postwoman")) {
                return true;
            }
            if (userAgent.contains("httpclient")) {
                return true;
            }
            if (userAgent.contains("okhttp")) {
                return true;
            }
            if (userAgent.contains("paw")) {
                return true;
            }
            String XRequestedWithHeader = request.getHeader("X-Requested-With");
            if ("XMLHttpRequest".equalsIgnoreCase(XRequestedWithHeader)) {
                return true;
            }
            String contentTypeHeader = request.getHeader("Content-Type");
            if (contentTypeHeader != null && contentTypeHeader.contains("json")) {
                return true;
            }
            String acceptHeader = request.getHeader("Accept");
            return acceptHeader != null && acceptHeader.contains("json");
        }
        return true;
    }

    public static boolean isMSBrowser(HttpServletRequest request) {
        String[] IEBrowserSignals = new String[]{"MSIE", "Trident", "Edge"};
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        for (String signal : IEBrowserSignals) {
            if (!userAgent.contains(signal)) continue;
            return true;
        }
        return false;
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ((ipAddress = request.getRemoteAddr()).equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1"))) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String encodeFileName(String fileName) {
        try {
            return URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setResponseFileName(HttpServletResponse response, String fileName) {
        fileName = HttpServletUtils.encodeFileName(fileName);
        String contentDispositionValue = "attachment; filename=" + fileName + "; filename*=utf-8''" + fileName;
        response.setHeader("Content-Disposition", contentDispositionValue);
    }

    public static void responseFile(HttpServletResponse response, File file) {
        try {
            ServletOutputStream out = response.getOutputStream();
            FileInputStream input = new FileInputStream(file);
            response.setContentType("multipart/form-data");
            String fileName = file.getName();
            HttpServletUtils.setResponseFileName(response, fileName);
            byte[] bin = new byte[4096];
            int i = 0;
            while (i != -1) {
                i = input.read(bin);
                if (i != -1) {
                    out.write(bin, 0, i);
                    continue;
                }
                input.close();
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void responseFile(HttpServletResponse response, String fileName, InputStream inputStream) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            response.setContentType("multipart/form-data");
            HttpServletUtils.setResponseFileName(response, fileName);
            byte[] bin = new byte[4096];
            int i = 0;
            while (i != -1) {
                i = inputStream.read(bin);
                if (i != -1) {
                    out.write(bin, 0, i);
                    continue;
                }
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void responseJson(boolean isMSBrowser, HttpServletResponse response, Object data) {
        response.setCharacterEncoding("UTF-8");
        if (isMSBrowser) {
            response.setHeader("Content-type", "text/html;charset=UTF-8");
            response.setContentType("text/html");
        } else {
            response.setHeader("Content-type", "text/json;charset=UTF-8");
            response.setContentType("text/json");
        }
        try (PrintWriter writer = response.getWriter();){
            writer.write(JacksonUtils.toJsonString((Object)data));
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void responseJson(HttpServletResponse response, Object data) {
        HttpServletUtils.responseJson(false, response, data);
    }

    public static void responseJson(HttpServletRequest request, HttpServletResponse response, Object data) {
        boolean isMSBrowser = HttpServletUtils.isMSBrowser(request);
        HttpServletUtils.responseJson(isMSBrowser, response, data);
    }
}

