/*
 * Decompiled with CFR 0.152.
 */
package org.rationalityfrontline.ktrader.broker.ctp;

import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rationalityfrontline.jctp.CThostFtdcBrokerTradingParamsField;
import org.rationalityfrontline.jctp.CThostFtdcDepthMarketDataField;
import org.rationalityfrontline.jctp.CThostFtdcInputOrderActionField;
import org.rationalityfrontline.jctp.CThostFtdcInputOrderField;
import org.rationalityfrontline.jctp.CThostFtdcInstrumentCommissionRateField;
import org.rationalityfrontline.jctp.CThostFtdcInstrumentField;
import org.rationalityfrontline.jctp.CThostFtdcInstrumentMarginRateField;
import org.rationalityfrontline.jctp.CThostFtdcInstrumentOrderCommRateField;
import org.rationalityfrontline.jctp.CThostFtdcInstrumentStatusField;
import org.rationalityfrontline.jctp.CThostFtdcInvestorPositionField;
import org.rationalityfrontline.jctp.CThostFtdcOptionInstrCommRateField;
import org.rationalityfrontline.jctp.CThostFtdcOptionInstrTradeCostField;
import org.rationalityfrontline.jctp.CThostFtdcOrderField;
import org.rationalityfrontline.jctp.CThostFtdcQryBrokerTradingParamsField;
import org.rationalityfrontline.jctp.CThostFtdcQryDepthMarketDataField;
import org.rationalityfrontline.jctp.CThostFtdcQryInstrumentCommissionRateField;
import org.rationalityfrontline.jctp.CThostFtdcQryInstrumentField;
import org.rationalityfrontline.jctp.CThostFtdcQryInstrumentMarginRateField;
import org.rationalityfrontline.jctp.CThostFtdcQryInstrumentOrderCommRateField;
import org.rationalityfrontline.jctp.CThostFtdcQryInvestorPositionField;
import org.rationalityfrontline.jctp.CThostFtdcQryOptionInstrCommRateField;
import org.rationalityfrontline.jctp.CThostFtdcQryOptionInstrTradeCostField;
import org.rationalityfrontline.jctp.CThostFtdcQryOrderField;
import org.rationalityfrontline.jctp.CThostFtdcQryTradeField;
import org.rationalityfrontline.jctp.CThostFtdcQryTradingAccountField;
import org.rationalityfrontline.jctp.CThostFtdcReqAuthenticateField;
import org.rationalityfrontline.jctp.CThostFtdcReqUserLoginField;
import org.rationalityfrontline.jctp.CThostFtdcRspAuthenticateField;
import org.rationalityfrontline.jctp.CThostFtdcRspInfoField;
import org.rationalityfrontline.jctp.CThostFtdcRspUserLoginField;
import org.rationalityfrontline.jctp.CThostFtdcSettlementInfoConfirmField;
import org.rationalityfrontline.jctp.CThostFtdcTradeField;
import org.rationalityfrontline.jctp.CThostFtdcTraderApi;
import org.rationalityfrontline.jctp.CThostFtdcTraderSpi;
import org.rationalityfrontline.jctp.CThostFtdcTradingAccountField;
import org.rationalityfrontline.jctp.THOST_TE_RESUME_TYPE;
import org.rationalityfrontline.jctp.jctpConstants;
import org.rationalityfrontline.kevent.Event;
import org.rationalityfrontline.kevent.EventDispatchMode;
import org.rationalityfrontline.kevent.KEvent;
import org.rationalityfrontline.ktrader.broker.api.Assets;
import org.rationalityfrontline.ktrader.broker.api.BrokerEvent;
import org.rationalityfrontline.ktrader.broker.api.BrokerEventType;
import org.rationalityfrontline.ktrader.broker.api.CommissionRate;
import org.rationalityfrontline.ktrader.broker.api.Direction;
import org.rationalityfrontline.ktrader.broker.api.MarginRate;
import org.rationalityfrontline.ktrader.broker.api.MarketStatus;
import org.rationalityfrontline.ktrader.broker.api.Order;
import org.rationalityfrontline.ktrader.broker.api.OrderOffset;
import org.rationalityfrontline.ktrader.broker.api.OrderStatus;
import org.rationalityfrontline.ktrader.broker.api.OrderType;
import org.rationalityfrontline.ktrader.broker.api.Position;
import org.rationalityfrontline.ktrader.broker.api.Security;
import org.rationalityfrontline.ktrader.broker.api.SecurityType;
import org.rationalityfrontline.ktrader.broker.api.Tick;
import org.rationalityfrontline.ktrader.broker.api.Trade;
import org.rationalityfrontline.ktrader.broker.ctp.BiPosition;
import org.rationalityfrontline.ktrader.broker.ctp.CtpConfig;
import org.rationalityfrontline.ktrader.broker.ctp.CtpMdApi;
import org.rationalityfrontline.ktrader.broker.ctp.CtpTdApi;
import org.rationalityfrontline.ktrader.broker.ctp.MarginPriceType;
import org.rationalityfrontline.ktrader.broker.ctp.QueryOrdersData;
import org.rationalityfrontline.ktrader.broker.ctp.QueryTradesData;
import org.rationalityfrontline.ktrader.broker.ctp.RequestContinuation;
import org.rationalityfrontline.ktrader.broker.ctp.Translator;
import org.rationalityfrontline.ktrader.broker.ctp.UtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u00b0\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ8\u0010Q\u001a\u00020)2\u0006\u0010R\u001a\u00020!2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u00112\u0006\u0010V\u001a\u00020\u00112\u0006\u0010W\u001a\u00020)2\u0006\u0010X\u001a\u00020)H\u0002J8\u0010Y\u001a\u00020)2\u0006\u0010R\u001a\u00020!2\u0006\u0010S\u001a\u00020T2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010W\u001a\u00020)2\u0006\u0010X\u001a\u00020)2\u0006\u0010[\u001a\u00020\u0016H\u0002J&\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020J2\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`J0\u0010a\u001a\u00020]2\u0006\u0010b\u001a\u00020c2\b\b\u0002\u0010d\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`J&\u0010e\u001a\u00020]2\u0006\u0010f\u001a\u00020M2\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`J1\u0010g\u001a\u00020]2\u0006\u0010h\u001a\u00020\u00072\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ\u0006\u0010j\u001a\u00020]J\u0011\u0010k\u001a\u00020]H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u000e\u0010m\u001a\u00020:2\u0006\u0010n\u001a\u00020\u0007J\u0012\u0010o\u001a\u0004\u0018\u00010p2\u0006\u0010R\u001a\u00020!H\u0002J\u0012\u0010q\u001a\u0004\u0018\u00010r2\u0006\u0010R\u001a\u00020!H\u0002J\u001e\u0010s\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00160t2\u0006\u0010n\u001a\u00020\u0007H\u0002J\u0006\u0010u\u001a\u00020\u0007JY\u0010v\u001a\u00020J2\u0006\u0010n\u001a\u00020\u00072\u0006\u0010w\u001a\u00020)2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010S\u001a\u00020T2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020{2\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010|J\u0010\u0010}\u001a\u00020]2\u0006\u0010^\u001a\u00020JH\u0002J\b\u0010~\u001a\u00020\u0011H\u0002J\b\u0010\u007f\u001a\u00020\u0011H\u0002J\u001c\u0010\u0080\u0001\u001a\u00020]2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020\u0001H\u0002J&\u0010\u0084\u0001\u001a\u00020]2\u0006\u0010n\u001a\u00020\u00072\t\b\u0002\u0010\u0085\u0001\u001a\u00020\u0016H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0086\u0001J?\u0010\u0084\u0001\u001a\u00020]2\u0012\b\u0002\u0010\u0087\u0001\u001a\u000b\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0088\u00012\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0089\u0001J=\u0010\u008a\u0001\u001a\t\u0012\u0004\u0012\u00020!0\u008b\u00012\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008d\u0001J6\u0010\u008e\u0001\u001a\u00020\n2\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008d\u0001J&\u0010\u008f\u0001\u001a\u0004\u0018\u00010c2\u0006\u0010n\u001a\u00020\u00072\u0006\u0010S\u001a\u00020T2\t\b\u0002\u0010\u0090\u0001\u001a\u00020\u0016H\u0002J\u001f\u0010\u0091\u0001\u001a\u00020]2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u0007H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J\u001f\u0010\u0093\u0001\u001a\u00020]2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u0007H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J\u001b\u0010\u0094\u0001\u001a\u00020]2\u0006\u0010n\u001a\u00020\u0007H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J@\u0010\u0095\u0001\u001a\u0004\u0018\u00010!2\u0006\u0010n\u001a\u00020\u00072\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001J>\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u000f2\u0006\u0010n\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001J\u0012\u0010\u0098\u0001\u001a\u00020]H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ\u001f\u0010\u0099\u0001\u001a\u00020]2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u0007H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J\u001f\u0010\u009a\u0001\u001a\u00020]2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u0007H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J@\u0010\u009b\u0001\u001a\u0004\u0018\u00010J2\u0006\u0010h\u001a\u00020\u00072\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001JT\u0010\u009c\u0001\u001a\t\u0012\u0004\u0012\u00020J0\u008b\u00012\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00072\t\b\u0002\u0010\u009d\u0001\u001a\u00020\u00162\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u009e\u0001JH\u0010\u009f\u0001\u001a\u0004\u0018\u00010c2\u0006\u0010n\u001a\u00020\u00072\u0006\u0010S\u001a\u00020T2\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a0\u0001JI\u0010\u00a1\u0001\u001a\t\u0012\u0004\u0012\u00020c0\u008b\u00012\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00072\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001JA\u0010\u00a2\u0001\u001a\u0004\u0018\u00010M2\u0007\u0010\u00a3\u0001\u001a\u00020\u00072\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001JU\u0010\u00a4\u0001\u001a\t\u0012\u0004\u0012\u00020M0\u008b\u00012\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010h\u001a\u0004\u0018\u00010\u00072\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00162\u0016\b\u0002\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010`H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a5\u0001J\u0011\u0010\u00a6\u0001\u001a\u00020]2\u0006\u0010^\u001a\u00020JH\u0002JC\u0010\u00a7\u0001\u001a\u00020]\"\u0005\b\u0000\u0010\u00a8\u00012\u0007\u0010\u00a9\u0001\u001a\u00020\u00072\b\u0010\u00aa\u0001\u001a\u0003H\u00a8\u00012\u0018\b\u0002\u0010\u00ab\u0001\u001a\u0011\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00ac\u0001H\u0002\u00a2\u0006\u0003\u0010\u00ad\u0001J5\u0010\u00ae\u0001\u001a\u00020]2\u0007\u0010\u00a9\u0001\u001a\u00020\u00072\u0007\u0010\u00af\u0001\u001a\u00020\u00072\u0018\b\u0002\u0010\u00ab\u0001\u001a\u0011\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00ac\u0001H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0014\u00102\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010+R\u000e\u00104\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002080\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020:0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020>0=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010A\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010G\u001a\u00060HR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020J0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020J0LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010P\u001a\b\u0012\u0004\u0012\u00020J0LX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00b1\u0001"}, d2={"Lorg/rationalityfrontline/ktrader/broker/ctp/CtpTdApi;", "", "config", "Lorg/rationalityfrontline/ktrader/broker/ctp/CtpConfig;", "kEvent", "Lorg/rationalityfrontline/kevent/KEvent;", "sourceId", "", "(Lorg/rationalityfrontline/ktrader/broker/ctp/CtpConfig;Lorg/rationalityfrontline/kevent/KEvent;Ljava/lang/String;)V", "assets", "Lorg/rationalityfrontline/ktrader/broker/api/Assets;", "cacheFile", "Ljava/io/File;", "cachedTickMap", "", "Lorg/rationalityfrontline/ktrader/broker/api/Tick;", "cancelStatistics", "", "codeProductMap", "getConfig", "()Lorg/rationalityfrontline/ktrader/broker/ctp/CtpConfig;", "<set-?>", "", "connected", "getConnected", "()Z", "frontId", "getFrontId", "()I", "futuresMarginPriceType", "Lorg/rationalityfrontline/ktrader/broker/ctp/MarginPriceType;", "inited", "instruments", "Lorg/rationalityfrontline/ktrader/broker/api/Security;", "getInstruments", "()Ljava/util/Map;", "getKEvent", "()Lorg/rationalityfrontline/kevent/KEvent;", "lastQueryAssetsTime", "", "maxLongPrice", "", "getMaxLongPrice", "()D", "mdApi", "Lorg/rationalityfrontline/ktrader/broker/ctp/CtpMdApi;", "getMdApi", "()Lorg/rationalityfrontline/ktrader/broker/ctp/CtpMdApi;", "setMdApi", "(Lorg/rationalityfrontline/ktrader/broker/ctp/CtpMdApi;)V", "minShortPrice", "getMinShortPrice", "optionsMarginPriceType", "orderRef", "Ljava/util/concurrent/atomic/AtomicInteger;", "positions", "Lorg/rationalityfrontline/ktrader/broker/ctp/BiPosition;", "productStatusMap", "Lorg/rationalityfrontline/ktrader/broker/api/MarketStatus;", "requestId", "requestMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/rationalityfrontline/ktrader/broker/ctp/RequestContinuation;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "sessionId", "getSessionId", "getSourceId", "()Ljava/lang/String;", "tdApi", "Lorg/rationalityfrontline/jctp/CThostFtdcTraderApi;", "tdSpi", "Lorg/rationalityfrontline/ktrader/broker/ctp/CtpTdApi$CtpTdSpi;", "todayOrders", "Lorg/rationalityfrontline/ktrader/broker/api/Order;", "todayTrades", "", "Lorg/rationalityfrontline/ktrader/broker/api/Trade;", "tradingDay", "unfinishedLongOrders", "unfinishedShortOrders", "calculateFuturesMargin", "instrument", "direction", "Lorg/rationalityfrontline/ktrader/broker/api/Direction;", "yesterdayVolume", "todayVolume", "avgOpenPrice", "fallback", "calculateOptionsMargin", "volume", "isOpen", "calculateOrder", "", "order", "extras", "", "calculatePosition", "position", "Lorg/rationalityfrontline/ktrader/broker/api/Position;", "calculateValue", "calculateTrade", "trade", "cancelOrder", "orderId", "(Ljava/lang/String;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "connect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInstrumentStatus", "code", "getOrQueryCommissionRate", "Lorg/rationalityfrontline/ktrader/broker/api/CommissionRate;", "getOrQueryMarginRate", "Lorg/rationalityfrontline/ktrader/broker/api/MarginRate;", "getOrQueryTick", "Lkotlin/Pair;", "getTradingDay", "insertOrder", "price", "offset", "Lorg/rationalityfrontline/ktrader/broker/api/OrderOffset;", "orderType", "Lorg/rationalityfrontline/ktrader/broker/api/OrderType;", "(Ljava/lang/String;DILorg/rationalityfrontline/ktrader/broker/api/Direction;Lorg/rationalityfrontline/ktrader/broker/api/OrderOffset;Lorg/rationalityfrontline/ktrader/broker/api/OrderType;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertUnfinishedOrder", "nextOrderRef", "nextRequestId", "postBrokerEvent", "type", "Lorg/rationalityfrontline/ktrader/broker/api/BrokerEventType;", "data", "prepareFeeCalculation", "throwException", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "codes", "", "(Ljava/util/Collection;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryAllInstruments", "", "useCache", "(ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryAssets", "queryCachedPosition", "isClose", "queryFuturesCommissionRate", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryFuturesMarginRate", "queryFuturesOrderCommissionRate", "queryInstrument", "(Ljava/lang/String;ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryLastTick", "queryMarginPriceType", "queryOptionsCommissionRate", "queryOptionsMargin", "queryOrder", "queryOrders", "onlyUnfinished", "(Ljava/lang/String;ZZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryPosition", "(Ljava/lang/String;Lorg/rationalityfrontline/ktrader/broker/api/Direction;ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryPositions", "queryTrade", "tradeId", "queryTrades", "(Ljava/lang/String;Ljava/lang/String;ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeUnfinishedOrder", "resumeRequests", "T", "tag", "result", "predicate", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "resumeRequestsWithException", "errorInfo", "CtpTdSpi", "lib"})
public final class CtpTdApi {
    @NotNull
    private final CtpConfig config;
    @NotNull
    private final KEvent kEvent;
    @NotNull
    private final String sourceId;
    @NotNull
    private final CThostFtdcTraderApi tdApi;
    @NotNull
    private final CtpTdSpi tdSpi;
    @NotNull
    private final ConcurrentHashMap<Integer, RequestContinuation> requestMap;
    @NotNull
    private final AtomicInteger requestId;
    @NotNull
    private final AtomicInteger orderRef;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private String tradingDay;
    @NotNull
    private final File cacheFile;
    public CtpMdApi mdApi;
    private boolean inited;
    private boolean connected;
    private int frontId;
    private int sessionId;
    @NotNull
    private final Map<String, Security> instruments;
    @NotNull
    private final Map<String, String> codeProductMap;
    @NotNull
    private final Map<String, MarketStatus> productStatusMap;
    @NotNull
    private final Map<String, Tick> cachedTickMap;
    @NotNull
    private MarginPriceType futuresMarginPriceType;
    @NotNull
    private MarginPriceType optionsMarginPriceType;
    @NotNull
    private final Assets assets;
    private long lastQueryAssetsTime;
    @NotNull
    private final Map<String, BiPosition> positions;
    @NotNull
    private final Map<String, Order> todayOrders;
    @NotNull
    private final List<Trade> todayTrades;
    @NotNull
    private final List<Order> unfinishedLongOrders;
    @NotNull
    private final List<Order> unfinishedShortOrders;
    @NotNull
    private final Map<String, Integer> cancelStatistics;

    public CtpTdApi(@NotNull CtpConfig config, @NotNull KEvent kEvent, @NotNull String sourceId) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)kEvent, (String)"kEvent");
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        this.config = config;
        this.kEvent = kEvent;
        this.sourceId = sourceId;
        this.requestMap = new ConcurrentHashMap();
        this.requestId = new AtomicInteger(0);
        this.orderRef = new AtomicInteger(10000);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
        this.tradingDay = "";
        boolean bl = false;
        this.instruments = new LinkedHashMap();
        bl = false;
        this.codeProductMap = new LinkedHashMap();
        bl = false;
        this.productStatusMap = new LinkedHashMap();
        bl = false;
        this.cachedTickMap = new LinkedHashMap();
        this.futuresMarginPriceType = MarginPriceType.PRE_SETTLEMENT_PRICE;
        this.optionsMarginPriceType = MarginPriceType.PRE_SETTLEMENT_PRICE;
        this.assets = new Assets(this.config.getInvestorId(), 0.0, 0.0, 0.0, 0.0, 0.0, null, 64, null);
        bl = false;
        this.positions = new LinkedHashMap();
        bl = false;
        this.todayOrders = new LinkedHashMap();
        bl = false;
        this.todayTrades = new ArrayList();
        bl = false;
        this.unfinishedLongOrders = new ArrayList();
        bl = false;
        this.unfinishedShortOrders = new ArrayList();
        bl = false;
        this.cancelStatistics = new LinkedHashMap();
        StringBuilder stringBuilder2 = new StringBuilder();
        CharSequence charSequence3 = this.config.getCachePath();
        boolean bl2 = false;
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            stringBuilder = stringBuilder2;
            boolean bl3 = false;
            string = "./ctp_cache/";
            stringBuilder2 = stringBuilder;
            charSequence2 = string;
        } else {
            charSequence2 = charSequence3;
        }
        StringBuilder stringBuilder3 = stringBuilder2.append((String)charSequence2);
        charSequence3 = this.config.getInvestorId();
        bl2 = false;
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            stringBuilder = stringBuilder3;
            boolean bl4 = false;
            string = "unknown";
            stringBuilder3 = stringBuilder;
            charSequence = string;
        } else {
            charSequence = charSequence3;
        }
        String tdCachePath = stringBuilder3.append((String)charSequence).append("/td/").toString();
        new File(tdCachePath).mkdirs();
        this.cacheFile = new File(Intrinsics.stringPlus((String)tdCachePath, (Object)"cache.txt"));
        charSequence3 = CThostFtdcTraderApi.CreateFtdcTraderApi((String)tdCachePath);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"CreateFtdcTraderApi(tdCachePath)");
        this.tdApi = charSequence3;
        this.tdSpi = new CtpTdSpi();
        charSequence3 = this.tdApi;
        bl2 = false;
        boolean bl5 = false;
        CharSequence $this$_init__u24lambda_u2d3 = charSequence3;
        boolean bl6 = false;
        $this$_init__u24lambda_u2d3.RegisterSpi(this.tdSpi);
        $this$_init__u24lambda_u2d3.SubscribePrivateTopic(THOST_TE_RESUME_TYPE.THOST_TERT_QUICK);
        $this$_init__u24lambda_u2d3.SubscribePublicTopic(THOST_TE_RESUME_TYPE.THOST_TERT_RESTART);
        Iterable $this$forEach$iv = this.getConfig().getTdFronts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String tFront = (String)element$iv;
            boolean bl7 = false;
            $this$_init__u24lambda_u2d3.RegisterFront(tFront);
        }
    }

    @NotNull
    public final CtpConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final KEvent getKEvent() {
        return this.kEvent;
    }

    @NotNull
    public final String getSourceId() {
        return this.sourceId;
    }

    private final int nextRequestId() {
        return this.requestId.incrementAndGet();
    }

    private final int nextOrderRef() {
        int nextOrderRef = this.orderRef.incrementAndGet();
        FilesKt.writeText$default((File)this.cacheFile, (String)(this.tradingDay + '\n' + nextOrderRef), null, (int)2, null);
        return nextOrderRef;
    }

    @NotNull
    public final CtpMdApi getMdApi() {
        CtpMdApi ctpMdApi = this.mdApi;
        if (ctpMdApi != null) {
            return ctpMdApi;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mdApi");
        throw null;
    }

    public final void setMdApi(@NotNull CtpMdApi ctpMdApi) {
        Intrinsics.checkNotNullParameter((Object)ctpMdApi, (String)"<set-?>");
        this.mdApi = ctpMdApi;
    }

    public final boolean getConnected() {
        return this.connected;
    }

    public final int getFrontId() {
        return this.frontId;
    }

    public final int getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final Map<String, Security> getInstruments() {
        return this.instruments;
    }

    private final double getMaxLongPrice() {
        double d;
        Order order2 = (Order)CollectionsKt.firstOrNull(this.unfinishedLongOrders);
        return order2 == null ? Double.MIN_VALUE : (d = order2.getPrice());
    }

    private final double getMinShortPrice() {
        double d;
        Order order2 = (Order)CollectionsKt.lastOrNull(this.unfinishedShortOrders);
        return order2 == null ? Double.MAX_VALUE : (d = order2.getPrice());
    }

    @NotNull
    public final MarketStatus getInstrumentStatus(@NotNull String code) {
        MarketStatus marketStatus;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        String product = this.codeProductMap.get(code);
        return product == null ? MarketStatus.UNKNOWN : ((marketStatus = this.productStatusMap.get(product)) == null ? MarketStatus.UNKNOWN : marketStatus);
    }

    private final void insertUnfinishedOrder(Order order2) {
        Direction direction = order2.getDirection();
        int n = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
        switch (n) {
            case 1: {
                UtilsKt.insert(this.unfinishedLongOrders, order2);
                break;
            }
            case 2: {
                UtilsKt.insert(this.unfinishedShortOrders, order2);
            }
        }
    }

    private final void removeUnfinishedOrder(Order order2) {
        Direction direction = order2.getDirection();
        int n = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
        switch (n) {
            case 1: {
                this.unfinishedLongOrders.remove(order2);
                break;
            }
            case 2: {
                this.unfinishedShortOrders.remove(order2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void resumeRequests(String tag, T result, Function1<? super RequestContinuation, Boolean> predicate) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Collection<RequestContinuation> collection = this.requestMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"requestMap.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RequestContinuation it = (RequestContinuation)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            RequestContinuation req = (RequestContinuation)element$iv;
            boolean bl2 = false;
            Function1<? super RequestContinuation, Boolean> function1 = predicate;
            if (function1 == null) {
                bl = false;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)req, (String)"req");
                bl = (Boolean)function1.invoke((Object)req) == false;
            }
            if (bl) continue;
            function1 = req.getContinuation();
            boolean bl3 = false;
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            function1.resumeWith(Result.constructor-impl(result));
            this.requestMap.remove(req.getRequestId());
        }
    }

    static /* synthetic */ void resumeRequests$default(CtpTdApi ctpTdApi, String string, Object object, Function1 function1, int n, Object object2) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        ctpTdApi.resumeRequests(string, object, (Function1<? super RequestContinuation, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final void resumeRequestsWithException(String tag, String errorInfo, Function1<? super RequestContinuation, Boolean> predicate) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Collection<RequestContinuation> collection = this.requestMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"requestMap.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RequestContinuation it = (RequestContinuation)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            RequestContinuation req = (RequestContinuation)element$iv;
            boolean bl2 = false;
            Function1<? super RequestContinuation, Boolean> function1 = predicate;
            if (function1 == null) {
                bl = false;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)req, (String)"req");
                bl = (Boolean)function1.invoke((Object)req) == false;
            }
            if (bl) continue;
            function1 = req.getContinuation();
            Throwable throwable = new Exception(errorInfo);
            boolean bl3 = false;
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            function1.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
            this.requestMap.remove(req.getRequestId());
        }
    }

    static /* synthetic */ void resumeRequestsWithException$default(CtpTdApi ctpTdApi, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        ctpTdApi.resumeRequestsWithException(string, string2, (Function1<? super RequestContinuation, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final void postBrokerEvent(BrokerEventType type, Object data) {
        void this_$iv;
        KEvent kEvent = this.kEvent;
        BrokerEvent data$iv = new BrokerEvent(type, this.sourceId, data);
        EventDispatchMode dispatchMode$iv = this_$iv.getDefaultDispatchMode();
        boolean isSticky$iv = false;
        boolean $i$f$post = false;
        this_$iv.post(new Event((Enum)type, (Object)data$iv, dispatchMode$iv, isSticky$iv));
    }

    @Nullable
    public final Object connect(@NotNull Continuation<? super Unit> $completion) {
        if (this.inited) {
            return Unit.INSTANCE;
        }
        boolean bl = false;
        boolean bl2 = false;
        Continuation<? super Unit> continuation = $completion;
        boolean bl3 = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl4 = false;
        int requestId = Integer.MIN_VALUE;
        Map map = this.requestMap;
        Integer n = Boxing.boxInt((int)requestId);
        RequestContinuation requestContinuation = new RequestContinuation(requestId, continuation2, "connect", null, 8, null);
        boolean bl5 = false;
        map.put(n, requestContinuation);
        this.tdApi.Init();
        this.inited = true;
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void close() {
        this.tdSpi.OnFrontDisconnected(0);
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        this.instruments.clear();
        this.productStatusMap.clear();
        this.codeProductMap.clear();
        this.cachedTickMap.clear();
        this.todayOrders.clear();
        this.unfinishedLongOrders.clear();
        this.unfinishedShortOrders.clear();
        this.cancelStatistics.clear();
        this.todayTrades.clear();
        this.positions.clear();
        this.tdApi.Release();
        this.tdApi.delete();
    }

    @NotNull
    public final String getTradingDay() {
        String string;
        if (this.connected) {
            string = this.tradingDay;
        } else {
            String string2 = this.tdApi.GetTradingDay();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tdApi.GetTradingDay()");
            string = string2;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object insertOrder(@NotNull String var1_1, double var2_2, int var4_3, @NotNull Direction var5_4, @NotNull OrderOffset var6_5, @NotNull OrderType var7_6, @Nullable Map<String, ? extends Object> var8_7, @NotNull Continuation<? super Order> var9_8) {
        block23: {
            if (!(var9_8 instanceof insertOrder.1)) ** GOTO lbl-1000
            var55_9 = var9_8;
            if ((var55_9.label & -2147483648) != 0) {
                var55_9.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var9_8){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    double D$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ CtpTdApi this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.insertOrder(null, 0.0, 0, null, null, null, null, (Continuation<? super Order>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var79_11 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var10_12 = UtilsKt.parseCode((String)code);
                    exchangeId = (String)var10_12.component1();
                    instrumentId = (String)var10_12.component2();
                    orderRef = String.valueOf(this.nextOrderRef());
                    v0 = direction == Direction.LONG && price >= this.getMinShortPrice() ? "\u672c\u5730\u62d2\u5355\uff1a\u5b58\u5728\u81ea\u6210\u4ea4\u98ce\u9669\uff08\u5f53\u524d\u505a\u591a\u4ef7\u683c\u4e3a " + (double)price + "\uff0c\u6700\u4f4e\u505a\u7a7a\u4ef7\u683c\u4e3a " + this.getMinShortPrice() + '\uff09' : (errorInfo = direction == Direction.SHORT && price <= this.getMaxLongPrice() ? "\u672c\u5730\u62d2\u5355\uff1a\u5b58\u5728\u81ea\u6210\u4ea4\u98ce\u9669\uff08\u5f53\u524d\u505a\u7a7a\u4ef7\u683c\u4e3a " + (double)price + "\uff0c\u6700\u9ad8\u505a\u591a\u4ef7\u683c\u4e3a " + this.getMaxLongPrice() + '\uff09' : null);
                    if (errorInfo != null) break block23;
                    var16_17 = new CThostFtdcInputOrderField();
                    var17_18 = false;
                    var18_20 = false;
                    $this$insertOrder_u24lambda_u2d9 = var16_17;
                    $i$a$-apply-CtpTdApi$insertOrder$reqField$1 = false;
                    $this$insertOrder_u24lambda_u2d9.setOrderRef(orderRef);
                    $this$insertOrder_u24lambda_u2d9.setBrokerID(this.getConfig().getBrokerId());
                    $this$insertOrder_u24lambda_u2d9.setInvestorID(this.getConfig().getInvestorId());
                    $this$insertOrder_u24lambda_u2d9.setExchangeID(exchangeId);
                    $this$insertOrder_u24lambda_u2d9.setInstrumentID(instrumentId);
                    $this$insertOrder_u24lambda_u2d9.setLimitPrice((double)price);
                    $this$insertOrder_u24lambda_u2d9.setDirection(Translator.INSTANCE.directionA2C((Direction)direction));
                    $this$insertOrder_u24lambda_u2d9.setVolumeTotalOriginal((int)volume);
                    $this$insertOrder_u24lambda_u2d9.setVolumeCondition(jctpConstants.THOST_FTDC_VC_AV);
                    $this$insertOrder_u24lambda_u2d9.setCombOffsetFlag(Translator.INSTANCE.offsetA2C((OrderOffset)offset));
                    $this$insertOrder_u24lambda_u2d9.setCombHedgeFlag(Translator.INSTANCE.getTHOST_FTDC_HF_Speculation());
                    $this$insertOrder_u24lambda_u2d9.setContingentCondition(jctpConstants.THOST_FTDC_CC_Immediately);
                    $this$insertOrder_u24lambda_u2d9.setForceCloseReason(jctpConstants.THOST_FTDC_FCC_NotForceClose);
                    $this$insertOrder_u24lambda_u2d9.setIsAutoSuspend(0);
                    $this$insertOrder_u24lambda_u2d9.setUserForceClose(0);
                    var21_25 = orderType;
                    var22_27 = WhenMappings.$EnumSwitchMapping$1[var21_25.ordinal()];
                    switch (var22_27) {
                        case 1: {
                            $this$insertOrder_u24lambda_u2d9.setOrderPriceType(jctpConstants.THOST_FTDC_OPT_LimitPrice);
                            $this$insertOrder_u24lambda_u2d9.setTimeCondition(jctpConstants.THOST_FTDC_TC_GFD);
                            break;
                        }
                        case 2: {
                            $this$insertOrder_u24lambda_u2d9.setOrderPriceType(jctpConstants.THOST_FTDC_OPT_LimitPrice);
                            $this$insertOrder_u24lambda_u2d9.setTimeCondition(jctpConstants.THOST_FTDC_TC_IOC);
                            var23_28 = extras;
                            if (var23_28 == null) {
                                v1 = false;
                            } else {
                                var24_29 = var23_28;
                                var25_30 = "minVolume";
                                var26_31 = false;
                                var27_32 = var24_29;
                                var28_33 = false;
                                v1 = var27_32.containsKey(var25_30) == true;
                            }
                            if (v1) {
                                $this$insertOrder_u24lambda_u2d9.setVolumeCondition(jctpConstants.THOST_FTDC_VC_MV);
                                var23_28 = extras.get("minVolume");
                                if (var23_28 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                $this$insertOrder_u24lambda_u2d9.setMinVolume(((Integer)var23_28).intValue());
                            }
                            break;
                        }
                        case 3: {
                            $this$insertOrder_u24lambda_u2d9.setOrderPriceType(jctpConstants.THOST_FTDC_OPT_LimitPrice);
                            $this$insertOrder_u24lambda_u2d9.setTimeCondition(jctpConstants.THOST_FTDC_TC_IOC);
                            $this$insertOrder_u24lambda_u2d9.setVolumeCondition(jctpConstants.THOST_FTDC_VC_CV);
                            break;
                        }
                        case 4: {
                            $this$insertOrder_u24lambda_u2d9.setOrderPriceType(jctpConstants.THOST_FTDC_OPT_AnyPrice);
                            $this$insertOrder_u24lambda_u2d9.setTimeCondition(jctpConstants.THOST_FTDC_TC_IOC);
                            $this$insertOrder_u24lambda_u2d9.setLimitPrice(0.0);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("\u672a\u652f\u6301 " + orderType + " \u7c7b\u578b\u7684\u8ba2\u5355");
                        }
                    }
                    reqField = var16_17;
                    retry$iv = true;
                    $i$f$runWithResultCheck = false;
                    $i$a$-runWithResultCheck$default-CtpTdApi$insertOrder$2 = false;
                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqOrderInsert(reqField, this.nextRequestId()))).intValue();
lbl87:
                    // 2 sources

                    while (resultCode$iv == -2 || resultCode$iv == -3) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = code;
                        $continuation.L$2 = direction;
                        $continuation.L$3 = offset;
                        $continuation.L$4 = orderType;
                        $continuation.L$5 = extras;
                        $continuation.L$6 = orderRef;
                        $continuation.L$7 = errorInfo;
                        $continuation.L$8 = reqField;
                        $continuation.D$0 = price;
                        $continuation.I$0 = volume;
                        $continuation.label = 1;
                        v2 = DelayKt.delay((long)10L, (Continuation)$continuation);
                        if (v2 == var79_11) {
                            return var79_11;
                        }
                        ** GOTO lbl120
                    }
                    break;
                }
                case 1: {
                    $i$f$runWithResultCheck = false;
                    var4_3 = $continuation.I$0;
                    var2_2 = $continuation.D$0;
                    reqField = (CThostFtdcInputOrderField)$continuation.L$8;
                    var14_16 = (String)$continuation.L$7;
                    var13_15 = (String)$continuation.L$6;
                    var8_7 = (Map)$continuation.L$5;
                    var7_6 = (OrderType)$continuation.L$4;
                    var6_5 = (OrderOffset)$continuation.L$3;
                    var5_4 = (Direction)$continuation.L$2;
                    var1_1 = (String)$continuation.L$1;
                    this = (CtpTdApi)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl120:
                    // 2 sources

                    $i$a$-runWithResultCheck$default-CtpTdApi$insertOrder$2 = false;
                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqOrderInsert(reqField, this.nextRequestId()))).intValue();
                    ** GOTO lbl87
                }
            }
            if (resultCode$iv == 0) {
                $i$a$-runWithResultCheck$default-CtpTdApi$insertOrder$3 = false;
            } else {
                var21_25 = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
        }
        now = LocalDateTime.now();
        v3 = this.getConfig().getInvestorId();
        v4 = "" + this.getFrontId() + '_' + this.getSessionId() + '_' + var13_15;
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        var17_18 = false;
        var17_19 = (Map<String, Order>)new LinkedHashMap<K, V>();
        var18_20 = false;
        var19_22 = false;
        code = var17_19;
        var52_35 = now;
        var51_36 = now;
        var49_37 = 0.0;
        var47_38 = 0.0;
        var45_39 = 0.0;
        var43_40 = 0.0;
        var42_41 = 0;
        var41_42 = "\u62a5\u5355\u5df2\u63d0\u4ea4";
        var40_43 = OrderStatus.SUBMITTING;
        var39_44 = var7_6;
        var38_45 = var6_5;
        var37_46 = var5_4;
        var36_47 = var4_3;
        var34_48 = var2_2;
        var33_49 = var1_1;
        var32_50 = v4;
        var31_51 = v3;
        $i$a$-apply-CtpTdApi$insertOrder$order$1 = false;
        if (var8_7 != null) {
            $this$insertOrder_u24lambda_u2d12.putAll(var8_7);
        }
        var53_52 = Unit.INSTANCE;
        var56_53 = var17_19;
        var57_54 = var52_35;
        var58_55 = var51_36;
        var59_56 = var49_37;
        var61_57 = var47_38;
        var63_58 = var45_39;
        var65_59 = var43_40;
        var67_60 = var42_41;
        var68_61 = var41_42;
        var69_62 = var40_43;
        var70_63 = var39_44;
        var71_64 = var38_45;
        var72_65 = var37_46;
        var73_66 = var36_47;
        var74_67 = var34_48;
        var76_68 = var33_49;
        var77_69 = var32_50;
        var78_70 = var31_51;
        order = new Order(var78_70, var77_69, var76_68, var74_67, var73_66, var72_65, var71_64, var70_63, var69_62, var68_61, var67_60, var65_59, var63_58, var61_57, var59_56, var58_55, var57_54, (Map)var56_53);
        if (var14_16 == null) {
            var17_19 = this.todayOrders;
            var18_20 = false;
            var17_19.put(var13_15, order);
            this.insertUnfinishedOrder(order);
        } else {
            order.setStatus(OrderStatus.ERROR);
            order.setStatusMsg(var14_16);
            var17_19 = this.todayOrders;
            var18_20 = false;
            var17_19.put(var13_15, order);
        }
        return UtilsKt.deepCopy(order);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object insertOrder$default(CtpTdApi ctpTdApi, String string, double d, int n, Direction direction, OrderOffset orderOffset, OrderType orderType, Map map, Continuation continuation, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            map = null;
        }
        return ctpTdApi.insertOrder(string, d, n, direction, orderOffset, orderType, map, (Continuation<? super Order>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object cancelOrder(@NotNull String var1_1, @Nullable Map<String, ? extends Object> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof cancelOrder.1)) ** GOTO lbl-1000
        var16_4 = var3_3;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CtpTdApi this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cancelOrder(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new CThostFtdcInputOrderActionField();
                var6_8 = false;
                var7_10 = 0;
                $this$cancelOrder_u24lambda_u2d13 = var5_7;
                $i$a$-apply-CtpTdApi$cancelOrder$cancelReqField$1 = false;
                $this$cancelOrder_u24lambda_u2d13.setBrokerID(this.getConfig().getBrokerId());
                $this$cancelOrder_u24lambda_u2d13.setInvestorID(this.getConfig().getInvestorId());
                $this$cancelOrder_u24lambda_u2d13.setUserID(this.getConfig().getInvestorId());
                $this$cancelOrder_u24lambda_u2d13.setActionFlag(jctpConstants.THOST_FTDC_AF_Delete);
                cancelReqField = var5_7;
                var6_9 = new char[]{'_'};
                splitResult = StringsKt.split$default((CharSequence)((CharSequence)orderId), (char[])var6_9, (boolean)false, (int)0, (int)6, null);
                order = null;
                var7_10 = splitResult.size();
                if (var7_10 == 3) {
                    $this$cancelOrder_u24lambda_u2d13 = cancelReqField;
                    $i$a$-apply-CtpTdApi$cancelOrder$cancelReqField$1 = false;
                    var10_16 = false;
                    $this$cancelOrder_u24lambda_u2d14 = $this$cancelOrder_u24lambda_u2d13;
                    $i$a$-apply-CtpTdApi$cancelOrder$2 = false;
                    var13_21 = (String)splitResult.get(0);
                    var14_22 = false;
                    $this$cancelOrder_u24lambda_u2d14.setFrontID(Integer.parseInt(var13_21));
                    var13_21 = (String)splitResult.get(1);
                    var14_22 = false;
                    $this$cancelOrder_u24lambda_u2d14.setSessionID(Integer.parseInt(var13_21));
                    $this$cancelOrder_u24lambda_u2d14.setOrderRef((String)splitResult.get(2));
                    var13_21 = this.todayOrders.get(splitResult.get(2));
                    v0 /* !! */  = order = var13_21 == null ? this.todayOrders.get(orderId) : var13_21;
                    if (order != null) {
                        $this$cancelOrder_u24lambda_u2d14.setInstrumentID((String)UtilsKt.parseCode(order.getCode()).getSecond());
                    }
                } else {
                    throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684 orderId (" + (String)orderId + ")\u3002\u6b63\u786e\u683c\u5f0f\u4e3a\uff1afrontId_sessionId_orderRef");
                }
                if (order == null || !Intrinsics.areEqual((Object)order.getOrderId(), (Object)orderId)) {
                    throw new Exception("\u672c\u5730\u62d2\u64a4\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u8bb0\u5f55");
                }
                var7_11 = new OrderStatus[]{OrderStatus.UNKNOWN, OrderStatus.SUBMITTING, OrderStatus.ACCEPTED, OrderStatus.PARTIALLY_FILLED};
                if (!SetsKt.setOf((Object[])var7_11).contains(order.getStatus())) {
                    throw new Exception("\u672c\u5730\u62d2\u64a4\uff1a\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u64a4\uff08" + order.getStatus() + '\uff09');
                }
                if (((Number)this.cancelStatistics.getOrDefault(order.getCode(), Boxing.boxInt((int)0))).intValue() >= 499) {
                    throw new Exception("\u672c\u5730\u62d2\u64a4\uff1a\u8fbe\u5230\u64a4\u5355\u6b21\u6570\u4e0a\u9650\uff08\u5df2\u64a4 " + this.cancelStatistics.get(order.getCode()) + " \u6b21\uff09");
                }
                retry$iv = true;
                $i$f$runWithResultCheck = false;
                $i$a$-runWithResultCheck$default-CtpTdApi$cancelOrder$3 = false;
                resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqOrderAction(cancelReqField, this.nextRequestId()))).intValue();
lbl59:
                // 2 sources

                while (resultCode$iv == -2 || resultCode$iv == -3) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = cancelReqField;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)10L, (Continuation)$continuation);
                    if (v1 == var17_6) {
                        return var17_6;
                    }
                    ** GOTO lbl74
                }
                break;
            }
            case 1: {
                $i$f$runWithResultCheck = false;
                var4_15 = (CThostFtdcInputOrderActionField)$continuation.L$1;
                this = (CtpTdApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl74:
                // 2 sources

                $i$a$-runWithResultCheck$default-CtpTdApi$cancelOrder$3 = false;
                resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqOrderAction(var4_15, this.nextRequestId()))).intValue();
                ** GOTO lbl59
            }
        }
        if (resultCode$iv != 0) {
            $i$a$-apply-CtpTdApi$cancelOrder$2 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        $i$a$-runWithResultCheck$default-CtpTdApi$cancelOrder$4 = false;
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object cancelOrder$default(CtpTdApi ctpTdApi, String string, Map map, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return ctpTdApi.cancelOrder(string, map, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryLastTick(@NotNull String var1_1, boolean var2_2, @Nullable Map<String, ? extends Object> var3_3, @NotNull Continuation<? super Tick> var4_4) {
        block13: {
            block12: {
                if (!(var4_4 instanceof queryLastTick.1)) ** GOTO lbl-1000
                var24_5 = var4_4;
                if ((var24_5.label & -2147483648) != 0) {
                    var24_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var4_4){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryLastTick(null, false, null, (Continuation<? super Tick>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var25_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache != false && (cachedTick = this.getMdApi().getLastTicks().get(code)) != null) {
                            cachedTick.setStatus(this.getInstrumentStatus((String)code));
                            var6_9 = this.cachedTickMap;
                            var7_13 = false;
                            var6_9.put((String)code, cachedTick);
                            return cachedTick;
                        }
                        var6_10 = new CThostFtdcQryDepthMarketDataField();
                        var7_14 = false;
                        var8_15 = false;
                        $this$queryLastTick_u24lambda_u2d17 = var6_10;
                        $i$a$-apply-CtpTdApi$queryLastTick$qryField$1 = false;
                        $this$queryLastTick_u24lambda_u2d17.setInstrumentID((String)UtilsKt.parseCode((String)code).getSecond());
                        qryField = var6_10;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryLastTick$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryDepthMarketData(qryField, requestId))).intValue();
lbl34:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = code;
                            $continuation.L$2 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v0 == var25_7) {
                                return var25_7;
                            }
                            ** GOTO lbl53
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var6_11 = $continuation.I$0;
                        var5_8 = (CThostFtdcQryDepthMarketDataField)$continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl53:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryLastTick$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryDepthMarketData(var5_8, var6_11))).intValue();
                        ** GOTO lbl34
                    }
                }
                if (resultCode$iv != 0) break block12;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryLastTick$3 = false;
                var12_22 = $continuation;
                var13_25 = false;
                var14_26 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var1_1;
                $continuation.L$2 = var12_22;
                $continuation.I$0 = var6_11;
                $continuation.label = 2;
                var14_27 = var12_22;
                var15_28 = false;
                var16_29 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var14_27));
                continuation = (Continuation)var16_29;
                $i$a$-suspendCoroutine-CtpTdApi$queryLastTick$3$1 = false;
                var19_32 = this.requestMap;
                var20_33 = Boxing.boxInt((int)var6_11);
                var21_34 = new RequestContinuation(var6_11, continuation, null, var1_1, 4, null);
                var22_35 = false;
                var19_32.put(var20_33, var21_34);
                v1 = var16_29.getOrThrow();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var12_22);
                }
                v2 = v1;
                if (v1 == var25_7) {
                    return var25_7;
                }
                break block13;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryLastTick$3 = false;
                        var6_12 = $continuation.I$0;
                        var12_23 = $continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block13;
                    }
                }
            }
            var12_24 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return (Tick)v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryLastTick$default(CtpTdApi ctpTdApi, String string, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        return ctpTdApi.queryLastTick(string, bl, map, (Continuation<? super Tick>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryInstrument(@NotNull String var1_1, boolean var2_2, @Nullable Map<String, ? extends Object> var3_3, @NotNull Continuation<? super Security> var4_4) {
        block15: {
            block14: {
                if (!(var4_4 instanceof queryInstrument.1)) ** GOTO lbl-1000
                var27_5 = var4_4;
                if ((var27_5.label & -2147483648) != 0) {
                    var27_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var4_4){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryInstrument(null, false, null, (Continuation<? super Security>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var28_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache == false || (cachedInstrument = this.getInstruments().get(code)) == null) break;
                        var6_9 = extras;
                        if (var6_9 == null ? false : Intrinsics.areEqual(var6_9.get("queryFee"), (Object)Boxing.boxBoolean((boolean)true))) {
                            $continuation.L$0 = cachedInstrument;
                            $continuation.label = 1;
                            v0 = CtpTdApi.prepareFeeCalculation$default(this, (String)code, false, (Continuation)$continuation, 2, null);
                            if (v0 == var28_7) {
                                return var28_7;
                            }
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        cachedInstrument = (Security)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        return cachedInstrument;
                    }
                }
                var5_8 = UtilsKt.parseCode((String)code);
                exchangeId = (String)var5_8.component1();
                instrumentId = (String)var5_8.component2();
                var9_12 = new CThostFtdcQryInstrumentField();
                var10_15 = false;
                var11_16 = false;
                $this$queryInstrument_u24lambda_u2d21 = var9_12;
                $i$a$-apply-CtpTdApi$queryInstrument$qryField$1 = false;
                $this$queryInstrument_u24lambda_u2d21.setExchangeID(exchangeId);
                $this$queryInstrument_u24lambda_u2d21.setInstrumentID(instrumentId);
                qryField = var9_12;
                requestId = this.nextRequestId();
                retry$iv = true;
                $i$f$runWithResultCheck = false;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryInstrument$2 = false;
                resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrument(qryField, requestId))).intValue();
lbl45:
                // 2 sources

                while (resultCode$iv == -2 || resultCode$iv == -3) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = code;
                    $continuation.L$2 = qryField;
                    $continuation.I$0 = requestId;
                    $continuation.label = 2;
                    v1 = DelayKt.delay((long)10L, (Continuation)$continuation);
                    if (v1 == var28_7) {
                        return var28_7;
                    }
                    ** GOTO lbl64
                }
                {
                    break;
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        var9_13 = $continuation.I$0;
                        var8_21 = (CThostFtdcQryInstrumentField)$continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl64:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryInstrument$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrument(var8_21, var9_13))).intValue();
                        ** GOTO lbl45
                    }
                }
                if (resultCode$iv != 0) break block14;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryInstrument$3 = false;
                var15_24 = $continuation;
                var16_27 = false;
                var17_28 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var1_1;
                $continuation.L$2 = var15_24;
                $continuation.I$0 = var9_13;
                $continuation.label = 3;
                var17_29 = var15_24;
                var18_30 = false;
                var19_31 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var17_29));
                continuation = (Continuation)var19_31;
                $i$a$-suspendCoroutine-CtpTdApi$queryInstrument$3$1 = false;
                var22_34 = this.requestMap;
                var23_35 = Boxing.boxInt((int)var9_13);
                var24_36 = new RequestContinuation(var9_13, continuation, null, var1_1, 4, null);
                var25_37 = false;
                var22_34.put(var23_35, var24_36);
                v2 = var19_31.getOrThrow();
                if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var15_24);
                }
                v3 = v2;
                if (v2 == var28_7) {
                    return var28_7;
                }
                break block15;
                {
                    case 3: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryInstrument$3 = false;
                        var9_14 = $continuation.I$0;
                        var15_25 = $continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break block15;
                    }
                }
            }
            var15_26 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return (Security)v3;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryInstrument$default(CtpTdApi ctpTdApi, String string, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        return ctpTdApi.queryInstrument(string, bl, map, (Continuation<? super Security>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryAllInstruments(boolean var1_1, @Nullable Map<String, ? extends Object> var2_2, @NotNull Continuation<? super List<Security>> var3_3) {
        block14: {
            block13: {
                if (!(var3_3 instanceof queryAllInstruments.1)) ** GOTO lbl-1000
                var23_4 = var3_3;
                if ((var23_4.label & -2147483648) != 0) {
                    var23_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var3_3){
                        Object L$0;
                        Object L$1;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryAllInstruments(false, null, (Continuation<? super List<Security>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache != false) {
                            var4_7 = this.getInstruments();
                            var5_8 = 0;
                            if (var4_7.isEmpty() == false) {
                                return CollectionsKt.toList((Iterable)this.getInstruments().values());
                            }
                        }
                        qryField = new CThostFtdcQryInstrumentField();
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryAllInstruments$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrument(qryField, requestId))).intValue();
lbl25:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v0 == var24_6) {
                                return var24_6;
                            }
                            ** GOTO lbl42
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var5_8 = $continuation.I$0;
                        var4_7 = (CThostFtdcQryInstrumentField)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl42:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryAllInstruments$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrument(var4_7, var5_8))).intValue();
                        ** GOTO lbl25
                    }
                }
                if (resultCode$iv != 0) break block13;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryAllInstruments$3 = false;
                var11_16 = $continuation;
                var12_19 = false;
                var13_20 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var11_16;
                $continuation.I$0 = var5_8;
                $continuation.label = 2;
                var13_21 = var11_16;
                var14_22 = false;
                var15_23 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_21));
                continuation = (Continuation)var15_23;
                $i$a$-suspendCoroutine-CtpTdApi$queryAllInstruments$3$1 = false;
                var18_26 = this.requestMap;
                var19_27 = Boxing.boxInt((int)var5_8);
                var20_28 = false;
                var20_29 = new RequestContinuation(var5_8, continuation, null, new ArrayList<E>(), 4, null);
                var21_30 = false;
                var18_26.put(var19_27, var20_29);
                v1 = var15_23.getOrThrow();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var11_16);
                }
                v2 = v1;
                if (v1 == var24_6) {
                    return var24_6;
                }
                break block14;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryAllInstruments$3 = false;
                        var5_9 = $continuation.I$0;
                        var11_17 = $continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block14;
                    }
                }
            }
            var11_18 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return (List)v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryAllInstruments$default(CtpTdApi ctpTdApi, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            map = null;
        }
        return ctpTdApi.queryAllInstruments(bl, map, (Continuation<? super List<Security>>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object queryOrder(@NotNull String var1_1, boolean var2_2, @Nullable Map<String, ? extends Object> var3_3, @NotNull Continuation<? super Order> var4_4) {
        block17: {
            block16: {
                if (!(var4_4 instanceof queryOrder.1)) ** GOTO lbl-1000
                var25_5 = var4_4;
                if ((var25_5.label & -2147483648) != 0) {
                    var25_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var4_4){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryOrder(null, false, null, (Continuation<? super Order>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var26_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache != false) {
                            var7_8 = new String[]{"_"};
                            var6_11 = this.todayOrders.get(CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)orderId), (String[])var7_8, (boolean)false, (int)0, (int)6, null)));
                            v0 /* !! */  = order = var6_11 == null ? this.todayOrders.get(orderId) : var6_11;
                            if (order != null && !Intrinsics.areEqual((Object)order.getOrderId(), (Object)orderId)) {
                                order = null;
                            }
                            if (order != null) {
                                CtpTdApi.calculateOrder$default(this, (Order)order, null, 2, null);
                                return order;
                            }
                        }
                        var6_11 = new CThostFtdcQryOrderField();
                        var7_9 = false;
                        var8_15 = false;
                        $this$queryOrder_u24lambda_u2d28 = var6_11;
                        $i$a$-apply-CtpTdApi$queryOrder$qryField$1 = false;
                        $this$queryOrder_u24lambda_u2d28.setBrokerID(this.getConfig().getBrokerId());
                        $this$queryOrder_u24lambda_u2d28.setInvestorID(this.getConfig().getInvestorId());
                        qryField = var6_11;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOrder$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOrder(qryField, requestId))).intValue();
lbl37:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = orderId;
                            $continuation.L$2 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v1 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v1 == var26_7) {
                                return var26_7;
                            }
                            ** GOTO lbl56
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var6_12 = $continuation.I$0;
                        var5_14 = (CThostFtdcQryOrderField)$continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl56:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOrder$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOrder(var5_14, var6_12))).intValue();
                        ** GOTO lbl37
                    }
                }
                if (resultCode$iv != 0) break block16;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryOrder$3 = false;
                var13_23 = $continuation;
                var14_26 = false;
                var15_27 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var1_1;
                $continuation.L$2 = var13_23;
                $continuation.I$0 = var6_12;
                $continuation.label = 2;
                var15_28 = var13_23;
                var16_29 = false;
                var17_30 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var15_28));
                continuation = (Continuation)var17_30;
                $i$a$-suspendCoroutine-CtpTdApi$queryOrder$3$1 = false;
                var20_33 = this.requestMap;
                var21_34 = Boxing.boxInt((int)var6_12);
                var22_35 = new RequestContinuation(var6_12, continuation, null, new QueryOrdersData(var1_1, null, false, null, 14, null), 4, null);
                var23_36 = false;
                var20_33.put(var21_34, var22_35);
                v2 = var17_30.getOrThrow();
                if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var13_23);
                }
                v3 = v2;
                if (v2 == var26_7) {
                    return var26_7;
                }
                break block17;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOrder$3 = false;
                        var6_13 = $continuation.I$0;
                        var13_24 = $continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break block17;
                    }
                }
            }
            var13_25 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        var7_10 = (Order)v3;
        if (var7_10 == null) {
            v4 = null;
        } else {
            var8_16 = var7_10;
            var9_18 = false;
            var10_19 = false;
            $this$queryOrder_u24lambda_u2d32 = var8_16;
            $i$a$-apply-CtpTdApi$queryOrder$4 = false;
            CtpTdApi.calculateOrder$default(this, $this$queryOrder_u24lambda_u2d32, null, 2, null);
            v4 = var8_16;
        }
        return v4;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryOrder$default(CtpTdApi ctpTdApi, String string, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        return ctpTdApi.queryOrder(string, bl, map, (Continuation<? super Order>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object queryOrders(@Nullable String var1_1, boolean var2_2, boolean var3_3, @Nullable Map<String, ? extends Object> var4_4, @NotNull Continuation<? super List<Order>> var5_5) {
        block20: {
            block19: {
                if (!(var5_5 instanceof queryOrders.1)) ** GOTO lbl-1000
                var25_6 = var5_5;
                if ((var25_6.label & -2147483648) != 0) {
                    var25_6.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var5_5){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        boolean Z$0;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryOrders(null, false, false, null, (Continuation<? super List<Order>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var26_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache != false) {
                            if (onlyUnfinished != false) {
                                var7_9 = false;
                                var7_10 = new ArrayList<E>();
                                var8_13 = false;
                                var9_16 = false;
                                $this$queryOrders_u24lambda_u2d33 = var7_10;
                                $i$a$-apply-CtpTdApi$queryOrders$orders$1 = false;
                                $this$queryOrders_u24lambda_u2d33.addAll((Collection)this.unfinishedLongOrders);
                                $this$queryOrders_u24lambda_u2d33.addAll((Collection)this.unfinishedShortOrders);
                                v0 = var7_10;
                            } else {
                                v0 = orders = CollectionsKt.toList((Iterable)this.todayOrders.values());
                            }
                            if (code != null) {
                                $this$filter$iv = orders;
                                $i$f$filter = false;
                                var9_17 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (Order)element$iv$iv;
                                    $i$a$-filter-CtpTdApi$queryOrders$2 = false;
                                    if (!Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)it.getCode(), (Object)code)).booleanValue()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                orders = (List)destination$iv$iv;
                            }
                            $this$onEach$iv = orders;
                            $i$f$onEach = false;
                            $this$filterTo$iv$iv = $this$onEach$iv;
                            destination$iv$iv = false;
                            $i$f$filterTo = false;
                            $this$apply$iv = $this$filterTo$iv$iv;
                            $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
                            for (T element$iv : $this$apply$iv) {
                                it = (Order)element$iv;
                                $i$a$-onEach-CtpTdApi$queryOrders$3 = false;
                                if (it.getOffset() != OrderOffset.OPEN || it.getVolume() <= it.getFilledVolume()) continue;
                                CtpTdApi.calculateOrder$default(this, it, null, 2, null);
                            }
                            return $this$filterTo$iv$iv;
                        }
                        $this$onEach$iv = new CThostFtdcQryOrderField();
                        $i$f$onEach = false;
                        $this$filterTo$iv$iv = false;
                        $this$queryOrders_u24lambda_u2d36 = $this$onEach$iv;
                        $i$a$-apply-CtpTdApi$queryOrders$qryField$1 = false;
                        $this$queryOrders_u24lambda_u2d36.setBrokerID(this.getConfig().getBrokerId());
                        $this$queryOrders_u24lambda_u2d36.setInvestorID(this.getConfig().getInvestorId());
                        if (code != null) {
                            $this$apply$iv = UtilsKt.parseCode((String)code);
                            excId /* !! */  = (String)$this$apply$iv.component1();
                            insId = (String)$this$apply$iv.component2();
                            $this$queryOrders_u24lambda_u2d36.setExchangeID((String)excId /* !! */ );
                            $this$queryOrders_u24lambda_u2d36.setInstrumentID(insId);
                        }
                        qryField = $this$onEach$iv;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOrders$4 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOrder(qryField, requestId))).intValue();
lbl79:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = code;
                            $continuation.L$2 = qryField;
                            $continuation.Z$0 = onlyUnfinished;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v1 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v1 == var26_8) {
                                return var26_8;
                            }
                            ** GOTO lbl100
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var7_12 = $continuation.I$0;
                        var2_2 = $continuation.Z$0;
                        var6_28 = (CThostFtdcQryOrderField)$continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl100:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOrders$4 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOrder(var6_28, var7_12))).intValue();
                        ** GOTO lbl79
                    }
                }
                if (resultCode$iv != 0) break block19;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryOrders$5 = false;
                excId /* !! */  = $continuation;
                insId = false;
                var15_40 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var1_1;
                $continuation.L$2 = excId /* !! */ ;
                $continuation.Z$0 = var2_2;
                $continuation.I$0 = var7_12;
                $continuation.label = 2;
                var15_41 /* !! */  = excId /* !! */ ;
                it = false;
                $i$a$-onEach-CtpTdApi$queryOrders$3 = new SafeContinuation(IntrinsicsKt.intercepted(var15_41 /* !! */ ));
                continuation = (Continuation)$i$a$-onEach-CtpTdApi$queryOrders$3;
                $i$a$-suspendCoroutine-CtpTdApi$queryOrders$5$1 = false;
                var20_50 = this.requestMap;
                var21_51 = Boxing.boxInt((int)var7_12);
                var22_52 = new RequestContinuation(var7_12, continuation, null, new QueryOrdersData(null, var1_1, var2_2 != false, null, 8, null), 4, null);
                var23_53 = false;
                var20_50.put(var21_51, var22_52);
                v2 = $i$a$-onEach-CtpTdApi$queryOrders$3.getOrThrow();
                if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)excId /* !! */ );
                }
                v3 = v2;
                if (v2 == var26_8) {
                    return var26_8;
                }
                break block20;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOrders$5 = false;
                        var7_12 = $continuation.I$0;
                        var2_2 = $continuation.Z$0;
                        excId /* !! */  = $continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break block20;
                    }
                }
            }
            excId /* !! */  = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        $this$onEach$iv = (List)v3;
        $i$f$onEach = false;
        var10_24 = $this$onEach$iv;
        var11_26 = false;
        var12_31 = false;
        $this$apply$iv = var10_24;
        $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
        for (T element$iv : $this$apply$iv) {
            it = (Order)element$iv;
            $i$a$-onEach-CtpTdApi$queryOrders$6 = false;
            CtpTdApi.calculateOrder$default(this, it, null, 2, null);
        }
        return var10_24;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryOrders$default(CtpTdApi ctpTdApi, String string, boolean bl, boolean bl2, Map map, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        return ctpTdApi.queryOrders(string, bl, bl2, map, (Continuation<? super List<Order>>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object queryTrade(@NotNull String var1_1, boolean var2_2, @Nullable Map<String, ? extends Object> var3_3, @NotNull Continuation<? super Trade> var4_4) {
        block16: {
            block15: {
                if (!(var4_4 instanceof queryTrade.1)) ** GOTO lbl-1000
                var25_5 = var4_4;
                if ((var25_5.label & -2147483648) != 0) {
                    var25_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var4_4){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryTrade(null, false, null, (Continuation<? super Trade>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var26_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache == false) ** GOTO lbl27
                        var6_8 = this.todayTrades;
                        var7_11 = false;
                        var8_13 = var6_8;
                        var9_16 = false;
                        for (T var11_21 : var8_13) {
                            it = (Trade)var11_21 /* !! */ ;
                            $i$a$-find-CtpTdApi$queryTrade$trade$1 = false;
                            if (!Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)it.getTradeId(), (Object)tradeId)).booleanValue()) continue;
                            v0 = var11_21 /* !! */ ;
                            ** GOTO lbl24
                        }
                        v0 = null;
lbl24:
                        // 2 sources

                        trade = v0;
                        if (trade != null) {
                            return trade;
                        }
lbl27:
                        // 3 sources

                        var6_8 = new CThostFtdcQryTradeField();
                        var7_11 = false;
                        var8_14 = false;
                        $this$queryTrade_u24lambda_u2d42 = var6_8;
                        $i$a$-apply-CtpTdApi$queryTrade$qryField$1 = false;
                        $this$queryTrade_u24lambda_u2d42.setBrokerID(this.getConfig().getBrokerId());
                        $this$queryTrade_u24lambda_u2d42.setInvestorID(this.getConfig().getInvestorId());
                        var11_21 /* !! */  = new String[]{"_"};
                        $this$queryTrade_u24lambda_u2d42.setTradeID((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)((CharSequence)tradeId), var11_21 /* !! */ , (boolean)false, (int)0, (int)6, null)));
                        qryField = var6_8;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryTrade$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryTrade((CThostFtdcQryTradeField)qryField, requestId))).intValue();
lbl45:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = tradeId;
                            $continuation.L$2 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v1 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v1 == var26_7) {
                                return var26_7;
                            }
                            ** GOTO lbl64
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var6_9 = $continuation.I$0;
                        var5_30 = (CThostFtdcQryTradeField)$continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl64:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryTrade$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryTrade(var5_30, var6_9))).intValue();
                        ** GOTO lbl45
                    }
                }
                if (resultCode$iv != 0) break block15;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryTrade$3 = false;
                $i$a$-find-CtpTdApi$queryTrade$trade$1 = $continuation;
                var14_31 = false;
                var15_32 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var1_1;
                $continuation.L$2 = $i$a$-find-CtpTdApi$queryTrade$trade$1;
                $continuation.I$0 = var6_9;
                $continuation.label = 2;
                var15_33 = $i$a$-find-CtpTdApi$queryTrade$trade$1;
                var16_34 = false;
                var17_35 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var15_33));
                continuation = (Continuation)var17_35;
                $i$a$-suspendCoroutine-CtpTdApi$queryTrade$3$1 = false;
                var20_38 = this.requestMap;
                var21_39 = Boxing.boxInt((int)var6_9);
                var22_40 = new RequestContinuation(var6_9, continuation, null, new QueryTradesData(var1_1, null, null, null, 14, null), 4, null);
                var23_41 = false;
                var20_38.put(var21_39, var22_40);
                v2 = var17_35.getOrThrow();
                if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$i$a$-find-CtpTdApi$queryTrade$trade$1);
                }
                v3 = v2;
                if (v2 == var26_7) {
                    return var26_7;
                }
                break block16;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryTrade$3 = false;
                        var6_10 = $continuation.I$0;
                        $i$a$-find-CtpTdApi$queryTrade$trade$1 = $continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break block16;
                    }
                }
            }
            $i$a$-find-CtpTdApi$queryTrade$trade$1 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        var7_12 = (Trade)v3;
        if (var7_12 == null) {
            v4 = null;
        } else {
            var8_15 = var7_12;
            var9_18 = false;
            var10_20 = false;
            $this$queryTrade_u24lambda_u2d46 = var8_15;
            $i$a$-apply-CtpTdApi$queryTrade$4 = false;
            CtpTdApi.calculateTrade$default(this, $this$queryTrade_u24lambda_u2d46, null, 2, null);
            v4 = var8_15;
        }
        return v4;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryTrade$default(CtpTdApi ctpTdApi, String string, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        return ctpTdApi.queryTrade(string, bl, map, (Continuation<? super Trade>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object queryTrades(@Nullable String var1_1, @Nullable String var2_2, boolean var3_3, @Nullable Map<String, ? extends Object> var4_4, @NotNull Continuation<? super List<Trade>> var5_5) {
        block25: {
            block24: {
                if (!(var5_5 instanceof queryTrades.1)) ** GOTO lbl-1000
                var26_6 = var5_5;
                if ((var26_6.label & -2147483648) != 0) {
                    var26_6.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var5_5){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryTrades(null, null, false, null, (Continuation<? super List<Trade>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var27_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache != false) {
                            if (orderId != null) {
                                $this$filter$iv = this.todayTrades;
                                $i$f$filter = false;
                                var8_15 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (Trade)element$iv$iv;
                                    $i$a$-filter-CtpTdApi$queryTrades$2 = false;
                                    if (!Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)it.getOrderId(), (Object)orderId)).booleanValue()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                v0 = (List)destination$iv$iv;
                            } else if (code != null) {
                                $this$filter$iv = this.todayTrades;
                                $i$f$filter = false;
                                $this$filterTo$iv$iv = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (Trade)element$iv$iv;
                                    $i$a$-filter-CtpTdApi$queryTrades$3 = false;
                                    if (!Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)it.getCode(), (Object)code)).booleanValue()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                v0 = (List)destination$iv$iv;
                            } else {
                                v0 = CollectionsKt.toList((Iterable)this.todayTrades);
                            }
                            return v0;
                        }
                        reqData = new QueryTradesData(null, null, null, null, 15, null);
                        $this$filterTo$iv$iv = new CThostFtdcQryTradeField();
                        destination$iv$iv = false;
                        $i$f$filterTo = false;
                        $this$queryTrades_u24lambda_u2d49 = $this$filterTo$iv$iv;
                        $i$a$-apply-CtpTdApi$queryTrades$qryField$1 = false;
                        $this$queryTrades_u24lambda_u2d49.setBrokerID(this.getConfig().getBrokerId());
                        $this$queryTrades_u24lambda_u2d49.setInvestorID(this.getConfig().getInvestorId());
                        if (code != null) {
                            it = UtilsKt.parseCode((String)code);
                            excId = (String)it.component1();
                            insId = (String)it.component2();
                            $this$queryTrades_u24lambda_u2d49.setExchangeID((String)excId);
                            $this$queryTrades_u24lambda_u2d49.setInstrumentID((String)insId);
                            reqData.setCode((String)code);
                        }
                        if (orderId != null) {
                            insId = new String[]{"_"};
                            excId = this.todayOrders.get(CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)orderId), (String[])insId, (boolean)false, (int)0, (int)6, null)));
                            if (excId == null) {
                                insId = this.todayOrders.get(orderId);
                                if (insId == null) {
                                    var16_43 = false;
                                    return CollectionsKt.emptyList();
                                }
                                v1 /* !! */  = insId;
                            } else {
                                v1 /* !! */  = excId;
                            }
                            order /* !! */  = v1 /* !! */ ;
                            excId = UtilsKt.parseCode(order /* !! */ .getCode());
                            excId = (String)excId.component1();
                            insId = (String)excId.component2();
                            $this$queryTrades_u24lambda_u2d49.setExchangeID(excId);
                            $this$queryTrades_u24lambda_u2d49.setInstrumentID(insId);
                            reqData.setOrderSysId(UtilsKt.getOrderSysId((Order)order /* !! */ ));
                        }
                        qryField = $this$filterTo$iv$iv;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryTrades$4 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryTrade(qryField, requestId))).intValue();
lbl90:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = reqData;
                            $continuation.L$2 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v2 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v2 == var27_8) {
                                return var27_8;
                            }
                            ** GOTO lbl109
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var8_18 = $continuation.I$0;
                        var7_14 = (CThostFtdcQryTradeField)$continuation.L$2;
                        var6_11 = (QueryTradesData)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl109:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryTrades$4 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryTrade(var7_14, var8_18))).intValue();
                        ** GOTO lbl90
                    }
                }
                if (resultCode$iv != 0) break block24;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryTrades$5 = false;
                excId = $continuation;
                excId = false;
                var16_45 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var6_11;
                $continuation.L$2 = excId;
                $continuation.I$0 = var8_18;
                $continuation.label = 2;
                var16_46 /* !! */  = excId;
                var17_47 = false;
                var18_49 = new SafeContinuation(IntrinsicsKt.intercepted(var16_46 /* !! */ ));
                continuation = (Continuation)var18_49;
                $i$a$-suspendCoroutine-CtpTdApi$queryTrades$5$1 = false;
                var21_53 = this.requestMap;
                var22_54 = Boxing.boxInt((int)var8_18);
                var23_55 = new RequestContinuation(var8_18, continuation, null, var6_11, 4, null);
                var24_56 = false;
                var21_53.put(var22_54, var23_55);
                v3 = var18_49.getOrThrow();
                if (v3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended(excId);
                }
                v4 = v3;
                if (v3 == var27_8) {
                    return var27_8;
                }
                break block25;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryTrades$5 = false;
                        var8_18 = $continuation.I$0;
                        excId = $continuation.L$2;
                        var6_11 = (QueryTradesData)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        break block25;
                    }
                }
            }
            excId = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        $this$onEach$iv = (List)v4;
        $i$f$onEach = false;
        var11_30 = $this$onEach$iv;
        var12_33 = false;
        var13_37 = false;
        $this$apply$iv = var11_30;
        $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
        for (T element$iv : $this$apply$iv) {
            it = (Trade)element$iv;
            $i$a$-onEach-CtpTdApi$queryTrades$6 = false;
            CtpTdApi.calculateTrade$default(this, it, null, 2, null);
        }
        return var11_30;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryTrades$default(CtpTdApi ctpTdApi, String string, String string2, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        return ctpTdApi.queryTrades(string, string2, bl, map, (Continuation<? super List<Trade>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryAssets(boolean var1_1, @Nullable Map<String, ? extends Object> var2_2, @NotNull Continuation<? super Assets> var3_3) {
        block13: {
            block12: {
                if (!(var3_3 instanceof queryAssets.1)) ** GOTO lbl-1000
                var23_4 = var3_3;
                if ((var23_4.label & -2147483648) != 0) {
                    var23_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var3_3){
                        Object L$0;
                        Object L$1;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryAssets(false, null, (Continuation<? super Assets>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache != false && System.currentTimeMillis() - this.lastQueryAssetsTime < 10000L) {
                            return Assets.copy$default((Assets)this.assets, null, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, null, (int)127, null);
                        }
                        var5_7 = new CThostFtdcQryTradingAccountField();
                        var6_10 = false;
                        var7_11 = false;
                        $this$queryAssets_u24lambda_u2d54 = var5_7;
                        $i$a$-apply-CtpTdApi$queryAssets$qryField$1 = false;
                        $this$queryAssets_u24lambda_u2d54.setBrokerID(this.getConfig().getBrokerId());
                        $this$queryAssets_u24lambda_u2d54.setInvestorID(this.getConfig().getInvestorId());
                        $this$queryAssets_u24lambda_u2d54.setCurrencyID("CNY");
                        qryField = var5_7;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryAssets$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryTradingAccount(qryField, requestId))).intValue();
lbl31:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v0 == var24_6) {
                                return var24_6;
                            }
                            ** GOTO lbl48
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var5_8 = $continuation.I$0;
                        var4_16 = (CThostFtdcQryTradingAccountField)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl48:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryAssets$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryTradingAccount(var4_16, var5_8))).intValue();
                        ** GOTO lbl31
                    }
                }
                if (resultCode$iv != 0) break block12;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryAssets$3 = false;
                var11_19 = $continuation;
                var12_22 = false;
                var13_23 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var11_19;
                $continuation.I$0 = var5_8;
                $continuation.label = 2;
                var13_24 = var11_19;
                var14_25 = false;
                var15_26 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_24));
                continuation = (Continuation)var15_26;
                $i$a$-suspendCoroutine-CtpTdApi$queryAssets$3$1 = false;
                var18_29 = this.requestMap;
                var19_30 = Boxing.boxInt((int)var5_8);
                var20_31 = new RequestContinuation(var5_8, continuation, null, null, 12, null);
                var21_32 = false;
                var18_29.put(var19_30, var20_31);
                v1 = var15_26.getOrThrow();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var11_19);
                }
                v2 = v1;
                if (v1 == var24_6) {
                    return var24_6;
                }
                break block13;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryAssets$3 = false;
                        var5_9 = $continuation.I$0;
                        var11_20 = $continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block13;
                    }
                }
            }
            var11_21 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return (Assets)v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryAssets$default(CtpTdApi ctpTdApi, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            map = null;
        }
        return ctpTdApi.queryAssets(bl, map, (Continuation<? super Assets>)continuation);
    }

    private final Position queryCachedPosition(String code, Direction direction, boolean isClose) {
        Position position;
        if (direction == Direction.UNKNOWN) {
            return null;
        }
        BiPosition biPosition = this.positions.get(code);
        if (biPosition == null) {
            return null;
        }
        BiPosition biPosition2 = biPosition;
        biPosition = direction;
        int n = WhenMappings.$EnumSwitchMapping$0[biPosition.ordinal()];
        switch (n) {
            case 1: {
                if (isClose) {
                    position = biPosition2.getShort();
                    break;
                }
                position = biPosition2.getLong();
                break;
            }
            case 2: {
                if (isClose) {
                    position = biPosition2.getLong();
                    break;
                }
                position = biPosition2.getShort();
                break;
            }
            default: {
                position = null;
            }
        }
        return position;
    }

    static /* synthetic */ Position queryCachedPosition$default(CtpTdApi ctpTdApi, String string, Direction direction, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return ctpTdApi.queryCachedPosition(string, direction, bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryPosition(@NotNull String var1_1, @NotNull Direction var2_2, boolean var3_3, @Nullable Map<String, ? extends Object> var4_4, @NotNull Continuation<? super Position> var5_5) {
        block14: {
            block13: {
                if (!(var5_5 instanceof queryPosition.1)) ** GOTO lbl-1000
                var25_6 = var5_5;
                if ((var25_6.label & -2147483648) != 0) {
                    var25_6.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var5_5){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryPosition(null, null, false, null, (Continuation<? super Position>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var26_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (direction == Direction.UNKNOWN) {
                            return null;
                        }
                        if (useCache != false) {
                            var6_9 = CtpTdApi.queryCachedPosition$default(this, (String)code, (Direction)direction, false, 4, null);
                            return var6_9 == null ? null : Position.copy$default((Position)var6_9, null, null, null, (int)0, (int)0, (double)0.0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, null, (int)262143, null);
                        }
                        var7_11 = new CThostFtdcQryInvestorPositionField();
                        var8_14 = false;
                        var9_15 = false;
                        $this$queryPosition_u24lambda_u2d58 = var7_11;
                        $i$a$-apply-CtpTdApi$queryPosition$qryField$1 = false;
                        $this$queryPosition_u24lambda_u2d58.setInstrumentID((String)UtilsKt.parseCode((String)code).getSecond());
                        qryField = var7_11;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryPosition$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInvestorPosition(qryField, requestId))).intValue();
lbl32:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = direction;
                            $continuation.L$2 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v0 == var26_8) {
                                return var26_8;
                            }
                            ** GOTO lbl51
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var7_12 = $continuation.I$0;
                        var6_10 = (CThostFtdcQryInvestorPositionField)$continuation.L$2;
                        var2_2 = (Direction)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl51:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryPosition$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInvestorPosition(var6_10, var7_12))).intValue();
                        ** GOTO lbl32
                    }
                }
                if (resultCode$iv != 0) break block13;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryPosition$3 = false;
                var13_22 = $continuation;
                var14_25 = false;
                var15_26 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_2;
                $continuation.L$2 = var13_22;
                $continuation.I$0 = var7_12;
                $continuation.label = 2;
                var15_27 = var13_22;
                var16_28 = false;
                var17_29 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var15_27));
                continuation = (Continuation)var17_29;
                $i$a$-suspendCoroutine-CtpTdApi$queryPosition$3$1 = false;
                var20_32 = this.requestMap;
                var21_33 = Boxing.boxInt((int)var7_12);
                var22_34 = false;
                var22_35 = new RequestContinuation(var7_12, continuation, var2_2.name(), new ArrayList<E>());
                var23_36 = false;
                var20_32.put(var21_33, var22_35);
                v1 = var17_29.getOrThrow();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var13_22);
                }
                v2 = v1;
                if (v1 == var26_8) {
                    return var26_8;
                }
                break block14;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryPosition$3 = false;
                        var7_13 = $continuation.I$0;
                        var13_23 = $continuation.L$2;
                        var2_2 = (Direction)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block14;
                    }
                }
            }
            var13_24 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return (Position)v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryPosition$default(CtpTdApi ctpTdApi, String string, Direction direction, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        return ctpTdApi.queryPosition(string, direction, bl, map, (Continuation<? super Position>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryPositions(@Nullable String var1_1, boolean var2_2, @Nullable Map<String, ? extends Object> var3_3, @NotNull Continuation<? super List<Position>> var4_4) {
        block23: {
            block22: {
                if (!(var4_4 instanceof queryPositions.1)) ** GOTO lbl-1000
                var26_5 = var4_4;
                if ((var26_5.label & -2147483648) != 0) {
                    var26_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var4_4){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.queryPositions(null, false, null, (Continuation<? super List<Position>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var27_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (useCache != false) {
                            var6_8 = false;
                            positionList = new ArrayList<E>();
                            var6_9 = (CharSequence)code;
                            var7_15 = false;
                            var8_19 = false;
                            if (var6_9 == null || var6_9.length() == 0) {
                                $this$forEach$iv = this.positions.values();
                                $i$f$forEach = false;
                                var8_20 = $this$forEach$iv.iterator();
                                while (var8_20.hasNext()) {
                                    element$iv = var8_20.next();
                                    biPosition = (BiPosition)element$iv;
                                    $i$a$-forEach-CtpTdApi$queryPositions$2 = false;
                                    var12_38 = biPosition.getLong();
                                    if (var12_38 != null) {
                                        var13_43 = var12_38;
                                        var14_45 = false;
                                        var15_48 = false;
                                        it = var13_43;
                                        $i$a$-let-CtpTdApi$queryPositions$2$1 = false;
                                        Boxing.boxBoolean((boolean)positionList.add(it));
                                    }
                                    var12_38 = biPosition.getShort();
                                    if (var12_38 == null) continue;
                                    var13_43 = var12_38;
                                    var14_45 = false;
                                    var15_48 = false;
                                    it = var13_43;
                                    $i$a$-let-CtpTdApi$queryPositions$2$2 = false;
                                    positionList.add(it);
                                }
                            } else {
                                $this$forEach$iv = this.positions.get(code);
                                if ($this$forEach$iv != null) {
                                    $i$f$forEach = $this$forEach$iv;
                                    var8_19 = false;
                                    element$iv = false;
                                    biPosition = $i$f$forEach;
                                    $i$a$-let-CtpTdApi$queryPositions$3 = false;
                                    var12_38 = biPosition.getLong();
                                    if (var12_38 != null) {
                                        var13_43 = var12_38;
                                        var14_45 = false;
                                        var15_48 = false;
                                        it = var13_43;
                                        $i$a$-let-CtpTdApi$queryPositions$3$1 = false;
                                        Boxing.boxBoolean((boolean)positionList.add(it));
                                    }
                                    var12_38 = biPosition.getShort();
                                    if (var12_38 != null) {
                                        var13_43 = var12_38;
                                        var14_45 = false;
                                        var15_48 = false;
                                        it = var13_43;
                                        $i$a$-let-CtpTdApi$queryPositions$3$2 = false;
                                        Boxing.boxBoolean((boolean)positionList.add(it));
                                    }
                                }
                            }
                            $this$forEach$iv = positionList;
                            $i$f$forEach = false;
                            var8_21 = $this$forEach$iv.iterator();
                            while (var8_21.hasNext()) {
                                element$iv = var8_21.next();
                                it = (Position)element$iv;
                                $i$a$-forEach-CtpTdApi$queryPositions$4 = false;
                                CtpTdApi.calculatePosition$default(this, it, false, null, 6, null);
                            }
                            $this$map$iv = positionList;
                            $i$f$map = false;
                            var8_21 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var13_43 = (Position)item$iv$iv;
                                var23_54 = destination$iv$iv;
                                $i$a$-map-CtpTdApi$queryPositions$5 = false;
                                var24_55 = Position.copy$default((Position)it, null, null, null, (int)0, (int)0, (double)0.0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, null, (int)262143, null);
                                var23_54.add(var24_55);
                            }
                            return (List)destination$iv$iv;
                        }
                        $this$map$iv = new CThostFtdcQryInvestorPositionField();
                        var7_18 = false;
                        $this$mapTo$iv$iv = false;
                        $this$queryPositions_u24lambda_u2d70 = $this$map$iv;
                        $i$a$-apply-CtpTdApi$queryPositions$qryField$1 = false;
                        $i$a$-forEach-CtpTdApi$queryPositions$4 = (CharSequence)code;
                        item$iv$iv = false;
                        var13_44 = false;
                        if (!($i$a$-forEach-CtpTdApi$queryPositions$4 == null || $i$a$-forEach-CtpTdApi$queryPositions$4.length() == 0)) {
                            $this$queryPositions_u24lambda_u2d70.setInstrumentID((String)UtilsKt.parseCode((String)code).getSecond());
                        }
                        qryField = $this$map$iv;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryPositions$6 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInvestorPosition(qryField, requestId))).intValue();
lbl120:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = code;
                            $continuation.L$2 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v0 == var27_7) {
                                return var27_7;
                            }
                            ** GOTO lbl139
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var6_11 = $continuation.I$0;
                        var5_14 = (CThostFtdcQryInvestorPositionField)$continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl139:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryPositions$6 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInvestorPosition(var5_14, var6_11))).intValue();
                        ** GOTO lbl120
                    }
                }
                if (resultCode$iv != 0) break block22;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryPositions$7 = false;
                item$iv$iv = $continuation;
                var13_44 = false;
                var14_46 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var1_1;
                $continuation.L$2 = item$iv$iv;
                $continuation.I$0 = var6_11;
                $continuation.label = 2;
                var14_47 = item$iv$iv;
                var15_49 = false;
                var16_51 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var14_47));
                continuation = (Continuation)var16_51;
                $i$a$-suspendCoroutine-CtpTdApi$queryPositions$7$1 = false;
                var19_57 = this.requestMap;
                var20_58 = Boxing.boxInt((int)var6_11);
                var21_59 = var1_1;
                v1 = var21_59 == null ? "" : var21_59;
                var21_60 = false;
                var21_61 = new RequestContinuation(var6_11, continuation, v1, new ArrayList<E>());
                var22_62 = false;
                var19_57.put(var20_58, var21_61);
                v2 = var16_51.getOrThrow();
                if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)item$iv$iv);
                }
                v3 = v2;
                if (v2 == var27_7) {
                    return var27_7;
                }
                break block23;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryPositions$7 = false;
                        var6_12 = $continuation.I$0;
                        item$iv$iv = $continuation.L$2;
                        var1_1 = (String)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break block23;
                    }
                }
            }
            item$iv$iv = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return (List)v3;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryPositions$default(CtpTdApi ctpTdApi, String string, boolean bl, Map map, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        return ctpTdApi.queryPositions(string, bl, map, (Continuation<? super List<Position>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object queryMarginPriceType(Continuation<? super Unit> var1_1) {
        block12: {
            block11: {
                if (!(var1_1 instanceof queryMarginPriceType.1)) ** GOTO lbl-1000
                var21_2 = var1_1;
                if ((var21_2.label & -2147483648) != 0) {
                    var21_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var1_1){
                        Object L$0;
                        Object L$1;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return CtpTdApi.access$queryMarginPriceType(this.this$0, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var22_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_5 = new CThostFtdcQryBrokerTradingParamsField();
                        var4_8 = false;
                        var5_9 = false;
                        $this$queryMarginPriceType_u24lambda_u2d74 = var3_5;
                        $i$a$-apply-CtpTdApi$queryMarginPriceType$qryField$1 = false;
                        $this$queryMarginPriceType_u24lambda_u2d74.setBrokerID(this.getConfig().getBrokerId());
                        $this$queryMarginPriceType_u24lambda_u2d74.setInvestorID(this.getConfig().getInvestorId());
                        $this$queryMarginPriceType_u24lambda_u2d74.setCurrencyID("CNY");
                        qryField = var3_5;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryMarginPriceType$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryBrokerTradingParams(qryField, requestId))).intValue();
lbl29:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v0 == var22_4) {
                                return var22_4;
                            }
                            ** GOTO lbl46
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var3_6 = $continuation.I$0;
                        var2_14 = (CThostFtdcQryBrokerTradingParamsField)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl46:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryMarginPriceType$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryBrokerTradingParams(var2_14, var3_6))).intValue();
                        ** GOTO lbl29
                    }
                }
                if (resultCode$iv != 0) break block11;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryMarginPriceType$3 = false;
                var9_17 = $continuation;
                var10_20 = false;
                var11_21 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var9_17;
                $continuation.I$0 = var3_6;
                $continuation.label = 2;
                var11_22 = var9_17;
                var12_23 = false;
                var13_24 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var11_22));
                continuation = (Continuation)var13_24;
                $i$a$-suspendCoroutine-CtpTdApi$queryMarginPriceType$3$1 = false;
                var16_27 = this.requestMap;
                var17_28 = Boxing.boxInt((int)var3_6);
                var18_29 = new RequestContinuation(var3_6, continuation, null, null, 12, null);
                var19_30 = false;
                var16_27.put(var17_28, var18_29);
                v1 = var13_24.getOrThrow();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var9_17);
                }
                v2 = v1;
                if (v1 == var22_4) {
                    return var22_4;
                }
                break block12;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryMarginPriceType$3 = false;
                        var3_7 = $continuation.I$0;
                        var9_18 = $continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block12;
                    }
                }
            }
            var9_19 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object queryFuturesMarginRate(String var1_1, Continuation<? super Unit> var2_2) {
        block20: {
            block22: {
                block21: {
                    block17: {
                        block19: {
                            block18: {
                                if (!(var2_2 instanceof queryFuturesMarginRate.1)) ** GOTO lbl-1000
                                var23_3 = var2_2;
                                if ((var23_3.label & -2147483648) != 0) {
                                    var23_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, var2_2){
                                        Object L$0;
                                        Object L$1;
                                        int I$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ CtpTdApi this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return CtpTdApi.access$queryFuturesMarginRate(this.this$0, null, (Continuation)this);
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (code != null) break block17;
                                        var4_6 = new CThostFtdcQryInstrumentMarginRateField();
                                        var5_10 = false;
                                        var6_14 = false;
                                        $this$queryFuturesMarginRate_u24lambda_u2d78 = var4_6;
                                        $i$a$-apply-CtpTdApi$queryFuturesMarginRate$qryField$1 = false;
                                        $this$queryFuturesMarginRate_u24lambda_u2d78.setBrokerID(this.getConfig().getBrokerId());
                                        $this$queryFuturesMarginRate_u24lambda_u2d78.setInvestorID(this.getConfig().getInvestorId());
                                        $this$queryFuturesMarginRate_u24lambda_u2d78.setHedgeFlag(jctpConstants.THOST_FTDC_HF_Speculation);
                                        qryField = var4_6;
                                        requestId = this.nextRequestId();
                                        retry$iv = true;
                                        $i$f$runWithResultCheck = false;
                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$2 = false;
                                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentMarginRate(qryField, requestId))).intValue();
lbl30:
                                        // 2 sources

                                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                                            $continuation.L$0 = this;
                                            $continuation.L$1 = qryField;
                                            $continuation.I$0 = requestId;
                                            $continuation.label = 1;
                                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                                            if (v0 == var24_5) {
                                                return var24_5;
                                            }
                                            ** GOTO lbl47
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $i$f$runWithResultCheck = false;
                                        requestId = $continuation.I$0;
                                        qryField = (CThostFtdcQryInstrumentMarginRateField)$continuation.L$1;
                                        this = (CtpTdApi)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl47:
                                        // 2 sources

                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$2 = false;
                                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentMarginRate(qryField, requestId))).intValue();
                                        ** GOTO lbl30
                                    }
                                }
                                if (resultCode$iv != 0) break block18;
                                $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$3 = false;
                                var10_29 = $continuation;
                                var11_34 = false;
                                var12_38 = false;
                                $continuation.L$0 = this;
                                $continuation.L$1 = var10_29;
                                $continuation.I$0 = requestId;
                                $continuation.label = 2;
                                var12_39 = var10_29;
                                var13_41 = false;
                                var14_44 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var12_39));
                                continuation = (Continuation)var14_44;
                                $i$a$-suspendCoroutine-CtpTdApi$queryFuturesMarginRate$3$1 = false;
                                var17_50 = this.requestMap;
                                var18_52 = Boxing.boxInt((int)requestId);
                                var19_54 = new RequestContinuation(requestId, continuation, null, null, 12, null);
                                var20_56 = false;
                                var17_50.put(var18_52, var19_54);
                                v1 = var14_44.getOrThrow();
                                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    DebugProbesKt.probeCoroutineSuspended((Continuation)var10_29);
                                }
                                v2 = v1;
                                if (v1 == var24_5) {
                                    return var24_5;
                                }
                                break block19;
                                {
                                    case 2: {
                                        $i$f$runWithResultCheck = false;
                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$3 = false;
                                        requestId = $continuation.I$0;
                                        var10_30 = $continuation.L$1;
                                        this = (CtpTdApi)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
                                        break block19;
                                    }
                                }
                            }
                            var10_31 = UtilsKt.getErrorInfo(resultCode$iv);
                            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                            throw new Exception((String)info + " (" + code + ')');
                        }
                        return Unit.INSTANCE;
                    }
                    instrument = this.getInstruments().get(var1_1);
                    if (instrument == null || instrument.getMarginRate() != null || instrument.getType() != SecurityType.FUTURES) break block20;
                    var5_11 = new CThostFtdcQryInstrumentMarginRateField();
                    var6_15 = false;
                    $i$f$runWithResultCheck = false;
                    $this$queryFuturesMarginRate_u24lambda_u2d82 = var5_11;
                    $i$a$-apply-CtpTdApi$queryFuturesMarginRate$qryField$2 = false;
                    $this$queryFuturesMarginRate_u24lambda_u2d82.setBrokerID(this.getConfig().getBrokerId());
                    $this$queryFuturesMarginRate_u24lambda_u2d82.setInvestorID(this.getConfig().getInvestorId());
                    $this$queryFuturesMarginRate_u24lambda_u2d82.setHedgeFlag(jctpConstants.THOST_FTDC_HF_Speculation);
                    $this$queryFuturesMarginRate_u24lambda_u2d82.setInstrumentID((String)UtilsKt.parseCode(var1_1).getSecond());
                    qryField = var5_11;
                    requestId = this.nextRequestId();
                    retry$iv = true;
                    $i$f$runWithResultCheck = false;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$4 = false;
                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentMarginRate(qryField, requestId))).intValue();
lbl115:
                    // 2 sources

                    while (resultCode$iv == -2 || resultCode$iv == -3) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = qryField;
                        $continuation.I$0 = requestId;
                        $continuation.label = 3;
                        v3 = DelayKt.delay((long)10L, (Continuation)$continuation);
                        if (v3 == var24_5) {
                            return var24_5;
                        }
                        ** GOTO lbl132
                    }
                    {
                        break;
                        case 3: {
                            $i$f$runWithResultCheck = false;
                            var5_12 = $continuation.I$0;
                            var4_9 = (CThostFtdcQryInstrumentMarginRateField)$continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl132:
                            // 2 sources

                            $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$4 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentMarginRate(var4_9, var5_12))).intValue();
                            ** GOTO lbl115
                        }
                    }
                    if (resultCode$iv != 0) break block21;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$5 = false;
                    var11_35 = $continuation;
                    var12_40 = false;
                    var13_42 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var11_35;
                    $continuation.I$0 = var5_12;
                    $continuation.label = 4;
                    var13_43 = var11_35;
                    var14_45 = false;
                    var15_47 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_43));
                    continuation = (Continuation)var15_47;
                    $i$a$-suspendCoroutine-CtpTdApi$queryFuturesMarginRate$5$1 = false;
                    var18_53 = this.requestMap;
                    var19_55 = Boxing.boxInt((int)var5_12);
                    var20_57 = new RequestContinuation(var5_12, continuation, null, null, 12, null);
                    var21_58 = false;
                    var18_53.put(var19_55, var20_57);
                    v4 = var15_47.getOrThrow();
                    if (v4 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)var11_35);
                    }
                    v5 = v4;
                    if (v4 == var24_5) {
                        return var24_5;
                    }
                    break block22;
                    {
                        case 4: {
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesMarginRate$5 = false;
                            var5_13 = $continuation.I$0;
                            var11_36 = $continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
                            break block22;
                        }
                    }
                }
                var11_37 = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object queryFuturesMarginRate$default(CtpTdApi ctpTdApi, String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ctpTdApi.queryFuturesMarginRate(string, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object queryOptionsMargin(String var1_1, Continuation<? super Unit> var2_2) {
        block20: {
            block22: {
                block21: {
                    block17: {
                        block19: {
                            block18: {
                                if (!(var2_2 instanceof queryOptionsMargin.1)) ** GOTO lbl-1000
                                var23_3 = var2_2;
                                if ((var23_3.label & -2147483648) != 0) {
                                    var23_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, var2_2){
                                        Object L$0;
                                        Object L$1;
                                        int I$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ CtpTdApi this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return CtpTdApi.access$queryOptionsMargin(this.this$0, null, (Continuation)this);
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (code != null) break block17;
                                        var4_6 = new CThostFtdcQryOptionInstrTradeCostField();
                                        var5_10 = false;
                                        var6_14 = false;
                                        $this$queryOptionsMargin_u24lambda_u2d86 = var4_6;
                                        $i$a$-apply-CtpTdApi$queryOptionsMargin$qryField$1 = false;
                                        $this$queryOptionsMargin_u24lambda_u2d86.setBrokerID(this.getConfig().getBrokerId());
                                        $this$queryOptionsMargin_u24lambda_u2d86.setInvestorID(this.getConfig().getInvestorId());
                                        $this$queryOptionsMargin_u24lambda_u2d86.setHedgeFlag(jctpConstants.THOST_FTDC_HF_Speculation);
                                        qryField = var4_6;
                                        requestId = this.nextRequestId();
                                        retry$iv = true;
                                        $i$f$runWithResultCheck = false;
                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$2 = false;
                                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrTradeCost(qryField, requestId))).intValue();
lbl30:
                                        // 2 sources

                                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                                            $continuation.L$0 = this;
                                            $continuation.L$1 = qryField;
                                            $continuation.I$0 = requestId;
                                            $continuation.label = 1;
                                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                                            if (v0 == var24_5) {
                                                return var24_5;
                                            }
                                            ** GOTO lbl47
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $i$f$runWithResultCheck = false;
                                        requestId = $continuation.I$0;
                                        qryField = (CThostFtdcQryOptionInstrTradeCostField)$continuation.L$1;
                                        this = (CtpTdApi)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl47:
                                        // 2 sources

                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$2 = false;
                                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrTradeCost(qryField, requestId))).intValue();
                                        ** GOTO lbl30
                                    }
                                }
                                if (resultCode$iv != 0) break block18;
                                $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$3 = false;
                                var10_29 = $continuation;
                                var11_34 = false;
                                var12_38 = false;
                                $continuation.L$0 = this;
                                $continuation.L$1 = var10_29;
                                $continuation.I$0 = requestId;
                                $continuation.label = 2;
                                var12_39 = var10_29;
                                var13_41 = false;
                                var14_44 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var12_39));
                                continuation = (Continuation)var14_44;
                                $i$a$-suspendCoroutine-CtpTdApi$queryOptionsMargin$3$1 = false;
                                var17_50 = this.requestMap;
                                var18_52 = Boxing.boxInt((int)requestId);
                                var19_54 = new RequestContinuation(requestId, continuation, null, null, 12, null);
                                var20_56 = false;
                                var17_50.put(var18_52, var19_54);
                                v1 = var14_44.getOrThrow();
                                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    DebugProbesKt.probeCoroutineSuspended((Continuation)var10_29);
                                }
                                v2 = v1;
                                if (v1 == var24_5) {
                                    return var24_5;
                                }
                                break block19;
                                {
                                    case 2: {
                                        $i$f$runWithResultCheck = false;
                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$3 = false;
                                        requestId = $continuation.I$0;
                                        var10_30 = $continuation.L$1;
                                        this = (CtpTdApi)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
                                        break block19;
                                    }
                                }
                            }
                            var10_31 = UtilsKt.getErrorInfo(resultCode$iv);
                            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                            throw new Exception((String)info + " (" + code + ')');
                        }
                        return Unit.INSTANCE;
                    }
                    instrument = this.getInstruments().get(var1_1);
                    if (instrument == null || instrument.getMarginRate() != null || instrument.getType() != SecurityType.OPTIONS) break block20;
                    var5_11 = new CThostFtdcQryOptionInstrTradeCostField();
                    var6_15 = false;
                    $i$f$runWithResultCheck = false;
                    $this$queryOptionsMargin_u24lambda_u2d90 = var5_11;
                    $i$a$-apply-CtpTdApi$queryOptionsMargin$qryField$2 = false;
                    $this$queryOptionsMargin_u24lambda_u2d90.setBrokerID(this.getConfig().getBrokerId());
                    $this$queryOptionsMargin_u24lambda_u2d90.setInvestorID(this.getConfig().getInvestorId());
                    $this$queryOptionsMargin_u24lambda_u2d90.setHedgeFlag(jctpConstants.THOST_FTDC_HF_Speculation);
                    $this$queryOptionsMargin_u24lambda_u2d90.setInstrumentID((String)UtilsKt.parseCode(var1_1).getSecond());
                    qryField = var5_11;
                    requestId = this.nextRequestId();
                    retry$iv = true;
                    $i$f$runWithResultCheck = false;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$4 = false;
                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrTradeCost(qryField, requestId))).intValue();
lbl115:
                    // 2 sources

                    while (resultCode$iv == -2 || resultCode$iv == -3) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = qryField;
                        $continuation.I$0 = requestId;
                        $continuation.label = 3;
                        v3 = DelayKt.delay((long)10L, (Continuation)$continuation);
                        if (v3 == var24_5) {
                            return var24_5;
                        }
                        ** GOTO lbl132
                    }
                    {
                        break;
                        case 3: {
                            $i$f$runWithResultCheck = false;
                            var5_12 = $continuation.I$0;
                            var4_9 = (CThostFtdcQryOptionInstrTradeCostField)$continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl132:
                            // 2 sources

                            $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$4 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrTradeCost(var4_9, var5_12))).intValue();
                            ** GOTO lbl115
                        }
                    }
                    if (resultCode$iv != 0) break block21;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$5 = false;
                    var11_35 = $continuation;
                    var12_40 = false;
                    var13_42 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var11_35;
                    $continuation.I$0 = var5_12;
                    $continuation.label = 4;
                    var13_43 = var11_35;
                    var14_45 = false;
                    var15_47 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_43));
                    continuation = (Continuation)var15_47;
                    $i$a$-suspendCoroutine-CtpTdApi$queryOptionsMargin$5$1 = false;
                    var18_53 = this.requestMap;
                    var19_55 = Boxing.boxInt((int)var5_12);
                    var20_57 = new RequestContinuation(var5_12, continuation, null, null, 12, null);
                    var21_58 = false;
                    var18_53.put(var19_55, var20_57);
                    v4 = var15_47.getOrThrow();
                    if (v4 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)var11_35);
                    }
                    v5 = v4;
                    if (v4 == var24_5) {
                        return var24_5;
                    }
                    break block22;
                    {
                        case 4: {
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsMargin$5 = false;
                            var5_13 = $continuation.I$0;
                            var11_36 = $continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
                            break block22;
                        }
                    }
                }
                var11_37 = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object queryOptionsMargin$default(CtpTdApi ctpTdApi, String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ctpTdApi.queryOptionsMargin(string, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object queryFuturesCommissionRate(String var1_1, Continuation<? super Unit> var2_2) {
        block23: {
            block25: {
                block24: {
                    block22: {
                        block21: {
                            if (!(var2_2 instanceof queryFuturesCommissionRate.1)) ** GOTO lbl-1000
                            var23_3 = var2_2;
                            if ((var23_3.label & -2147483648) != 0) {
                                var23_3.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, var2_2){
                                    Object L$0;
                                    Object L$1;
                                    int I$0;
                                    /* synthetic */ Object result;
                                    final /* synthetic */ CtpTdApi this$0;
                                    int label;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return CtpTdApi.access$queryFuturesCommissionRate(this.this$0, null, (Continuation)this);
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    if (code != null) break;
                                    var4_6 = new CThostFtdcQryInstrumentCommissionRateField();
                                    var5_9 = false;
                                    var6_13 = false;
                                    $this$queryFuturesCommissionRate_u24lambda_u2d94 = var4_6;
                                    $i$a$-apply-CtpTdApi$queryFuturesCommissionRate$qryField$1 = false;
                                    $this$queryFuturesCommissionRate_u24lambda_u2d94.setBrokerID(this.getConfig().getBrokerId());
                                    $this$queryFuturesCommissionRate_u24lambda_u2d94.setInvestorID(this.getConfig().getInvestorId());
                                    qryField = var4_6;
                                    requestId = this.nextRequestId();
                                    retry$iv = true;
                                    $i$f$runWithResultCheck = false;
                                    $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$2 = false;
                                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentCommissionRate(qryField, requestId))).intValue();
lbl29:
                                    // 2 sources

                                    while (resultCode$iv == -2 || resultCode$iv == -3) {
                                        $continuation.L$0 = this;
                                        $continuation.L$1 = qryField;
                                        $continuation.I$0 = requestId;
                                        $continuation.label = 1;
                                        v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                                        if (v0 == var24_5) {
                                            return var24_5;
                                        }
                                        ** GOTO lbl46
                                    }
                                    break;
                                }
                                case 1: {
                                    $i$f$runWithResultCheck = false;
                                    requestId = $continuation.I$0;
                                    qryField = (CThostFtdcQryInstrumentCommissionRateField)$continuation.L$1;
                                    this = (CtpTdApi)$continuation.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl46:
                                    // 2 sources

                                    $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$2 = false;
                                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentCommissionRate(qryField, requestId))).intValue();
                                    ** GOTO lbl29
                                }
                            }
                            if (resultCode$iv != 0) break block21;
                            $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$3 = false;
                            var10_31 = $continuation;
                            var11_37 = false;
                            var12_40 = false;
                            $continuation.L$0 = this;
                            $continuation.L$1 = var10_31;
                            $continuation.I$0 = requestId;
                            $continuation.label = 2;
                            var12_41 = var10_31;
                            var13_44 = false;
                            var14_47 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var12_41));
                            continuation = (Continuation)var14_47;
                            $i$a$-suspendCoroutine-CtpTdApi$queryFuturesCommissionRate$3$1 = false;
                            var17_53 = this.requestMap;
                            var18_55 = Boxing.boxInt((int)requestId);
                            var19_57 = false;
                            var19_58 = new RequestContinuation(requestId, continuation, null, new ArrayList<E>(), 4, null);
                            var20_60 = false;
                            var17_53.put(var18_55, var19_58);
                            v1 = var14_47.getOrThrow();
                            if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)var10_31);
                            }
                            v2 = v1;
                            if (v1 == var24_5) {
                                return var24_5;
                            }
                            break block22;
                            {
                                case 2: {
                                    $i$f$runWithResultCheck = false;
                                    $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$3 = false;
                                    requestId = $continuation.I$0;
                                    var10_31 = $continuation.L$1;
                                    this = (CtpTdApi)$continuation.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
                                    break block22;
                                }
                            }
                        }
                        var10_32 = UtilsKt.getErrorInfo(resultCode$iv);
                        code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                        throw new Exception((String)info + " (" + code + ')');
                    }
                    $this$forEach$iv = (List)v2;
                    $i$f$forEach = false;
                    $i$f$runWithResultCheck = $this$forEach$iv.iterator();
lbl96:
                    // 3 sources

                    while ($i$f$runWithResultCheck.hasNext()) {
                        element$iv = $i$f$runWithResultCheck.next();
                        it = (Job)element$iv;
                        $i$a$-forEach-CtpTdApi$queryFuturesCommissionRate$4 = false;
                        $continuation.L$0 = $i$f$runWithResultCheck;
                        $continuation.L$1 = null;
                        $continuation.label = 3;
                        v3 = it.join((Continuation)$continuation);
                        if (v3 != var24_5) continue;
                        return var24_5;
                    }
                    {
                        break;
                        case 3: {
                            $i$f$forEach = false;
                            $i$a$-forEach-CtpTdApi$queryFuturesCommissionRate$4 = false;
                            $i$f$runWithResultCheck = (Iterator<T>)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** GOTO lbl96
                        }
                    }
                    instrument = this.getInstruments().get(var1_1);
                    if (instrument == null || instrument.getCommissionRate() != null || instrument.getType() != SecurityType.FUTURES) break block23;
                    $this$forEach$iv = new CThostFtdcQryInstrumentCommissionRateField();
                    $i$f$forEach = false;
                    $i$f$runWithResultCheck = false;
                    $this$queryFuturesCommissionRate_u24lambda_u2d99 = $this$forEach$iv;
                    $i$a$-apply-CtpTdApi$queryFuturesCommissionRate$qryField$2 = false;
                    $this$queryFuturesCommissionRate_u24lambda_u2d99.setBrokerID(this.getConfig().getBrokerId());
                    $this$queryFuturesCommissionRate_u24lambda_u2d99.setInvestorID(this.getConfig().getInvestorId());
                    $i$a$-forEach-CtpTdApi$queryFuturesCommissionRate$4 = UtilsKt.parseCode(var1_1);
                    excId /* !! */  = (String)$i$a$-forEach-CtpTdApi$queryFuturesCommissionRate$4.component1();
                    insId = (String)$i$a$-forEach-CtpTdApi$queryFuturesCommissionRate$4.component2();
                    $this$queryFuturesCommissionRate_u24lambda_u2d99.setExchangeID((String)excId /* !! */ );
                    $this$queryFuturesCommissionRate_u24lambda_u2d99.setInstrumentID(insId);
                    qryField = $this$forEach$iv;
                    requestId = this.nextRequestId();
                    retry$iv = true;
                    $i$f$runWithResultCheck = false;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$5 = false;
                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentCommissionRate(qryField, requestId))).intValue();
lbl137:
                    // 2 sources

                    while (resultCode$iv == -2 || resultCode$iv == -3) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = qryField;
                        $continuation.I$0 = requestId;
                        $continuation.label = 4;
                        v4 = DelayKt.delay((long)10L, (Continuation)$continuation);
                        if (v4 == var24_5) {
                            return var24_5;
                        }
                        ** GOTO lbl154
                    }
                    {
                        break;
                        case 4: {
                            $i$f$runWithResultCheck = false;
                            var5_12 = $continuation.I$0;
                            var4_8 = (CThostFtdcQryInstrumentCommissionRateField)$continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl154:
                            // 2 sources

                            $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$5 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentCommissionRate(var4_8, var5_12))).intValue();
                            ** GOTO lbl137
                        }
                    }
                    if (resultCode$iv != 0) break block24;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$6 = false;
                    excId /* !! */  = $continuation;
                    var12_43 = false;
                    var13_45 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = excId /* !! */ ;
                    $continuation.I$0 = var5_12;
                    $continuation.label = 5;
                    var13_46 /* !! */  = excId /* !! */ ;
                    var14_48 = false;
                    var15_50 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_46 /* !! */ ));
                    continuation = (Continuation)var15_50;
                    $i$a$-suspendCoroutine-CtpTdApi$queryFuturesCommissionRate$6$1 = false;
                    var18_56 = this.requestMap;
                    var19_59 = Boxing.boxInt((int)var5_12);
                    var20_61 = false;
                    var20_62 = new RequestContinuation(var5_12, continuation, null, new ArrayList<E>(), 4, null);
                    var21_63 = false;
                    var18_56.put(var19_59, var20_62);
                    v5 = var15_50.getOrThrow();
                    if (v5 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)excId /* !! */ );
                    }
                    v6 = v5;
                    if (v5 == var24_5) {
                        return var24_5;
                    }
                    break block25;
                    {
                        case 5: {
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesCommissionRate$6 = false;
                            var5_12 = $continuation.I$0;
                            excId /* !! */  = $continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
                            break block25;
                        }
                    }
                }
                excId /* !! */  = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
            $this$forEach$iv = (List)v6;
            $i$f$forEach = false;
            var8_24 = $this$forEach$iv.iterator();
lbl204:
            // 3 sources

            while (var8_24.hasNext()) {
                element$iv = var8_24.next();
                it = (Job)element$iv;
                $i$a$-forEach-CtpTdApi$queryFuturesCommissionRate$7 = false;
                $continuation.L$0 = var8_24;
                $continuation.L$1 = null;
                $continuation.label = 6;
                v7 = it.join((Continuation)$continuation);
                if (v7 != var24_5) continue;
                return var24_5;
            }
            {
                break;
                case 6: {
                    $i$f$forEach = false;
                    $i$a$-forEach-CtpTdApi$queryFuturesCommissionRate$7 = false;
                    var8_24 = (Iterator<T>)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
                    ** GOTO lbl204
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object queryFuturesCommissionRate$default(CtpTdApi ctpTdApi, String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ctpTdApi.queryFuturesCommissionRate(string, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object queryFuturesOrderCommissionRate(String var1_1, Continuation<? super Unit> var2_2) {
        block12: {
            block11: {
                if (!(var2_2 instanceof queryFuturesOrderCommissionRate.1)) ** GOTO lbl-1000
                var22_3 = var2_2;
                if ((var22_3.label & -2147483648) != 0) {
                    var22_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var2_2){
                        Object L$0;
                        Object L$1;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ CtpTdApi this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return CtpTdApi.access$queryFuturesOrderCommissionRate(this.this$0, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var23_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var4_6 = new CThostFtdcQryInstrumentOrderCommRateField();
                        var5_9 = false;
                        var6_10 = false;
                        $this$queryFuturesOrderCommissionRate_u24lambda_u2d104 = var4_6;
                        $i$a$-apply-CtpTdApi$queryFuturesOrderCommissionRate$qryField$1 = false;
                        $this$queryFuturesOrderCommissionRate_u24lambda_u2d104.setBrokerID(this.getConfig().getBrokerId());
                        $this$queryFuturesOrderCommissionRate_u24lambda_u2d104.setInvestorID(this.getConfig().getInvestorId());
                        $this$queryFuturesOrderCommissionRate_u24lambda_u2d104.setInstrumentID((String)UtilsKt.parseCode((String)code).getSecond());
                        qryField = var4_6;
                        requestId = this.nextRequestId();
                        retry$iv = true;
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesOrderCommissionRate$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentOrderCommRate(qryField, requestId))).intValue();
lbl29:
                        // 2 sources

                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                            $continuation.L$0 = this;
                            $continuation.L$1 = qryField;
                            $continuation.I$0 = requestId;
                            $continuation.label = 1;
                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                            if (v0 == var23_5) {
                                return var23_5;
                            }
                            ** GOTO lbl46
                        }
                        break;
                    }
                    case 1: {
                        $i$f$runWithResultCheck = false;
                        var4_7 = $continuation.I$0;
                        var3_15 = (CThostFtdcQryInstrumentOrderCommRateField)$continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl46:
                        // 2 sources

                        $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesOrderCommissionRate$2 = false;
                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryInstrumentOrderCommRate(var3_15, var4_7))).intValue();
                        ** GOTO lbl29
                    }
                }
                if (resultCode$iv != 0) break block11;
                $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesOrderCommissionRate$3 = false;
                var10_18 = $continuation;
                var11_21 = false;
                var12_22 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var10_18;
                $continuation.I$0 = var4_7;
                $continuation.label = 2;
                var12_23 = var10_18;
                var13_24 = false;
                var14_25 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var12_23));
                continuation = (Continuation)var14_25;
                $i$a$-suspendCoroutine-CtpTdApi$queryFuturesOrderCommissionRate$3$1 = false;
                var17_28 = this.requestMap;
                var18_29 = Boxing.boxInt((int)var4_7);
                var19_30 = new RequestContinuation(var4_7, continuation, null, null, 12, null);
                var20_31 = false;
                var17_28.put(var18_29, var19_30);
                v1 = var14_25.getOrThrow();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)var10_18);
                }
                v2 = v1;
                if (v1 == var23_5) {
                    return var23_5;
                }
                break block12;
                {
                    case 2: {
                        $i$f$runWithResultCheck = false;
                        $i$a$-runWithResultCheck$default-CtpTdApi$queryFuturesOrderCommissionRate$3 = false;
                        var4_8 = $continuation.I$0;
                        var10_19 = $continuation.L$1;
                        this = (CtpTdApi)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block12;
                    }
                }
            }
            var10_20 = UtilsKt.getErrorInfo(resultCode$iv);
            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
            throw new Exception((String)info + " (" + code + ')');
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object queryOptionsCommissionRate(String var1_1, Continuation<? super Unit> var2_2) {
        block20: {
            block22: {
                block21: {
                    block17: {
                        block19: {
                            block18: {
                                if (!(var2_2 instanceof queryOptionsCommissionRate.1)) ** GOTO lbl-1000
                                var23_3 = var2_2;
                                if ((var23_3.label & -2147483648) != 0) {
                                    var23_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, var2_2){
                                        Object L$0;
                                        Object L$1;
                                        int I$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ CtpTdApi this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return CtpTdApi.access$queryOptionsCommissionRate(this.this$0, null, (Continuation)this);
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (code != null) break block17;
                                        var4_6 = new CThostFtdcQryOptionInstrCommRateField();
                                        var5_10 = false;
                                        var6_14 = false;
                                        $this$queryOptionsCommissionRate_u24lambda_u2d108 = var4_6;
                                        $i$a$-apply-CtpTdApi$queryOptionsCommissionRate$qryField$1 = false;
                                        $this$queryOptionsCommissionRate_u24lambda_u2d108.setBrokerID(this.getConfig().getBrokerId());
                                        $this$queryOptionsCommissionRate_u24lambda_u2d108.setInvestorID(this.getConfig().getInvestorId());
                                        qryField = var4_6;
                                        requestId = this.nextRequestId();
                                        retry$iv = true;
                                        $i$f$runWithResultCheck = false;
                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$2 = false;
                                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrCommRate(qryField, requestId))).intValue();
lbl29:
                                        // 2 sources

                                        while (resultCode$iv == -2 || resultCode$iv == -3) {
                                            $continuation.L$0 = this;
                                            $continuation.L$1 = qryField;
                                            $continuation.I$0 = requestId;
                                            $continuation.label = 1;
                                            v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                                            if (v0 == var24_5) {
                                                return var24_5;
                                            }
                                            ** GOTO lbl46
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $i$f$runWithResultCheck = false;
                                        requestId = $continuation.I$0;
                                        qryField = (CThostFtdcQryOptionInstrCommRateField)$continuation.L$1;
                                        this = (CtpTdApi)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl46:
                                        // 2 sources

                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$2 = false;
                                        resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrCommRate(qryField, requestId))).intValue();
                                        ** GOTO lbl29
                                    }
                                }
                                if (resultCode$iv != 0) break block18;
                                $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$3 = false;
                                var10_29 = $continuation;
                                var11_35 = false;
                                var12_38 = false;
                                $continuation.L$0 = this;
                                $continuation.L$1 = var10_29;
                                $continuation.I$0 = requestId;
                                $continuation.label = 2;
                                var12_39 = var10_29;
                                var13_42 = false;
                                var14_45 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var12_39));
                                continuation = (Continuation)var14_45;
                                $i$a$-suspendCoroutine-CtpTdApi$queryOptionsCommissionRate$3$1 = false;
                                var17_51 = this.requestMap;
                                var18_53 = Boxing.boxInt((int)requestId);
                                var19_55 = new RequestContinuation(requestId, continuation, null, null, 12, null);
                                var20_57 = false;
                                var17_51.put(var18_53, var19_55);
                                v1 = var14_45.getOrThrow();
                                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    DebugProbesKt.probeCoroutineSuspended((Continuation)var10_29);
                                }
                                v2 = v1;
                                if (v1 == var24_5) {
                                    return var24_5;
                                }
                                break block19;
                                {
                                    case 2: {
                                        $i$f$runWithResultCheck = false;
                                        $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$3 = false;
                                        requestId = $continuation.I$0;
                                        var10_30 = $continuation.L$1;
                                        this = (CtpTdApi)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
                                        break block19;
                                    }
                                }
                            }
                            var10_31 = UtilsKt.getErrorInfo(resultCode$iv);
                            code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                            throw new Exception((String)info + " (" + code + ')');
                        }
                        return Unit.INSTANCE;
                    }
                    instrument = this.getInstruments().get(var1_1);
                    if (instrument == null || instrument.getCommissionRate() != null || instrument.getType() != SecurityType.OPTIONS) break block20;
                    var5_11 = new CThostFtdcQryOptionInstrCommRateField();
                    var6_15 = false;
                    $i$f$runWithResultCheck = false;
                    $this$queryOptionsCommissionRate_u24lambda_u2d112 = var5_11;
                    $i$a$-apply-CtpTdApi$queryOptionsCommissionRate$qryField$2 = false;
                    $this$queryOptionsCommissionRate_u24lambda_u2d112.setBrokerID(this.getConfig().getBrokerId());
                    $this$queryOptionsCommissionRate_u24lambda_u2d112.setInvestorID(this.getConfig().getInvestorId());
                    info = UtilsKt.parseCode(var1_1);
                    excId /* !! */  = (String)info.component1();
                    insId = (String)info.component2();
                    $this$queryOptionsCommissionRate_u24lambda_u2d112.setExchangeID((String)excId /* !! */ );
                    $this$queryOptionsCommissionRate_u24lambda_u2d112.setInstrumentID(insId);
                    qryField = var5_11;
                    requestId = this.nextRequestId();
                    retry$iv = true;
                    $i$f$runWithResultCheck = false;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$4 = false;
                    resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrCommRate(qryField, requestId))).intValue();
lbl117:
                    // 2 sources

                    while (resultCode$iv == -2 || resultCode$iv == -3) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = qryField;
                        $continuation.I$0 = requestId;
                        $continuation.label = 3;
                        v3 = DelayKt.delay((long)10L, (Continuation)$continuation);
                        if (v3 == var24_5) {
                            return var24_5;
                        }
                        ** GOTO lbl134
                    }
                    {
                        break;
                        case 3: {
                            $i$f$runWithResultCheck = false;
                            var5_12 = $continuation.I$0;
                            var4_9 = (CThostFtdcQryOptionInstrCommRateField)$continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl134:
                            // 2 sources

                            $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$4 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)this.tdApi.ReqQryOptionInstrCommRate(var4_9, var5_12))).intValue();
                            ** GOTO lbl117
                        }
                    }
                    if (resultCode$iv != 0) break block21;
                    $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$5 = false;
                    excId /* !! */  = $continuation;
                    var12_41 = false;
                    var13_43 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = excId /* !! */ ;
                    $continuation.I$0 = var5_12;
                    $continuation.label = 4;
                    var13_44 /* !! */  = excId /* !! */ ;
                    var14_46 = false;
                    var15_48 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_44 /* !! */ ));
                    continuation = (Continuation)var15_48;
                    $i$a$-suspendCoroutine-CtpTdApi$queryOptionsCommissionRate$5$1 = false;
                    var18_54 = this.requestMap;
                    var19_56 = Boxing.boxInt((int)var5_12);
                    var20_58 = new RequestContinuation(var5_12, continuation, null, null, 12, null);
                    var21_59 = false;
                    var18_54.put(var19_56, var20_58);
                    v4 = var15_48.getOrThrow();
                    if (v4 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)excId /* !! */ );
                    }
                    v5 = v4;
                    if (v4 == var24_5) {
                        return var24_5;
                    }
                    break block22;
                    {
                        case 4: {
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$queryOptionsCommissionRate$5 = false;
                            var5_13 = $continuation.I$0;
                            excId = $continuation.L$1;
                            this = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
                            break block22;
                        }
                    }
                }
                excId /* !! */  = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object queryOptionsCommissionRate$default(CtpTdApi ctpTdApi, String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ctpTdApi.queryOptionsCommissionRate(string, (Continuation<? super Unit>)continuation);
    }

    private final CommissionRate getOrQueryCommissionRate(Security instrument2) {
        if (this.config.getDisableFeeCalculation()) {
            return null;
        }
        if (instrument2.getCommissionRate() == null) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, instrument2, null){
                int label;
                final /* synthetic */ CtpTdApi this$0;
                final /* synthetic */ Security $instrument;
                {
                    this.this$0 = $receiver;
                    this.$instrument = $instrument;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = CtpTdApi.access$prepareFeeCalculation(this.this$0, this.$instrument.getCode(), false, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        return instrument2.getCommissionRate();
    }

    private final MarginRate getOrQueryMarginRate(Security instrument2) {
        if (this.config.getDisableFeeCalculation()) {
            return null;
        }
        if (instrument2.getMarginRate() == null) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, instrument2, null){
                int label;
                final /* synthetic */ CtpTdApi this$0;
                final /* synthetic */ Security $instrument;
                {
                    this.this$0 = $receiver;
                    this.$instrument = $instrument;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = CtpTdApi.access$prepareFeeCalculation(this.this$0, this.$instrument.getCode(), false, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        return instrument2.getMarginRate();
    }

    /*
     * Exception decompiling
     */
    private final Object prepareFeeCalculation(String var1_1, boolean var2_2, Continuation<? super Unit> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ Object prepareFeeCalculation$default(CtpTdApi ctpTdApi, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ctpTdApi.prepareFeeCalculation(string, bl, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object prepareFeeCalculation(@Nullable Collection<String> var1_1, @Nullable Map<String, ? extends Object> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof prepareFeeCalculation.10)) ** GOTO lbl-1000
        var11_4 = var3_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CtpTdApi this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.prepareFeeCalculation(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (codes != null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = UtilsKt.runWithRetry$default((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ CtpTdApi this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = CtpTdApi.queryFuturesCommissionRate$default(this.this$0, null, (Continuation)this, 1, null);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, null, (Continuation)$continuation, 2, null);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (CtpTdApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.label = 2;
                v1 = UtilsKt.runWithRetry$default((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ CtpTdApi this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = CtpTdApi.queryFuturesMarginRate$default(this.this$0, null, (Continuation)this, 1, null);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, null, (Continuation)$continuation, 2, null);
                if (v1 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl33
            }
            case 2: {
                this = (CtpTdApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.label = 3;
                v2 = UtilsKt.runWithRetry$default((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ CtpTdApi this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = CtpTdApi.queryOptionsCommissionRate$default(this.this$0, null, (Continuation)this, 1, null);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, null, (Continuation)$continuation, 2, null);
                if (v2 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl43
            }
            case 3: {
                this = (CtpTdApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl43:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 4;
                v3 = UtilsKt.runWithRetry$default((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ CtpTdApi this$0;
                    {
                        this.this$0 = $receiver;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = CtpTdApi.queryOptionsMargin$default(this.this$0, null, (Continuation)this, 1, null);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, null, (Continuation)$continuation, 2, null);
                if (v3 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl52
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl52:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        $this$forEach$iv = var1_1;
        $i$f$forEach = false;
        var6_9 = $this$forEach$iv.iterator();
lbl56:
        // 3 sources

        while (var6_9.hasNext()) {
            element$iv = var6_9.next();
            it = (String)element$iv;
            $i$a$-forEach-CtpTdApi$prepareFeeCalculation$15 = false;
            $continuation.L$0 = this;
            $continuation.L$1 = var6_9;
            $continuation.label = 5;
            v4 = CtpTdApi.prepareFeeCalculation$default(this, it, false, (Continuation)$continuation, 2, null);
            if (v4 != var12_6) continue;
            return var12_6;
        }
        {
            break;
            case 5: {
                $i$f$forEach = false;
                $i$a$-forEach-CtpTdApi$prepareFeeCalculation$15 = false;
                var6_9 = (Iterator<T>)$continuation.L$1;
                this = (CtpTdApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                ** GOTO lbl56
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object prepareFeeCalculation$default(CtpTdApi ctpTdApi, Collection collection, Map map, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            collection = null;
        }
        if ((n & 2) != 0) {
            map = null;
        }
        return ctpTdApi.prepareFeeCalculation(collection, map, (Continuation<? super Unit>)continuation);
    }

    private final Pair<Tick, Boolean> getOrQueryTick(String code) {
        Ref.ObjectRef tick2 = new Ref.ObjectRef();
        Ref.BooleanRef isLatestTick = new Ref.BooleanRef();
        if (this.getMdApi().getConnected() && !this.config.getDisableAutoSubscribe()) {
            tick2.element = this.getMdApi().getLastTicks().get(code);
            if (tick2.element == null) {
                try {
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, code, null){
                        int label;
                        final /* synthetic */ CtpTdApi this$0;
                        final /* synthetic */ String $code;
                        {
                            this.this$0 = $receiver;
                            this.$code = $code;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = CtpMdApi.subscribeMarketData$default(this.this$0.getMdApi(), CollectionsKt.listOf((Object)this.$code), null, (Continuation)this, 2, null);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
                catch (Exception e) {
                    this.postBrokerEvent(BrokerEventType.TD_ERROR, "\u8ba1\u7b97\u4fdd\u8bc1\u91d1\u65f6\u8ba2\u9605\u5408\u7ea6\u884c\u60c5\u5931\u8d25\uff1a" + code + ", " + e);
                }
            } else {
                isLatestTick.element = true;
            }
        }
        if (tick2.element == null) {
            tick2.element = this.cachedTickMap.get(code);
            if (tick2.element == null) {
                try {
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<Tick>)tick2, isLatestTick, this, code, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ Ref.ObjectRef<Tick> $tick;
                        final /* synthetic */ Ref.BooleanRef $isLatestTick;
                        final /* synthetic */ CtpTdApi this$0;
                        final /* synthetic */ String $code;
                        {
                            this.$tick = $tick;
                            this.$isLatestTick = $isLatestTick;
                            this.this$0 = $receiver;
                            this.$code = $code;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.L$0 = var2_3 = this.$tick;
                                    this.label = 1;
                                    v0 = UtilsKt.runWithRetry$default((Function1)new Function1<Continuation<? super Tick>, Object>(this.this$0, this.$code, null){
                                        int label;
                                        final /* synthetic */ CtpTdApi this$0;
                                        final /* synthetic */ String $code;
                                        {
                                            this.this$0 = $receiver;
                                            this.$code = $code;
                                            super(1, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.label = 1;
                                                    Object object3 = CtpTdApi.queryLastTick$default(this.this$0, this.$code, false, null, (Continuation)this, 4, null);
                                                    if (object3 != object2) return object3;
                                                    return object2;
                                                }
                                                case 1: {
                                                    void $result;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object3 = $result;
                                                    return object3;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@Nullable Continuation<? super Tick> p1) {
                                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, null, (Continuation)this, 2, null);
                                    if (v0 == var4_2) {
                                        return var4_2;
                                    }
                                    ** GOTO lbl15
                                }
                                case 1: {
                                    var2_3 = (Ref.ObjectRef<Tick>)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl15:
                                    // 2 sources

                                    var3_4 = v0;
                                    var2_3.element = var3_4;
                                    this.$isLatestTick.element = true;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
                catch (Exception e) {
                    this.postBrokerEvent(BrokerEventType.TD_ERROR, "\u8ba1\u7b97\u4fdd\u8bc1\u91d1\u65f6\u67e5\u8be2\u5408\u7ea6\u6700\u65b0\u884c\u60c5\u5931\u8d25\uff1a" + code + ", " + e);
                }
            }
        }
        return new Pair(tick2.element, (Object)isLatestTick.element);
    }

    private final double calculateFuturesMargin(Security instrument2, Direction direction, int yesterdayVolume, int todayVolume, double avgOpenPrice, double fallback) {
        Pair<Tick, Boolean> pair = this.getOrQueryMarginRate(instrument2);
        if (pair == null) {
            return fallback;
        }
        Pair<Tick, Boolean> marginRate = pair;
        pair = this.getOrQueryTick(instrument2.getCode());
        Tick tick2 = (Tick)pair.component1();
        boolean isLatestTick = (Boolean)pair.component2();
        if (tick2 == null) {
            return fallback;
        }
        int settlementVolume = yesterdayVolume;
        double todayMargin = 0.0;
        if (todayVolume > 0) {
            if (this.futuresMarginPriceType == MarginPriceType.OPEN_PRICE) {
                todayMargin = CtpTdApi.calculateFuturesMargin$calculateMargin(direction, marginRate, instrument2, todayVolume, avgOpenPrice);
            } else if (isLatestTick) {
                MarginPriceType marginPriceType = this.futuresMarginPriceType;
                int n = WhenMappings.$EnumSwitchMapping$3[marginPriceType.ordinal()];
                switch (n) {
                    case 1: {
                        todayMargin = CtpTdApi.calculateFuturesMargin$calculateMargin(direction, marginRate, instrument2, todayVolume, tick2.getTodayAvgPrice());
                        break;
                    }
                    case 2: {
                        todayMargin = CtpTdApi.calculateFuturesMargin$calculateMargin(direction, marginRate, instrument2, todayVolume, tick2.getLastPrice());
                        break;
                    }
                    default: {
                        settlementVolume += todayVolume;
                        break;
                    }
                }
            } else {
                settlementVolume += todayVolume;
            }
        }
        double settlementMargin = CtpTdApi.calculateFuturesMargin$calculateMargin(direction, marginRate, instrument2, settlementVolume, tick2.getPreSettlementPrice());
        return todayMargin + settlementMargin;
    }

    private final double calculateOptionsMargin(Security instrument2, Direction direction, int volume, double avgOpenPrice, double fallback, boolean isOpen) {
        Direction direction2 = direction;
        int n = WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()];
        switch (n) {
            case 1: {
                return isOpen ? avgOpenPrice * (double)instrument2.getVolumeMultiple() : 0.0;
            }
            case 2: {
                double d;
                Pair<Tick, Boolean> pair = this.getOrQueryMarginRate(instrument2);
                if (pair == null) {
                    return fallback;
                }
                Pair<Tick, Boolean> marginRate = pair;
                if (this.optionsMarginPriceType == MarginPriceType.OPEN_PRICE && !isOpen) {
                    return CtpTdApi.calculateOptionsMargin$calculateMargin-117(volume, instrument2, marginRate, avgOpenPrice);
                }
                pair = this.getOrQueryTick(instrument2.getCode());
                Tick tick2 = (Tick)pair.component1();
                boolean isLatestTick = (Boolean)pair.component2();
                if (tick2 == null) {
                    return fallback;
                }
                if (isLatestTick) {
                    MarginPriceType marginPriceType = this.optionsMarginPriceType;
                    int n2 = WhenMappings.$EnumSwitchMapping$3[marginPriceType.ordinal()];
                    switch (n2) {
                        case 3: {
                            double d2 = tick2.getLastPrice();
                            double d3 = tick2.getPreSettlementPrice();
                            boolean bl = false;
                            d = Math.max(d2, d3);
                            break;
                        }
                        case 2: {
                            d = tick2.getLastPrice();
                            break;
                        }
                        default: {
                            d = tick2.getPreSettlementPrice();
                            break;
                        }
                    }
                } else {
                    d = tick2.getPreSettlementPrice();
                }
                double price = d;
                return CtpTdApi.calculateOptionsMargin$calculateMargin-117(volume, instrument2, marginRate, price);
            }
        }
        return fallback;
    }

    public final void calculatePosition(@NotNull Position position, boolean calculateValue, @Nullable Map<String, ? extends Object> extras) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Security security = this.instruments.get(position.getCode());
        if (security == null) {
            return;
        }
        Security instrument2 = security;
        if (instrument2.getType() == SecurityType.FUTURES || instrument2.getType() == SecurityType.OPTIONS) {
            SecurityType securityType;
            Tick lastTick;
            if (position.getVolume() != 0 && instrument2.getVolumeMultiple() != 0) {
                position.setAvgOpenPrice(position.getOpenCost() / (double)position.getVolume() / (double)instrument2.getVolumeMultiple());
            }
            if ((lastTick = this.getMdApi().getLastTicks().get(position.getCode())) != null) {
                position.setLastPrice(lastTick.getLastPrice());
                position.setPnl(position.getLastPrice() * (double)instrument2.getVolumeMultiple() * (double)position.getVolume() - position.getOpenCost());
                if (position.getDirection() == Direction.SHORT) {
                    securityType = position;
                    securityType.setPnl(securityType.getPnl() * (double)-1);
                }
            }
            if (calculateValue) {
                securityType = instrument2.getType();
                int n = WhenMappings.$EnumSwitchMapping$2[securityType.ordinal()];
                switch (n) {
                    case 1: {
                        position.setValue(this.calculateFuturesMargin(instrument2, position.getDirection(), position.getYesterdayVolume(), position.getTodayVolume(), position.getAvgOpenPrice(), position.getValue()));
                        break;
                    }
                    case 2: {
                        position.setValue(this.calculateOptionsMargin(instrument2, position.getDirection(), position.getVolume(), position.getAvgOpenPrice(), position.getValue(), false));
                        break;
                    }
                }
            }
        }
    }

    public static /* synthetic */ void calculatePosition$default(CtpTdApi ctpTdApi, Position position, boolean bl, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        ctpTdApi.calculatePosition(position, bl, map);
    }

    public final void calculateOrder(@NotNull Order order2, @Nullable Map<String, ? extends Object> extras) {
        Intrinsics.checkNotNullParameter((Object)order2, (String)"order");
        Security security = this.instruments.get(order2.getCode());
        if (security == null) {
            return;
        }
        Security instrument2 = security;
        if (instrument2.getType() == SecurityType.FUTURES || instrument2.getType() == SecurityType.OPTIONS) {
            CommissionRate com;
            if (order2.getFilledVolume() != 0 && instrument2.getVolumeMultiple() != 0) {
                order2.setAvgFillPrice(order2.getTurnover() / (double)order2.getFilledVolume() / (double)instrument2.getVolumeMultiple());
            }
            int restVolume = order2.getVolume() - order2.getFilledVolume();
            if (order2.getOffset() == OrderOffset.OPEN && restVolume > 0) {
                SecurityType securityType = instrument2.getType();
                int n = WhenMappings.$EnumSwitchMapping$2[securityType.ordinal()];
                switch (n) {
                    case 1: {
                        order2.setFrozenCash(this.calculateFuturesMargin(instrument2, order2.getDirection(), 0, restVolume, order2.getPrice(), 0.0));
                        break;
                    }
                    case 2: {
                        order2.setFrozenCash(this.calculateOptionsMargin(instrument2, order2.getDirection(), restVolume, order2.getPrice(), 0.0, true));
                    }
                }
            }
            if (StringsKt.startsWith$default((String)order2.getCode(), (String)"CFFEX", (boolean)false, (int)2, null) && instrument2.getType() == SecurityType.FUTURES && (com = this.getOrQueryCommissionRate(instrument2)) != null) {
                OrderStatus orderStatus = order2.getStatus();
                int n = WhenMappings.$EnumSwitchMapping$4[orderStatus.ordinal()];
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (UtilsKt.getInsertFeeCalculated(order2)) break;
                        Order order3 = order2;
                        order3.setCommission(order3.getCommission() + (com.getOrderInsertFeeByTrade() + com.getOrderInsertFeeByVolume() * (double)order2.getVolume()));
                        UtilsKt.setInsertFeeCalculated(order2, true);
                        break;
                    }
                    case 4: {
                        if (UtilsKt.getCancelFeeCalculated(order2)) break;
                        Order order4 = order2;
                        order4.setCommission(order4.getCommission() + (com.getOrderCancelFeeByTrade() + com.getOrderCancelFeeByVolume() * (double)order2.getVolume()));
                        UtilsKt.setCancelFeeCalculated(order2, true);
                    }
                }
            }
        }
    }

    public static /* synthetic */ void calculateOrder$default(CtpTdApi ctpTdApi, Order order2, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        ctpTdApi.calculateOrder(order2, map);
    }

    public final void calculateTrade(@NotNull Trade trade2, @Nullable Map<String, ? extends Object> extras) {
        Intrinsics.checkNotNullParameter((Object)trade2, (String)"trade");
        Security security = this.instruments.get(trade2.getCode());
        if (security == null) {
            return;
        }
        Security instrument2 = security;
        security = instrument2.getType();
        int n = WhenMappings.$EnumSwitchMapping$2[security.ordinal()];
        block0 : switch (n) {
            case 1: 
            case 2: {
                CommissionRate com;
                if (trade2.getTurnover() == 0.0) {
                    trade2.setTurnover((double)trade2.getVolume() * trade2.getPrice() * (double)instrument2.getVolumeMultiple());
                }
                if (!(trade2.getCommission() == 0.0) || (com = this.getOrQueryCommissionRate(instrument2)) == null) break;
                OrderOffset orderOffset = trade2.getOffset();
                int n2 = WhenMappings.$EnumSwitchMapping$5[orderOffset.ordinal()];
                switch (n2) {
                    case 1: {
                        trade2.setCommission(trade2.getTurnover() * com.getOpenRatioByMoney() + (double)trade2.getVolume() * com.getOpenRatioByVolume());
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        trade2.setCommission(trade2.getTurnover() * com.getCloseRatioByMoney() + (double)trade2.getVolume() * com.getCloseRatioByVolume());
                        break block0;
                    }
                    case 4: {
                        trade2.setCommission(trade2.getTurnover() * com.getCloseTodayRatioByMoney() + (double)trade2.getVolume() * com.getCloseTodayRatioByVolume());
                    }
                }
            }
        }
    }

    public static /* synthetic */ void calculateTrade$default(CtpTdApi ctpTdApi, Trade trade2, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        ctpTdApi.calculateTrade(trade2, map);
    }

    private static final void prepareFeeCalculation$handleException(boolean $throwException, CtpTdApi this$0, String $code, Exception e, String msg) {
        if ($throwException) {
            throw e;
        }
        this$0.postBrokerEvent(BrokerEventType.TD_ERROR, "\u67e5\u8be2\u671f\u8d27\u624b\u7eed\u8d39\u7387\u51fa\u9519\uff1a" + $code + ", " + e);
    }

    private static final double calculateFuturesMargin$calculateMargin(Direction $direction, MarginRate marginRate, Security $instrument, int volume, double price) {
        double d;
        Direction direction = $direction;
        int n = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
        switch (n) {
            case 1: {
                d = (double)volume * marginRate.getLongMarginRatioByVolume() + (double)(volume * $instrument.getVolumeMultiple()) * price * marginRate.getLongMarginRatioByMoney();
                break;
            }
            case 2: {
                d = (double)volume * marginRate.getShortMarginRatioByVolume() + (double)(volume * $instrument.getVolumeMultiple()) * price * marginRate.getShortMarginRatioByMoney();
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    private static final double calculateOptionsMargin$calculateMargin-117(int $volume, Security $instrument, MarginRate marginRate, double price) {
        double d = marginRate.getLongMarginRatioByMoney();
        double d2 = marginRate.getShortMarginRatioByMoney();
        boolean bl = false;
        return (double)$volume * (price * (double)$instrument.getVolumeMultiple() + Math.max(d, d2));
    }

    public static final /* synthetic */ Object access$queryMarginPriceType(CtpTdApi $this, Continuation $completion) {
        return $this.queryMarginPriceType((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$queryFuturesMarginRate(CtpTdApi $this, String code, Continuation $completion) {
        return $this.queryFuturesMarginRate(code, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$queryOptionsMargin(CtpTdApi $this, String code, Continuation $completion) {
        return $this.queryOptionsMargin(code, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$queryFuturesCommissionRate(CtpTdApi $this, String code, Continuation $completion) {
        return $this.queryFuturesCommissionRate(code, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$queryFuturesOrderCommissionRate(CtpTdApi $this, String code, Continuation $completion) {
        return $this.queryFuturesOrderCommissionRate(code, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$queryOptionsCommissionRate(CtpTdApi $this, String code, Continuation $completion) {
        return $this.queryOptionsCommissionRate(code, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$prepareFeeCalculation(CtpTdApi $this, String code, boolean throwException, Continuation $completion) {
        return $this.prepareFeeCalculation(code, throwException, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$prepareFeeCalculation$handleException(boolean $throwException, CtpTdApi this$0, String $code, Exception e, String msg) {
        CtpTdApi.prepareFeeCalculation$handleException($throwException, this$0, $code, e, msg);
    }

    public static final /* synthetic */ int access$nextRequestId(CtpTdApi $this) {
        return $this.nextRequestId();
    }

    public static final /* synthetic */ CThostFtdcTraderApi access$getTdApi$p(CtpTdApi $this) {
        return $this.tdApi;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010#\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010&\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010)\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010,\u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010-2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010.\u001a\u00020\u00042\b\u0010/\u001a\u0004\u0018\u0001002\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u00101\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u0001032\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u00104\u001a\u00020\u00042\b\u00105\u001a\u0004\u0018\u0001062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u00107\u001a\u00020\u00042\b\u00108\u001a\u0004\u0018\u0001092\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010:\u001a\u00020\u00042\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010=\u001a\u00020\u00042\b\u0010>\u001a\u0004\u0018\u00010?2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010D\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0016J\u0011\u0010E\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0011\u0010G\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0011\u0010H\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010F\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006I"}, d2={"Lorg/rationalityfrontline/ktrader/broker/ctp/CtpTdApi$CtpTdSpi;", "Lorg/rationalityfrontline/jctp/CThostFtdcTraderSpi;", "(Lorg/rationalityfrontline/ktrader/broker/ctp/CtpTdApi;)V", "OnFrontConnected", "", "OnFrontDisconnected", "nReason", "", "OnRspAuthenticate", "pRspAuthenticateField", "Lorg/rationalityfrontline/jctp/CThostFtdcRspAuthenticateField;", "pRspInfo", "Lorg/rationalityfrontline/jctp/CThostFtdcRspInfoField;", "nRequestID", "bIsLast", "", "OnRspError", "OnRspOrderAction", "pInputOrderAction", "Lorg/rationalityfrontline/jctp/CThostFtdcInputOrderActionField;", "OnRspOrderInsert", "pInputOrder", "Lorg/rationalityfrontline/jctp/CThostFtdcInputOrderField;", "OnRspQryBrokerTradingParams", "pBrokerTradingParams", "Lorg/rationalityfrontline/jctp/CThostFtdcBrokerTradingParamsField;", "OnRspQryDepthMarketData", "pDepthMarketData", "Lorg/rationalityfrontline/jctp/CThostFtdcDepthMarketDataField;", "OnRspQryInstrument", "pInstrument", "Lorg/rationalityfrontline/jctp/CThostFtdcInstrumentField;", "OnRspQryInstrumentCommissionRate", "pCommissionRate", "Lorg/rationalityfrontline/jctp/CThostFtdcInstrumentCommissionRateField;", "OnRspQryInstrumentMarginRate", "pMarginRate", "Lorg/rationalityfrontline/jctp/CThostFtdcInstrumentMarginRateField;", "OnRspQryInstrumentOrderCommRate", "pOrderCommRate", "Lorg/rationalityfrontline/jctp/CThostFtdcInstrumentOrderCommRateField;", "OnRspQryInvestorPosition", "pInvestorPosition", "Lorg/rationalityfrontline/jctp/CThostFtdcInvestorPositionField;", "OnRspQryOptionInstrCommRate", "Lorg/rationalityfrontline/jctp/CThostFtdcOptionInstrCommRateField;", "OnRspQryOptionInstrTradeCost", "pOptionMargin", "Lorg/rationalityfrontline/jctp/CThostFtdcOptionInstrTradeCostField;", "OnRspQryOrder", "pOrder", "Lorg/rationalityfrontline/jctp/CThostFtdcOrderField;", "OnRspQryTrade", "pTrade", "Lorg/rationalityfrontline/jctp/CThostFtdcTradeField;", "OnRspQryTradingAccount", "pTradingAccount", "Lorg/rationalityfrontline/jctp/CThostFtdcTradingAccountField;", "OnRspSettlementInfoConfirm", "pSettlementInfoConfirm", "Lorg/rationalityfrontline/jctp/CThostFtdcSettlementInfoConfirmField;", "OnRspUserLogin", "pRspUserLogin", "Lorg/rationalityfrontline/jctp/CThostFtdcRspUserLoginField;", "OnRtnInstrumentStatus", "pInstrumentStatus", "Lorg/rationalityfrontline/jctp/CThostFtdcInstrumentStatusField;", "OnRtnOrder", "OnRtnTrade", "reqAuthenticate", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reqSettlementInfoConfirm", "reqUserLogin", "lib"})
    private final class CtpTdSpi
    extends CThostFtdcTraderSpi {
        public CtpTdSpi() {
            Intrinsics.checkNotNullParameter((Object)CtpTdApi.this, (String)"this$0");
        }

        /*
         * Unable to fully structure code
         */
        private final Object reqAuthenticate(Continuation<? super Unit> var1_1) {
            block12: {
                block11: {
                    if (!(var1_1 instanceof reqAuthenticate.1)) ** GOTO lbl-1000
                    var23_2 = var1_1;
                    if ((var23_2.label & -2147483648) != 0) {
                        var23_2.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var1_1){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            int I$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ CtpTdSpi this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return CtpTdSpi.access$reqAuthenticate(this.this$0, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var24_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var3_5 = new CThostFtdcReqAuthenticateField();
                            var4_8 = CtpTdApi.this;
                            var5_9 = false;
                            var6_10 = false;
                            $this$reqAuthenticate_u24lambda_u2d0 = var3_5;
                            $i$a$-apply-CtpTdApi$CtpTdSpi$reqAuthenticate$reqField$1 = false;
                            $this$reqAuthenticate_u24lambda_u2d0.setAppID(var4_8.getConfig().getAppId());
                            $this$reqAuthenticate_u24lambda_u2d0.setAuthCode(var4_8.getConfig().getAuthCode());
                            $this$reqAuthenticate_u24lambda_u2d0.setUserProductInfo(var4_8.getConfig().getUserProductInfo());
                            $this$reqAuthenticate_u24lambda_u2d0.setUserID(var4_8.getConfig().getInvestorId());
                            $this$reqAuthenticate_u24lambda_u2d0.setBrokerID(var4_8.getConfig().getBrokerId());
                            reqField = var3_5;
                            requestId = CtpTdApi.access$nextRequestId(CtpTdApi.this);
                            var6_11 = CtpTdApi.this;
                            var7_12 = CtpTdApi.this;
                            retry$iv = true;
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqAuthenticate$2 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)CtpTdApi.access$getTdApi$p(var6_11).ReqAuthenticate(reqField, requestId))).intValue();
lbl33:
                            // 2 sources

                            while (resultCode$iv == -2 || resultCode$iv == -3) {
                                $continuation.L$0 = reqField;
                                $continuation.L$1 = var6_11;
                                $continuation.L$2 = var7_12;
                                $continuation.I$0 = requestId;
                                $continuation.label = 1;
                                v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                                if (v0 == var24_4) {
                                    return var24_4;
                                }
                                ** GOTO lbl52
                            }
                            break;
                        }
                        case 1: {
                            $i$f$runWithResultCheck = false;
                            var3_6 = $continuation.I$0;
                            var7_12 = (CtpTdApi)$continuation.L$2;
                            var6_11 = (CtpTdApi)$continuation.L$1;
                            var2_16 = (CThostFtdcReqAuthenticateField)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl52:
                            // 2 sources

                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqAuthenticate$2 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)CtpTdApi.access$getTdApi$p(var6_11).ReqAuthenticate(var2_16, var3_6))).intValue();
                            ** GOTO lbl33
                        }
                    }
                    if (resultCode$iv != 0) break block11;
                    $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqAuthenticate$3 = false;
                    var11_20 = $continuation;
                    var12_23 = false;
                    var13_24 = false;
                    $continuation.L$0 = var7_12;
                    $continuation.L$1 = var11_20;
                    $continuation.L$2 = null;
                    $continuation.I$0 = var3_6;
                    $continuation.label = 2;
                    var13_25 = var11_20;
                    var14_26 = false;
                    var15_27 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_25));
                    continuation = (Continuation)var15_27;
                    $i$a$-suspendCoroutine-CtpTdApi$CtpTdSpi$reqAuthenticate$3$1 = false;
                    var18_30 = CtpTdApi.access$getRequestMap$p(var7_12);
                    var19_31 = Boxing.boxInt((int)var3_6);
                    var20_32 = new RequestContinuation(var3_6, continuation, null, null, 12, null);
                    var21_33 = false;
                    var18_30.put(var19_31, var20_32);
                    v1 = var15_27.getOrThrow();
                    if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)var11_20);
                    }
                    v2 = v1;
                    if (v1 == var24_4) {
                        return var24_4;
                    }
                    break block12;
                    {
                        case 2: {
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqAuthenticate$3 = false;
                            var3_7 = $continuation.I$0;
                            var11_21 = $continuation.L$1;
                            var7_13 = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break block12;
                        }
                    }
                }
                var11_22 = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object reqUserLogin(Continuation<? super Unit> var1_1) {
            block12: {
                block11: {
                    if (!(var1_1 instanceof reqUserLogin.1)) ** GOTO lbl-1000
                    var23_2 = var1_1;
                    if ((var23_2.label & -2147483648) != 0) {
                        var23_2.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var1_1){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            int I$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ CtpTdSpi this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return CtpTdSpi.access$reqUserLogin(this.this$0, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var24_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var3_5 = new CThostFtdcReqUserLoginField();
                            var4_8 = CtpTdApi.this;
                            var5_9 = false;
                            var6_10 = false;
                            $this$reqUserLogin_u24lambda_u2d4 = var3_5;
                            $i$a$-apply-CtpTdApi$CtpTdSpi$reqUserLogin$reqField$1 = false;
                            $this$reqUserLogin_u24lambda_u2d4.setUserID(var4_8.getConfig().getInvestorId());
                            $this$reqUserLogin_u24lambda_u2d4.setPassword(var4_8.getConfig().getPassword());
                            $this$reqUserLogin_u24lambda_u2d4.setBrokerID(var4_8.getConfig().getBrokerId());
                            $this$reqUserLogin_u24lambda_u2d4.setUserProductInfo(var4_8.getConfig().getUserProductInfo());
                            reqField = var3_5;
                            requestId = CtpTdApi.access$nextRequestId(CtpTdApi.this);
                            var6_11 = CtpTdApi.this;
                            var7_12 = CtpTdApi.this;
                            retry$iv = true;
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqUserLogin$2 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)CtpTdApi.access$getTdApi$p(var6_11).ReqUserLogin(reqField, requestId))).intValue();
lbl32:
                            // 2 sources

                            while (resultCode$iv == -2 || resultCode$iv == -3) {
                                $continuation.L$0 = reqField;
                                $continuation.L$1 = var6_11;
                                $continuation.L$2 = var7_12;
                                $continuation.I$0 = requestId;
                                $continuation.label = 1;
                                v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                                if (v0 == var24_4) {
                                    return var24_4;
                                }
                                ** GOTO lbl51
                            }
                            break;
                        }
                        case 1: {
                            $i$f$runWithResultCheck = false;
                            var3_6 = $continuation.I$0;
                            var7_12 = (CtpTdApi)$continuation.L$2;
                            var6_11 = (CtpTdApi)$continuation.L$1;
                            var2_16 = (CThostFtdcReqUserLoginField)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl51:
                            // 2 sources

                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqUserLogin$2 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)CtpTdApi.access$getTdApi$p(var6_11).ReqUserLogin(var2_16, var3_6))).intValue();
                            ** GOTO lbl32
                        }
                    }
                    if (resultCode$iv != 0) break block11;
                    $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqUserLogin$3 = false;
                    var11_20 = $continuation;
                    var12_23 = false;
                    var13_24 = false;
                    $continuation.L$0 = var7_12;
                    $continuation.L$1 = var11_20;
                    $continuation.L$2 = null;
                    $continuation.I$0 = var3_6;
                    $continuation.label = 2;
                    var13_25 = var11_20;
                    var14_26 = false;
                    var15_27 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_25));
                    continuation = (Continuation)var15_27;
                    $i$a$-suspendCoroutine-CtpTdApi$CtpTdSpi$reqUserLogin$3$1 = false;
                    var18_30 = CtpTdApi.access$getRequestMap$p(var7_12);
                    var19_31 = Boxing.boxInt((int)var3_6);
                    var20_32 = new RequestContinuation(var3_6, continuation, null, null, 12, null);
                    var21_33 = false;
                    var18_30.put(var19_31, var20_32);
                    v1 = var15_27.getOrThrow();
                    if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)var11_20);
                    }
                    v2 = v1;
                    if (v1 == var24_4) {
                        return var24_4;
                    }
                    break block12;
                    {
                        case 2: {
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqUserLogin$3 = false;
                            var3_7 = $continuation.I$0;
                            var11_21 = $continuation.L$1;
                            var7_13 = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break block12;
                        }
                    }
                }
                var11_22 = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object reqSettlementInfoConfirm(Continuation<? super Unit> var1_1) {
            block12: {
                block11: {
                    if (!(var1_1 instanceof reqSettlementInfoConfirm.1)) ** GOTO lbl-1000
                    var23_2 = var1_1;
                    if ((var23_2.label & -2147483648) != 0) {
                        var23_2.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var1_1){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            int I$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ CtpTdSpi this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return CtpTdSpi.access$reqSettlementInfoConfirm(this.this$0, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var24_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var3_5 = new CThostFtdcSettlementInfoConfirmField();
                            var4_8 = CtpTdApi.this;
                            var5_9 = false;
                            var6_10 = false;
                            $this$reqSettlementInfoConfirm_u24lambda_u2d8 = var3_5;
                            $i$a$-apply-CtpTdApi$CtpTdSpi$reqSettlementInfoConfirm$reqField$1 = false;
                            $this$reqSettlementInfoConfirm_u24lambda_u2d8.setInvestorID(var4_8.getConfig().getInvestorId());
                            $this$reqSettlementInfoConfirm_u24lambda_u2d8.setBrokerID(var4_8.getConfig().getBrokerId());
                            reqField = var3_5;
                            requestId = CtpTdApi.access$nextRequestId(CtpTdApi.this);
                            var6_11 = CtpTdApi.this;
                            var7_12 = CtpTdApi.this;
                            retry$iv = true;
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqSettlementInfoConfirm$2 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)CtpTdApi.access$getTdApi$p(var6_11).ReqSettlementInfoConfirm(reqField, requestId))).intValue();
lbl30:
                            // 2 sources

                            while (resultCode$iv == -2 || resultCode$iv == -3) {
                                $continuation.L$0 = reqField;
                                $continuation.L$1 = var6_11;
                                $continuation.L$2 = var7_12;
                                $continuation.I$0 = requestId;
                                $continuation.label = 1;
                                v0 = DelayKt.delay((long)10L, (Continuation)$continuation);
                                if (v0 == var24_4) {
                                    return var24_4;
                                }
                                ** GOTO lbl49
                            }
                            break;
                        }
                        case 1: {
                            $i$f$runWithResultCheck = false;
                            var3_6 = $continuation.I$0;
                            var7_12 = (CtpTdApi)$continuation.L$2;
                            var6_11 = (CtpTdApi)$continuation.L$1;
                            var2_16 = (CThostFtdcSettlementInfoConfirmField)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl49:
                            // 2 sources

                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqSettlementInfoConfirm$2 = false;
                            resultCode$iv = ((Number)Boxing.boxInt((int)CtpTdApi.access$getTdApi$p(var6_11).ReqSettlementInfoConfirm(var2_16, var3_6))).intValue();
                            ** GOTO lbl30
                        }
                    }
                    if (resultCode$iv != 0) break block11;
                    $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqSettlementInfoConfirm$3 = false;
                    var11_20 = $continuation;
                    var12_23 = false;
                    var13_24 = false;
                    $continuation.L$0 = var7_12;
                    $continuation.L$1 = var11_20;
                    $continuation.L$2 = null;
                    $continuation.I$0 = var3_6;
                    $continuation.label = 2;
                    var13_25 = var11_20;
                    var14_26 = false;
                    var15_27 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var13_25));
                    continuation = (Continuation)var15_27;
                    $i$a$-suspendCoroutine-CtpTdApi$CtpTdSpi$reqSettlementInfoConfirm$3$1 = false;
                    var18_30 = CtpTdApi.access$getRequestMap$p(var7_12);
                    var19_31 = Boxing.boxInt((int)var3_6);
                    var20_32 = new RequestContinuation(var3_6, continuation, null, null, 12, null);
                    var21_33 = false;
                    var18_30.put(var19_31, var20_32);
                    v1 = var15_27.getOrThrow();
                    if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)var11_20);
                    }
                    v2 = v1;
                    if (v1 == var24_4) {
                        return var24_4;
                    }
                    break block12;
                    {
                        case 2: {
                            $i$f$runWithResultCheck = false;
                            $i$a$-runWithResultCheck$default-CtpTdApi$CtpTdSpi$reqSettlementInfoConfirm$3 = false;
                            var3_7 = $continuation.I$0;
                            var11_21 = $continuation.L$1;
                            var7_13 = (CtpTdApi)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break block12;
                        }
                    }
                }
                var11_22 = UtilsKt.getErrorInfo(resultCode$iv);
                code = ((Number)Boxing.boxInt((int)resultCode$iv)).intValue();
                throw new Exception((String)info + " (" + code + ')');
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public void OnRtnInstrumentStatus(@NotNull CThostFtdcInstrumentStatusField pInstrumentStatus) {
            Intrinsics.checkNotNullParameter((Object)pInstrumentStatus, (String)"pInstrumentStatus");
            char c = pInstrumentStatus.getInstrumentStatus();
            MarketStatus marketStatus = c == jctpConstants.THOST_FTDC_IS_AuctionOrdering ? MarketStatus.AUCTION_ORDERING : (c == jctpConstants.THOST_FTDC_IS_AuctionMatch ? MarketStatus.AUCTION_MATCHED : ((c == jctpConstants.THOST_FTDC_IS_NoTrading ? true : c == jctpConstants.THOST_FTDC_IS_BeforeTrading) ? MarketStatus.STOP_TRADING : (c == jctpConstants.THOST_FTDC_IS_Continous ? MarketStatus.CONTINUOUS_MATCHING : (c == jctpConstants.THOST_FTDC_IS_Closed ? MarketStatus.CLOSED : MarketStatus.UNKNOWN))));
            Map map = CtpTdApi.this.productStatusMap;
            String string = pInstrumentStatus.getInstrumentID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pInstrumentStatus.instrumentID");
            boolean bl = false;
            map.put(string, marketStatus);
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspError(@NotNull CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Intrinsics.checkNotNullParameter((Object)pRspInfo, (String)"pRspInfo");
            RequestContinuation request = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (request == null) {
                void $this$filterTo$iv$iv;
                String errorInfo = pRspInfo.getErrorMsg() + ", requestId=" + nRequestID + ", isLast=" + bIsLast;
                Collection collection = CtpTdApi.this.requestMap.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"requestMap.values");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    RequestContinuation it = (RequestContinuation)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTag(), (Object)"connect")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List connectRequests = (List)destination$iv$iv;
                if (connectRequests.isEmpty()) {
                    CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_ERROR, errorInfo);
                } else {
                    CtpTdApi.resumeRequestsWithException$default(CtpTdApi.this, "connect", errorInfo, null, 4, null);
                }
            } else {
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception(pRspInfo.getErrorMsg());
                boolean bl = false;
                Result.Companion companion = Result.Companion;
                boolean bl2 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                CtpTdApi.this.requestMap.remove(nRequestID);
            }
        }

        public void OnFrontConnected() {
            CtpTdApi.this.requestId.set(0);
            CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_NET_CONNECTED, Unit.INSTANCE);
            BuildersKt.launch$default((CoroutineScope)CtpTdApi.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, CtpTdApi.this, null){
                int label;
                final /* synthetic */ CtpTdSpi this$0;
                final /* synthetic */ CtpTdApi this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = CtpTdSpi.access$reqAuthenticate(this.this$0, (Continuation)this);
                            ** if (v0 != var8_2) goto lbl11
lbl10:
                            // 1 sources

                            return var8_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl21
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                            }
                            catch (Exception e) {
                                CtpTdApi.resumeRequestsWithException$default(this.this$1, "connect", Intrinsics.stringPlus((String)"\u8bf7\u6c42\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                            }
lbl21:
                            // 4 sources

                            this.label = 2;
                            v1 = CtpTdSpi.access$reqUserLogin(this.this$0, (Continuation)this);
                            ** if (v1 != var8_2) goto lbl26
lbl25:
                            // 1 sources

                            return var8_2;
lbl26:
                            // 1 sources

                            ** GOTO lbl36
                        }
                        case 2: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                            }
                            catch (Exception e) {
                                CtpTdApi.resumeRequestsWithException$default(this.this$1, "connect", Intrinsics.stringPlus((String)"\u8bf7\u6c42\u7528\u6237\u767b\u5f55\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                            }
lbl36:
                            // 4 sources

                            this.label = 3;
                            v2 = CtpTdSpi.access$reqSettlementInfoConfirm(this.this$0, (Continuation)this);
                            ** if (v2 != var8_2) goto lbl41
lbl40:
                            // 1 sources

                            return var8_2;
lbl41:
                            // 1 sources

                            ** GOTO lbl50
                        }
                        case 3: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
                            }
                            catch (Exception e) {
                                CtpTdApi.resumeRequestsWithException$default(this.this$1, "connect", Intrinsics.stringPlus((String)"\u8bf7\u6c42\u7ed3\u7b97\u5355\u786e\u8ba4\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                            }
lbl50:
                            // 3 sources

                            this.label = 4;
                            v3 = UtilsKt.runWithRetry((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$1, null){
                                int label;
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = this.this$0.queryAllInstruments(false, null, (Continuation<? super List<Security>>)((Continuation)this));
                                            if (v0 == var14_2) {
                                                return var14_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            allInstruments = (List)v0;
                                            var3_4 = allInstruments;
                                            var4_5 = this.this$0;
                                            $i$f$forEach = false;
                                            for (T element$iv : $this$forEach$iv) {
                                                it = (Security)element$iv;
                                                $i$a$-forEach-CtpTdApi$CtpTdSpi$OnFrontConnected$1$1$1 = false;
                                                var10_11 = var4_5.getInstruments();
                                                var11_12 = it.getCode();
                                                var12_14 = false;
                                                var10_11.put((String)var11_12, (String)it);
                                                var10_11 = CtpTdApi.access$getCodeProductMap$p(var4_5);
                                                var11_12 = it.getCode();
                                                var12_13 = it.getProductId();
                                                var13_15 = false;
                                                var10_11.put((String)var11_12, var12_13);
                                                var10_11 = var4_5.getMdApi().getCodeMap();
                                                var11_12 = new char[1];
                                                var11_12[0] = 46;
                                                var11_12 = StringsKt.split$default((CharSequence)it.getCode(), (char[])var11_12, (boolean)false, (int)2, (int)2, null).get(1);
                                                var12_13 = it.getCode();
                                                var13_15 = false;
                                                var10_11.put((String)var11_12, var12_13);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Function1)new Function1<Exception, Unit>(this.this$1){
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Exception e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    CtpTdApi.resumeRequestsWithException$default(this.this$0, "connect", Intrinsics.stringPlus((String)"\u67e5\u8be2\u5168\u5e02\u573a\u5408\u7ea6\u4fe1\u606f\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                                }
                            }, (Continuation)this);
                            if (v3 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl58
                        }
                        case 4: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl58:
                            // 2 sources

                            if (this.this$1.getConfig().getDisableFeeCalculation()) ** GOTO lbl82
                            this.label = 5;
                            v4 = UtilsKt.runWithRetry((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$1, null){
                                int label;
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = CtpTdApi.access$queryMarginPriceType(this.this$0, (Continuation)this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Function1)new Function1<Exception, Unit>(this.this$1){
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Exception e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    CtpTdApi.resumeRequestsWithException$default(this.this$0, "connect", Intrinsics.stringPlus((String)"\u67e5\u8be2\u4fdd\u8bc1\u91d1\u4ef7\u683c\u7c7b\u578b\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                                }
                            }, (Continuation)this);
                            if (v4 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl68
                        }
                        case 5: {
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl68:
                            // 3 sources

                            this.label = 6;
                            v5 = CtpTdApi.prepareFeeCalculation$default(this.this$1, null, null, (Continuation)this, 3, null);
                            ** if (v5 != var8_2) goto lbl73
lbl72:
                            // 1 sources

                            return var8_2;
lbl73:
                            // 1 sources

                            ** GOTO lbl82
                        }
                        case 6: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                            }
                            catch (Exception e) {
                                CtpTdApi.resumeRequestsWithException$default(this.this$1, "connect", Intrinsics.stringPlus((String)"\u67e5\u8be2\u624b\u7eed\u8d39\u7387\u53ca\u4fdd\u8bc1\u91d1\u7387\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                            }
lbl82:
                            // 4 sources

                            this.label = 7;
                            v6 = UtilsKt.runWithRetry((Function1)new Function1<Continuation<? super Object>, Object>(this.this$1, null){
                                int label;
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = CtpTdApi.queryPositions$default(this.this$0, null, false, null, (Continuation)this, 5, null);
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@Nullable Continuation<Object> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Function1)new Function1<Exception, Unit>(this.this$1){
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Exception e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    CtpTdApi.resumeRequestsWithException$default(this.this$0, "connect", Intrinsics.stringPlus((String)"\u67e5\u8be2\u8d26\u6237\u6301\u4ed3\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                                }
                            }, (Continuation)this);
                            if (v6 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl90
                        }
                        case 7: {
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl90:
                            // 2 sources

                            this.label = 8;
                            v7 = UtilsKt.runWithRetry((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$1, null){
                                int label;
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = CtpTdApi.queryOrders$default(this.this$0, null, false, false, null, (Continuation)this, 9, null);
                                            if (v0 == var15_2) {
                                                return var15_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            orders = (List)v0;
                                            var4_4 /* !! */  = new OrderStatus[]{OrderStatus.CANCELED, OrderStatus.FILLED, OrderStatus.ERROR};
                                            finishedStatus = SetsKt.setOf((Object[])var4_4 /* !! */ );
                                            var4_4 /* !! */  = orders;
                                            var5_6 = this.this$0;
                                            $i$f$forEach = false;
                                            for (T element$iv : $this$forEach$iv) {
                                                it = (Order)element$iv;
                                                $i$a$-forEach-CtpTdApi$CtpTdSpi$OnFrontConnected$1$7$1 = false;
                                                var11_12 = CtpTdApi.access$getTodayOrders$p(var5_6);
                                                var12_13 = it.getOrderId();
                                                var13_15 = false;
                                                var11_12.put(var12_13, it);
                                                if (!finishedStatus.contains(it.getStatus())) {
                                                    var11_12 = it.getDirection();
                                                    var12_14 = OnFrontConnected.WhenMappings.$EnumSwitchMapping$0[var11_12.ordinal()];
                                                    switch (var12_14) {
                                                        case 1: {
                                                            UtilsKt.insert(CtpTdApi.access$getUnfinishedLongOrders$p(var5_6), it);
                                                            break;
                                                        }
                                                        case 2: {
                                                            UtilsKt.insert(CtpTdApi.access$getUnfinishedShortOrders$p(var5_6), it);
                                                        }
                                                    }
                                                }
                                                if (it.getStatus() != OrderStatus.CANCELED) continue;
                                                var11_12 = CtpTdApi.access$getCancelStatistics$p(var5_6);
                                                var12_13 = it.getCode();
                                                var13_16 = Boxing.boxInt((int)(((Number)CtpTdApi.access$getCancelStatistics$p(var5_6).getOrDefault(it.getCode(), Boxing.boxInt((int)0))).intValue() + 1));
                                                var14_17 = false;
                                                var11_12.put(var12_13, var13_16);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Function1)new Function1<Exception, Unit>(this.this$1){
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Exception e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    CtpTdApi.resumeRequestsWithException$default(this.this$0, "connect", Intrinsics.stringPlus((String)"\u67e5\u8be2\u5f53\u65e5\u8ba2\u5355\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                                }
                            }, (Continuation)this);
                            if (v7 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl98
                        }
                        case 8: {
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl98:
                            // 2 sources

                            this.label = 9;
                            v8 = UtilsKt.runWithRetry((Function1)new Function1<Continuation<? super Object>, Object>(this.this$1, null){
                                int label;
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = CtpTdApi.queryTrades$default(this.this$0, null, null, false, null, (Continuation)this, 11, null);
                                            if (v0 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            trades = (List)v0;
                                            return Boxing.boxBoolean((boolean)CtpTdApi.access$getTodayTrades$p(this.this$0).addAll(trades));
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@Nullable Continuation<Object> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Function1)new Function1<Exception, Unit>(this.this$1){
                                final /* synthetic */ CtpTdApi this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Exception e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    CtpTdApi.resumeRequestsWithException$default(this.this$0, "connect", Intrinsics.stringPlus((String)"\u67e5\u8be2\u5f53\u65e5\u6210\u4ea4\u8bb0\u5f55\u5931\u8d25\uff1a", (Object)e), null, 4, null);
                                }
                            }, (Continuation)this);
                            if (v8 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl106
                        }
                        case 9: {
                            ResultKt.throwOnFailure((Object)$result);
                            v8 = $result;
lbl106:
                            // 2 sources

                            if (this.this$1.getMdApi().getConnected() && !this.this$1.getConfig().getDisableAutoSubscribe()) {
                                this.label = 10;
                                v9 = CtpMdApi.subscribeMarketData$default(this.this$1.getMdApi(), CtpTdApi.access$getPositions$p(this.this$1).keySet(), null, (Continuation)this, 2, null);
                                if (v9 == var8_2) {
                                    return var8_2;
                                }
                            }
                            ** GOTO lbl115
                        }
                        case 10: {
                            ResultKt.throwOnFailure((Object)$result);
                            v9 = $result;
lbl115:
                            // 2 sources

                            e = CtpTdApi.access$getRequestMap$p(this.this$1).values();
                            Intrinsics.checkNotNullExpressionValue(e, (String)"requestMap.values");
                            $this$any$iv = e;
                            $i$f$any = false;
                            if (!((Collection)$this$any$iv).isEmpty()) ** GOTO lbl122
                            v10 = false;
                            ** GOTO lbl129
lbl122:
                            // 2 sources

                            for (T element$iv : $this$any$iv) {
                                it = (RequestContinuation)element$iv;
                                $i$a$-any-CtpTdApi$CtpTdSpi$OnFrontConnected$1$11 = false;
                                if (!Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)it.getTag(), (Object)"connect")).booleanValue()) continue;
                                v10 = true;
                                ** GOTO lbl129
                            }
                            v10 = false;
lbl129:
                            // 3 sources

                            if (v10) {
                                CtpTdApi.access$setConnected$p(this.this$1, true);
                                CtpTdApi.access$postBrokerEvent(this.this$1, BrokerEventType.TD_USER_LOGGED_IN, Unit.INSTANCE);
                                CtpTdApi.resumeRequests$default(this.this$1, "connect", Unit.INSTANCE, null, 4, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public void OnFrontDisconnected(int nReason) {
            CtpTdApi.this.connected = false;
            CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_NET_DISCONNECTED, UtilsKt.getDisconnectReason(nReason) + " (" + nReason + ')');
            Exception e = new Exception("\u7f51\u7edc\u8fde\u63a5\u65ad\u5f00\uff1a" + UtilsKt.getDisconnectReason(nReason) + " (" + nReason + ')');
            Collection collection = CtpTdApi.this.requestMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"requestMap.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RequestContinuation it = (RequestContinuation)element$iv;
                boolean bl = false;
                Continuation<?> continuation = it.getContinuation();
                boolean bl2 = false;
                Result.Companion companion = Result.Companion;
                boolean bl3 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
            }
            CtpTdApi.this.requestMap.clear();
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspAuthenticate(@Nullable CThostFtdcRspAuthenticateField pRspAuthenticateField, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
                if (bIsLast) {
                    Continuation<?> continuation = request.getContinuation();
                    Unit unit = Unit.INSTANCE;
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)unit));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String string2 = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl4 = false;
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspUserLogin(@Nullable CThostFtdcRspUserLoginField pRspUserLogin, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl;
                Assets assets;
                List lines;
                boolean bl2 = false;
                if (pRspUserLogin == null) {
                    Continuation<?> continuation = request.getContinuation();
                    Throwable throwable = new Exception("pRspUserLogin \u4e3a null");
                    boolean bl3 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    return;
                }
                ((CtpTdApi)object2).frontId = pRspUserLogin.getFrontID();
                ((CtpTdApi)object2).sessionId = pRspUserLogin.getSessionID();
                String string = pRspUserLogin.getTradingDay();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspUserLogin.tradingDay");
                ((CtpTdApi)object2).tradingDay = string;
                String lastTradingDay = "";
                int lastMaxOrderRef = 10000;
                if (((CtpTdApi)object2).cacheFile.exists() && (lines = FilesKt.readLines$default((File)((CtpTdApi)object2).cacheFile, null, (int)1, null)).size() >= 2) {
                    lastTradingDay = (String)lines.get(0);
                    Integer n = StringsKt.toIntOrNull((String)((String)lines.get(1)));
                    int n2 = lastMaxOrderRef = n == null ? lastMaxOrderRef : n;
                }
                if (Intrinsics.areEqual((Object)lastTradingDay, (Object)((CtpTdApi)object2).tradingDay)) {
                    ((CtpTdApi)object2).orderRef.set(lastMaxOrderRef);
                } else {
                    ((CtpTdApi)object2).orderRef.set(10000);
                    ((CtpTdApi)object2).todayOrders.clear();
                    ((CtpTdApi)object2).todayTrades.clear();
                    ((CtpTdApi)object2).unfinishedLongOrders.clear();
                    ((CtpTdApi)object2).unfinishedShortOrders.clear();
                    ((CtpTdApi)object2).cancelStatistics.clear();
                    ((CtpTdApi)object2).getInstruments().clear();
                    ((CtpTdApi)object2).codeProductMap.clear();
                    ((CtpTdApi)object2).cachedTickMap.clear();
                    ((CtpTdApi)object2).getMdApi().getCodeMap().clear();
                    assets = ((CtpTdApi)object2).assets;
                    boolean bl5 = false;
                    bl = false;
                    Assets $this$OnRspUserLogin_u24lambda_u2d17_u24lambda_u2d16 = assets;
                    boolean bl6 = false;
                    $this$OnRspUserLogin_u24lambda_u2d17_u24lambda_u2d16.setTotal(0.0);
                    $this$OnRspUserLogin_u24lambda_u2d17_u24lambda_u2d16.setAvailable(0.0);
                    $this$OnRspUserLogin_u24lambda_u2d17_u24lambda_u2d16.setPositionValue(0.0);
                    $this$OnRspUserLogin_u24lambda_u2d17_u24lambda_u2d16.setFrozenByOrder(0.0);
                    $this$OnRspUserLogin_u24lambda_u2d17_u24lambda_u2d16.setTodayCommission(0.0);
                    ((CtpTdApi)object2).positions.clear();
                }
                if (bIsLast) {
                    assets = request.getContinuation();
                    Unit unit = Unit.INSTANCE;
                    bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl7 = false;
                    assets.resumeWith(Result.constructor-impl((Object)unit));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String lastTradingDay = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl8 = false;
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspSettlementInfoConfirm(@Nullable CThostFtdcSettlementInfoConfirmField pSettlementInfoConfirm, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
                if (bIsLast) {
                    Continuation<?> continuation = request.getContinuation();
                    Unit unit = Unit.INSTANCE;
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)unit));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String string2 = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl4 = false;
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspOrderInsert(@Nullable CThostFtdcInputOrderField pInputOrder, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            CtpTdApi ctpTdApi = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String string2 = string;
                int errorCode = n;
                boolean bl = false;
                if (pInputOrder == null) {
                    return;
                }
                Order order2 = (Order)ctpTdApi.todayOrders.get(pInputOrder.getOrderRef());
                if (order2 == null) {
                    return;
                }
                Order order3 = order2;
                String orderId = "" + ctpTdApi.getFrontId() + '_' + ctpTdApi.getSessionId() + '_' + pInputOrder.getOrderRef();
                if (!Intrinsics.areEqual((Object)orderId, (Object)order3.getOrderId())) {
                    return;
                }
                Order order4 = order3;
                boolean bl2 = false;
                boolean bl3 = false;
                Order $this$OnRspOrderInsert_u24lambda_u2d23_u24lambda_u2d22 = order4;
                boolean bl4 = false;
                $this$OnRspOrderInsert_u24lambda_u2d23_u24lambda_u2d22.setStatus(OrderStatus.ERROR);
                $this$OnRspOrderInsert_u24lambda_u2d23_u24lambda_u2d22.setStatusMsg((String)errorMsg + " (" + errorCode + ')');
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now()");
                $this$OnRspOrderInsert_u24lambda_u2d23_u24lambda_u2d22.setUpdateTime(localDateTime);
                ctpTdApi.postBrokerEvent(BrokerEventType.TD_ORDER_STATUS, UtilsKt.deepCopy(order3));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspOrderAction(@Nullable CThostFtdcInputOrderActionField pInputOrderAction, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            CtpTdApi ctpTdApi = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
            } else {
                void errorMsg;
                Order order2;
                Order order3;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String string2 = string;
                int errorCode = n;
                boolean bl = false;
                if (pInputOrderAction == null) {
                    return;
                }
                String orderId = "" + pInputOrderAction.getFrontID() + '_' + pInputOrderAction.getSessionID() + '_' + pInputOrderAction.getOrderRef();
                Order order4 = (Order)ctpTdApi.todayOrders.get(pInputOrderAction.getOrderRef());
                if (order4 == null) {
                    Order order5 = (Order)ctpTdApi.todayOrders.get(orderId);
                    if (order5 == null) {
                        return;
                    }
                    order3 = order5;
                } else {
                    order3 = order2 = order4;
                }
                if (!Intrinsics.areEqual((Object)orderId, (Object)order2.getOrderId())) {
                    return;
                }
                order4 = order2;
                boolean bl2 = false;
                boolean bl3 = false;
                Order $this$OnRspOrderAction_u24lambda_u2d26_u24lambda_u2d25 = order4;
                boolean bl4 = false;
                $this$OnRspOrderAction_u24lambda_u2d26_u24lambda_u2d25.setStatusMsg((String)errorMsg + " (" + errorCode + ')');
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now()");
                $this$OnRspOrderAction_u24lambda_u2d26_u24lambda_u2d25.setUpdateTime(localDateTime);
                ctpTdApi.postBrokerEvent(BrokerEventType.TD_CANCEL_FAILED, UtilsKt.deepCopy(order2));
            }
        }

        public void OnRtnOrder(@NotNull CThostFtdcOrderField pOrder) {
            LocalDateTime position;
            LocalDateTime localDateTime;
            char c;
            OrderStatus orderStatus;
            CharSequence code;
            Intrinsics.checkNotNullParameter((Object)pOrder, (String)"pOrder");
            String orderId = "" + pOrder.getFrontID() + '_' + pOrder.getSessionID() + '_' + pOrder.getOrderRef();
            Order order2 = null;
            order2 = (Order)CtpTdApi.this.todayOrders.get(pOrder.getOrderRef());
            if (!(order2 != null && Intrinsics.areEqual((Object)orderId, (Object)((Order)order2).getOrderId()) || (order2 = (Order)CtpTdApi.this.todayOrders.get(orderId)) != null)) {
                int n;
                code = pOrder.getExchangeID() + '.' + pOrder.getInstrumentID();
                Object object = CtpTdApi.this.getInstruments().get(code);
                order2 = Translator.INSTANCE.orderC2A(pOrder, object == null ? 0 : (n = object.getVolumeMultiple()), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(CtpTdApi.this, orderId, (String)code, pOrder){
                    final /* synthetic */ CtpTdApi this$0;
                    final /* synthetic */ String $orderId;
                    final /* synthetic */ String $code;
                    final /* synthetic */ CThostFtdcOrderField $pOrder;
                    {
                        this.this$0 = $receiver;
                        this.$orderId = $orderId;
                        this.$code = $code;
                        this.$pOrder = $pOrder;
                        super(1);
                    }

                    public final void invoke(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        CtpTdApi.access$postBrokerEvent(this.this$0, BrokerEventType.TD_ERROR, "OnRtnOrder time \u89e3\u6790\u5931\u8d25\uff1a" + this.$orderId + ", " + this.$code + ", " + this.$pOrder.getInsertDate() + '_' + this.$pOrder.getInsertTime() + '_' + this.$pOrder.getCancelTime() + ", " + e);
                    }
                }));
                CtpTdApi.calculateOrder$default(CtpTdApi.this, order2, null, 2, null);
                object = CtpTdApi.this.todayOrders;
                Order order3 = order2;
                boolean bl = false;
                object.put(orderId, order3);
                object = order2.getStatus();
                int n2 = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: {
                        CtpTdApi.this.insertUnfinishedOrder(order2);
                    }
                }
            }
            code = pOrder.getOrderSysID();
            Intrinsics.checkNotNullExpressionValue((Object)code, (String)"pOrder.orderSysID");
            code = code;
            boolean bl = false;
            if (code.length() > 0) {
                UtilsKt.setOrderSysId(order2, pOrder.getExchangeID() + '_' + pOrder.getOrderSysID());
            }
            OrderStatus oldStatus = ((Order)order2).getStatus();
            double oldCommission = ((Order)order2).getCommission();
            char c2 = pOrder.getOrderSubmitStatus();
            if (c2 == jctpConstants.THOST_FTDC_OSS_InsertRejected) {
                CtpTdApi.this.removeUnfinishedOrder(order2);
                orderStatus = OrderStatus.ERROR;
            } else if (c2 == jctpConstants.THOST_FTDC_OSS_CancelRejected ? true : c2 == jctpConstants.THOST_FTDC_OSS_ModifyRejected) {
                orderStatus = ((Order)order2).getStatus();
            } else {
                c = pOrder.getOrderStatus();
                if (c == jctpConstants.THOST_FTDC_OST_Unknown) {
                    orderStatus = OrderStatus.SUBMITTING;
                } else if (c == jctpConstants.THOST_FTDC_OST_NoTradeQueueing) {
                    if (Intrinsics.areEqual((Object)pOrder.getExchangeID(), (Object)"CFFEX")) {
                        CtpTdApi.calculateOrder$default(CtpTdApi.this, order2, null, 2, null);
                    }
                    orderStatus = OrderStatus.ACCEPTED;
                } else if (c == jctpConstants.THOST_FTDC_OST_PartTradedQueueing) {
                    orderStatus = OrderStatus.PARTIALLY_FILLED;
                } else if (c == jctpConstants.THOST_FTDC_OST_AllTraded) {
                    CtpTdApi.this.removeUnfinishedOrder(order2);
                    orderStatus = OrderStatus.FILLED;
                } else if (c == jctpConstants.THOST_FTDC_OST_Canceled) {
                    CtpTdApi.this.removeUnfinishedOrder(order2);
                    Map map = CtpTdApi.this.cancelStatistics;
                    String string = order2.getCode();
                    Integer n = ((Number)CtpTdApi.this.cancelStatistics.getOrDefault(order2.getCode(), 0)).intValue() + 1;
                    boolean bl2 = false;
                    map.put(string, n);
                    if (Intrinsics.areEqual((Object)pOrder.getExchangeID(), (Object)"CFFEX")) {
                        CtpTdApi.calculateOrder$default(CtpTdApi.this, order2, null, 2, null);
                    }
                    orderStatus = OrderStatus.CANCELED;
                } else {
                    CtpTdApi.this.removeUnfinishedOrder(order2);
                    orderStatus = OrderStatus.ERROR;
                }
            }
            OrderStatus newOrderStatus = orderStatus;
            Order order4 = order2;
            c = '\u0000';
            boolean bl3 = false;
            Order $this$OnRtnOrder_u24lambda_u2d272 = order4;
            boolean bl4 = false;
            $this$OnRtnOrder_u24lambda_u2d272.setStatus(newOrderStatus);
            String string = pOrder.getStatusMsg();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pOrder.statusMsg");
            $this$OnRtnOrder_u24lambda_u2d272.setStatusMsg(string);
            if (!(oldCommission == order2.getCommission()) && (localDateTime = (position = CtpTdApi.this.queryCachedPosition(order2.getCode(), order2.getDirection(), order2.getOffset() != OrderOffset.OPEN))) != null) {
                LocalDateTime localDateTime2 = localDateTime;
                boolean $this$OnRtnOrder_u24lambda_u2d272 = false;
                boolean bl5 = false;
                LocalDateTime $this$OnRtnOrder_u24lambda_u2d28 = localDateTime2;
                boolean bl6 = false;
                LocalDateTime localDateTime3 = $this$OnRtnOrder_u24lambda_u2d28;
                localDateTime3.setTodayCommission(localDateTime3.getTodayCommission() + (order2.getCommission() - oldCommission));
            }
            if (newOrderStatus == OrderStatus.ERROR) {
                position = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)position, (String)"now()");
                order2.setUpdateTime(position);
                CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_ORDER_STATUS, UtilsKt.deepCopy(order2));
            } else if (newOrderStatus != oldStatus && newOrderStatus != OrderStatus.PARTIALLY_FILLED && newOrderStatus != OrderStatus.FILLED) {
                LocalDateTime localDateTime4;
                if (order2.getOffset() != OrderOffset.OPEN && (position = CtpTdApi.this.queryCachedPosition(order2.getCode(), order2.getDirection(), true)) != null) {
                    OrderStatus orderStatus2 = newOrderStatus;
                    int n = WhenMappings.$EnumSwitchMapping$0[orderStatus2.ordinal()];
                    switch (n) {
                        case 1: {
                            LocalDateTime $this$OnRtnOrder_u24lambda_u2d272 = position;
                            $this$OnRtnOrder_u24lambda_u2d272.setFrozenVolume($this$OnRtnOrder_u24lambda_u2d272.getFrozenVolume() + order2.getVolume());
                            $this$OnRtnOrder_u24lambda_u2d272 = position;
                            $this$OnRtnOrder_u24lambda_u2d272.setCloseableVolume($this$OnRtnOrder_u24lambda_u2d272.getCloseableVolume() - order2.getVolume());
                            break;
                        }
                        case 4: 
                        case 5: {
                            int restVolume = order2.getVolume() - pOrder.getVolumeTraded();
                            LocalDateTime localDateTime5 = position;
                            localDateTime5.setFrozenVolume(localDateTime5.getFrozenVolume() - restVolume);
                            localDateTime5 = position;
                            localDateTime5.setCloseableVolume(localDateTime5.getCloseableVolume() + restVolume);
                        }
                    }
                }
                try {
                    LocalDateTime localDateTime6;
                    if (newOrderStatus == OrderStatus.CANCELED) {
                        localDateTime6 = LocalTime.parse(pOrder.getCancelTime()).atDate(LocalDate.now());
                    } else {
                        String date = pOrder.getInsertDate();
                        StringBuilder stringBuilder = new StringBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
                        localDateTime6 = LocalDateTime.parse(stringBuilder.append(StringsKt.slice((String)date, (IntRange)new IntRange(0, 3))).append('-').append(StringsKt.slice((String)date, (IntRange)new IntRange(4, 5))).append('-').append(StringsKt.slice((String)date, (IntRange)new IntRange(6, 7))).append('T').append((Object)pOrder.getInsertTime()).toString());
                    }
                    localDateTime4 = localDateTime6;
                }
                catch (Exception e) {
                    CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_ERROR, "OnRtnOrder updateTime \u89e3\u6790\u5931\u8d25\uff1a" + order2.getOrderId() + ", " + pOrder.getInsertDate() + '_' + pOrder.getInsertTime() + '_' + pOrder.getCancelTime() + ", " + e);
                    localDateTime4 = LocalDateTime.now();
                }
                LocalDateTime updateTime = localDateTime4;
                Intrinsics.checkNotNullExpressionValue((Object)updateTime, (String)"updateTime");
                order2.setUpdateTime(updateTime);
                CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_ORDER_STATUS, UtilsKt.deepCopy(order2));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRtnTrade(@NotNull CThostFtdcTradeField pTrade) {
            Position position;
            Position position2;
            Object object;
            void $this$getOrPut$iv;
            Order order2;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)pTrade, (String)"pTrade");
            Order order3 = (Order)CtpTdApi.this.todayOrders.get(pTrade.getOrderRef());
            String orderSysId = pTrade.getExchangeID() + '_' + pTrade.getOrderSysID();
            if (order3 == null || !Intrinsics.areEqual((Object)UtilsKt.getOrderSysId(order3), (Object)orderSysId)) {
                Object v0;
                block38: {
                    Iterable iterable = CtpTdApi.this.todayOrders.values();
                    boolean bl = false;
                    object2 = iterable;
                    boolean bl2 = false;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        Order it = (Order)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)UtilsKt.getOrderSysId(it), (Object)orderSysId)) continue;
                        v0 = t;
                        break block38;
                    }
                    v0 = null;
                }
                order3 = v0;
                if (order3 == null) {
                    CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_ERROR, "OnRtnTrade \u6536\u5230\u672a\u77e5\u6210\u4ea4\u56de\u62a5\uff1a" + pTrade.getTradeID() + ", " + pTrade.getOrderRef() + ", " + orderSysId + ", " + pTrade.getExchangeID() + '.' + pTrade.getInstrumentID());
                }
            }
            Trade trade2 = Translator.INSTANCE.tradeC2A(pTrade, (String)((order2 = order3) == null ? orderSysId : ((object2 = order2.getOrderId()) == null ? orderSysId : object2)), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(CtpTdApi.this, pTrade, orderSysId){
                final /* synthetic */ CtpTdApi this$0;
                final /* synthetic */ CThostFtdcTradeField $pTrade;
                final /* synthetic */ String $orderSysId;
                {
                    this.this$0 = $receiver;
                    this.$pTrade = $pTrade;
                    this.$orderSysId = $orderSysId;
                    super(1);
                }

                public final void invoke(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    CtpTdApi.access$postBrokerEvent(this.this$0, BrokerEventType.TD_ERROR, "OnRtnTrade tradeTime \u89e3\u6790\u5931\u8d25\uff1a" + this.$pTrade.getTradeID() + ", " + this.$pTrade.getOrderRef() + ", " + this.$orderSysId + ", " + this.$pTrade.getExchangeID() + '.' + this.$pTrade.getInstrumentID() + ", " + this.$pTrade.getTradeDate() + 'T' + this.$pTrade.getTradeTime() + ", " + e);
                }
            }));
            object2 = CtpTdApi.this.getInstruments().get(trade2.getCode());
            if (object2 == null) {
                return;
            }
            Object instrument2 = object2;
            trade2.setTurnover((double)trade2.getVolume() * trade2.getPrice() * (double)instrument2.getVolumeMultiple());
            Map map = CtpTdApi.this.positions;
            String key$iv = trade2.getCode();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                BiPosition answer$iv = new BiPosition(null, null, 3, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            BiPosition biPosition = (BiPosition)object;
            if (trade2.getDirection() == Direction.LONG && trade2.getOffset() == OrderOffset.OPEN || trade2.getDirection() == Direction.SHORT && trade2.getOffset() != OrderOffset.OPEN) {
                if (biPosition.getLong() == null) {
                    biPosition.setLong(new Position(CtpTdApi.this.getConfig().getInvestorId(), trade2.getCode(), Direction.LONG, 0, 0, 0.0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, null, 131072, null));
                }
                position2 = biPosition.getLong();
            } else if (trade2.getDirection() == Direction.SHORT && trade2.getOffset() == OrderOffset.OPEN || trade2.getDirection() == Direction.LONG && trade2.getOffset() != OrderOffset.OPEN) {
                if (biPosition.getShort() == null) {
                    biPosition.setShort(new Position(CtpTdApi.this.getConfig().getInvestorId(), trade2.getCode(), Direction.SHORT, 0, 0, 0.0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, null, 131072, null));
                }
                position2 = biPosition.getShort();
            } else {
                position2 = position = null;
            }
            if (position != null) {
                if (trade2.getOffset() == OrderOffset.OPEN) {
                    key$iv = position;
                    key$iv.setTodayVolume(key$iv.getTodayVolume() + trade2.getVolume());
                    key$iv = position;
                    key$iv.setVolume(key$iv.getVolume() + trade2.getVolume());
                    key$iv = position;
                    key$iv.setCloseableVolume(key$iv.getCloseableVolume() + trade2.getVolume());
                    key$iv = position;
                    key$iv.setTodayOpenVolume(key$iv.getTodayOpenVolume() + trade2.getVolume());
                    key$iv = position;
                    key$iv.setOpenCost(key$iv.getOpenCost() + trade2.getTurnover());
                } else {
                    int todayClosed = 0;
                    int yesterdayClosed = 0;
                    CommissionRate com = CtpTdApi.this.getOrQueryCommissionRate((Security)instrument2);
                    String answer$iv = pTrade.getExchangeID();
                    if (Intrinsics.areEqual((Object)answer$iv, (Object)"SHFE") ? true : Intrinsics.areEqual((Object)answer$iv, (Object)"INE")) {
                        Order order4 = order3;
                        OrderOffset orderOffset = order4 == null ? null : order4.getOffset();
                        trade2.setOffset(orderOffset == null ? trade2.getOffset() : orderOffset);
                        if (trade2.getOffset() == OrderOffset.CLOSE) {
                            trade2.setOffset(OrderOffset.CLOSE_YESTERDAY);
                        }
                        orderOffset = trade2.getOffset();
                        int n = WhenMappings.$EnumSwitchMapping$1[orderOffset.ordinal()];
                        switch (n) {
                            case 1: {
                                todayClosed = trade2.getVolume();
                                break;
                            }
                            case 2: {
                                yesterdayClosed = trade2.getVolume();
                            }
                        }
                    } else {
                        boolean todayFirst = false;
                        if (com != null && (com.getCloseTodayRatioByVolume() < com.getCloseRatioByVolume() || com.getCloseTodayRatioByMoney() < com.getCloseRatioByMoney())) {
                            todayFirst = true;
                        }
                        if (todayFirst) {
                            if (trade2.getVolume() <= position.getTodayVolume()) {
                                trade2.setOffset(OrderOffset.CLOSE_TODAY);
                                todayClosed = trade2.getVolume();
                            } else if (position.getTodayVolume() == 0 && position.getYesterdayVolume() >= trade2.getVolume()) {
                                trade2.setOffset(OrderOffset.CLOSE_YESTERDAY);
                                yesterdayClosed = trade2.getVolume();
                            } else if (trade2.getVolume() <= position.getVolume()) {
                                trade2.setOffset(OrderOffset.CLOSE);
                                todayClosed = position.getTodayVolume();
                                yesterdayClosed = trade2.getVolume() - position.getTodayVolume();
                            }
                        } else if (trade2.getVolume() <= position.getYesterdayVolume()) {
                            trade2.setOffset(OrderOffset.CLOSE_YESTERDAY);
                            yesterdayClosed = trade2.getVolume();
                        } else if (position.getYesterdayVolume() == 0 && trade2.getVolume() <= position.getTodayVolume()) {
                            trade2.setOffset(OrderOffset.CLOSE_TODAY);
                            todayClosed = trade2.getVolume();
                        } else if (trade2.getVolume() <= position.getVolume()) {
                            trade2.setOffset(OrderOffset.CLOSE);
                            yesterdayClosed = position.getYesterdayVolume();
                            todayClosed = trade2.getVolume() - yesterdayClosed;
                        }
                    }
                    int totalClosed = todayClosed + yesterdayClosed;
                    Position todayFirst = position;
                    todayFirst.setVolume(todayFirst.getVolume() - totalClosed);
                    todayFirst = position;
                    todayFirst.setTodayVolume(todayFirst.getTodayVolume() - todayClosed);
                    todayFirst = position;
                    todayFirst.setYesterdayVolume(todayFirst.getYesterdayVolume() - yesterdayClosed);
                    todayFirst = position;
                    todayFirst.setTodayCloseVolume(todayFirst.getTodayCloseVolume() + totalClosed);
                    todayFirst = position;
                    todayFirst.setFrozenVolume(todayFirst.getFrozenVolume() - totalClosed);
                    todayFirst = position;
                    todayFirst.setOpenCost(todayFirst.getOpenCost() - position.getAvgOpenPrice() * (double)totalClosed * (double)instrument2.getVolumeMultiple());
                    if (trade2.getOffset() == OrderOffset.CLOSE && com != null) {
                        double todayClosedTurnover = (double)todayClosed * trade2.getTurnover() / (double)totalClosed;
                        double yesterdayClosedTurnover = (double)yesterdayClosed * trade2.getTurnover() / (double)totalClosed;
                        trade2.setCommission(yesterdayClosedTurnover * com.getCloseRatioByMoney() + (double)yesterdayClosed * com.getCloseRatioByVolume() + todayClosedTurnover * com.getCloseTodayRatioByMoney() + (double)todayClosed * com.getCloseTodayRatioByVolume());
                    }
                }
            }
            CtpTdApi.calculateTrade$default(CtpTdApi.this, trade2, null, 2, null);
            if (position != null) {
                Position position3 = position;
                position3.setTodayCommission(position3.getTodayCommission() + trade2.getCommission());
            }
            CtpTdApi.this.todayTrades.add(trade2);
            CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_TRADE_REPORT, Trade.copy$default((Trade)trade2, null, null, null, null, (double)0.0, (int)0, (double)0.0, null, null, (double)0.0, null, null, (int)4095, null));
            if (order3 != null) {
                Order order5 = order3;
                order5.setFilledVolume(order5.getFilledVolume() + trade2.getVolume());
                order5 = order3;
                order5.setTurnover(order5.getTurnover() + trade2.getTurnover());
                order5 = order3;
                order5.setCommission(order5.getCommission() + trade2.getCommission());
                order3.setUpdateTime(trade2.getTime());
                order3.setStatus(order3.getFilledVolume() < order3.getVolume() ? OrderStatus.PARTIALLY_FILLED : OrderStatus.FILLED);
                CtpTdApi.calculateOrder$default(CtpTdApi.this, order3, null, 2, null);
                CtpTdApi.this.postBrokerEvent(BrokerEventType.TD_ORDER_STATUS, UtilsKt.deepCopy(order3));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryOrder(@Nullable CThostFtdcOrderField pOrder, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
                QueryOrdersData reqData = (QueryOrdersData)request.getData();
                if (pOrder != null) {
                    int n;
                    String code = pOrder.getExchangeID() + '.' + pOrder.getInstrumentID();
                    Security security = ((CtpTdApi)object2).getInstruments().get(code);
                    Order order2 = Translator.INSTANCE.orderC2A(pOrder, security == null ? 0 : (n = security.getVolumeMultiple()), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>((CtpTdApi)object2, pOrder, code){
                        final /* synthetic */ CtpTdApi this$0;
                        final /* synthetic */ CThostFtdcOrderField $pOrder;
                        final /* synthetic */ String $code;
                        {
                            this.this$0 = $receiver;
                            this.$pOrder = $pOrder;
                            this.$code = $code;
                            super(1);
                        }

                        public final void invoke(@NotNull Exception e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            CtpTdApi.access$postBrokerEvent(this.this$0, BrokerEventType.TD_ERROR, "OnRspQryOrder time \u89e3\u6790\u5931\u8d25\uff1a" + this.$pOrder.getFrontID() + '_' + this.$pOrder.getSessionID() + '_' + this.$pOrder.getOrderRef() + ", " + this.$code + ", " + this.$pOrder.getInsertDate() + '_' + this.$pOrder.getInsertTime() + '_' + this.$pOrder.getCancelTime() + ", " + e);
                        }
                    }));
                    reqData.getResults().add(order2);
                }
                if (bIsLast) {
                    Result.Companion companion;
                    if (reqData.getOrderId() != null) {
                        Object v0;
                        boolean bl2;
                        Result.Companion companion2;
                        boolean bl3;
                        block10: {
                            companion = (Result.Companion)reqData.getResults();
                            bl3 = false;
                            companion2 = companion;
                            bl2 = false;
                            for (Object t : companion2) {
                                Order it = (Order)t;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it.getOrderId(), (Object)reqData.getOrderId())) continue;
                                v0 = t;
                                break block10;
                            }
                            v0 = null;
                        }
                        Order order3 = v0;
                        companion = request.getContinuation();
                        bl3 = false;
                        companion2 = Result.Companion;
                        bl2 = false;
                        companion.resumeWith(Result.constructor-impl((Object)order3));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    } else {
                        Object finishedStatus;
                        if (reqData.getCode() != null) {
                            CollectionsKt.removeAll(reqData.getResults(), (Function1)((Function1)new Function1<Order, Boolean>(reqData){
                                final /* synthetic */ QueryOrdersData $reqData;
                                {
                                    this.$reqData = $reqData;
                                    super(1);
                                }

                                public final boolean invoke(@NotNull Order it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return !Intrinsics.areEqual((Object)it.getCode(), (Object)this.$reqData.getCode());
                                }
                            }));
                        }
                        if (reqData.getOnlyUnfinished()) {
                            companion = new Result.Companion[]{OrderStatus.CANCELED, OrderStatus.FILLED, OrderStatus.ERROR};
                            finishedStatus = SetsKt.setOf(companion);
                            CollectionsKt.removeAll(reqData.getResults(), (Function1)((Function1)new Function1<Order, Boolean>(finishedStatus){
                                final /* synthetic */ Set<OrderStatus> $finishedStatus;
                                {
                                    this.$finishedStatus = $finishedStatus;
                                    super(1);
                                }

                                public final boolean invoke(@NotNull Order it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return this.$finishedStatus.contains(it.getStatus());
                                }
                            }));
                        }
                        finishedStatus = request.getContinuation();
                        companion = reqData.getResults();
                        boolean bl5 = false;
                        Result.Companion companion3 = Result.Companion;
                        boolean bl6 = false;
                        finishedStatus.resumeWith(Result.constructor-impl((Object)companion));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    }
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String reqData = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl7 = false;
                Result.Companion companion = Result.Companion;
                boolean bl8 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryTrade(@Nullable CThostFtdcTradeField pTrade, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                Order order2;
                boolean bl = false;
                QueryTradesData reqData = (QueryTradesData)request.getData();
                if (pTrade != null) {
                    Object object3;
                    String orderSysId = pTrade.getExchangeID() + '_' + pTrade.getOrderSysID();
                    Order order3 = (Order)((CtpTdApi)object2).todayOrders.get(pTrade.getOrderRef());
                    if (order3 == null || !Intrinsics.areEqual((Object)UtilsKt.getOrderSysId(order3), (Object)orderSysId)) {
                        Object v0;
                        block13: {
                            Iterable iterable = ((CtpTdApi)object2).todayOrders.values();
                            boolean bl2 = false;
                            object3 = iterable;
                            boolean bl3 = false;
                            Object object4 = object3.iterator();
                            while (object4.hasNext()) {
                                Object e = object4.next();
                                Order it = (Order)e;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)UtilsKt.getOrderSysId(it), (Object)orderSysId)) continue;
                                v0 = e;
                                break block13;
                            }
                            v0 = null;
                        }
                        order3 = v0;
                        if (order3 == null) {
                            ((CtpTdApi)object2).postBrokerEvent(BrokerEventType.TD_ERROR, "OnRspQryTrade \u672a\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff1a" + pTrade.getTradeID() + ", " + pTrade.getOrderRef() + ", " + orderSysId + ", " + pTrade.getExchangeID() + '.' + pTrade.getInstrumentID());
                        }
                    }
                    Trade trade2 = Translator.INSTANCE.tradeC2A(pTrade, (String)((order2 = order3) == null ? orderSysId : ((object3 = order2.getOrderId()) == null ? orderSysId : object3)), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>((CtpTdApi)object2, pTrade, orderSysId){
                        final /* synthetic */ CtpTdApi this$0;
                        final /* synthetic */ CThostFtdcTradeField $pTrade;
                        final /* synthetic */ String $orderSysId;
                        {
                            this.this$0 = $receiver;
                            this.$pTrade = $pTrade;
                            this.$orderSysId = $orderSysId;
                            super(1);
                        }

                        public final void invoke(@NotNull Exception e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            CtpTdApi.access$postBrokerEvent(this.this$0, BrokerEventType.TD_ERROR, "OnRspQryTrade tradeTime \u89e3\u6790\u5931\u8d25\uff1a" + this.$pTrade.getTradeID() + ", " + this.$pTrade.getOrderRef() + ", " + this.$orderSysId + ", " + this.$pTrade.getExchangeID() + '.' + this.$pTrade.getInstrumentID() + ", " + this.$pTrade.getTradeDate() + 'T' + this.$pTrade.getTradeTime() + ", " + e);
                        }
                    }));
                    reqData.getResults().add(trade2);
                }
                if (bIsLast) {
                    Trade trade3;
                    Order order4;
                    if (reqData.getTradeId() != null) {
                        Object v1;
                        boolean bl5;
                        boolean bl6;
                        block14: {
                            order4 = (Order)reqData.getResults();
                            bl6 = false;
                            order2 = order4;
                            bl5 = false;
                            for (Object object4 : order2) {
                                Trade it = (Trade)object4;
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual((Object)it.getTradeId(), (Object)reqData.getTradeId())) continue;
                                v1 = object4;
                                break block14;
                            }
                            v1 = null;
                        }
                        trade3 = v1;
                        order4 = request.getContinuation();
                        bl6 = false;
                        order2 = Result.Companion;
                        bl5 = false;
                        order4.resumeWith(Result.constructor-impl((Object)trade3));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    } else {
                        if (reqData.getCode() != null) {
                            CollectionsKt.removeAll(reqData.getResults(), (Function1)((Function1)new Function1<Trade, Boolean>(reqData){
                                final /* synthetic */ QueryTradesData $reqData;
                                {
                                    this.$reqData = $reqData;
                                    super(1);
                                }

                                public final boolean invoke(@NotNull Trade it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return !Intrinsics.areEqual((Object)it.getCode(), (Object)this.$reqData.getCode());
                                }
                            }));
                        }
                        if (reqData.getOrderSysId() != null) {
                            CollectionsKt.removeAll(reqData.getResults(), (Function1)((Function1)new Function1<Trade, Boolean>(reqData){
                                final /* synthetic */ QueryTradesData $reqData;
                                {
                                    this.$reqData = $reqData;
                                    super(1);
                                }

                                public final boolean invoke(@NotNull Trade it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return !Intrinsics.areEqual((Object)it.getOrderId(), (Object)this.$reqData.getOrderSysId());
                                }
                            }));
                        }
                        trade3 = request.getContinuation();
                        order4 = reqData.getResults();
                        boolean bl8 = false;
                        order2 = Result.Companion;
                        boolean bl9 = false;
                        trade3.resumeWith(Result.constructor-impl((Object)order4));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    }
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String reqData = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl10 = false;
                Result.Companion companion = Result.Companion;
                boolean bl11 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryDepthMarketData(@Nullable CThostFtdcDepthMarketDataField pDepthMarketData, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            RequestContinuation requestContinuation;
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            RequestContinuation request = requestContinuation = object;
            String reqCode = (String)request.getData();
            object = CtpTdApi.this;
            CtpTdApi ctpTdApi = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
                if (pDepthMarketData == null) {
                    Continuation<?> continuation = request.getContinuation();
                    Object var12_15 = null;
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl(var12_15));
                    ((CtpTdApi)object).requestMap.remove(nRequestID);
                    return;
                }
                String code = pDepthMarketData.getExchangeID() + '.' + pDepthMarketData.getInstrumentID();
                if (Intrinsics.areEqual((Object)code, (Object)reqCode)) {
                    Object object2 = ((CtpTdApi)object).getInstruments().get(code);
                    Tick tick2 = Translator.tickC2A$default(Translator.INSTANCE, code, pDepthMarketData, null, object2 == null ? null : Integer.valueOf(object2.getVolumeMultiple()), ((CtpTdApi)object).getInstrumentStatus(code), (Function1)new Function1<Exception, Unit>((CtpTdApi)object, request, pDepthMarketData){
                        final /* synthetic */ CtpTdApi this$0;
                        final /* synthetic */ RequestContinuation $request;
                        final /* synthetic */ CThostFtdcDepthMarketDataField $pDepthMarketData;
                        {
                            this.this$0 = $receiver;
                            this.$request = $request;
                            this.$pDepthMarketData = $pDepthMarketData;
                            super(1);
                        }

                        public final void invoke(@NotNull Exception e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            CtpTdApi.access$postBrokerEvent(this.this$0, BrokerEventType.TD_ERROR, "OnRspQryDepthMarketData updateTime \u89e3\u6790\u5931\u8d25\uff1a" + this.$request.getData() + ", " + this.$pDepthMarketData.getUpdateTime() + '.' + this.$pDepthMarketData.getUpdateMillisec() + ", " + e);
                        }
                    }, 4, null);
                    object2 = ((CtpTdApi)object).cachedTickMap;
                    boolean bl4 = false;
                    object2.put(code, tick2);
                    object2 = request.getContinuation();
                    bl4 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl5 = false;
                    object2.resumeWith(Result.constructor-impl((Object)tick2));
                    ((CtpTdApi)object).requestMap.remove(nRequestID);
                } else if (bIsLast) {
                    Continuation<?> tick2 = request.getContinuation();
                    Object var13_21 = null;
                    boolean bl6 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl7 = false;
                    tick2.resumeWith(Result.constructor-impl(var13_21));
                    ((CtpTdApi)object).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String code = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl8 = false;
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ctpTdApi.requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryInstrument(@Nullable CThostFtdcInstrumentField pInstrument, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Continuation<?> it;
            Object object;
            Security security;
            RequestContinuation requestContinuation;
            RequestContinuation requestContinuation2 = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (requestContinuation2 == null) {
                return;
            }
            RequestContinuation request = requestContinuation = requestContinuation2;
            Object reqData = request.getData();
            Object object2 = pInstrument;
            if (object2 == null) {
                security = null;
            } else {
                object = object2;
                CtpTdApi ctpTdApi = CtpTdApi.this;
                boolean bl = false;
                boolean bl2 = false;
                it = object;
                boolean bl3 = false;
                security = Translator.INSTANCE.securityC2A(pInstrument, (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(ctpTdApi, pInstrument){
                    final /* synthetic */ CtpTdApi this$0;
                    final /* synthetic */ CThostFtdcInstrumentField $pInstrument;
                    {
                        this.this$0 = $receiver;
                        this.$pInstrument = $pInstrument;
                        super(1);
                    }

                    public final void invoke(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        CtpTdApi.access$postBrokerEvent(this.this$0, BrokerEventType.TD_ERROR, "OnRspQryInstrument Instrument \u89e3\u6790\u5931\u8d25(" + this.$pInstrument.getExchangeID() + '.' + this.$pInstrument.getInstrumentID() + ")\uff1a" + e);
                    }
                }));
            }
            Security instrument2 = security;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl;
                boolean bl4 = false;
                if (reqData instanceof String) {
                    Continuation<?> con = request.getContinuation();
                    if (instrument2 == null) {
                        it = con;
                        Object var14_20 = null;
                        boolean bl5 = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl6 = false;
                        it.resumeWith(Result.constructor-impl(var14_20));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                        return;
                    }
                    if (Intrinsics.areEqual((Object)reqData, (Object)instrument2.getCode())) {
                        it = con;
                        bl = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl7 = false;
                        it.resumeWith(Result.constructor-impl((Object)instrument2));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    } else if (bIsLast) {
                        it = con;
                        Object var14_21 = null;
                        boolean bl8 = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl9 = false;
                        it.resumeWith(Result.constructor-impl(var14_21));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    }
                } else {
                    List insList = TypeIntrinsics.asMutableList((Object)request.getData());
                    if (instrument2 != null) {
                        insList.add(instrument2);
                    }
                    if (bIsLast) {
                        it = request.getContinuation();
                        bl = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl10 = false;
                        it.resumeWith(Result.constructor-impl((Object)insList));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    }
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String insList = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl11 = false;
                Result.Companion companion = Result.Companion;
                boolean bl12 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryTradingAccount(@Nullable CThostFtdcTradingAccountField pTradingAccount, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
                if (pTradingAccount == null) {
                    Continuation<?> continuation = request.getContinuation();
                    Throwable throwable = new Exception("pTradingAccount \u4e3a null");
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                    return;
                }
                Continuation<?> continuation = request.getContinuation();
                Assets assets = Translator.INSTANCE.assetsC2A(pTradingAccount);
                boolean bl4 = false;
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                continuation.resumeWith(Result.constructor-impl((Object)assets));
                ((CtpTdApi)object2).requestMap.remove(nRequestID);
                ((CtpTdApi)object2).lastQueryAssetsTime = System.currentTimeMillis();
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String string2 = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl6 = false;
                Result.Companion companion = Result.Companion;
                boolean bl7 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryInvestorPosition(@Nullable CThostFtdcInvestorPositionField pInvestorPosition, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl;
                Iterable iterable;
                boolean bl2 = false;
                List posList = TypeIntrinsics.asMutableList((Object)request.getData());
                if (pInvestorPosition != null) {
                    Object it;
                    Direction direction = Translator.INSTANCE.directionC2A(pInvestorPosition.getPosiDirection());
                    String code = pInvestorPosition.getExchangeID() + '.' + pInvestorPosition.getInstrumentID();
                    Position mergePosition = null;
                    if (Intrinsics.areEqual((Object)pInvestorPosition.getExchangeID(), (Object)"SHFE") || Intrinsics.areEqual((Object)pInvestorPosition.getExchangeID(), (Object)"INE")) {
                        Object v0;
                        block28: {
                            iterable = posList;
                            bl = false;
                            Iterable iterable2 = iterable;
                            boolean bl3 = false;
                            for (Object object3 : iterable2) {
                                it = (Position)object3;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual((Object)it.getCode(), (Object)code) && it.getDirection() == direction)) continue;
                                v0 = object3;
                                break block28;
                            }
                            v0 = null;
                        }
                        mergePosition = v0;
                    }
                    if (mergePosition == null) {
                        posList.add(Translator.INSTANCE.positionC2A(pInvestorPosition));
                    } else {
                        Object object3;
                        iterable = mergePosition;
                        bl = false;
                        boolean bl5 = false;
                        Iterable $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46 = iterable;
                        boolean bl6 = false;
                        object3 = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                        object3.setVolume(object3.getVolume() + pInvestorPosition.getPosition());
                        object3 = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                        object3.setFrozenVolume(object3.getFrozenVolume() + $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46.getFrozenVolume());
                        $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46.setCloseableVolume($this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46.getVolume() - $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46.getFrozenVolume());
                        object3 = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                        object3.setTodayCloseVolume(object3.getTodayCloseVolume() + pInvestorPosition.getCloseVolume());
                        object3 = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                        object3.setTodayCommission(object3.getTodayCommission() + pInvestorPosition.getCommission());
                        object3 = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                        object3.setOpenCost(object3.getOpenCost() + pInvestorPosition.getOpenCost());
                        char c = pInvestorPosition.getPositionDate();
                        if (c == jctpConstants.THOST_FTDC_PSD_Today) {
                            it = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                            it.setTodayVolume(it.getTodayVolume() + pInvestorPosition.getTodayPosition());
                            it = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                            it.setTodayOpenVolume(it.getTodayOpenVolume() + pInvestorPosition.getOpenVolume());
                        } else if (c == jctpConstants.THOST_FTDC_PSD_History) {
                            it = $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46;
                            it.setYesterdayVolume(it.getYesterdayVolume() + pInvestorPosition.getYdPosition());
                        }
                    }
                }
                if (bIsLast) {
                    Object $this$forEach$iv = (Continuation<?>)posList;
                    boolean $i$f$forEach = false;
                    Object object4 = $this$forEach$iv.iterator();
                    while (object4.hasNext()) {
                        Object element$iv = object4.next();
                        Position it = (Position)element$iv;
                        boolean bl7 = false;
                        CtpTdApi.calculatePosition$default((CtpTdApi)object2, it, false, null, 4, null);
                    }
                    if (Intrinsics.areEqual((Object)request.getTag(), (Object)"")) {
                        $this$forEach$iv = request.getContinuation();
                        $i$f$forEach = false;
                        object4 = Result.Companion;
                        boolean element$iv = false;
                        $this$forEach$iv.resumeWith(Result.constructor-impl((Object)posList));
                        ((CtpTdApi)object2).requestMap.remove(nRequestID);
                        ((CtpTdApi)object2).positions.clear();
                        $this$forEach$iv = posList;
                        $i$f$forEach = false;
                        object4 = $this$forEach$iv.iterator();
                        while (object4.hasNext()) {
                            Object object5;
                            void $this$getOrPut$iv;
                            Object element$iv2 = object4.next();
                            Position it = (Position)element$iv2;
                            boolean bl8 = false;
                            Map $this$OnRspQryInvestorPosition_u24lambda_u2d52_u24lambda_u2d46 = ((CtpTdApi)object2).positions;
                            String key$iv = it.getCode();
                            boolean $i$f$getOrPut = false;
                            Object value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                boolean bl9 = false;
                                BiPosition answer$iv = new BiPosition(null, null, 3, null);
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object5 = answer$iv;
                            } else {
                                object5 = value$iv;
                            }
                            BiPosition biPosition = (BiPosition)object5;
                            Direction direction = it.getDirection();
                            int n = WhenMappings.$EnumSwitchMapping$2[direction.ordinal()];
                            switch (n) {
                                case 1: {
                                    biPosition.setLong(it);
                                    break;
                                }
                                case 2: {
                                    biPosition.setShort(it);
                                }
                            }
                        }
                    } else {
                        Position it;
                        Iterator iterator;
                        $this$forEach$iv = request.getTag();
                        if (Intrinsics.areEqual($this$forEach$iv, (Object)Direction.LONG.name())) {
                            Iterator iterator2;
                            boolean bl10;
                            Object object6;
                            boolean bl11;
                            Continuation<?> continuation;
                            block29: {
                                continuation = request.getContinuation();
                                object4 = posList;
                                bl11 = false;
                                object6 = object4;
                                bl10 = false;
                                Iterator iterator3 = object6.iterator();
                                while (iterator3.hasNext()) {
                                    iterator = iterator3.next();
                                    it = (Position)iterator;
                                    boolean bl12 = false;
                                    if (!(it.getDirection() == Direction.LONG)) continue;
                                    iterator2 = iterator;
                                    break block29;
                                }
                                iterator2 = null;
                            }
                            object4 = iterator2;
                            bl11 = false;
                            object6 = Result.Companion;
                            bl10 = false;
                            continuation.resumeWith(Result.constructor-impl((Object)object4));
                            ((CtpTdApi)object2).requestMap.remove(nRequestID);
                        } else if (Intrinsics.areEqual($this$forEach$iv, (Object)Direction.SHORT.name())) {
                            Iterator iterator4;
                            boolean bl13;
                            Object object7;
                            boolean bl14;
                            Continuation<?> continuation;
                            block30: {
                                continuation = request.getContinuation();
                                object4 = posList;
                                bl14 = false;
                                object7 = object4;
                                bl13 = false;
                                Iterator iterator5 = object7.iterator();
                                while (iterator5.hasNext()) {
                                    iterator = iterator5.next();
                                    it = (Position)iterator;
                                    boolean bl15 = false;
                                    if (!(it.getDirection() == Direction.SHORT)) continue;
                                    iterator4 = iterator;
                                    break block30;
                                }
                                iterator4 = null;
                            }
                            object4 = iterator4;
                            bl14 = false;
                            object7 = Result.Companion;
                            bl13 = false;
                            continuation.resumeWith(Result.constructor-impl((Object)object4));
                            ((CtpTdApi)object2).requestMap.remove(nRequestID);
                        } else {
                            Continuation<?> continuation = request.getContinuation();
                            boolean bl16 = false;
                            iterable = Result.Companion;
                            bl = false;
                            continuation.resumeWith(Result.constructor-impl((Object)posList));
                            ((CtpTdApi)object2).requestMap.remove(nRequestID);
                        }
                    }
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String posList = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl17 = false;
                Result.Companion companion = Result.Companion;
                boolean bl18 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryBrokerTradingParams(@Nullable CThostFtdcBrokerTradingParamsField pBrokerTradingParams, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean bl = false;
                if (pBrokerTradingParams != null) {
                    ((CtpTdApi)object2).futuresMarginPriceType = Translator.INSTANCE.marginPriceTypeC2A(pBrokerTradingParams.getMarginPriceType());
                    ((CtpTdApi)object2).optionsMarginPriceType = Translator.INSTANCE.marginPriceTypeC2A(pBrokerTradingParams.getOptionRoyaltyPriceType());
                }
                if (bIsLast) {
                    Continuation<?> continuation = request.getContinuation();
                    Unit unit = Unit.INSTANCE;
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)unit));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String string2 = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl4 = false;
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryInstrumentMarginRate(@Nullable CThostFtdcInstrumentMarginRateField pMarginRate, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                Unit instrument2;
                Object code;
                boolean bl = false;
                if (pMarginRate != null && (code = ((CtpTdApi)object2).getMdApi().getCodeMap().get(pMarginRate.getInstrumentID())) != null && (instrument2 = ((CtpTdApi)object2).getInstruments().get(code)) != null && instrument2.getMarginRate() == null) {
                    instrument2.setMarginRate(Translator.INSTANCE.futuresMarginRateC2A(pMarginRate, (String)code));
                }
                if (bIsLast) {
                    code = request.getContinuation();
                    instrument2 = Unit.INSTANCE;
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    code.resumeWith(Result.constructor-impl((Object)instrument2));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String code = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl4 = false;
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryInstrumentCommissionRate(@Nullable CThostFtdcInstrumentCommissionRateField pCommissionRate, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                List commissionRate;
                Object code;
                boolean bl = false;
                if (pCommissionRate != null) {
                    String string = ((CtpTdApi)object2).getMdApi().getCodeMap().get(pCommissionRate.getInstrumentID());
                    code = string == null ? pCommissionRate.getInstrumentID() : string;
                    Intrinsics.checkNotNullExpressionValue(code, (String)"code");
                    commissionRate = Translator.INSTANCE.futuresCommissionRateC2A(pCommissionRate, (String)code);
                    Security instrument2 = ((CtpTdApi)object2).getInstruments().get(code);
                    Ref.ObjectRef standardCode = new Ref.ObjectRef();
                    standardCode.element = "";
                    if (instrument2 == null) {
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv = ((CtpTdApi)object2).getInstruments().values();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Security it = (Security)element$iv$iv;
                            boolean bl2 = false;
                            if (!(it.getType() != SecurityType.FUTURES ? false : (it.getCommissionRate() != null ? false : Intrinsics.areEqual((Object)it.getProductId(), code)))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List instrumentList = (List)destination$iv$iv;
                        $this$filter$iv = instrumentList;
                        $i$f$filter = false;
                        if (!$this$filter$iv.isEmpty()) {
                            Iterable $this$forEach$iv = instrumentList;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                Security it = (Security)element$iv;
                                boolean bl3 = false;
                                it.setCommissionRate((CommissionRate)commissionRate);
                            }
                            standardCode.element = ((Security)CollectionsKt.first((List)instrumentList)).getCode();
                        }
                    } else if (instrument2.getCommissionRate() == null) {
                        instrument2.setCommissionRate((CommissionRate)commissionRate);
                        standardCode.element = instrument2.getCode();
                    }
                    if (StringsKt.startsWith$default((String)((String)standardCode.element), (String)"CFFEX", (boolean)false, (int)2, null)) {
                        Job job2 = BuildersKt.launch$default((CoroutineScope)((CtpTdApi)object2).scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((CtpTdApi)object2, (Ref.ObjectRef<String>)standardCode, null){
                            int label;
                            final /* synthetic */ CtpTdApi this$0;
                            final /* synthetic */ Ref.ObjectRef<String> $standardCode;
                            {
                                this.this$0 = $receiver;
                                this.$standardCode = $standardCode;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = UtilsKt.runWithRetry((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, this.$standardCode, null){
                                            int label;
                                            final /* synthetic */ CtpTdApi this$0;
                                            final /* synthetic */ Ref.ObjectRef<String> $standardCode;
                                            {
                                                this.this$0 = $receiver;
                                                this.$standardCode = $standardCode;
                                                super(1, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = CtpTdApi.access$queryFuturesOrderCommissionRate(this.this$0, (String)this.$standardCode.element, (Continuation)this);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, (Function1)new Function1<Exception, Unit>(this.this$0, this.$standardCode){
                                            final /* synthetic */ CtpTdApi this$0;
                                            final /* synthetic */ Ref.ObjectRef<String> $standardCode;
                                            {
                                                this.this$0 = $receiver;
                                                this.$standardCode = $standardCode;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Exception e) {
                                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                                CtpTdApi.access$postBrokerEvent(this.this$0, BrokerEventType.TD_ERROR, "\u67e5\u8be2\u671f\u8d27\u7533\u62a5\u624b\u7eed\u8d39\u5931\u8d25\uff1a" + (String)this.$standardCode.element + ", " + e);
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        TypeIntrinsics.asMutableList((Object)request.getData()).add(job2);
                    }
                }
                if (bIsLast) {
                    code = request.getContinuation();
                    commissionRate = TypeIntrinsics.asMutableList((Object)request.getData());
                    boolean bl4 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl5 = false;
                    code.resumeWith(Result.constructor-impl((Object)commissionRate));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String commissionRate = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl6 = false;
                Result.Companion companion = Result.Companion;
                boolean bl7 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryInstrumentOrderCommRate(@Nullable CThostFtdcInstrumentOrderCommRateField pOrderCommRate, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                boolean $i$f$forEach;
                Object $this$forEach$iv;
                Object object3;
                boolean bl = false;
                if (pOrderCommRate != null && pOrderCommRate.getHedgeFlag() == jctpConstants.THOST_FTDC_HF_Speculation) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Security it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = ((CtpTdApi)object2).getInstruments().values();
                    boolean $i$f$filter = false;
                    object3 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Security)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it.getType() != SecurityType.FUTURES ? false : (it.getCommissionRate() == null ? false : Intrinsics.areEqual((Object)it.getProductId(), (Object)pOrderCommRate.getInstrumentID())))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        CommissionRate commissionRate;
                        it = (Security)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it.getCommissionRate());
                        collection.add(commissionRate);
                    }
                    List commissionList = (List)destination$iv$iv;
                    $this$forEach$iv = commissionList;
                    $i$f$forEach = false;
                    object3 = $this$forEach$iv.iterator();
                    while (object3.hasNext()) {
                        Object element$iv = object3.next();
                        CommissionRate it2 = (CommissionRate)element$iv;
                        boolean bl4 = false;
                        it2.setOrderInsertFeeByTrade(pOrderCommRate.getOrderCommByTrade());
                        it2.setOrderInsertFeeByVolume(pOrderCommRate.getOrderCommByVolume());
                        it2.setOrderCancelFeeByTrade(pOrderCommRate.getOrderActionCommByTrade());
                        it2.setOrderCancelFeeByVolume(pOrderCommRate.getOrderActionCommByVolume());
                    }
                }
                if (bIsLast) {
                    Continuation<?> continuation = request.getContinuation();
                    $this$forEach$iv = Unit.INSTANCE;
                    $i$f$forEach = false;
                    object3 = Result.Companion;
                    boolean bl5 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)$this$forEach$iv));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String $this$forEach$iv = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl6 = false;
                Result.Companion companion = Result.Companion;
                boolean bl7 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryOptionInstrCommRate(@Nullable CThostFtdcOptionInstrCommRateField pCommissionRate, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                Continuation<?> commissionRate;
                boolean bl = false;
                if (pCommissionRate != null) {
                    void $this$filterTo$iv$iv;
                    commissionRate = Translator.INSTANCE.optionsCommissionRateC2A(pCommissionRate);
                    Iterable $this$filter$iv = ((CtpTdApi)object2).getInstruments().values();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Security it = (Security)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it.getType() != SecurityType.OPTIONS ? false : (it.getCommissionRate() != null ? false : Intrinsics.areEqual((Object)it.getProductId(), (Object)pCommissionRate.getInstrumentID())))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List instrumentList = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = instrumentList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Security it = (Security)element$iv;
                        boolean bl3 = false;
                        it.setCommissionRate(commissionRate);
                    }
                }
                if (bIsLast) {
                    commissionRate = request.getContinuation();
                    Unit unit = Unit.INSTANCE;
                    boolean $this$forEach$iv = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    commissionRate.resumeWith(Result.constructor-impl((Object)unit));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String commissionRate = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl5 = false;
                Result.Companion companion = Result.Companion;
                boolean bl6 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void OnRspQryOptionInstrTradeCost(@Nullable CThostFtdcOptionInstrTradeCostField pOptionMargin, @Nullable CThostFtdcRspInfoField pRspInfo, int nRequestID, boolean bIsLast) {
            Object object = (RequestContinuation)CtpTdApi.this.requestMap.get(nRequestID);
            if (object == null) {
                return;
            }
            Object object2 = object;
            RequestContinuation request = object2;
            object2 = CtpTdApi.this;
            object = CtpTdApi.this;
            boolean $i$f$checkRspInfo = false;
            if (pRspInfo == null || pRspInfo.getErrorID() == 0) {
                Unit instrument2;
                Object code;
                boolean bl = false;
                if (pOptionMargin != null) {
                    String string = ((CtpTdApi)object2).getMdApi().getCodeMap().get(pOptionMargin.getInstrumentID());
                    code = string == null ? pOptionMargin.getInstrumentID() : string;
                    instrument2 = ((CtpTdApi)object2).getInstruments().get(code);
                    if (instrument2 != null && instrument2.getMarginRate() == null) {
                        Intrinsics.checkNotNullExpressionValue(code, (String)"code");
                        instrument2.setMarginRate(Translator.INSTANCE.optionsMarginC2A(pOptionMargin, (String)code));
                    }
                }
                if (bIsLast) {
                    code = request.getContinuation();
                    instrument2 = Unit.INSTANCE;
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    code.resumeWith(Result.constructor-impl((Object)instrument2));
                    ((CtpTdApi)object2).requestMap.remove(nRequestID);
                }
            } else {
                void errorMsg;
                int n = pRspInfo.getErrorID();
                String string = pRspInfo.getErrorMsg();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pRspInfo.errorMsg");
                String instrument2 = string;
                int errorCode = n;
                boolean bl = false;
                Continuation<?> continuation = request.getContinuation();
                Throwable throwable = new Exception((String)errorMsg + " (" + errorCode + ')');
                boolean bl4 = false;
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                ((CtpTdApi)object).requestMap.remove(nRequestID);
            }
        }

        public static final /* synthetic */ Object access$reqAuthenticate(CtpTdSpi $this, Continuation $completion) {
            return $this.reqAuthenticate((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$reqUserLogin(CtpTdSpi $this, Continuation $completion) {
            return $this.reqUserLogin((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$reqSettlementInfoConfirm(CtpTdSpi $this, Continuation $completion) {
            return $this.reqSettlementInfoConfirm((Continuation<? super Unit>)$completion);
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[OrderStatus.values().length];
                nArray[OrderStatus.SUBMITTING.ordinal()] = 1;
                nArray[OrderStatus.ACCEPTED.ordinal()] = 2;
                nArray[OrderStatus.PARTIALLY_FILLED.ordinal()] = 3;
                nArray[OrderStatus.CANCELED.ordinal()] = 4;
                nArray[OrderStatus.ERROR.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[OrderOffset.values().length];
                nArray[OrderOffset.CLOSE_TODAY.ordinal()] = 1;
                nArray[OrderOffset.CLOSE_YESTERDAY.ordinal()] = 2;
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[Direction.values().length];
                nArray[Direction.LONG.ordinal()] = 1;
                nArray[Direction.SHORT.ordinal()] = 2;
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[Direction.values().length];
            nArray[Direction.LONG.ordinal()] = 1;
            nArray[Direction.SHORT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OrderType.values().length];
            nArray[OrderType.LIMIT.ordinal()] = 1;
            nArray[OrderType.FAK.ordinal()] = 2;
            nArray[OrderType.FOK.ordinal()] = 3;
            nArray[OrderType.MARKET.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[SecurityType.values().length];
            nArray[SecurityType.FUTURES.ordinal()] = 1;
            nArray[SecurityType.OPTIONS.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[MarginPriceType.values().length];
            nArray[MarginPriceType.TODAY_SETTLEMENT_PRICE.ordinal()] = 1;
            nArray[MarginPriceType.LAST_PRICE.ordinal()] = 2;
            nArray[MarginPriceType.MAX_PRE_SETTLEMENT_PRICE_LAST_PRICE.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[OrderStatus.values().length];
            nArray[OrderStatus.ACCEPTED.ordinal()] = 1;
            nArray[OrderStatus.PARTIALLY_FILLED.ordinal()] = 2;
            nArray[OrderStatus.FILLED.ordinal()] = 3;
            nArray[OrderStatus.CANCELED.ordinal()] = 4;
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[OrderOffset.values().length];
            nArray[OrderOffset.OPEN.ordinal()] = 1;
            nArray[OrderOffset.CLOSE.ordinal()] = 2;
            nArray[OrderOffset.CLOSE_YESTERDAY.ordinal()] = 3;
            nArray[OrderOffset.CLOSE_TODAY.ordinal()] = 4;
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

