/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.handlers;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.raml.jaxrs.handlers.PojoToRamlProperty;
import org.raml.pojotoraml.ClassParser;
import org.raml.pojotoraml.Property;
import org.raml.utilities.types.Cast;

public class BeanLikeClassParser
implements ClassParser {
    public List<Property> properties(Class<?> classToParse) {
        Class currentInterface = Cast.toClass(classToParse);
        Method[] methods = currentInterface.getDeclaredMethods();
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Method method : methods) {
            if (!method.getName().startsWith("get") || "getClass".equals(method.getName()) && method.getParameterTypes().length == 0) continue;
            String badlyCasedfieldName = method.getName().substring(3);
            properties.add(new BeanProperty(badlyCasedfieldName, method));
        }
        return properties;
    }

    public Collection<Type> parentClasses(Class<?> classToParse) {
        Class currentInterface = Cast.toClass(classToParse);
        Class<?>[] interfaces = currentInterface.getInterfaces();
        ArrayList<Type> superTypes = new ArrayList<Type>();
        Collections.addAll(superTypes, interfaces);
        return superTypes;
    }

    private static class BeanProperty
    implements PojoToRamlProperty {
        private final String badlyCasedfieldName;
        private final Method method;

        public BeanProperty(String badlyCasedfieldName, Method method) {
            this.badlyCasedfieldName = badlyCasedfieldName;
            this.method = method;
        }

        public String name() {
            return Character.toLowerCase(this.badlyCasedfieldName.charAt(0)) + this.badlyCasedfieldName.substring(1);
        }

        public Type type() {
            return this.method.getGenericReturnType();
        }

        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return Optional.fromNullable(this.method.getAnnotation(annotationType));
        }
    }
}

