/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.raml.api.RamlParameter;
import org.raml.api.ScalarType;
import org.raml.builder.NodeBuilder;
import org.raml.builder.ParameterBuilder;
import org.raml.builder.PropertyValueBuilder;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.types.TypeRegistry;

public class ParameterEmitter {
    private final TypeRegistry typeRegistry;
    private final TypeHandler typeHandler;

    public ParameterEmitter(TypeRegistry typeRegistry, TypeHandler typeHandler) {
        this.typeRegistry = typeRegistry;
        this.typeHandler = typeHandler;
    }

    public ParameterBuilder emit(RamlParameter parameter) throws IOException {
        ParameterBuilder parameterBuilder = ParameterBuilder.parameter((String)parameter.getName()).ofType(this.typeHandler.writeType(this.typeRegistry, parameter.getEntity()));
        if (parameter.getDefaultValue().isPresent()) {
            parameterBuilder.with(new NodeBuilder[]{PropertyValueBuilder.property((String)"default", (String)((String)parameter.getDefaultValue().get())), PropertyValueBuilder.property((String)"required", (boolean)false)});
        } else if (parameter.getAnnotation(NotNull.class).isPresent()) {
            parameterBuilder.with(new NodeBuilder[]{PropertyValueBuilder.property((String)"required", (boolean)true)});
        }
        Optional ramlType = ScalarType.fromType((Type)parameter.getEntity().getType());
        if (ramlType.isPresent()) {
            if (ramlType.get() == ScalarType.INTEGER || ramlType.get() == ScalarType.NUMBER) {
                if (parameter.getAnnotation(Min.class).isPresent()) {
                    parameterBuilder.with(new NodeBuilder[]{PropertyValueBuilder.property((String)"minimum", (long)((Min)parameter.getAnnotation(Min.class).get()).value())});
                }
                if (parameter.getAnnotation(Max.class).isPresent()) {
                    parameterBuilder.with(new NodeBuilder[]{PropertyValueBuilder.property((String)"maximum", (long)((Max)parameter.getAnnotation(Max.class).get()).value())});
                }
            }
            if (parameter.getAnnotation(Size.class).isPresent() && ramlType.get() == ScalarType.STRING) {
                parameterBuilder.with(new NodeBuilder[]{PropertyValueBuilder.property((String)"minLength", (long)((Size)parameter.getAnnotation(Size.class).get()).min()), PropertyValueBuilder.property((String)"maxLength", (long)((Size)parameter.getAnnotation(Size.class).get()).max())});
            }
        }
        return parameterBuilder;
    }
}

