/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.types;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.api.RamlEntity;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.builder.RamlDocumentBuilder;
import org.raml.jaxrs.types.Descriptor;
import org.raml.jaxrs.types.RamlType;

public class TypeRegistry {
    private Map<String, RamlType> types = new HashMap<String, RamlType>();

    public RamlType registerType(String name, final RamlEntity type) {
        if (this.types.containsKey(name)) {
            return this.types.get(name);
        }
        RamlType ramlType = new RamlType(type.getType(), new Descriptor(){

            @Override
            public Optional<String> describe() {
                return type.getDescription();
            }
        });
        if (ramlType.isRamlScalarType()) {
            return ramlType;
        }
        this.types.put(name, ramlType);
        return ramlType;
    }

    public void writeAll(List<RamlSupportedAnnotation> supportedAnnotations, Package topPackage, RamlDocumentBuilder documentBuilder) throws IOException {
        for (RamlType ramlType : this.types.values()) {
            ramlType.write(supportedAnnotations, topPackage, documentBuilder);
        }
        for (RamlType ramlType : RamlType.getAllTypes().values()) {
            ramlType.emitExamples();
        }
    }
}

