package example.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

@JsonDeserialize(
    using = Limb.LimbDeserializer.class
)
@JsonSerialize(
    using = Limb.Serializer.class
)
public interface Limb {
  Arm getArm();

  boolean isArm();

  Leg getLeg();

  boolean isLeg();

  class Serializer extends StdSerializer<Limb> {
    public Serializer() {
      super(Limb.class);}

    public void serialize(Limb object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isArm()) {
        jsonGenerator.writeObject(object.getArm());
        return;
      }
      if ( object.isLeg()) {
        jsonGenerator.writeObject(object.getLeg());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class LimbDeserializer extends StdDeserializer<Limb> {
    public LimbDeserializer() {
      super(Limb.class);}

    private boolean looksLikeArm(Map<String, Object> map) {
      return map.keySet().containsAll(Arrays.asList("fingers"));
    }

    private boolean looksLikeLeg(Map<String, Object> map) {
      return map.keySet().containsAll(Arrays.asList("toes"));
    }

    public Limb deserialize(JsonParser jsonParser, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      ObjectMapper mapper  = new ObjectMapper();
      Map<String, Object> map = mapper.readValue(jsonParser, Map.class);
      if ( looksLikeArm(map) ) return new LimbImpl(mapper.convertValue(map, ArmImpl.class));
      if ( looksLikeLeg(map) ) return new LimbImpl(mapper.convertValue(map, LegImpl.class));
      throw new IOException("Can't figure out type of object" + map);
    }
  }
}
