package example.resources;

import example.model.Animal;
import example.support.ResponseDelegate;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;

@Path("/animals")
public interface Animals {
  @GET
  @Produces("application/xml")
  @Consumes
  GetAnimalsResponse getAnimals(@QueryParam("type") String type);

  @GET
  @Path("/{id}")
  @Produces("application/xml")
  @Consumes
  GetAnimalsByIdResponse getAnimalsById(@PathParam("id") String id);

  @PUT
  @Path("/{id}")
  @Consumes("application/xml")
  PutAnimalsByIdResponse putAnimalsById(@PathParam("id") String id, Animal entity);

  class GetAnimalsResponse extends ResponseDelegate {
    private GetAnimalsResponse(Response response, Object entity) {
      super(response, entity);
    }

    private GetAnimalsResponse(Response response) {
      super(response);
    }

    public static GetAnimalsResponse respond200WithApplicationXml(List<Animal> entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/xml");
      GenericEntity<List<Animal>> wrappedEntity = new GenericEntity<List<Animal>>(entity){};
      responseBuilder.entity(wrappedEntity);
      return new GetAnimalsResponse(responseBuilder.build(), wrappedEntity);
    }
  }

  class GetAnimalsByIdResponse extends ResponseDelegate {
    private GetAnimalsByIdResponse(Response response, Object entity) {
      super(response, entity);
    }

    private GetAnimalsByIdResponse(Response response) {
      super(response);
    }

    public static GetAnimalsByIdResponse respond200WithApplicationXml(Animal entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/xml");
      responseBuilder.entity(entity);
      return new GetAnimalsByIdResponse(responseBuilder.build(), entity);
    }
  }

  class PutAnimalsByIdResponse extends ResponseDelegate {
    private PutAnimalsByIdResponse(Response response, Object entity) {
      super(response, entity);
    }

    private PutAnimalsByIdResponse(Response response) {
      super(response);
    }

    public static PutAnimalsByIdResponse respond200() {
      Response.ResponseBuilder responseBuilder = Response.status(200);
      return new PutAnimalsByIdResponse(responseBuilder.build());
    }
  }
}
