package example.model;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(
    namespace = "##default",
    name = "Invertebrate"
)
public class InvertebrateImpl implements Invertebrate {
  @XmlElement(
      name = "animalType",
      namespace = "##default"
  )
  private String animalType;

  @XmlAttribute(
      name = "specimenName",
      namespace = "foo.bar"
  )
  private String specimenName;

  @XmlElement(
      name = "gender",
      namespace = "##default"
  )
  private Gender gender;

  @XmlElementWrapper(
      name = "siblings"
  )
  @XmlElement(
      name = "example.model.AnimalImpl",
      namespace = "##default"
  )
  private List<Animal> siblings;

  @XmlElement(
      name = "mother",
      namespace = "##default"
  )
  private Animal mother;

  @XmlElement(
      name = "ancestor",
      namespace = "##default"
  )
  private Ancestor ancestor;

  @XmlElement(
      name = "squishy",
      namespace = "##default"
  )
  private boolean squishy;

  public String getAnimalType() {
    return this.animalType;
  }

  public void setAnimalType(String animalType) {
    this.animalType = animalType;
  }

  public String getSpecimenName() {
    return this.specimenName;
  }

  public void setSpecimenName(String specimenName) {
    this.specimenName = specimenName;
  }

  public Gender getGender() {
    return this.gender;
  }

  public void setGender(Gender gender) {
    this.gender = gender;
  }

  public List<Animal> getSiblings() {
    return this.siblings;
  }

  public void setSiblings(List<Animal> siblings) {
    this.siblings = siblings;
  }

  public Animal getMother() {
    return this.mother;
  }

  public void setMother(Animal mother) {
    this.mother = mother;
  }

  public Ancestor getAncestor() {
    return this.ancestor;
  }

  public void setAncestor(Ancestor ancestor) {
    this.ancestor = ancestor;
  }

  public boolean getSquishy() {
    return this.squishy;
  }

  public void setSquishy(boolean squishy) {
    this.squishy = squishy;
  }
}
