package example.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(
    namespace = "##default",
    name = "Ancestor"
)
public class AncestorImpl implements Ancestor {
  @XmlElements({
      @XmlElement(name = "Insect", type = AncestorImpl.class),
      @XmlElement(name = "Invertebrate", type = AncestorImpl.class)
  })
  private Object anyType;

  private AncestorImpl() {
    this.anyType = null;
  }

  public AncestorImpl(Insect insect) {
    this.anyType = insect;
  }

  public AncestorImpl(Invertebrate invertebrate) {
    this.anyType = invertebrate;
  }

  public Insect getInsect() {
    if ( !(anyType instanceof  Insect)) throw new IllegalStateException("fetching wrong type out of the union: example.model.Insect");
    return (Insect) anyType;
  }

  public boolean isInsect() {
    return anyType instanceof Insect;
  }

  public Invertebrate getInvertebrate() {
    if ( !(anyType instanceof  Invertebrate)) throw new IllegalStateException("fetching wrong type out of the union: example.model.Invertebrate");
    return (Invertebrate) anyType;
  }

  public boolean isInvertebrate() {
    return anyType instanceof Invertebrate;
  }
}
