package example.model;

import java.lang.IllegalStateException;
import java.lang.Object;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(
    namespace = "##default",
    name = "Ancestor"
)
public class Ancestor {
  @XmlElements({
      @XmlElement(name = "Insect", type = InsectImpl.class),
      @XmlElement(name = "Invertebrate", type = InvertebrateImpl.class)
  })
  private Object anyType;

  private Ancestor() {
    this.anyType = null;
  }

  public Ancestor(Insect insect) {
    this.anyType = insect;
  }

  public Ancestor(Invertebrate invertebrate) {
    this.anyType = invertebrate;
  }

  public Insect getInsect() {
    if ( !(anyType instanceof  Insect)) throw new IllegalStateException("fetching wrong type out of the union: Insect");
    return (Insect) anyType;
  }

  public boolean isInsect() {
    return anyType instanceof Insect;
  }

  public Invertebrate getInvertebrate() {
    if ( !(anyType instanceof  Invertebrate)) throw new IllegalStateException("fetching wrong type out of the union: Invertebrate");
    return (Invertebrate) anyType;
  }

  public boolean isInvertebrate() {
    return anyType instanceof Invertebrate;
  }
}
