/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.raml.model.Raml;
import org.raml.model.Raml2;
import org.raml.model.Resource;
import org.raml.model.ResourceType;
import org.raml.model.TraitModel;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.loader.ClassPathResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.TemplateResolver;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlDocumentBuilder;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public final class PreservingTemplatesBuilder
extends RamlDocumentBuilder {
    protected TagResolver[] rs;
    protected HashMap<String, Exception> errorMap = new HashMap();

    @Override
    public void onCustomTagError(Tag tag, Node node, String message) {
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag)) {
            if (message.startsWith("Include file is empty")) {
                return;
            }
            throw new RuntimeException("resource not found: " + ((ScalarNode)node).getValue());
        }
    }

    @Override
    public TemplateResolver getTemplateResolver() {
        if (this.templateResolver == null) {
            this.templateResolver = new TemplateResolver(this.getResourceLoader(), this, false);
        }
        return this.templateResolver;
    }

    public PreservingTemplatesBuilder() {
        super((Class<? extends Raml>)Raml2.class, (ResourceLoader)new ClassPathResourceLoader(), new TagResolver[0]);
        this.rs = new TagResolver[0];
    }

    public PreservingTemplatesBuilder(ResourceLoader resourceLoader, TagResolver[] tagResolvers) {
        super((Class<? extends Raml>)Raml2.class, resourceLoader, tagResolvers);
        this.rs = tagResolvers;
    }

    public HashMap<String, Exception> getErrorMap() {
        return this.errorMap;
    }

    @Override
    public Raml2 build(Reader content) {
        Object partialType;
        IncludedResourceOrTraitBuilder includedResourceOrTraitBuilder;
        MappingNode z;
        LinkedHashMap<String, ResourceType> resourceTypes = new LinkedHashMap<String, ResourceType>();
        LinkedHashMap<String, TraitModel> traits = new LinkedHashMap<String, TraitModel>();
        Raml2 build = (Raml2)super.build(content);
        Map<String, MappingNode> resourceTypesMap = this.getTemplateResolver().getResourceTypesMap();
        for (String s : resourceTypesMap.keySet()) {
            try {
                z = resourceTypesMap.get(s);
                includedResourceOrTraitBuilder = new IncludedResourceOrTraitBuilder(ResourceType.class, this.getResourceLoader(), new TagResolver[]{new IncludeResolver()});
                partialType = (ResourceType)includedResourceOrTraitBuilder.build(z);
                ((Resource)partialType).setRelativeUri(s);
                resourceTypes.put(s, (ResourceType)partialType);
            }
            catch (Exception e) {
                this.errorMap.put(s, e);
            }
        }
        resourceTypesMap = this.getTemplateResolver().getTraitsMap();
        for (String s : resourceTypesMap.keySet()) {
            z = resourceTypesMap.get(s);
            includedResourceOrTraitBuilder = new IncludedResourceOrTraitBuilder(TraitModel.class, this.getResourceLoader(), new TagResolver[]{new IncludeResolver()});
            partialType = (TraitModel)includedResourceOrTraitBuilder.build(z);
            traits.put(s, (TraitModel)partialType);
        }
        build.setResourceTypesModel(resourceTypes);
        build.setTraitsModel(traits);
        return build;
    }

    private final class IncludedResourceOrTraitBuilder<T>
    extends YamlDocumentBuilder<T> {
        private IncludedResourceOrTraitBuilder(Class<T> documentClass, ResourceLoader resourceLoader, TagResolver[] tagResolvers) {
            super(documentClass, resourceLoader, tagResolvers);
        }

        @Override
        public void onMappingNodeStart(MappingNode mappingNode, TupleType tupleType) {
            super.onMappingNodeStart(mappingNode, tupleType);
            if (this.getDocumentContext().peek() instanceof Resource) {
                Resource resource = (Resource)this.getDocumentContext().peek();
                PreservingTemplatesBuilder.this.getTemplateResolver().resolve(mappingNode, resource.getRelativeUri(), resource.getUri());
            } else if (this.isBodyBuilder(this.getBuilderContext().peek())) {
                PreservingTemplatesBuilder.this.getMediaTypeResolver().resolve(mappingNode);
            }
        }

        private boolean isBodyBuilder(NodeBuilder builder) {
            try {
                Field valueType = builder.getClass().getDeclaredField("valueClass");
                valueType.setAccessible(true);
                return valueType.get(builder) != null && ((Class)valueType.get(builder)).getName().equals("org.raml.model.MimeType");
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }

        @Override
        protected void preBuildProcess() {
            PreservingTemplatesBuilder.this.getTemplateResolver().init(this.getRootNode());
            PreservingTemplatesBuilder.this.getMediaTypeResolver().beforeDocumentStart(this.getRootNode());
        }
    }
}

