/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.PojoTupleRule;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationMessage;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class MapTupleRule
extends DefaultTupleRule<ScalarNode, MappingNode> {
    private Class valueType;
    private String fieldName;
    private final Set<String> keys = new HashSet<String>();

    public MapTupleRule(String fieldName, Class valueType) {
        super(fieldName, new DefaultScalarTupleHandler(fieldName));
        this.valueType = valueType;
    }

    public MapTupleRule(Class<?> valueType, NodeRuleFactory nodeRuleFactory) {
        this(null, valueType);
        this.setNodeRuleFactory(nodeRuleFactory);
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        DefaultTupleRule tupleRule = ReflectionUtils.isPojo(this.valueType) ? new PojoTupleRule(this.fieldName, this.valueType, this.getNodeRuleFactory()) : this.getScalarRule();
        tupleRule.setParentTupleRule(this);
        return tupleRule;
    }

    protected DefaultTupleRule getScalarRule() {
        return new SimpleRule(this.getFieldName(), this.getValueType());
    }

    protected Class getValueType() {
        return this.valueType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setValueType(Type valueType) {
        this.valueType = (Class)valueType;
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        this.fieldName = key.getValue();
        return super.validateKey(key);
    }

    public void checkDuplicate(ScalarNode key, List<ValidationResult> validationResults) {
        if (this.keys.contains(key.getValue())) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getDuplicateRuleMessage(this.getName()), (Node)key));
        } else {
            this.keys.add(key.getValue());
        }
    }
}

