/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.util.ArrayList;
import org.raml.model.Resource;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.TypeExtraHandler;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.utils.ConvertUtils;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ScalarTupleBuilder
extends DefaultTupleBuilder<ScalarNode, ScalarNode> {
    private String fieldName;
    private Class<?> type;
    private String includeField;

    public ScalarTupleBuilder(String field, Class<?> type, String includeField) {
        super(new DefaultScalarTupleHandler(field));
        this.type = type;
        this.includeField = includeField;
    }

    @Override
    public TupleHandler getHandler() {
        return super.getHandler();
    }

    @Override
    public Object buildValue(Object parent, ScalarNode node) {
        String value = node.getValue();
        Object converted = ConvertUtils.convertTo(value, this.type);
        String unalias = this.unalias(parent, this.fieldName);
        ReflectionUtils.setProperty(parent, unalias, converted);
        if (this.includeField != null && this.includeField.length() > 0 && node instanceof IncludeResolver.IncludeScalarNode) {
            IncludeResolver.IncludeScalarNode sc = (IncludeResolver.IncludeScalarNode)node;
            ReflectionUtils.setProperty(parent, this.includeField, sc.getIncludeName());
        }
        if (this.fieldName != null && this.fieldName.equals("type") && parent instanceof Resource) {
            ArrayList<ScalarNode> nm = new ArrayList<ScalarNode>();
            nm.add(node);
            new TypeExtraHandler().handle(parent, new SequenceNode(Tag.BOOL, nm, null));
        }
        return parent;
    }

    @Override
    public void buildKey(Object parent, ScalarNode tuple) {
        this.fieldName = tuple.getValue();
    }
}

