/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.utils.ConvertUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class ImplicitMapEntryBuilder
extends DefaultTupleBuilder<ScalarNode, Node> {
    private String fieldName;
    private String keyValue;
    private Class<?> keyClass;
    private Class valueClass;

    public ImplicitMapEntryBuilder(String fieldName, Class<?> keyClass, Class<?> valueClass) {
        super(new DefaultScalarTupleHandler(fieldName));
        this.fieldName = fieldName;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    public NodeBuilder getBuilderForTuple(NodeTuple tuple) {
        if (this.builders.isEmpty()) {
            this.addBuildersFor(this.valueClass);
        }
        return super.getBuilderForTuple(tuple);
    }

    @Override
    public Object buildValue(Object parent, Node node) {
        try {
            Map actualParent = (Map)new PropertyUtilsBean().getProperty(parent, this.fieldName);
            Object newValue = this.valueClass.newInstance();
            Object key = ConvertUtils.convertTo(this.keyValue, this.keyClass);
            actualParent.put(key, newValue);
            this.processPojoAnnotations(newValue, key, parent);
            return newValue;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void buildKey(Object parent, ScalarNode tuple) {
        this.keyValue = tuple.getValue();
    }

    public String toString() {
        return this.keyValue;
    }
}

