/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.raml.parser.annotation.Key;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Parent;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.annotation.TransformHandler;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.builder.TupleBuilderFactory;
import org.raml.parser.resolver.DefaultTupleHandler;
import org.raml.parser.resolver.ITransformHandler;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;

public class DefaultTupleBuilder<K extends Node, V extends Node>
implements TupleBuilder<K, V> {
    protected Map<String, TupleBuilder<?, ?>> builders = new HashMap();
    private NodeBuilder<?> parent;
    private TupleHandler handler;

    public DefaultTupleBuilder(TupleHandler tupleHandler) {
        this.setHandler(tupleHandler);
    }

    @Override
    public NodeBuilder getBuilderForTuple(NodeTuple tuple) {
        if (this.builders == null || this.builders.isEmpty()) {
            return new DefaultTupleBuilder<K, V>(new DefaultTupleHandler());
        }
        for (TupleBuilder<?, ?> tupleBuilder : this.builders.values()) {
            if (!tupleBuilder.getHandler().handles(tuple)) continue;
            return tupleBuilder;
        }
        throw new RuntimeException("Builder not found for " + tuple);
    }

    @Override
    public Object buildValue(Object parent, V node) {
        return parent;
    }

    @Override
    public void setHandler(TupleHandler handler) {
        this.handler = handler;
    }

    @Override
    public TupleHandler getHandler() {
        return this.handler;
    }

    @Override
    public void buildKey(Object parent, K tuple) {
    }

    @Override
    public void setParentNodeBuilder(NodeBuilder parentBuilder) {
        this.parent = parentBuilder;
    }

    @Override
    public void setNestedBuilders(Map<String, TupleBuilder<?, ?>> nestedBuilders) {
        this.builders = nestedBuilders;
    }

    public void addBuildersFor(Class<?> documentClass) {
        new TupleBuilderFactory().addBuildersTo(documentClass, this);
    }

    public NodeBuilder getParent() {
        return this.parent;
    }

    protected String unalias(Object pojo, String fieldName) {
        List<Field> declaredFields = ReflectionUtils.getInheritedFields(pojo.getClass());
        for (Field declaredField : declaredFields) {
            Scalar scalar = declaredField.getAnnotation(Scalar.class);
            Mapping mapping = declaredField.getAnnotation(Mapping.class);
            Sequence sequence = declaredField.getAnnotation(Sequence.class);
            if (!(scalar != null && scalar.alias() != null && scalar.alias().equals(fieldName) || mapping != null && mapping.alias() != null && mapping.alias().equals(fieldName)) && (sequence == null || sequence.alias() == null || !sequence.alias().equals(fieldName))) continue;
            return declaredField.getName();
        }
        return fieldName;
    }

    protected void processPojoAnnotations(Object pojo, Object keyFieldName, Object parent) {
        List<Field> declaredFields = ReflectionUtils.getInheritedFields(pojo.getClass());
        for (Field declaredField : declaredFields) {
            Key keyAnnotation = declaredField.getAnnotation(Key.class);
            Parent parentAnnotation = declaredField.getAnnotation(Parent.class);
            if (keyAnnotation != null) {
                TransformHandler annotation = declaredField.getAnnotation(TransformHandler.class);
                if (annotation != null) {
                    try {
                        ITransformHandler newInstance = annotation.value().newInstance();
                        keyFieldName = newInstance.handle(keyFieldName, pojo);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ReflectionUtils.setProperty(pojo, declaredField.getName(), keyFieldName);
            }
            if (parentAnnotation == null) continue;
            Object value = parent;
            if (!parentAnnotation.property().isEmpty()) {
                try {
                    value = PropertyUtils.getProperty((Object)parent, (String)parentAnnotation.property());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!declaredField.getType().isAssignableFrom(value.getClass())) continue;
            ReflectionUtils.setProperty(pojo, declaredField.getName(), value);
        }
    }
}

