/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model.validation;

import org.raml.model.validation.Validation;

public class MaximumIntegerValidation
implements Validation {
    private Integer maximum;

    public MaximumIntegerValidation(String maximum) {
        this.maximum = this.parse(maximum);
    }

    public Integer parse(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse number: " + value);
        }
    }

    @Override
    public boolean check(String input) {
        return this.maximum.compareTo(this.parse(input)) >= 0;
    }
}

