/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.raml.emitter.Dumper;
import org.raml.emitter.ResourceTypeEmitter;
import org.raml.emitter.SchemasEmitter;
import org.raml.emitter.SecuritySchemeEmitter;
import org.raml.emitter.TraitEmitter;
import org.raml.model.DocumentationItem;
import org.raml.model.Protocol;
import org.raml.model.Resource;
import org.raml.model.SecurityReference;
import org.raml.model.SecurityScheme;
import org.raml.model.Template;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.resolver.ResourceHandler;
import org.raml.parser.rule.BaseUriRule;
import org.raml.parser.rule.GlobalSchemasHandler;
import org.raml.parser.rule.GlobalSchemasRule;
import org.raml.parser.rule.SecurityReferenceSequenceRule;
import org.raml.parser.rule.UriParametersRule;

public class Raml {
    @Scalar(required=true)
    private String title;
    @Scalar
    private String version;
    @Scalar(rule=BaseUriRule.class)
    private String baseUri;
    @Sequence
    private List<Protocol> protocols = new ArrayList<Protocol>();
    @Mapping(rule=UriParametersRule.class)
    private Map<String, UriParameter> baseUriParameters = new HashMap<String, UriParameter>();
    @Scalar
    private String mediaType;
    @Sequence
    @Dumper(value=SecuritySchemeEmitter.class)
    private List<Map<String, SecurityScheme>> securitySchemes = new ArrayList<Map<String, SecurityScheme>>();
    @Sequence(rule=GlobalSchemasRule.class, extraHandler=GlobalSchemasHandler.class)
    @Dumper(value=SchemasEmitter.class)
    protected List<Map<String, String>> schemas = new ArrayList<Map<String, String>>();
    @Sequence
    @Dumper(value=ResourceTypeEmitter.class)
    private List<Map<String, Template>> resourceTypes;
    @Sequence
    @Dumper(value=TraitEmitter.class)
    private List<Map<String, Template>> traits;
    @Sequence(rule=SecurityReferenceSequenceRule.class)
    private List<SecurityReference> securedBy = new ArrayList<SecurityReference>();
    @Mapping(handler=ResourceHandler.class, implicit=true)
    private Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    @Sequence
    private List<DocumentationItem> documentation;

    public void setDocumentation(List<DocumentationItem> documentation) {
        this.documentation = documentation;
    }

    public List<DocumentationItem> getDocumentation() {
        return this.documentation;
    }

    public void setBaseUriParameters(Map<String, UriParameter> uriParameters) {
        this.baseUriParameters = uriParameters;
    }

    public void setResources(Map<String, Resource> resources) {
        this.resources = resources;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBasePath() {
        int start = this.baseUri.indexOf("//") + 2;
        if (start == -1) {
            start = 0;
        }
        start = this.baseUri.indexOf("/", start);
        return this.baseUri.substring(start);
    }

    public String getUri() {
        return "";
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public Map<String, UriParameter> getBaseUriParameters() {
        return this.baseUriParameters;
    }

    public List<Map<String, Template>> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(List<Map<String, Template>> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public List<Map<String, Template>> getTraits() {
        return this.traits;
    }

    public void setTraits(List<Map<String, Template>> traits) {
        this.traits = traits;
    }

    public List<Map<String, String>> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<Map<String, String>> schemas) {
        this.schemas = schemas;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    public List<Map<String, SecurityScheme>> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(List<Map<String, SecurityScheme>> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public List<SecurityReference> getSecuredBy() {
        return this.securedBy;
    }

    public void setSecuredBy(List<SecurityReference> securedBy) {
        this.securedBy = securedBy;
    }

    public Map<String, String> getConsolidatedSchemas() {
        HashMap<String, String> consolidated = new HashMap<String, String>();
        for (Map<String, String> map : this.getSchemas()) {
            consolidated.putAll(map);
        }
        return consolidated;
    }

    public Resource getResource(String path) {
        for (Resource resource : this.resources.values()) {
            Resource found;
            if (!path.startsWith(resource.getRelativeUri())) continue;
            if (path.length() == resource.getRelativeUri().length()) {
                return resource;
            }
            if (path.charAt(resource.getRelativeUri().length()) != '/' || (found = resource.getResource(path.substring(resource.getRelativeUri().length()))) == null) continue;
            return found;
        }
        return null;
    }
}

