/*
 * Decompiled with CFR 0.152.
 */
package org.raml.emitter;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.raml.emitter.Dumper;
import org.raml.emitter.IFilter;
import org.raml.emitter.IRAMLFieldDumper;
import org.raml.emitter.IRamlHierarchyTarget;
import org.raml.emitter.MapFilter;
import org.raml.model.DocumentationItem;
import org.raml.model.ParamType;
import org.raml.model.Protocol;
import org.raml.model.Raml;
import org.raml.model.SecurityReference;
import org.raml.model.parameter.AbstractParam;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.utils.ReflectionUtils;

public class RamlEmitterV2 {
    public static final String VERSION = "#%RAML 0.8\n";
    private static final String INDENTATION = "  ";
    private static final String YAML_SEQ = "- ";
    private static final String YAML_SEQ_START = "[";
    private static final String YAML_SEQ_END = "]";
    private static final String YAML_SEQ_SEP = ", ";
    private static final String YAML_MAP_SEP = ": ";
    private Field currentField;
    protected boolean isSeparated = true;
    protected IRamlHierarchyTarget writer;
    private boolean escape;

    public void dump(IRamlHierarchyTarget writer, Raml r) {
        this.isSeparated = true;
        this.writer = writer;
        String dump = this.dump(r);
        writer.writeRoot(dump);
    }

    public String dump(Raml raml) {
        StringBuilder dump = new StringBuilder(VERSION);
        int depth = 0;
        this.dumpPojo(dump, depth, raml);
        return dump.toString();
    }

    public void dumpPojo(StringBuilder dump, int depth, Object pojo) {
        List<Field> declaredFields = ReflectionUtils.getInheritedFields(pojo.getClass());
        pojo.getClass();
        for (Field declaredField : declaredFields) {
            declaredField.setAccessible(true);
            Scalar scalar = declaredField.getAnnotation(Scalar.class);
            Mapping mapping = declaredField.getAnnotation(Mapping.class);
            Sequence sequence = declaredField.getAnnotation(Sequence.class);
            Dumper dumper = declaredField.getAnnotation(Dumper.class);
            if (dumper != null) {
                try {
                    IRAMLFieldDumper newInstance = dumper.value().newInstance();
                    newInstance.dumpField(dump, depth, declaredField, pojo, this);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (scalar != null) {
                String includeField = scalar.includeField();
                this.dumpScalarField(dump, depth, declaredField, pojo, includeField);
                continue;
            }
            if (mapping != null) {
                boolean inlineLists = false;
                this.dumpMappingField(dump, depth, declaredField, mapping.implicit(), pojo, inlineLists);
                continue;
            }
            if (sequence == null) continue;
            this.dumpSequenceField(dump, depth, declaredField, pojo);
        }
    }

    private Object getFieldValue(Field field, Object pojo) {
        try {
            return field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void dumpSequenceField(StringBuilder dump, int depth, Field field, Object pojo) {
        if (!List.class.isAssignableFrom(field.getType())) {
            throw new RuntimeException("Only List can be sequence.");
        }
        this.currentField = field;
        List seq = (List)this.getFieldValue(field, pojo);
        if (seq == null || seq.size() == 0) {
            return;
        }
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type itemType = pType.getActualTypeArguments()[0];
            dump.append(this.indent(depth)).append(this.alias(field)).append(YAML_MAP_SEP);
            this.dumpSequenceItems(dump, depth, seq, itemType, false);
        }
    }

    void dumpSequenceItems(StringBuilder dump, int depth, List<?> seq, Type itemType, boolean inlineSeq) {
        if (itemType instanceof ParameterizedType) {
            this.generateSequenceOfMaps(dump, depth + 1, seq, (ParameterizedType)itemType);
            return;
        }
        if (this.customSequenceHandled(dump, depth + 1, seq, itemType)) {
            return;
        }
        if (ReflectionUtils.isPojo((Class)itemType)) {
            dump.append("\n");
            if (this.currentField.getName().equals("documentation")) {
                for (Object item : seq) {
                    DocumentationItem it = (DocumentationItem)item;
                    dump.append(this.indent(depth + 1)).append(YAML_SEQ).append("title: ").append(it.getTitle()).append("\n");
                    if (this.isSeparated) {
                        String origin = it.getOrigin();
                        if (origin == null) {
                            origin = "docs/" + it.getTitle().toLowerCase() + ".md";
                        }
                        dump.append(this.indent(depth + 2)).append("content: !include ").append(origin).append("\n");
                        if (this.writer == null) continue;
                        this.writer.write(origin, it.getContent());
                        continue;
                    }
                    dump.append(this.indent(depth + 2)).append("content: ").append(this.sanitizeScalarValue(depth + 2, it.getContent(), false)).append("\n");
                }
                return;
            }
            for (Object item : seq) {
                dump.append(this.indent(depth + 1)).append(YAML_SEQ).append("\n");
                this.dumpPojo(dump, depth + 2, item);
            }
        } else if (seq.size() > 2 && !this.currentField.getName().equals("is")) {
            dump.append("\n");
            for (Object item : seq) {
                dump.append(this.indent(depth + 1)).append(YAML_SEQ).append(this.sanitizeScalarValue(0, item, false)).append("\n");
            }
        } else {
            this.generateInlineSequence(dump, seq, inlineSeq);
        }
    }

    private boolean customSequenceHandled(StringBuilder dump, int depth, List seq, Type itemType) {
        if (itemType instanceof Class && SecurityReference.class.isAssignableFrom((Class)itemType)) {
            this.handleSecurityReference(dump, depth, seq);
        } else if (itemType instanceof Class && AbstractParam.class.isAssignableFrom((Class)itemType) && seq.size() == 1) {
            this.handleSingleParameterAsNoSeq(dump, depth, seq);
        } else {
            return false;
        }
        return true;
    }

    private void handleSingleParameterAsNoSeq(StringBuilder dump, int depth, List seq) {
        dump.append("\n");
        this.dumpPojo(dump, depth, seq.get(0));
    }

    private void handleSecurityReference(StringBuilder dump, int depth, List seq) {
        ArrayList<String> sm = new ArrayList<String>();
        for (SecurityReference r : seq) {
            if (r.getParameters().isEmpty()) {
                sm.add(r.getName());
                continue;
            }
            sm = null;
            break;
        }
        if (sm != null) {
            this.generateInlineSequence(dump, sm, false);
            return;
        }
        dump.append("\n");
        for (Object item : seq) {
            dump.append(this.indent(depth)).append(YAML_SEQ);
            dump.append(((SecurityReference)item).getName());
            if (((SecurityReference)item).getParameters().size() > 0) {
                dump.append(YAML_MAP_SEP).append("\n");
                this.dumpMap(dump, depth + 2, (Type)((Object)String.class), ((SecurityReference)item).getParameters(), false, false);
                continue;
            }
            dump.append("\n");
        }
    }

    private void generateSequenceOfMaps(StringBuilder dump, int depth, List seq, ParameterizedType itemType) {
        Type valueType;
        Type rawType = itemType.getRawType();
        if (rawType instanceof Class && Map.class.isAssignableFrom((Class)rawType) && (valueType = itemType.getActualTypeArguments()[1]) instanceof Class) {
            dump.append("\n");
            for (Object item : seq) {
                dump.append(this.indent(depth)).append(YAML_SEQ);
                this.dumpMap(dump, depth + 1, valueType, (Map)item, false, true);
            }
        }
    }

    private void generateInlineSequence(StringBuilder dump, List seq, boolean inlineSeq) {
        if (inlineSeq) {
            Object item = seq.get(0);
            dump.append(this.sanitizeScalarValue(0, item, false)).append("\n");
            return;
        }
        dump.append(YAML_SEQ_START);
        for (int i = 0; i < seq.size(); ++i) {
            Object item = seq.get(i);
            if (i == 0) {
                dump.append(' ');
            }
            dump.append(this.sanitizeScalarValue(0, item, false));
            dump.append(' ');
            if (i >= seq.size() - 1) continue;
            dump.append(YAML_SEQ_SEP);
        }
        dump.append(YAML_SEQ_END).append("\n");
    }

    protected void dumpMappingField(StringBuilder dump, int depth, Field field, boolean implicit, Object pojo, boolean inlineLists) {
        if (!Map.class.isAssignableFrom(field.getType())) {
            throw new RuntimeException("invalid type");
        }
        LinkedHashMap value = (LinkedHashMap)this.getFieldValue(field, pojo);
        MapFilter annotation = field.getAnnotation(MapFilter.class);
        if (annotation != null) {
            try {
                IFilter<?> newInstance = annotation.value().newInstance();
                LinkedHashMap q = new LinkedHashMap();
                for (Object a : value.keySet()) {
                    Object object = value.get(a);
                    if (!newInstance.accept(object)) continue;
                    q.put(a, object);
                }
                value = q;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (value == null || value.isEmpty()) {
            return;
        }
        boolean isSettings = false;
        if (field.getName().equals("settings")) {
            isSettings = true;
        }
        if (!implicit) {
            dump.append(this.indent(depth)).append(this.alias(field)).append(YAML_MAP_SEP).append("\n");
            ++depth;
        }
        ParameterizedType pType = (ParameterizedType)field.getGenericType();
        Type valueType = pType.getActualTypeArguments()[1];
        this.dumpMap(dump, depth, valueType, value, isSettings, false);
    }

    public void dumpMap(StringBuilder dump, int depth, Type valueType, Map value, boolean isSettings, boolean newLine) {
        Type rawType;
        Type listType = null;
        if (valueType instanceof ParameterizedType && (rawType = ((ParameterizedType)valueType).getRawType()) instanceof Class && List.class.isAssignableFrom((Class)rawType)) {
            listType = ((ParameterizedType)valueType).getActualTypeArguments()[0];
        }
        int k = newLine ? 0 : depth;
        for (Map.Entry entry : value.entrySet()) {
            dump.append(this.indent(k)).append(this.sanitizeScalarValue(depth, entry.getKey(), false));
            k = depth;
            dump.append(YAML_MAP_SEP);
            if (listType != null) {
                if (isSettings) {
                    boolean inlineSeq = false;
                    String string = entry.getKey().toString();
                    if (string.equals("authorizationUri") || string.equals("requestTokenUri") || string.equals("tokenCredentialsUri")) {
                        inlineSeq = true;
                    } else if (string.equals("accessTokenUri")) {
                        inlineSeq = true;
                    }
                    this.dumpSequenceItems(dump, depth, (List)entry.getValue(), listType, inlineSeq);
                    continue;
                }
                this.dumpSequenceItems(dump, depth, (List)entry.getValue(), listType, false);
                continue;
            }
            if (ReflectionUtils.isPojo((Class)valueType)) {
                dump.append("\n");
                this.dumpPojo(dump, depth + 1, entry.getValue());
                continue;
            }
            dump.append(this.sanitizeScalarValue(depth + 1, entry.getValue(), true)).append("\n");
        }
    }

    public void dumpMapInSeq(StringBuilder dump, int depth, Type valueType, Map value, boolean isSettings, boolean newLine) {
        Type rawType;
        Type listType = null;
        if (valueType instanceof ParameterizedType && (rawType = ((ParameterizedType)valueType).getRawType()) instanceof Class && List.class.isAssignableFrom((Class)rawType)) {
            listType = ((ParameterizedType)valueType).getActualTypeArguments()[0];
        }
        int k = newLine ? 0 : depth;
        for (Map.Entry entry : value.entrySet()) {
            dump.append(this.indent(k)).append(YAML_SEQ).append(this.sanitizeScalarValue(depth, entry.getKey(), false));
            k = depth;
            dump.append(YAML_MAP_SEP);
            if (listType != null) {
                if (isSettings) {
                    boolean inlineSeq = false;
                    if (entry.getKey().toString().equals("authorizationUri")) {
                        inlineSeq = true;
                    } else if (entry.getKey().toString().equals("accessTokenUri")) {
                        inlineSeq = true;
                    }
                    this.dumpSequenceItems(dump, depth + 2, (List)entry.getValue(), listType, inlineSeq);
                    continue;
                }
                this.dumpSequenceItems(dump, depth + 2, (List)entry.getValue(), listType, false);
                continue;
            }
            if (ReflectionUtils.isPojo((Class)valueType)) {
                dump.append("\n");
                this.dumpPojo(dump, depth + 2, entry.getValue());
                continue;
            }
            dump.append(this.sanitizeScalarValue(depth + 2, entry.getValue(), true)).append("\n");
        }
    }

    private void dumpScalarField(StringBuilder dump, int depth, Field field, Object pojo, String includeField) {
        block17: {
            try {
                this.currentField = field;
                Object value = field.get(pojo);
                if (field.getName().equals("content")) {
                    System.out.println("a");
                }
                if (value == ParamType.STRING) {
                    return;
                }
                if (field.getName().equals("required") && value != null && value.equals(false)) {
                    return;
                }
                if (field.getName().equals("repeat") && value != null && value.equals(false)) {
                    return;
                }
                if (field.getName().equals("schema")) {
                    value = this.adjustSchema(value);
                }
                if (field.getName().equals("content")) {
                    value = this.adjustDocumentationContent(value);
                }
                if (field.getName().equals("example")) {
                    value = this.adjustExample(value);
                }
                if (value == null) {
                    return;
                }
                dump.append(this.indent(depth)).append(this.alias(field)).append(YAML_MAP_SEP);
                if (ReflectionUtils.isPojo(value.getClass())) {
                    dump.append("\n");
                    this.dumpPojo(dump, depth + 1, value);
                    break block17;
                }
                String sanitizeScalarValue = this.sanitizeScalarValue(depth, value, true);
                if (this.isSeparated && includeField != null && includeField.length() > 0) {
                    try {
                        Field declaredField = field.getDeclaringClass().getDeclaredField(includeField);
                        declaredField.setAccessible(true);
                        Object object = declaredField.get(pojo);
                        if (object != null && object instanceof String) {
                            dump.append("!include " + object.toString()).append("\n");
                            if (this.writer != null) {
                                this.writer.write(object.toString(), value.toString());
                            }
                            return;
                        }
                    }
                    catch (NoSuchFieldException e) {
                        throw new IllegalStateException();
                    }
                    catch (SecurityException e) {
                        throw new IllegalStateException();
                    }
                }
                dump.append(sanitizeScalarValue).append("\n");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Object adjustSchema(Object value) {
        return value;
    }

    private Object adjustDocumentationContent(Object value) {
        return value;
    }

    private Object adjustExample(Object value) {
        return value;
    }

    private String alias(Field field) {
        Scalar scalar = field.getAnnotation(Scalar.class);
        Mapping mapping = field.getAnnotation(Mapping.class);
        Sequence sequence = field.getAnnotation(Sequence.class);
        if (scalar != null && StringUtils.isNotEmpty((String)scalar.alias())) {
            return scalar.alias();
        }
        if (mapping != null && StringUtils.isNotEmpty((String)mapping.alias())) {
            return mapping.alias();
        }
        if (sequence != null && StringUtils.isNotEmpty((String)sequence.alias())) {
            return sequence.alias();
        }
        return field.getName();
    }

    private String sanitizeScalarValue(int depth, Object value, boolean isValue) {
        Class<?> type = value.getClass();
        String result = this.handleCustomScalar(value);
        if (result != null) {
            return result;
        }
        if (ReflectionUtils.isEnum(type)) {
            result = String.valueOf(value).toLowerCase();
        } else if (String.class.isAssignableFrom(type)) {
            String text = (String)value;
            result = (text = text.replace("\t", INDENTATION)).contains("\n") || text.contains("\"") && text.contains("'") ? this.blockFormat(depth, text) : this.inlineFormat(depth, text, isValue);
        } else {
            result = String.valueOf(value);
        }
        return result;
    }

    private String handleCustomScalar(Object value) {
        if (value instanceof Protocol) {
            return String.valueOf(value);
        }
        return null;
    }

    private String inlineFormat(int depth, String text, boolean isValue) {
        boolean isIdentifier = true;
        if (text.length() == 0) {
            return "\"\"";
        }
        if (text.startsWith("!include")) {
            return "\"" + text + "\"";
        }
        if (this.currentField.getName().equals("schemas")) {
            return text;
        }
        if (this.currentField.getName().contains("relative")) {
            return text;
        }
        if (text.contains("\"")) {
            return '\'' + text + '\'';
        }
        if (text.contains("*")) {
            return "\"" + text + "\"";
        }
        if (text.contains("{") && this.escape) {
            return "\"" + text + "\"";
        }
        for (int a = 0; a < text.length(); ++a) {
            char c = text.charAt(a);
            if (a == 0 && c == '{' && text.endsWith("}") && (this.currentField.getName().equals("type") || this.currentField.getName().equals("is"))) {
                return text;
            }
            if (!isValue && Character.isWhitespace(c)) {
                isIdentifier = false;
                break;
            }
            if (c == ':') {
                if (a - "https".length() >= 0) {
                    if (!text.startsWith("https:", a - "https".length())) {
                        isIdentifier = false;
                        break;
                    }
                } else if (a - "http".length() >= 0) {
                    if (!text.startsWith("http:", a - "http".length())) {
                        isIdentifier = false;
                        break;
                    }
                } else {
                    isIdentifier = false;
                    break;
                }
            }
            if (c == '\"') {
                isIdentifier = false;
                break;
            }
            if (c != '\'') continue;
            isIdentifier = false;
            break;
        }
        if (isIdentifier) {
            return text;
        }
        if (!text.contains("\"")) {
            return "\"" + text + "\"";
        }
        if (!text.contains("'")) {
            return "'" + text + "'";
        }
        return this.blockFormat(depth, text);
    }

    private String blockFormat(int depth, String text) {
        String[] lines;
        StringBuilder block = new StringBuilder("|\n");
        for (String line : lines = text.split("\n")) {
            block.append(this.indent(depth + 1)).append(line).append("\n");
        }
        return block.substring(0, block.length() - 1);
    }

    public String indent(int depth) {
        return StringUtils.repeat((String)INDENTATION, (int)depth);
    }

    public void setSingle(boolean b) {
        this.isSeparated = false;
    }

    public void setEscapeLiterals(boolean b) {
        this.escape = b;
    }
}

