/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jsonschema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JSONObjectWrapper {
    private JSONObject object;
    private HashMap<String, JSONObjectWrapper> properties = new HashMap();
    private String type;

    public JSONObjectWrapper(JSONObject object) {
        this.object = object;
        try {
            this.type = object.getString("type");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject props = null;
        try {
            props = object.getJSONObject("properties");
        }
        catch (JSONException e) {
            props = null;
        }
        if (props != null) {
            Iterator iter = props.keys();
            while (iter.hasNext()) {
                Object o = iter.next();
                String propName = o.toString();
                try {
                    JSONObject property = props.getJSONObject(propName);
                    JSONObjectWrapper child = new JSONObjectWrapper(property);
                    this.properties.put(propName, child);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public JSONObject getObject() {
        return this.object;
    }

    public boolean equals(Object obj) {
        HashMap<String, JSONObjectWrapper> thatProperties;
        Set<String> otherKeys;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONObjectWrapper other = (JSONObjectWrapper)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        HashMap<String, JSONObjectWrapper> thisProperties = this.properties;
        Set<String> thisKeys = thisProperties.keySet();
        if (!thisKeys.containsAll(otherKeys = (thatProperties = other.properties).keySet())) {
            return false;
        }
        if (!otherKeys.containsAll(thisKeys)) {
            return false;
        }
        for (String key : thisKeys) {
            JSONObjectWrapper thatProp;
            JSONObjectWrapper thisProp = thisProperties.get(key);
            if (thisProp.equals(thatProp = thatProperties.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }
}

