/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jaxb;

import com.mulesoft.jaxrs.raml.jaxb.IExampleWriter;
import com.mulesoft.jaxrs.raml.jaxb.JAXBAttributeProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBElementProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBType;
import com.mulesoft.jaxrs.raml.jaxb.JAXBValueProperty;
import java.util.HashMap;
import java.util.HashSet;

public class ExampleGenerator {
    protected IExampleWriter writer;
    HashSet<JAXBType> onStack = new HashSet();

    public ExampleGenerator(IExampleWriter writer) {
        this.writer = writer;
    }

    public void generateXML(JAXBType type) {
        String xmlName = type.getXMLName();
        this.generateType(type, xmlName);
    }

    private void generateType(JAXBType type, String xmlName) {
        if (!this.onStack.add(type)) {
            return;
        }
        HashMap<String, String> prefixes = type.gatherNamespaces();
        this.writer.startEntityAndDeclareNamespaces(xmlName, prefixes);
        for (JAXBProperty p : type.properties) {
            this.writeProperty(p, prefixes);
        }
        this.writer.endEntity(xmlName);
        this.onStack.remove(type);
    }

    private void writeProperty(JAXBProperty p, HashMap<String, String> prefixes) {
        String string;
        String name = p.name();
        if (name == null || name.length() == 0) {
            return;
        }
        if (p.namespace != null && (string = prefixes.get(p.namespace)) != null) {
            name = string + ":" + name;
        }
        if (p instanceof JAXBAttributeProperty) {
            JAXBAttributeProperty ap = (JAXBAttributeProperty)p;
            this.writer.generateAttribute(name, ap.asJavaType(), ap.required);
        }
        if (p instanceof JAXBElementProperty) {
            JAXBElementProperty el = (JAXBElementProperty)p;
            JAXBType jaxbType = el.getJAXBType();
            if (jaxbType != null) {
                this.generateType(jaxbType, name);
                if (p.isCollection()) {
                    this.generateType(jaxbType, name);
                }
            } else {
                this.writer.generateElement(name, el.asJavaType(), el.required);
                if (p.isCollection()) {
                    this.writer.generateElement(name, el.asJavaType(), el.required);
                }
            }
        }
        if (p instanceof JAXBValueProperty) {
            this.writer.addValueSample(p.asJavaType(), p.required);
        }
    }
}

