/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model;

import com.mulesoft.jaxrs.raml.annotation.model.Path;
import com.mulesoft.jaxrs.raml.annotation.model.PathCleanuper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.raml.model.Protocol;
import org.raml.model.Raml2;
import org.raml.model.RamlFileVisitorAdapter;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;

public class RAMLModelHelper {
    protected Raml2 coreRaml = new Raml2();
    boolean extractCommonParts = true;
    boolean doSort = true;

    public RAMLModelHelper() {
        this.coreRaml.setBaseUri("http://example.com");
        this.coreRaml.setTitle("Please type API title here");
        this.coreRaml.setProtocols(Collections.singletonList(Protocol.HTTP));
    }

    public String getMediaType() {
        return this.coreRaml.getMediaType();
    }

    public void addResource(Resource res) {
        this.cleanupUrl(res);
        String relativeUri = res.getRelativeUri();
        int c = 0;
        for (int a = 0; a < relativeUri.length(); ++a) {
            if (relativeUri.charAt(a) != '/') continue;
            ++c;
        }
        Map<String, Resource> resources = this.getCoreRaml().getResources();
        if (c == 1) {
            Resource put = resources.put(relativeUri, res);
            if (put != null) {
                RAMLModelHelper.merge(res, put);
            }
            if (relativeUri.length() > 0) {
                Path ps = new Path(relativeUri);
                for (String s : new HashSet<String>(resources.keySet())) {
                    Path anotherPath = new Path(s);
                    if (!ps.isPrefixOf(anotherPath) || ps.equals(anotherPath) || ps.segmentCount() <= 0) continue;
                    Resource remove = resources.remove(s);
                    Path removeFirstSegments = anotherPath.removeFirstSegments(ps.segmentCount());
                    String portableString = removeFirstSegments.toPortableString();
                    String doCleanup = RAMLModelHelper.doCleanup("/" + portableString);
                    res.getResources().put(doCleanup, remove);
                    remove.setRelativeUri(doCleanup);
                }
            }
            return;
        }
        if (res.getRelativeUri().length() == 0 && res.getActions().isEmpty()) {
            return;
        }
        RAMLModelHelper.placeResource(resources, res);
    }

    private static void merge(Resource res, Resource put) {
        res.getActions().putAll(put.getActions());
        for (String s : put.getResources().keySet()) {
            if (res.getResources().containsKey(s)) {
                RAMLModelHelper.merge(res.getResources().get(s), put.getResources().get(s));
                continue;
            }
            res.getResources().put(s, put.getResources().get(s));
        }
    }

    private void cleanupUrl(Resource res) {
        String relativeUri = res.getRelativeUri();
        String string = RAMLModelHelper.doCleanup(relativeUri);
        if (string.length() == 0) {
            string = "/";
        }
        res.setRelativeUri(string);
    }

    private static String doCleanup(String relativeUri) {
        relativeUri = PathCleanuper.cleanupPath(relativeUri);
        StringBuilder bld = new StringBuilder();
        int pc = 0;
        for (int a = 0; a < relativeUri.length(); ++a) {
            char c = relativeUri.charAt(a);
            if (c == '/' && pc == 47) continue;
            bld.append(c);
            pc = c;
        }
        String string = bld.toString();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    public static void placeResource(Map<String, Resource> resources, Resource createResource) {
        Map<String, UriParameter> uriParameters2;
        Map<String, UriParameter> uriParameters;
        String portableString;
        Path removeFirstSegments;
        Path rp;
        String relativeUri = createResource.getRelativeUri();
        Path path = new Path(relativeUri);
        boolean restructure = false;
        for (String s : new HashSet<String>(resources.keySet())) {
            rp = new Path(s);
            if (!path.isPrefixOf(rp)) continue;
            if (path.equals(rp)) {
                Resource resource = resources.get(s);
                resource.getActions().putAll(createResource.getActions());
                return;
            }
            restructure = true;
            Resource remove = resources.remove(s);
            removeFirstSegments = rp.removeFirstSegments(path.segmentCount());
            portableString = "/" + removeFirstSegments.toPortableString();
            portableString = RAMLModelHelper.doCleanup(portableString);
            remove.setRelativeUri(portableString);
            Resource old = resources.put(relativeUri, createResource);
            if (old != null) {
                createResource.getActions().putAll(old.getActions());
            }
            uriParameters = createResource.getUriParameters();
            uriParameters2 = remove.getUriParameters();
            for (String q : uriParameters.keySet()) {
                uriParameters2.remove(q);
            }
            createResource.getResources().put(portableString, remove);
            Resource put = resources.put(relativeUri, createResource);
            if (put == null) continue;
            createResource.getActions().putAll(put.getActions());
        }
        if (restructure) {
            return;
        }
        for (String s : resources.keySet()) {
            Path removeFirstSegments2;
            if (s.equals("/") || !(rp = new Path(s)).isPrefixOf(path) || path.segmentCount() - rp.segmentCount() < 1) continue;
            removeFirstSegments = removeFirstSegments2 = path.removeFirstSegments(rp.segmentCount());
            portableString = "/" + removeFirstSegments.toPortableString();
            createResource.setRelativeUri(RAMLModelHelper.doCleanup(portableString));
            Resource resource = resources.get(s);
            uriParameters = resource.getUriParameters();
            uriParameters2 = createResource.getUriParameters();
            for (String sa : uriParameters.keySet()) {
                uriParameters2.remove(sa);
            }
            RAMLModelHelper.placeResource(resource.getResources(), createResource);
            return;
        }
        Resource put = resources.put(relativeUri, createResource);
        if (put != null) {
            RAMLModelHelper.merge(createResource, put);
        }
    }

    public void setMediaType(String mediaType) {
        this.coreRaml.setMediaType(mediaType);
    }

    public Raml2 getCoreRaml() {
        return this.coreRaml;
    }

    public void optimize() {
        this.optimizeResourceMap(this.coreRaml.getResources());
        this.coreRaml.visit(new RamlFileVisitorAdapter(){

            @Override
            public boolean startVisit(Resource resource) {
                RAMLModelHelper.this.optimizeResourceMap(resource.getResources());
                return super.startVisit(resource);
            }
        });
    }

    protected void optimizeResourceMap(Map<String, Resource> resources) {
        this.sortIfNeeded(resources);
        this.extractCommonPaths(resources);
    }

    private void extractCommonPaths(Map<String, Resource> resources) {
        if (!this.extractCommonParts) {
            return;
        }
        LinkedHashMap rs = (LinkedHashMap)resources;
        ArrayList<Entry> rt = this.getEntries(rs);
        HashMap<String, ArrayList<Entry>> map = new HashMap<String, ArrayList<Entry>>();
        for (Entry e : rt) {
            Path c = new Path(e.path);
            if (c.segmentCount() <= 1) continue;
            String segment = c.segment(0);
            ArrayList<Entry> arrayList = (ArrayList<Entry>)map.get(segment);
            if (arrayList == null) {
                arrayList = new ArrayList<Entry>();
                map.put(segment, arrayList);
            }
            arrayList.add(e);
        }
        if (!map.isEmpty()) {
            for (String s : map.keySet()) {
                ArrayList e = (ArrayList)map.get(s);
                Entry base = (Entry)e.get(0);
                Resource r0 = base.res;
                Resource newRes = new Resource();
                String relativeUri = "/" + s;
                newRes.setRelativeUri(relativeUri);
                base.path = relativeUri;
                this.stripSegment(r0);
                newRes.getResources().put(r0.getRelativeUri(), r0);
                base.res = newRes;
                for (int a = 1; a < e.size(); ++a) {
                    Entry entry = (Entry)e.get(a);
                    this.stripSegment(entry.res);
                    rt.remove(entry);
                    newRes.getResources().put(entry.res.getRelativeUri(), entry.res);
                }
            }
        }
        resources.clear();
        this.entriesToMap(resources, rt);
    }

    private void stripSegment(Resource r0) {
        String relativeUri = r0.getRelativeUri();
        Path p = new Path(relativeUri);
        p = p.removeFirstSegments(1);
        r0.setRelativeUri("/" + p.toPortableString());
    }

    private ArrayList<Entry> getEntries(LinkedHashMap<String, Resource> rs) {
        ArrayList<Entry> rt = new ArrayList<Entry>();
        for (String path : rs.keySet()) {
            rt.add(new Entry(path, rs.get(path)));
        }
        return rt;
    }

    private void entriesToMap(Map<String, Resource> resources, ArrayList<Entry> rt) {
        for (Entry e : rt) {
            resources.put(e.path, e.res);
        }
    }

    private void sortIfNeeded(Map<String, Resource> resources) {
        if (this.doSort) {
            LinkedHashMap rs = (LinkedHashMap)resources;
            ArrayList<Entry> rt = this.getEntries(rs);
            Collections.sort(rt);
            resources.clear();
            this.entriesToMap(resources, rt);
        }
    }

    static class Entry
    implements Comparable<Entry> {
        protected String path;
        protected Resource res;

        public Entry(String path, Resource res) {
            this.path = path;
            this.res = res;
        }

        @Override
        public int compareTo(Entry o) {
            return this.path.compareTo(o.path);
        }
    }
}

