/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.NodeVisitor;
import org.raml.parser.visitor.YamlValidator;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;

public class YamlValidationService {
    private List<ValidationResult> errorMessage;
    private YamlValidator yamlValidator;
    private ResourceLoader resourceLoader;
    private TagResolver[] tagResolvers;

    protected YamlValidationService(ResourceLoader resourceLoader, YamlValidator yamlValidator, TagResolver[] tagResolvers) {
        this.resourceLoader = resourceLoader;
        this.yamlValidator = yamlValidator;
        this.errorMessage = new ArrayList<ValidationResult>();
        this.tagResolvers = tagResolvers;
    }

    public List<ValidationResult> validate(MappingNode root) {
        NodeVisitor nodeVisitor = new NodeVisitor(this.yamlValidator, this.resourceLoader, this.tagResolvers);
        this.errorMessage.addAll(this.preValidation(root));
        nodeVisitor.visitDocument(root);
        return this.errorMessage;
    }

    public List<ValidationResult> validate(InputStream content) {
        return this.validate(new InputStreamReader(content));
    }

    public List<ValidationResult> validate(String content) {
        return this.validate(new StringReader(content));
    }

    public List<ValidationResult> validate(Reader content) {
        long startTime = System.currentTimeMillis();
        Yaml yamlParser = new Yaml();
        try {
            Node root = yamlParser.compose(content);
            if (root != null && root.getNodeId() == NodeId.mapping) {
                this.validate((MappingNode)root);
            } else {
                this.errorMessage.add(ValidationResult.createErrorResult("Invalid RAML"));
            }
        }
        catch (MarkedYAMLException mye) {
            this.errorMessage.add(ValidationResult.createErrorResult(mye.getProblem(), mye.getProblemMark(), mye.getProblemMark()));
        }
        catch (YAMLException ex) {
            this.errorMessage.add(ValidationResult.createErrorResult(ex.getMessage()));
        }
        this.errorMessage.addAll(this.yamlValidator.getMessages());
        return this.errorMessage;
    }

    protected List<ValidationResult> preValidation(MappingNode root) {
        return new ArrayList<ValidationResult>();
    }
}

