/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.utils.NodeUtils;
import org.raml.parser.visitor.IncludeInfo;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class NodeVisitor {
    public static final Tag LOOP_TAG = new Tag("!loop");
    private NodeHandler nodeHandler;
    private ResourceLoader resourceLoader;
    private TagResolver[] tagResolvers;
    private Deque<String> loopDetector = new ArrayDeque<String>();
    private Deque<String> includeStack = new ArrayDeque<String>();

    public NodeVisitor(NodeHandler nodeHandler, ResourceLoader resourceLoader, TagResolver ... tagResolvers) {
        this.nodeHandler = nodeHandler;
        this.resourceLoader = resourceLoader;
        this.tagResolvers = tagResolvers;
        this.includeStack.push("root");
    }

    private void visitMappingNode(MappingNode mappingNode, TupleType tupleType) {
        if (this.checkLoop((Node)mappingNode)) {
            this.nodeHandler.onCustomTagError(LOOP_TAG, (Node)mappingNode, "Circular reference detected");
            return;
        }
        this.nodeHandler.onMappingNodeStart(mappingNode, tupleType);
        if (tupleType == TupleType.VALUE) {
            this.doVisitMappingNode(mappingNode);
        }
        this.nodeHandler.onMappingNodeEnd(mappingNode, tupleType);
        if (mappingNode.getStartMark() != null) {
            this.loopDetector.pop();
        }
    }

    private boolean checkLoop(Node node) {
        if (node.getStartMark() == null) {
            return false;
        }
        String index = this.includeStack.peek() + node.getStartMark().getIndex();
        if (this.loopDetector.contains(index)) {
            return true;
        }
        this.loopDetector.push(index);
        return false;
    }

    private void doVisitMappingNode(MappingNode mappingNode) {
        if (mappingNode.isMerged()) {
            new MappingNodeMerger().merge(mappingNode);
        }
        List tuples = mappingNode.getValue();
        ArrayList<NodeTuple> updatedTuples = new ArrayList<NodeTuple>();
        for (NodeTuple nodeTuple : tuples) {
            Tag tag;
            Node resolvedNode;
            Node keyNode = nodeTuple.getKeyNode();
            Node originalValueNode = nodeTuple.getValueNode();
            if (originalValueNode != (resolvedNode = this.resolveTag(tag = originalValueNode.getTag(), originalValueNode))) {
                nodeTuple = new NodeTuple(keyNode, resolvedNode);
            }
            updatedTuples.add(nodeTuple);
            this.nodeHandler.onTupleStart(nodeTuple);
            this.visit(keyNode, TupleType.KEY);
            this.visitResolvedNode(originalValueNode, resolvedNode);
            this.nodeHandler.onTupleEnd(nodeTuple);
        }
        mappingNode.setValue(updatedTuples);
    }

    private Node resolveTag(Tag tag, Node valueNode) {
        TagResolver tagResolver = this.getTagResolver(tag);
        if (tagResolver != null) {
            valueNode = tagResolver.resolve(valueNode, this.resourceLoader, this.nodeHandler);
        } else if (!NodeUtils.isStandardTag(tag)) {
            this.nodeHandler.onCustomTagError(tag, valueNode, "Unknown tag " + tag);
        }
        return valueNode;
    }

    private void visitResolvedNode(Node originalValueNode, Node resolvedNode) {
        boolean tagResolved;
        Tag tag = originalValueNode.getTag();
        boolean bl = tagResolved = !NodeUtils.isStandardTag(tag);
        if (tagResolved) {
            this.nodeHandler.onCustomTagStart(tag, originalValueNode, resolvedNode);
            this.pushIncludeIfNeeded(tag, originalValueNode);
        }
        this.visit(resolvedNode, TupleType.VALUE);
        if (tagResolved) {
            this.nodeHandler.onCustomTagEnd(tag, originalValueNode, resolvedNode);
            this.popIncludeIfNeeded(tag);
        }
    }

    private void popIncludeIfNeeded(Tag tag) {
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag) || tag.startsWith("!include-applied_")) {
            this.includeStack.pop();
        }
    }

    private void pushIncludeIfNeeded(Tag tag, Node node) {
        String includeName = null;
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag)) {
            if (node.getNodeId() != NodeId.scalar) {
                return;
            }
            includeName = ((ScalarNode)node).getValue();
        } else if (tag.startsWith("!include-applied_")) {
            includeName = new IncludeInfo(tag).getIncludeName();
        }
        if (includeName != null) {
            this.includeStack.push(includeName);
        }
    }

    private TagResolver getTagResolver(Tag tag) {
        for (TagResolver resolver : this.tagResolvers) {
            if (!resolver.handles(tag)) continue;
            return resolver;
        }
        return null;
    }

    public void visitDocument(MappingNode node) {
        this.nodeHandler.onDocumentStart(node);
        if (node != null) {
            this.doVisitMappingNode(node);
        }
        this.nodeHandler.onDocumentEnd(node);
    }

    private void visit(Node node, TupleType tupleType) {
        if (node.getNodeId() == NodeId.mapping) {
            this.visitMappingNode((MappingNode)node, tupleType);
        } else if (node.getNodeId() == NodeId.scalar) {
            this.visitScalar((ScalarNode)node, tupleType);
        } else if (node.getNodeId() == NodeId.sequence) {
            this.visitSequence((SequenceNode)node, tupleType);
        }
    }

    private void visitSequence(SequenceNode node, TupleType tupleType) {
        this.nodeHandler.onSequenceStart(node, tupleType);
        if (tupleType == TupleType.VALUE) {
            List value = node.getValue();
            for (int i = 0; i < value.size(); ++i) {
                Node resolvedNode;
                Node originalNode = (Node)value.get(i);
                if (originalNode != (resolvedNode = this.resolveTag(originalNode.getTag(), originalNode))) {
                    node.getValue().remove(i);
                    node.getValue().add(i, resolvedNode);
                }
                this.nodeHandler.onSequenceElementStart(resolvedNode);
                this.visitResolvedNode(originalNode, resolvedNode);
                this.nodeHandler.onSequenceElementEnd(resolvedNode);
            }
        }
        this.nodeHandler.onSequenceEnd(node, tupleType);
    }

    private void visitScalar(ScalarNode node, TupleType tupleType) {
        try {
            if (node.getValue() != null) {
                this.nodeHandler.onScalar(node, tupleType);
            }
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    private static class MappingNodeMerger
    extends SafeConstructor {
        private MappingNodeMerger() {
        }

        void merge(MappingNode mappingNode) {
            this.flattenMapping(mappingNode);
        }
    }
}

