/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.List;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.PojoTupleRule;
import org.raml.parser.rule.SequenceTupleRule;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class MapWithListValueTupleRule
extends DefaultTupleRule<ScalarNode, MappingNode> {
    private final Class valueType;
    private String fieldName;

    public MapWithListValueTupleRule(String fieldName, Class<?> valueType, NodeRuleFactory nodeRuleFactory) {
        super(fieldName, new DefaultScalarTupleHandler(fieldName), nodeRuleFactory);
        this.valueType = valueType;
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        if (nodeTuple.getValueNode().getNodeId() == NodeId.sequence) {
            return new SequenceTupleRule(this.fieldName, this.valueType, this.getNodeRuleFactory());
        }
        if (ReflectionUtils.isPojo(this.valueType)) {
            return new PojoTupleRule(this.fieldName, this.valueType, this.getNodeRuleFactory());
        }
        return new SimpleRule(this.fieldName, this.valueType);
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        this.fieldName = key.getValue();
        return super.validateKey(key);
    }
}

