/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;

public class ContributionTupleRule
implements TupleRule<Node, Node> {
    private TupleRule rule;
    private List<TupleRule> contributionRules;

    public ContributionTupleRule(TupleRule rule, List<TupleRule> contributionRules) {
        this.rule = rule;
        this.contributionRules = contributionRules;
    }

    @Override
    public List<ValidationResult> validateKey(Node key) {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        result.addAll(this.rule.validateKey(key));
        for (TupleRule contributionRule : this.contributionRules) {
            result.addAll(contributionRule.validateKey(key));
        }
        return result;
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        return this.rule.getRuleForTuple(nodeTuple);
    }

    @Override
    public void setParentTupleRule(TupleRule<?, ?> parent) {
        this.rule.setParentTupleRule(parent);
        for (TupleRule contributionRule : this.contributionRules) {
            contributionRule.setParentTupleRule(parent);
        }
    }

    @Override
    public TupleRule<?, ?> getParentTupleRule() {
        return this.rule.getParentTupleRule();
    }

    @Override
    public TupleRule<?, ?> getRootTupleRule() {
        return this.rule.getRootTupleRule();
    }

    @Override
    public String getName() {
        return this.rule.getName();
    }

    @Override
    public TupleRule<?, ?> getRuleByFieldName(String fieldName) {
        return this.rule.getRuleByFieldName(fieldName);
    }

    @Override
    public void setNestedRules(Map<String, TupleRule<?, ?>> innerBuilders) {
        this.rule.setNestedRules(innerBuilders);
    }

    @Override
    public void setHandler(TupleHandler tupleHandler) {
        this.rule.setHandler(tupleHandler);
    }

    @Override
    public TupleHandler getHandler() {
        return this.rule.getHandler();
    }

    @Override
    public void setRequired(boolean required) {
        this.rule.setRequired(required);
        for (TupleRule contributionRule : this.contributionRules) {
            contributionRule.setRequired(required);
        }
    }

    @Override
    public void setNodeRuleFactory(NodeRuleFactory nodeRuleFactory) {
        this.rule.setNodeRuleFactory(nodeRuleFactory);
    }

    @Override
    public Node getKey() {
        return this.rule.getKey();
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setValueType(Type valueType) {
    }

    @Override
    public List<ValidationResult> validateValue(Node value) {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        result.addAll(this.rule.validateValue(value));
        for (TupleRule contributionRule : this.contributionRules) {
            result.addAll(contributionRule.validateValue(value));
        }
        return result;
    }

    @Override
    public List<ValidationResult> onRuleEnd() {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        result.addAll(this.rule.onRuleEnd());
        for (TupleRule contributionRule : this.contributionRules) {
            result.addAll(contributionRule.onRuleEnd());
        }
        return result;
    }
}

